/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExpandStackEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;

public class StackFramesVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementMementoProvider,
IElementPropertiesProvider {
    public static final String PROP_IS_INCOMPLETE_STACK_MARKER = "is_incomplete_stack_marker";
    private Map<IRunControl.IExecutionDMContext, Integer> fTemporaryLimits = new HashMap<IRunControl.IExecutionDMContext, Integer>();
    private IElementLabelProvider fLabelProvider = this.createLabelProvider();

    public StackFramesVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IStack.IFrameDMContext.class);
    }

    public String toString() {
        return "StackFramesVMNode(" + this.getSession().getId() + ")";
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__Incomplete_stack_marker__text_format, new String[]{PROP_IS_INCOMPLETE_STACK_MARKER}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.TRUE.equals(properties.get(StackFramesVMNode.PROP_IS_INCOMPLETE_STACK_MARKER));
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__text_format, new String[]{"frame_address", "frame_function", "frame_file", "frame_line", "frame_column", "frame_module"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Integer line = (Integer)properties.get("frame_line");
                String file = (String)properties.get("frame_file");
                String function = (String)properties.get("frame_function");
                return line != null && line >= 0 && file != null && file.length() > 0 && function != null && function.contains(")");
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__add_parens__text_format, new String[]{"frame_address", "frame_function", "frame_file", "frame_line", "frame_column", "frame_module"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Integer line = (Integer)properties.get("frame_line");
                String file = (String)properties.get("frame_file");
                String function = (String)properties.get("frame_function");
                return line != null && line >= 0 && file != null && file.length() > 0 && (function == null || !function.contains(")"));
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_line__text_format, new String[]{"frame_address", "frame_function", "frame_module"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                String module = (String)properties.get("frame_module");
                return function != null && function.length() > 0 && function.contains(")") && module != null && module.length() > 0;
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_line__add_parens__text_format, new String[]{"frame_address", "frame_function", "frame_module"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                String module = (String)properties.get("frame_module");
                return function != null && function.length() > 0 && !function.contains(")") && module != null && module.length() > 0;
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_function__text_format, new String[]{"frame_address", "frame_module"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String module = (String)properties.get("frame_module");
                return module != null && module.length() > 0;
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__text_format, new String[]{"frame_address", "frame_function"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                return function != null && function.length() > 0 && function.contains(")");
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__add_parens__text_format, new String[]{"frame_address", "frame_function"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                return function != null && function.length() > 0 && !function.contains(")");
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__Address_only__text_format, new String[]{"frame_address"}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_STACKFRAME_RUNNING")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.FALSE.equals(properties.get("is_suspended"));
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_STACKFRAME"))}));
        return provider;
    }

    @Override
    protected void updateHasElementsInSessionThread(IHasChildrenUpdate update) {
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IRunControl.IExecutionDMContext execCtx = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (runControl == null || execCtx == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setHasChilren(runControl.isSuspended(execCtx) || runControl.isStepping(execCtx));
        update.done();
    }

    @Override
    protected void updateElementCountInSessionThread(final IChildrenCountUpdate update) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        IRunControl.IExecutionDMContext execDmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (stackService == null || execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final int stackFrameLimit = this.getStackFrameLimit(execDmc);
        stackService.getStackDepth((IDMContext)execDmc, stackFrameLimit == Integer.MAX_VALUE ? 0 : stackFrameLimit + 1, (DataRequestMonitor)new ViewerDataRequestMonitor<Integer>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                int stackDepth = (Integer)this.getData();
                if (stackFrameLimit < stackDepth) {
                    stackDepth = stackFrameLimit + 1;
                }
                update.setChildCount(stackDepth);
                update.done();
            }
        });
    }

    @Override
    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        final IRunControl.IExecutionDMContext execDmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (stackService == null || execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final int stackFrameLimit = this.getStackFrameLimit(execDmc);
        final int startIndex = update.getOffset();
        if (startIndex == 0 && update.getLength() == 1) {
            stackService.getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    update.setChild((Object)StackFramesVMNode.this.createVMContext((IDMContext)this.getData()), 0);
                    update.done();
                }
            });
        } else if (startIndex >= 0 && update.getLength() > 0) {
            int endIndex = startIndex + update.getLength() - 1;
            if (startIndex < stackFrameLimit && endIndex >= stackFrameLimit) {
                endIndex = stackFrameLimit - 1;
            }
            stackService.getFrames((IDMContext)execDmc, startIndex, endIndex, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    IStack.IFrameDMContext[] frames = (IStack.IFrameDMContext[])this.getData();
                    StackFramesVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])frames, startIndex);
                    if (startIndex + update.getLength() > stackFrameLimit) {
                        update.setChild((Object)new IncompleteStackVMContext(execDmc, stackFrameLimit), stackFrameLimit);
                    }
                    update.done();
                }
            });
        } else {
            stackService.getFrames((IDMContext)execDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    IStack.IFrameDMContext[] frames = (IStack.IFrameDMContext[])this.getData();
                    if (frames.length > stackFrameLimit) {
                        IStack.IFrameDMContext[] tmpFrames = new IStack.IFrameDMContext[stackFrameLimit];
                        System.arraycopy(frames, 0, tmpFrames, 0, stackFrameLimit);
                        frames = tmpFrames;
                        update.setChild((Object)new IncompleteStackVMContext(execDmc, stackFrameLimit), stackFrameLimit);
                    }
                    StackFramesVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])frames);
                    update.done();
                }
            });
        }
    }

    public void update(ILabelUpdate[] updates) {
        this.fLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        StackFramesVMNode.this.updatePropertiesInSessionThread(updates);
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException v0) {
                var5_2 = updates;
                var4_3 = updates.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                update = var5_2[var3_4];
                this.handleFailedUpdate(update);
                ++var3_4;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IStack service = (IStack)this.getServicesTracker().getService(IStack.class);
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            if (service == null) {
                this.handleFailedUpdate(update);
            } else if (update.getElement() instanceof IncompleteStackVMContext) {
                update.setProperty(PROP_IS_INCOMPLETE_STACK_MARKER, Boolean.TRUE);
                update.done();
            } else {
                IStack.IFrameDMContext dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IStack.IFrameDMContext.class);
                if (dmc == null) {
                    this.handleFailedUpdate(update);
                } else {
                    IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
                    IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IExecutionDMContext.class);
                    if (execDmc != null && runControlService != null) {
                        update.setProperty("is_suspended", runControlService.isSuspended(execDmc));
                        update.setProperty("is_stepping", runControlService.isStepping(execDmc));
                    } else {
                        update.setStatus(DsfUIPlugin.newErrorStatus(10002, "Invalid context or service not available", null));
                    }
                    service.getFrameData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                        @Override
                        protected void handleSuccess() {
                            StackFramesVMNode.this.fillFrameDataProperties(update, (IStack.IFrameDMData)this.getData());
                            update.done();
                        }
                    });
                }
            }
            ++n2;
        }
    }

    protected void fillFrameDataProperties(IPropertiesUpdate update, IStack.IFrameDMData data) {
        Object showFullPathPreference;
        String fileName;
        IAddress address = data.getAddress();
        if (address != null) {
            update.setProperty("frame_address", "0x" + address.toString(16));
        }
        if ((fileName = data.getFile()) != null && (showFullPathPreference = this.getVMProvider().getPresentationContext().getProperty("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths")) instanceof Boolean && !((Boolean)showFullPathPreference).booleanValue()) {
            fileName = new Path(fileName).lastSegment();
        }
        update.setProperty("frame_file", fileName);
        update.setProperty("frame_function", data.getFunction());
        update.setProperty("frame_line", data.getLine());
        update.setProperty("frame_column", data.getColumn());
        update.setProperty("frame_module", data.getModule());
    }

    protected void fillColumnLabel(IStack.IFrameDMContext dmContext, IStack.IFrameDMData dmData, String columnId, int idx, ILabelUpdate update) {
        boolean hasFileName;
        if (idx != 0) {
            return;
        }
        IRunControl.IExecutionDMContext execDmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc == null) {
            return;
        }
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        SteppingController stepQueueMgr = (SteppingController)execDmc.getAdapter(SteppingController.class);
        if (runControlService == null || stepQueueMgr == null) {
            return;
        }
        String imageKey = null;
        imageKey = runControlService.isSuspended(execDmc) || runControlService.isStepping(execDmc) && !stepQueueMgr.isSteppingTimedOut(execDmc) ? "IMG_OBJS_STACKFRAME" : "IMG_OBJS_STACKFRAME_RUNNING";
        update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
        StringBuilder label = new StringBuilder();
        if (dmData.getFunction() != null && dmData.getFunction().length() != 0) {
            label.append(" ");
            label.append(dmData.getFunction());
            label.append("()");
        }
        boolean bl = hasFileName = dmData.getFile() != null && dmData.getFile().length() != 0;
        if (hasFileName) {
            label.append(" at ");
            label.append(dmData.getFile());
        }
        if (dmData.getLine() >= 0) {
            label.append(":");
            label.append(dmData.getLine());
            label.append(" ");
        }
        if (!hasFileName && dmData.getModule() != null && dmData.getModule().length() != 0) {
            label.append(" ");
            label.append(dmData.getModule());
            label.append(" ");
        }
        if (dmData.getAddress() != null) {
            label.append("- 0x" + dmData.getAddress().toString(16));
        }
        update.setLabel(label.toString(), 0);
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object e, final DataRequestMonitor<IVMContext[]> rm) {
        if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            this.getVMProvider().updateNode((IVMNode)this, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), 0, 1, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

                public void handleCompleted() {
                    if (this.isSuccess() && ((List)this.getData()).size() != 0) {
                        rm.setData((Object)new IVMContext[]{(IVMContext)((List)this.getData()).get(0)});
                    } else {
                        rm.setData((Object)new IVMContext[0]);
                    }
                    rm.done();
                }
            }));
            return;
        }
        super.getContextsForEvent(parentDelta, e, rm);
    }

    @Override
    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 0x300400;
        }
        if (e instanceof FullStackRefreshEvent && !(((FullStackRefreshEvent)((Object)e)).getTriggeringEvent() instanceof IRunControl.IContainerSuspendedDMEvent)) {
            return 1024;
        }
        if (e instanceof SteppingController.SteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            return 0x300000;
        }
        if (e instanceof ExpandStackEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.IExitedDMEvent) {
            this.resetStackFrameLimit((IRunControl.IExecutionDMContext)((IRunControl.IExitedDMEvent)e).getDMContext());
            return 0;
        }
        if (e instanceof PropertyChangeEvent) {
            String property = ((PropertyChangeEvent)e).getProperty();
            if ("stackFrameLimitEnable".equals(property) || "stackFrameLimit".equals(property)) {
                return 1024;
            }
            if ("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths".equals(property)) {
                return 2048;
            }
        }
        return 0;
    }

    @Override
    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext triggeringCtx;
            this.resetStackFrameLimit((IRunControl.IExecutionDMContext)((IRunControl.IContainerSuspendedDMEvent)e).getDMContext());
            IRunControl.IContainerSuspendedDMEvent csEvent = (IRunControl.IContainerSuspendedDMEvent)e;
            IRunControl.IExecutionDMContext iExecutionDMContext = triggeringCtx = csEvent.getTriggeringContexts().length != 0 ? csEvent.getTriggeringContexts()[0] : null;
            if (parent.getElement() instanceof IDMVMContext) {
                IRunControl.IExecutionDMContext threadDmc = null;
                threadDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)parent.getElement()).getDMContext(), IRunControl.IExecutionDMContext.class);
                this.buildDeltaForSuspendedEvent(threadDmc, triggeringCtx, parent, nodeOffset, rm);
            } else {
                rm.done();
            }
        } else if (e instanceof FullStackRefreshEvent) {
            FullStackRefreshEvent refreshEvent = (FullStackRefreshEvent)((Object)e);
            if (!(refreshEvent.getTriggeringEvent() instanceof IRunControl.IContainerSuspendedDMEvent)) {
                IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((FullStackRefreshEvent)((Object)e)).getDMContext();
                this.buildDeltaForFullStackRefreshEvent(execDmc, execDmc, parent, nodeOffset, rm);
            } else {
                rm.done();
            }
        } else if (e instanceof IRunControl.ISuspendedDMEvent) {
            this.resetStackFrameLimit((IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)e).getDMContext());
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)e).getDMContext();
            this.buildDeltaForSuspendedEvent(execDmc, execDmc, parent, nodeOffset, rm);
        } else if (e instanceof SteppingController.SteppingTimedOutEvent) {
            this.buildDeltaForSteppingTimedOutEvent((SteppingController.SteppingTimedOutEvent)((Object)e), parent, nodeOffset, rm);
        } else if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            this.buildDeltaForModelProxyInstalledEvent(parent, nodeOffset, rm);
        } else if (e instanceof ExpandStackEvent) {
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((ExpandStackEvent)((Object)e)).getDMContext();
            this.buildDeltaForExpandStackEvent(execDmc, parent, rm);
        } else if (e instanceof PropertyChangeEvent) {
            String property = ((PropertyChangeEvent)e).getProperty();
            if ("stackFrameLimitEnable".equals(property) || "stackFrameLimit".equals(property)) {
                this.buildDeltaForStackFrameLimitPreferenceChangedEvent(parent, rm);
            } else if ("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths".equals(property)) {
                this.buildDeltaForShowFullPathPreferenceChangedEvent(parent, rm);
            } else {
                rm.done();
            }
        } else {
            rm.done();
        }
    }

    protected void buildDeltaForSuspendedEvent(IRunControl.IExecutionDMContext executionCtx, IRunControl.IExecutionDMContext triggeringCtx, final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        if (executionCtx.equals(triggeringCtx)) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x100000);
            this.getVMProvider().updateNode((IVMNode)this, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), 0, 1, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

                public void handleCompleted() {
                    List data = (List)this.getData();
                    if (data != null && data.size() != 0) {
                        parentDelta.addNode(data.get(0), 0, 0x200800);
                    }
                    rm.done();
                }
            }));
        }
    }

    protected void buildDeltaForFullStackRefreshEvent(IRunControl.IExecutionDMContext executionCtx, final IRunControl.IExecutionDMContext triggeringCtx, final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRunControl runControlService = (IRunControl)StackFramesVMNode.this.getServicesTracker().getService(IRunControl.class);
                    IStack stackService = (IStack)StackFramesVMNode.this.getServicesTracker().getService(IStack.class);
                    if (stackService == null || runControlService == null) {
                        rm.done();
                        return;
                    }
                    if (triggeringCtx == null || !runControlService.isStepping(triggeringCtx)) {
                        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
                    }
                    rm.done();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rm.done();
        }
    }

    protected void buildDeltaForSteppingTimedOutEvent(SteppingController.SteppingTimedOutEvent e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        rm.done();
    }

    protected void buildDeltaForModelProxyInstalledEvent(final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        this.getVMProvider().updateNode((IVMNode)this, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            public void handleCompleted() {
                if (this.isSuccess() && ((List)this.getData()).size() != 0) {
                    parentDelta.addNode(((List)this.getData()).get(0), 0, 0x300000);
                }
                rm.done();
            }
        }));
    }

    protected void buildDeltaForExpandStackEvent(IRunControl.IExecutionDMContext execDmc, final VMDelta parentDelta, final RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        final int offset = this.getStackFrameLimit(execDmc) / 2;
        this.getVMProvider().updateNode((IVMNode)this, new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), offset, offset, new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            public void handleCompleted() {
                List data = (List)this.getData();
                if (data != null && data.size() != 0) {
                    parentDelta.addNode(data.get(0), offset, 0x200000);
                }
                rm.done();
            }
        }));
    }

    protected void buildDeltaForStackFrameLimitPreferenceChangedEvent(VMDelta parentDelta, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        rm.done();
    }

    private void buildDeltaForShowFullPathPreferenceChangedEvent(VMDelta parentDelta, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x800);
        rm.done();
    }

    private String produceFrameElementName(String viewName, IStack.IFrameDMContext frame) {
        if (viewName.startsWith("org.eclipse.debug.ui.VariableView") || viewName.startsWith("org.eclipse.debug.ui.ExpressionView")) {
            return "Frame." + frame.getLevel() + "." + frame.getSessionId();
        }
        return "Frame" + frame.getSessionId();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString("STACK_FRAME_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IStack.IFrameDMContext) {
                String elementName = this.produceFrameElementName(request.getPresentationContext().getId(), (IStack.IFrameDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IStack.IFrameDMContext) {
                String elementName = this.produceFrameElementName(request.getPresentationContext().getId(), (IStack.IFrameDMContext)dmc);
                memento.putString("STACK_FRAME_MEMENTO_NAME", elementName);
            }
            request.done();
            ++n2;
        }
    }

    public int getStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        if (this.fTemporaryLimits.containsKey(execCtx)) {
            return this.fTemporaryLimits.get(execCtx);
        }
        Object stackDepthLimit = this.getVMProvider().getPresentationContext().getProperty("stackFrameLimit");
        if (stackDepthLimit instanceof Integer) {
            return (Integer)stackDepthLimit;
        }
        return Integer.MAX_VALUE;
    }

    protected void resetStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        if (execCtx instanceof IRunControl.IContainerDMContext) {
            Iterator<IRunControl.IExecutionDMContext> itr = this.fTemporaryLimits.keySet().iterator();
            while (itr.hasNext()) {
                IRunControl.IExecutionDMContext limitCtx = itr.next();
                if (!limitCtx.equals(execCtx) && !DMContexts.isAncestorOf((IDMContext)limitCtx, (IDMContext)execCtx)) continue;
                itr.remove();
            }
        } else {
            this.fTemporaryLimits.remove(execCtx);
        }
    }

    public void incrementStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        int stackFrameLimit = this.getStackFrameLimit(execCtx);
        if (stackFrameLimit < 0x3FFFFFFF) {
            this.fTemporaryLimits.put(execCtx, stackFrameLimit * 2);
        } else {
            this.fTemporaryLimits.put(execCtx, Integer.MAX_VALUE);
        }
    }

    public class IncompleteStackVMContext
    extends AbstractVMContext {
        private final int fLevel;
        private final IRunControl.IExecutionDMContext fDmc;

        public IncompleteStackVMContext(IRunControl.IExecutionDMContext dmc, int level) {
            super(StackFramesVMNode.this);
            this.fDmc = dmc;
            this.fLevel = level;
        }

        public int getLevel() {
            return this.fLevel;
        }

        public IRunControl.IExecutionDMContext getExecutionDMContext() {
            return this.fDmc;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof IncompleteStackVMContext && ((IncompleteStackVMContext)obj).fDmc.equals(this.fDmc);
        }

        @Override
        public int hashCode() {
            return this.fDmc.hashCode();
        }
    }
}

