/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.parts.VerticalRulerEditPart;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.swt.graphics.Cursor;

public class VerticalRulerReorderDragTracker
extends SimpleDragTracker {
    protected static final int DRAG_THRESHOLD = 3;
    private VerticalRulerEditPart source;
    private Timeline timeline;
    private Point buttonDownLoc;
    private VerticalRulerEditPart.InsertLocation insertLocation;

    public VerticalRulerReorderDragTracker(VerticalRulerEditPart source, Timeline timeline) {
        this.source = source;
        this.timeline = timeline;
    }

    protected boolean movedPastThreshold() {
        return Math.abs(this.getLocation().y - this.getStartLocation().y) > 3;
    }

    protected void eraseSourceFeedback() {
    }

    protected void showSourceFeedback() {
        this.source.setSelectedTimeline(this.timeline, true);
        Point loc = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)loc);
        this.insertLocation = this.source.setInsertLocation(this.timeline, this.buttonDownLoc, loc);
    }

    protected boolean handleButtonDown(int button) {
        boolean res = super.handleButtonDown(button);
        this.source.setSelectedTimeline(this.timeline, false);
        this.buttonDownLoc = this.getStartLocation();
        this.source.getFigure().translateToRelative((Translatable)this.buttonDownLoc);
        return res;
    }

    protected void performDrag() {
        this.source.reorderTimeline(this.timeline, this.insertLocation);
    }

    protected Cursor getDefaultCursor() {
        return Cursors.SIZENS;
    }

    protected String getDebugName() {
        return "Vertical Ruler Reordering";
    }

    protected String getCommandName() {
        return "Reorder";
    }
}

