/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViewUtils;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.RunAnalysisStageAction;
import com.nvidia.viper.actions.RunnerAction;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.NvprofMessageDialog;
import com.nvidia.viper.ui.RememberChoiceDialog;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.Disposable;

public class RunAnalysisAction
extends RunnerAction
implements Disposable {
    private Session session;
    private final boolean timelineOnly;
    private final ShowMode showMode;

    public RunAnalysisAction(Session session, boolean timelineOnly, ShowMode showMode) {
        super(ViperMessages.RunAnalysis_Label, ViperImages.DESC_RUN_ANALYSIS);
        this.session = session;
        this.timelineOnly = timelineOnly;
        this.showMode = showMode;
        this.setToolTipText(ViperMessages.RunAnalysis_Tooltip);
        this.setId("com.nvidia.viper.runanalysis");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.session = null;
    }

    public void run() {
        Analysis analysis;
        if (ShowMode.GUIDED.equals((Object)this.showMode) && this.session != null && this.session.isProfileInRebel()) {
            RememberChoiceDialog.openMessage("Unable To Run Guided Analysis", "The Guided Analysis is not supported on devices with compute capability greater than 7.2", "ShowGuidedAnalysisNotSupported", false, new String[]{"OK"});
        }
        if ((analysis = this.session.getAnalysis()) != null) {
            AnalysisStage[] aStages;
            if (this.timelineOnly) {
                aStages = new AnalysisStage[]{AnalysisStage.TIMELINE};
            } else {
                AnalysisStage[] allStages = analysis.getOrderedStages();
                LinkedHashSet<AnalysisStage> stages = new LinkedHashSet<AnalysisStage>(Arrays.asList(allStages));
                stages.removeAll(analysis.getVisitedStages());
                if (stages.size() > 1) {
                    stages.remove((Object)AnalysisStage.NVLINK_TOPOLOGY);
                }
                aStages = stages.toArray(new AnalysisStage[stages.size()]);
            }
            if (aStages.length > 0) {
                RunAnalysisStageAction analysisAction = new RunAnalysisStageAction(this.session, aStages, this.session.getExecutable() == null ? RunAnalysisStageAction.DataCollection.NONE : RunAnalysisStageAction.DataCollection.IFNEEDED){

                    @Override
                    public void analysisCompleted(IStatus status) {
                        analysis.setVisitedStages(aStages, true);
                        if (RunAnalysisAction.this.timelineOnly) {
                            analysis.setSelectedStage(aStages[0]);
                        }
                        if (RunAnalysisAction.this.session.getAnalysis() != null && !ShowMode.NONE.equals((Object)RunAnalysisAction.this.showMode)) {
                            if (!ShowMode.NONE.equals((Object)RunAnalysisAction.this.showMode)) {
                                AnalysisViewMode current = AnalysisViewMode.guided;
                                if (ShowMode.UNGUIDED.equals((Object)RunAnalysisAction.this.showMode) || ShowMode.CURRENT.equals((Object)RunAnalysisAction.this.showMode)) {
                                    current = AnalysisViewMode.unguided;
                                }
                                if (ShowMode.REBEL_REPORT.equals((Object)RunAnalysisAction.this.showMode)) {
                                    current = AnalysisViewMode.rebelreport;
                                }
                                RunAnalysisAction.this.session.getAnalysis().setCurrentAnalysisMode(current);
                                if (RunAnalysisAction.this.session.getExpertSystem() != null) {
                                    RunAnalysisAction.this.session.getExpertSystem().setCurrentStageKind(ExpertSystemStageKind.INTRO);
                                }
                            }
                            if (!NvprofMessageDialog.openWarning(RunAnalysisAction.this.session)) {
                                ViewUtils.showAnalysisView();
                            }
                        }
                    }
                };
                analysisAction.run();
            }
        }
    }

    public static enum ShowMode {
        NONE,
        CURRENT,
        UNGUIDED,
        GUIDED,
        REBEL_REPORT;

    }
}

