/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.nvccsupport;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class NvccSpecsConsoleParser
implements IScannerInfoConsoleParser {
    private static final String INCLUDES_PREFIX = "#$ INCLUDES=";
    public static final String CUDA_ARCH_MACRO = "__CUDA_ARCH__";
    private static final Pattern MACRO_PATTERN = Pattern.compile("-D([\\w]*)(=([\\w]*))?");
    public static final String GCC_INVOKE_PATTERN = String.format("^#\\$ gcc.*-D%s=\\d*?[ $].*", "__CUDA_ARCH__");
    public static final String CLANG_INVOKE_PATTERN = String.format("^#\\$ clang.*-D%s=\\d*?[ $].*", "__CUDA_ARCH__");
    private final Collection<String> includePaths = new LinkedList<String>();
    private Map<String, String> archMacro = Collections.emptyMap();
    private IScannerInfoCollector collector;
    private IProject project;
    private Architecture arch;

    public boolean processLine(String line) {
        if (line.startsWith(INCLUDES_PREFIX)) {
            String s = line.substring(INCLUDES_PREFIX.length()).trim();
            s = s.substring("\"-I".length(), s.length() - 1);
            String[] strings = s.split("\" \"\\-I");
            this.includePaths.addAll(Arrays.asList(strings));
        } else if (Pattern.matches(GCC_INVOKE_PATTERN, line) || Pattern.matches(CLANG_INVOKE_PATTERN, line)) {
            Map<String, String> macro = this.getMacro(line);
            String curVersion = macro.get(CUDA_ARCH_MACRO);
            if (this.arch != null) {
                if (this.arch.getMacroValue().equals(curVersion)) {
                    macro.putAll(this.archMacro);
                    this.archMacro = macro;
                }
            } else {
                String prevVersion = this.archMacro.get(CUDA_ARCH_MACRO);
                if (prevVersion == null || curVersion != null && curVersion.compareTo(prevVersion) < 0) {
                    this.archMacro = macro;
                } else if (curVersion == null || curVersion.compareTo(prevVersion) == 0) {
                    macro.putAll(this.archMacro);
                    this.archMacro = macro;
                }
            }
        }
        return true;
    }

    private Map<String, String> getMacro(String line) {
        HashMap<String, String> macro = new HashMap<String, String>();
        Matcher matcher = MACRO_PATTERN.matcher(line);
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = matcher.group(3);
            macro.put(name, value);
        }
        macro.put("__CUDA_RUNTIME_H__", "");
        macro.put("__DRIVER_TYPES_H__", "");
        return macro;
    }

    public void shutdown() {
        HashMap<ScannerInfoTypes, List<String>> scannerInfo = new HashMap<ScannerInfoTypes, List<String>>();
        scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, new ArrayList<String>(this.includePaths));
        scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, this.getMacrosList(this.archMacro));
        if (this.collector != null) {
            if (this.collector instanceof PerProjectSICollector) {
                ((PerProjectSICollector)this.collector).deleteAll((IResource)this.project);
                ((PerProjectSICollector)this.collector).contributeToScannerConfig((Object)this.project, scannerInfo, true);
            } else {
                this.collector.contributeToScannerConfig((Object)this.project, scannerInfo);
            }
        }
    }

    private List<String> getMacrosList(Map<String, String> macros) {
        if (macros.isEmpty()) {
            return Collections.singletonList("__CUDACC__=");
        }
        ArrayList<String> result = new ArrayList<String>(macros.size());
        Set<Map.Entry<String, String>> set = macros.entrySet();
        for (Map.Entry<String, String> entry : set) {
            result.add(String.format("%s=%s", entry.getKey(), entry.getValue() != null ? entry.getValue() : ""));
        }
        return result;
    }

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.project = project;
        this.collector = collector;
        ICProjectDescription description = CoreModel.getDefault().getProjectDescriptionManager().getProjectDescription(project);
        if (description != null) {
            this.arch = CudaProjectUtil.getEditorArch(description);
        }
        this.includePaths.clear();
        this.archMacro = Collections.emptyMap();
    }
}

