/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.mi;

import com.nvidia.cuda.ide.debug.mi.AbstractMITableInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedThreadInfo;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MICudaInfoThreadsInfo
extends AbstractMITableInfo<UncoalescedThreadInfo> {
    public MICudaInfoThreadsInfo(MIOutput record) {
        super(record, "UncoalescedInfoCudaThreadsTable");
    }

    @Override
    protected void setEntryProperty(UncoalescedThreadInfo entry, String var, String val) {
        if ("kernel".equals(var)) {
            entry.setKernelId(Long.parseLong(val));
        } else if ("blockIdx".equals(var)) {
            entry.setBlockIdx(CudaCoord.parse(val));
        } else if ("threadIdx".equals(var)) {
            entry.setThreadIdx(CudaCoord.parse(val));
        } else if ("warp".equals(var)) {
            entry.setWarp(Short.parseShort(val));
        } else if ("lane".equals(var)) {
            entry.setLane(Short.parseShort(val));
        } else if ("virtual_pc".equals(var)) {
            entry.setVirtualPC(Long.parseLong(val.substring(2), 16));
        } else if ("filename".equals(var)) {
            entry.setSourceFile(val);
        } else if ("line".equals(var)) {
            entry.setLineNo(Integer.parseInt(val));
        }
    }

    @Override
    protected UncoalescedThreadInfo createEntry(String variable) {
        if (variable.equals("UncoalescedInfoCudaThreadsRow")) {
            return new UncoalescedThreadInfo();
        }
        return null;
    }

    protected UncoalescedThreadInfo[] createArray(int length) {
        return new UncoalescedThreadInfo[length];
    }
}

