/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildListComparator;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IConfigurationModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IConflict;
import org.eclipse.cdt.managedbuilder.tcmodification.IFileInfoModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IFolderInfoModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IModificationOperation;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolListModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolModification;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolSelectionDialog;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ToolChainEditTab
extends AbstractCBuildPropertyTab {
    private static final IToolChainModificationManager tcmmgr = ManagedBuildManager.getToolChainModificationManager();
    private static final String NO_TC = Messages.StdProjectTypeHandler_0;
    private static final IToolChain[] r_tcs = ManagedBuildManager.getRealToolChains();
    private static final IBuilder[] r_bs = ManagedBuildManager.getRealBuilders();
    private static final ITool[] r_tools = ManagedBuildManager.getRealTools();
    private static final Color red = Display.getDefault().getSystemColor(3);
    private static final String SPACE = " ";
    private static final Image IMG_WARNING = CDTSharedImages.getImage((String)"icons/obj16/warning_obj.gif");
    private static final Image IMG_ERROR = CDTSharedImages.getImage((String)"icons/obj16/error_obj.gif");
    private static final Image IMG_INFO = CDTSharedImages.getImage((String)"icons/obj16/info_obj.gif");
    private Text text;
    private Button b_dispCompatible;
    private Combo c_toolchain;
    private Combo c_builder;
    private Combo c_tool;
    private Button button_edit;
    private Group tools_group;
    private Group single_tool_group;
    private Text st_builder;
    private Text st_toolchain;
    private Label st_tool;
    private IBuilder[] v_bs;
    private IToolChain[] v_tcs;
    private ITool[] v_tools;
    private IConfiguration cfg;
    private IResourceInfo ri;
    private IToolListModification mod;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(2, false));
        this.b_dispCompatible = this.setupCheck(this.usercomp, Messages.ToolChainEditTab_0, 2, 1);
        this.b_dispCompatible.setSelection(true);
        this.setupLabel(this.usercomp, Messages.ToolChainEditTab_1, 1, 1);
        this.c_toolchain = new Combo(this.usercomp, 2060);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.c_toolchain.setLayoutData((Object)gd);
        this.c_toolchain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainEditTab.this.modifyToolchain();
            }
        });
        this.c_toolchain.setEnabled(!this.page.isForFile());
        this.st_toolchain = new Text(this.usercomp, 16392);
        this.setupControl((Control)this.st_toolchain, 2, 768);
        this.st_toolchain.setForeground(red);
        this.setupLabel(this.usercomp, Messages.ToolChainEditTab_2, 1, 1);
        this.c_builder = new Combo(this.usercomp, 2060);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.c_builder.setLayoutData((Object)gd);
        this.c_builder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainEditTab.this.modifyBuilder();
            }
        });
        this.c_builder.setEnabled(this.page.isForProject());
        this.st_builder = new Text(this.usercomp, 16392);
        this.setupControl((Control)this.st_builder, 2, 768);
        this.st_builder.setForeground(red);
        if (this.page.isForFile()) {
            this.single_tool_group = this.setupGroup(this.usercomp, Messages.ToolChainEditTab_5, 2, 1808);
            this.setupControl((Control)this.single_tool_group, 2, 1808);
            this.c_tool = new Combo((Composite)this.single_tool_group, 2060);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.c_tool.setLayoutData((Object)gd);
            this.c_tool.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolChainEditTab.this.saveToolSelected();
                }
            });
            this.st_tool = this.setupLabel((Composite)this.single_tool_group, "", 2, 768);
            this.st_tool.setForeground(red);
        } else {
            this.tools_group = this.setupGroup(this.usercomp, Messages.ToolChainEditTab_3, 2, 1808);
            this.setupControl((Control)this.tools_group, 2, 1808);
            this.text = new Text((Composite)this.tools_group, 2890);
            gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            this.text.setLayoutData((Object)gd);
            this.button_edit = new Button((Composite)this.tools_group, 8);
            GridData gdb = new GridData(4);
            gdb.grabExcessHorizontalSpace = false;
            gdb.horizontalAlignment = 4;
            gdb.widthHint = 80;
            this.button_edit.setLayoutData((Object)gdb);
            this.button_edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ToolChainEditTab.this.modifyTools();
                }
            });
            this.button_edit.setLayoutData((Object)new GridData(3));
            this.button_edit.setText(Messages.ToolChainEditTab_4);
        }
    }

    private IToolListModification getModification() {
        if (this.ri instanceof IFolderInfo) {
            return tcmmgr.createModification((IFolderInfo)this.ri);
        }
        return tcmmgr.createModification((IFileInfo)this.ri);
    }

    protected void updateData(ICResourceDescription rcfg) {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, null);
            return;
        }
        this.setAllVisible(true, null);
        this.cfg = ToolChainEditTab.getCfg(rcfg.getConfiguration());
        this.ri = this.cfg.getResourceInfo(rcfg.getPath(), false);
        this.mod = this.getModification();
        this.updateData();
    }

    public boolean canSupportMultiCfg() {
        return false;
    }

    private void updateData() {
        this.showErrorMessage();
        this.fillToolChainCombo();
        this.fillBuilderCombo();
        this.fillToolsList();
    }

    private void showErrorMessage() {
        if (this.ri instanceof IFolderInfo) {
            IConfigurationModification cm;
            IFolderInfoModification foim = (IFolderInfoModification)this.mod;
            IToolChain toolChain = ((IFolderInfoModification)this.mod).getToolChain();
            IToolChain realToolChain = ManagedBuildManager.getRealToolChain((IToolChain)toolChain);
            if (realToolChain == null) {
                String errText = NLS.bind((String)Messages.ToolChainEditTab_OrphanedToolchain, (Object)toolChain.getId(), (Object)toolChain.getName());
                this.st_toolchain.setText(errText);
            } else if (foim.isToolChainCompatible()) {
                this.st_toolchain.setText("");
            } else {
                String s = foim.getToolChainCompatibilityStatus().getMessage();
                this.st_toolchain.setText(s);
            }
            this.st_builder.setText("");
            if (foim instanceof IConfigurationModification && !(cm = (IConfigurationModification)foim).isBuilderCompatible()) {
                IBuilder builder = this.cfg.getBuilder();
                IBuilder realBuilder = ManagedBuildManager.getRealBuilder((IBuilder)builder);
                if (realBuilder == null) {
                    String errText = NLS.bind((String)Messages.ToolChainEditTab_OrphanedBuilder, (Object)builder.getId(), (Object)builder.getName());
                    this.st_builder.setText(errText);
                } else {
                    CompatibilityStatus cs = cm.getBuilderCompatibilityStatus();
                    if (cs != null) {
                        String s = cs.getMessage();
                        this.st_builder.setText(s);
                    }
                }
            }
        }
        this.st_toolchain.setEnabled(!"".equals(this.st_toolchain.getText()));
        this.st_builder.setEnabled(!"".equals(this.st_builder.getText()));
    }

    private void fillToolChainCombo() {
        IToolChain toolChainInstance;
        IToolChain realToolChain = null;
        if (this.ri instanceof IFolderInfo && (realToolChain = ManagedBuildManager.getRealToolChain((IToolChain)(toolChainInstance = ((IFolderInfoModification)this.mod).getToolChain()))) == null) {
            realToolChain = toolChainInstance;
        }
        this.c_toolchain.removeAll();
        boolean isMng = this.cfg.getBuilder().isManagedBuildOn();
        ArrayList<IToolChain> list = new ArrayList<IToolChain>();
        IToolChain[] tcs = r_tcs;
        if (this.b_dispCompatible.getSelection() && this.ri instanceof IFolderInfo) {
            IFolderInfoModification fim = (IFolderInfoModification)this.mod;
            tcs = fim.getCompatibleToolChains();
            IToolChain[] tcs1 = new IToolChain[tcs.length + 1];
            System.arraycopy(tcs, 0, tcs1, 0, tcs.length);
            tcs1[tcs.length] = realToolChain;
            tcs = tcs1;
        }
        IToolChain[] iToolChainArray = tcs;
        int n = tcs.length;
        int tcs1 = 0;
        while (tcs1 < n) {
            IToolChain tc = iToolChainArray[tcs1];
            if (!tc.isSystemObject() || ((ToolChain)tc).isPreferenceToolChain() && !isMng) {
                list.add(tc);
            }
            ++tcs1;
        }
        Collections.sort(list, BuildListComparator.getInstance());
        int pos = -1;
        this.v_tcs = list.toArray(new IToolChain[list.size()]);
        int i = 0;
        while (i < this.v_tcs.length) {
            this.c_toolchain.add(this.v_tcs[i].getUniqueRealName());
            if (this.v_tcs[i].matches(realToolChain)) {
                pos = i;
            }
            ++i;
        }
        if (pos != -1) {
            this.c_toolchain.select(pos);
            this.c_builder.setEnabled(this.page.isForProject());
        } else {
            this.c_toolchain.setText("");
            this.c_builder.setEnabled(false);
        }
    }

    private void fillBuilderCombo() {
        IFolderInfoModification fim;
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder((IBuilder)this.cfg.getBuilder());
        if (realBuilder == null) {
            realBuilder = this.cfg.getBuilder();
        }
        int pos = -1;
        this.c_builder.removeAll();
        ArrayList<IBuilder> list = new ArrayList<IBuilder>();
        IBuilder[] bs = r_bs;
        if (this.b_dispCompatible.getSelection() && this.ri instanceof IFolderInfo && (fim = (IFolderInfoModification)this.mod) instanceof IConfigurationModification) {
            bs = ((IConfigurationModification)fim).getCompatibleBuilders();
            IBuilder[] bs1 = new IBuilder[bs.length + 1];
            System.arraycopy(bs, 0, bs1, 0, bs.length);
            bs1[bs.length] = realBuilder;
            bs = bs1;
        }
        int i = 0;
        while (i < bs.length) {
            if (!bs[i].isSystemObject() || bs[i].equals(realBuilder)) {
                list.add(bs[i]);
            }
            ++i;
        }
        bs = null;
        Collections.sort(list, BuildListComparator.getInstance());
        this.v_bs = list.toArray(new IBuilder[list.size()]);
        i = 0;
        while (i < this.v_bs.length) {
            this.c_builder.add(this.v_bs[i].getUniqueRealName());
            if (this.v_bs[i].matches(realBuilder)) {
                pos = i;
            }
            ++i;
        }
        if (pos != -1) {
            this.c_builder.select(pos);
        } else {
            this.c_builder.setText("");
        }
    }

    private ITool getToolForFile() {
        ITool[] tools = ((IFileInfoModification)this.mod).getProjectTools();
        if (tools != null && tools.length > 0) {
            int i = 0;
            while (i < tools.length) {
                if (tools[i] != null && !tools[i].getCustomBuildStep()) {
                    return tools[i];
                }
                ++i;
            }
        }
        return null;
    }

    private void fillToolCombo(boolean add, ITool curr) {
        this.c_tool.removeAll();
        int pos = curr == null ? this.v_tools.length : -1;
        int i = 0;
        while (i < this.v_tools.length) {
            if (pos == -1 && curr.matches(this.v_tools[i])) {
                pos = i;
                this.c_tool.add(curr.getUniqueRealName());
            } else {
                this.c_tool.add(this.v_tools[i].getUniqueRealName());
            }
            ++i;
        }
        if (add) {
            this.c_tool.add(Messages.ToolChainEditTab_6);
        }
        this.c_tool.select(pos);
    }

    private void fillToolsList() {
        this.updateAllTools();
        ToolChain tc = null;
        if (this.ri instanceof IFolderInfo) {
            tc = (ToolChain)ManagedBuildManager.getRealToolChain((IToolChain)((IFolderInfo)this.ri).getToolChain());
        }
        if (this.page.isForFile()) {
            ITool curr = this.getToolForFile();
            boolean canAddNO_TOOL = true;
            if (this.ri instanceof IFileInfo && this.b_dispCompatible.getSelection()) {
                canAddNO_TOOL = this.updateCompatibleTools(curr);
            }
            this.fillToolCombo(canAddNO_TOOL, curr);
            this.showToolStatus(curr);
        } else if (tc != null && tc.isPreferenceToolChain()) {
            this.tools_group.setVisible(false);
        } else {
            ITool[] tools;
            this.tools_group.setVisible(true);
            String s = "";
            ITool[] iToolArray = tools = this.ri.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                s = String.valueOf(s) + tool.getUniqueRealName() + "\n";
                ++n2;
            }
            this.text.setText(s);
        }
    }

    private void updateAllTools() {
        int cnt = 0;
        this.v_tools = new ITool[r_tools.length];
        ITool[] iToolArray = r_tools;
        int n = r_tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool r_tool = iToolArray[n2];
            if (!r_tool.isSystemObject() && !r_tool.isAbstract()) {
                this.v_tools[cnt++] = r_tool;
            }
            ++n2;
        }
        ITool[] tmp = new ITool[cnt];
        System.arraycopy(this.v_tools, 0, tmp, 0, cnt);
        Arrays.sort(tmp, BuildListComparator.getInstance());
        this.v_tools = tmp;
    }

    private void showToolStatus(ITool tool) {
        CompatibilityStatus cs;
        this.st_tool.setText("");
        this.st_tool.setImage(null);
        if (tool == null) {
            return;
        }
        IFileInfoModification fim = (IFileInfoModification)this.mod;
        IToolModification tm = fim.getToolModification(tool);
        if (tm != null && !tm.isCompatible() && (cs = tm.getCompatibilityStatus()) != null) {
            this.st_tool.setText(cs.getMessage());
            this.st_tool.setImage(ToolChainEditTab.getErrorIcon((IStatus)cs));
        }
    }

    private boolean updateCompatibleTools(ITool real) {
        boolean result = false;
        ArrayList<ITool> list = new ArrayList<ITool>();
        IFileInfoModification fim = (IFileInfoModification)this.mod;
        if (real != null) {
            IModificationOperation[] mos;
            real = ManagedBuildManager.getRealTool((ITool)real);
            list.add(real);
            IToolModification tm = fim.getToolModification(real);
            IModificationOperation[] iModificationOperationArray = mos = tm.getSupportedOperations();
            int n = mos.length;
            int n2 = 0;
            while (n2 < n) {
                IModificationOperation mo = iModificationOperationArray[n2];
                ITool t = mo.getReplacementTool();
                if (t == null) {
                    result = true;
                } else if (!t.isSystemObject() && !t.isAbstract()) {
                    list.add(t);
                }
                ++n2;
            }
        } else {
            IToolModification[] tms;
            result = true;
            IToolModification[] iToolModificationArray = tms = fim.getSystemToolModifications();
            int n = tms.length;
            int n3 = 0;
            while (n3 < n) {
                IModificationOperation[] mos;
                IToolModification tm = iToolModificationArray[n3];
                IModificationOperation[] iModificationOperationArray = mos = tm.getSupportedOperations();
                int n4 = mos.length;
                int n5 = 0;
                while (n5 < n4) {
                    IModificationOperation mo = iModificationOperationArray[n5];
                    if (mo.getReplacementTool() == null) {
                        ITool t = tm.getTool();
                        if (t.isSystemObject() || t.isAbstract()) break;
                        list.add(t);
                        break;
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        Collections.sort(list, BuildListComparator.getInstance());
        this.v_tools = list.toArray(new ITool[list.size()]);
        return result;
    }

    protected void checkPressed(SelectionEvent e) {
        this.updateData();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.mod == null) {
            return;
        }
        IConfiguration cfg = ToolChainEditTab.getCfg(dst.getConfiguration());
        try {
            IFolderInfoModification tlm = this.ri instanceof IFolderInfo ? tcmmgr.createModification(cfg, (IFolderInfoModification)this.mod) : tcmmgr.createModification(cfg, (IFileInfoModification)this.mod);
            tlm.apply();
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }

    protected void performDefaults() {
        if (this.mod != null) {
            this.mod.restoreDefaults();
            this.apply();
            this.updateData();
        }
    }

    protected void updateButtons() {
    }

    private void saveToolSelected() {
        IFileInfoModification fim = (IFileInfoModification)this.mod;
        ITool oldTool = null;
        ITool[] ots = fim.getProjectTools();
        int i = 0;
        while (i < ots.length) {
            if (!ots[i].getCustomBuildStep()) {
                oldTool = ots[i];
                break;
            }
            ++i;
        }
        ITool newTool = null;
        int pos = this.c_tool.getSelectionIndex();
        if (pos < this.c_tool.getItemCount() - 1) {
            newTool = this.v_tools[pos];
        }
        if (newTool == null && oldTool == null) {
            return;
        }
        if (newTool != null && newTool.matches(oldTool)) {
            return;
        }
        fim.changeProjectTools(oldTool, newTool);
        this.apply();
        this.updateData();
    }

    private void modifyTools() {
        ToolSelectionDialog d = new ToolSelectionDialog(this.usercomp.getShell(), this.ri);
        d.all = this.v_tools;
        d.fi = (IFolderInfo)this.ri;
        d.mod = this.mod;
        int result = d.open();
        if (d.removed.size() > 0 || d.added.size() > 0) {
            if (result == 0) {
                this.apply();
                this.updateData();
            } else {
                this.mod = this.getModification();
            }
        }
    }

    private void apply() {
        try {
            this.mod.apply();
        }
        catch (CoreException e) {
            ManagedBuilderUIPlugin.log(e);
        }
    }

    private void modifyToolchain() {
        IFolderInfoModification foim = (IFolderInfoModification)this.mod;
        int x = this.c_toolchain.getSelectionIndex();
        if (NO_TC.equals(this.c_toolchain.getItem(x))) {
            foim.setToolChain(null);
        } else {
            IToolChain tc = this.v_tcs[x];
            if (tc == null) {
                return;
            }
            foim.setToolChain(tc);
        }
        this.apply();
        this.updateData();
    }

    public static Image getErrorIcon(IStatus st) {
        if (st.isOK()) {
            return null;
        }
        int sev = st.getSeverity();
        if (sev == 4) {
            return IMG_ERROR;
        }
        if (sev == 2) {
            return IMG_WARNING;
        }
        return IMG_INFO;
    }

    private void modifyBuilder() {
        IConfigurationModification cm = (IConfigurationModification)this.mod;
        cm.setBuilder(this.v_bs[this.c_builder.getSelectionIndex()]);
        this.apply();
        this.updateData();
    }

    public static String getCompatibilityMessage(CompatibilityStatus cs) {
        IConflict[] cons = cs.getConflicts();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < cons.length) {
            IBuildObject bo = cons[i].getBuildObject();
            String n = bo == null ? "NULL" : (bo instanceof ITool ? ((ITool)bo).getUniqueRealName() : bo.getName());
            String t = "";
            switch (cons[i].getConflictType()) {
                case 1: {
                    t = Messages.ToolChainEditTab_7;
                    break;
                }
                case 2: {
                    t = Messages.ToolChainEditTab_8;
                }
            }
            String o = "";
            switch (cons[i].getObjectType()) {
                case 1: {
                    o = Messages.ToolChainEditTab_9;
                    break;
                }
                case 4: {
                    o = Messages.ToolChainEditTab_10;
                    break;
                }
                case 32: {
                    o = Messages.ToolChainEditTab_11;
                    break;
                }
                case 8: {
                    o = Messages.ToolChainEditTab_12;
                    break;
                }
                case 16: {
                    o = Messages.ToolChainEditTab_13;
                    break;
                }
                case 2: {
                    o = Messages.ToolChainEditTab_14;
                }
            }
            result.append(String.valueOf(Messages.ToolChainEditTab_15) + (i + 1) + Messages.ToolChainEditTab_16 + SPACE + t + SPACE + o + SPACE + n + Messages.ToolChainEditTab_17);
            ++i;
        }
        String s = result.toString();
        if (s.trim().length() == 0) {
            s = cs.getMessage();
        }
        if (s == null) {
            s = "";
        }
        return s;
    }
}

