/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.make.core.makefile.ICommand;
import org.eclipse.cdt.make.internal.core.makefile.Directive;

public class Command
extends Directive
implements ICommand {
    public static final char NL = '\n';
    String command = "";
    char prefix = '\u0000';

    public Command(Directive parent, String cmd) {
        super(parent);
        this.parse(cmd);
    }

    @Override
    public boolean shouldIgnoreError() {
        return this.getPrefix() == '-';
    }

    @Override
    public boolean shouldBeSilent() {
        return this.getPrefix() == '@';
    }

    @Override
    public boolean shouldExecute() {
        return this.getPrefix() == '+';
    }

    @Override
    public String toString() {
        StringBuffer cmd = new StringBuffer();
        cmd.append('\t');
        if (this.getPrefix() != '\u0000') {
            cmd.append(this.getPrefix());
        }
        cmd.append(this.command).append('\n');
        return cmd.toString();
    }

    public boolean equals(Command cmd) {
        return cmd.toString().equals(this.toString());
    }

    char getPrefix() {
        return this.prefix;
    }

    void parse(String cmd) {
        this.command = cmd.trim();
        if (this.command.startsWith("-") || this.command.startsWith("@") || this.command.startsWith("+")) {
            this.prefix = this.command.charAt(0);
            this.command = this.command.substring(1).trim();
        }
    }

    @Override
    public Process execute(String shell, String[] envp, File dir) throws IOException {
        String[] cmdArray = new String[]{shell, "-c", this.command};
        return Runtime.getRuntime().exec(cmdArray, envp, dir);
    }
}

