/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIWatchpointScopeEvent
extends MIStoppedEvent {
    int number;

    public MIWatchpointScopeEvent(MISession source, MIExecAsyncOutput async) {
        super(source, async);
        this.parse();
    }

    public MIWatchpointScopeEvent(MISession source, MIResultRecord record) {
        super(source, record);
        this.parse();
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    void parse() {
        MIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        MIResultRecord rr = this.getMIResultRecord();
        MIResult[] results = null;
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String str;
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                if (var.equals("wpnum")) {
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getString();
                        try {
                            this.number = Integer.parseInt(str.trim());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("thread-id")) {
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getString();
                        try {
                            int id = Integer.parseInt(str.trim());
                            this.setThreadId(id);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (var.equals("frame") && value instanceof MITuple) {
                    MIFrame f = new MIFrame((MITuple)value);
                    this.setFrame(f);
                }
                ++i;
            }
        }
    }
}

