/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.MetricManager;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultWarpExecutionEfficiency;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.AnalysisUtils;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import java.util.List;
import java.util.Set;

public class KernelInstructionAnalysis
extends AnalysisBase {
    public static final int DEFAULT_THREADS_PER_WARP = 32;
    public static final double BAD_WARP_EXECUTION_EFFICIENCY = 80.0;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = true;
        if (session.getTimelines().isEmpty()) {
            results.add(new AnalysisResult(AnalysisDescriptor.KERNELINST_NO_TIMELINE));
            ret = false;
        } else {
            List<Timeline> deviceTimelines = session.getTimelines(TimelineKind.DEVICE);
            if (deviceTimelines.isEmpty()) {
                results.add(new AnalysisResult(AnalysisDescriptor.KERNELINST_NO_DEVICE));
            } else {
                if (generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELINST_NO_TIMELINE));
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELINST_NO_DEVICE));
                }
                boolean retWarpExec = this.runWarpExecutionEfficiencyAnalysis(session, results, deviceTimelines, generateAllResults);
                ret = ret && retWarpExec;
            }
        }
        return ret;
    }

    private boolean runWarpExecutionEfficiencyAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        boolean ret = true;
        AnalysisResultWarpExecutionEfficiency goodWarpExecutionEfficiency = new AnalysisResultWarpExecutionEfficiency(session, AnalysisDescriptor.KERNELINST_WARP_EXECUTION_EFFICIENCY_GOOD);
        AnalysisResultWarpExecutionEfficiency badWarpExecutionEfficiency = new AnalysisResultWarpExecutionEfficiency(session, AnalysisDescriptor.KERNELINST_WARP_EXECUTION_EFFICIENCY_BAD);
        AnalysisResultIntervalNoData noDataWarpExecutionEfficiency = new AnalysisResultIntervalNoData(session, AnalysisDescriptor.KERNELINST_WARP_EXECUTION_EFFICIENCY_NO_DATA);
        long totalKernelTime = 0L;
        Set<Metric> weeMetrics = MetricManager.getMetrics("warp_execution_efficiency");
        Set<Metric> wnpeeMetrics = MetricManager.getMetrics("warp_nonpred_execution_efficiency");
        for (Timeline deviceTimeline : deviceTimelines) {
            Metric weeMetric = null;
            Metric wnpeeMetric = null;
            int threadsPerWarp = ((TimelineDevice)deviceTimeline).getNumThreadsPerWarp();
            if (threadsPerWarp <= 0) {
                threadsPerWarp = 32;
            }
            List<Timeline> kernelTimelines = deviceTimeline.getDescendants(TimelineKind.KERNEL);
            for (Timeline timeline : kernelTimelines) {
                TimelineKernel kernelTimeline = (TimelineKernel)timeline;
                for (ITimelineInterval interval : kernelTimeline.getIntervals(true)) {
                    Number bestWarpExecNumber;
                    Number warpNonPredExecNumber;
                    TimelineIntervalKernel kernel = AnalysisStage.getHostLaunchedKernel(interval);
                    if (kernel == null) continue;
                    totalKernelTime += kernel.getDuration();
                    if (weeMetric == null) {
                        weeMetric = AnalysisUtils.getSingleIntersect(weeMetrics, kernel.getAggregateMetrics());
                    }
                    if (wnpeeMetric == null) {
                        wnpeeMetric = AnalysisUtils.getSingleIntersect(wnpeeMetrics, kernel.getAggregateMetrics());
                    }
                    Number warpExecNumber = weeMetric == null ? (Number)null : (Number)kernel.getAggregateMetricValue(weeMetric);
                    Number number = warpNonPredExecNumber = wnpeeMetric == null ? (Number)null : (Number)kernel.getAggregateMetricValue(wnpeeMetric);
                    if (!(warpExecNumber instanceof Double)) {
                        noDataWarpExecutionEfficiency.addInterval(kernel, null);
                        if (((TimelineDevice)deviceTimeline).getComputeCapabilityMajor() == 3 && ((TimelineDevice)deviceTimeline).getComputeCapabilityMinor() == 0) continue;
                        ret = false;
                        continue;
                    }
                    AnalysisResultWarpExecutionEfficiency.WarpExecutionEfficiency warpExecValue = new AnalysisResultWarpExecutionEfficiency.WarpExecutionEfficiency((Double)warpNonPredExecNumber, (Double)warpExecNumber);
                    Number number2 = bestWarpExecNumber = warpNonPredExecNumber != null ? (Number)warpNonPredExecNumber : (Number)warpExecNumber;
                    if (bestWarpExecNumber.doubleValue() < 80.0) {
                        badWarpExecutionEfficiency.addInterval((ITimelineInterval)kernel, warpExecValue);
                        continue;
                    }
                    goodWarpExecutionEfficiency.addInterval((ITimelineInterval)kernel, warpExecValue);
                }
            }
        }
        badWarpExecutionEfficiency.setTotalKernelTime(totalKernelTime);
        goodWarpExecutionEfficiency.setTotalKernelTime(totalKernelTime);
        if (noDataWarpExecutionEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(noDataWarpExecutionEfficiency);
        }
        if (badWarpExecutionEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(badWarpExecutionEfficiency);
        }
        if (goodWarpExecutionEfficiency.getIntervalCount() > 0 || generateAllResults) {
            results.add(goodWarpExecutionEfficiency);
        }
        return ret;
    }
}

