/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValuePercent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class AnalysisResultKernelExecutionEfficiency
extends AnalysisResult {
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private final TimelineIntervalKernel kernel;
    private final double maxExecEfficiency;
    private final Number execEfficiency;
    private final Number nonPredExecEfficiency;

    static {
        percentFormatter.setMaximumFractionDigits(1);
        percentFormatter.setGroupingUsed(false);
    }

    public AnalysisResultKernelExecutionEfficiency(TimelineIntervalKernel kernel, Number execEfficiency, Number nonPredExecEfficiency, double maxExecEfficiency) {
        super(AnalysisDescriptor.KERNEL_COMPUTE_EXEC_EFFICIENCY);
        this.kernel = kernel;
        this.execEfficiency = execEfficiency;
        this.nonPredExecEfficiency = nonPredExecEfficiency;
        this.maxExecEfficiency = maxExecEfficiency;
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public IValue getValue() {
        return new ValuePercent(this.execEfficiency);
    }

    public String getValueDescription() {
        return ViperMessages.WarpExecEfficiency_Value_Desc;
    }

    public IValue getNonPredicatedValue() {
        if (this.nonPredExecEfficiency != null) {
            return new ValuePercent(this.nonPredExecEfficiency);
        }
        return null;
    }

    public String getNonPredicatedValueDescription() {
        return ViperMessages.WarpExecEfficiency_NonpredValue_Desc;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = super.getDescription(otpt);
        desc = this.maxExecEfficiency <= 0.9 ? (!this.kernel.hasChildren() ? String.valueOf(desc) + " " + ViperMessages.KernelSM_ExecEfficiency_BlockSize_Desc : (this.nonPredExecEfficiency != null ? String.valueOf(desc) + " " + ViperMessages.KernelSM_ExecEfficiency_BlockSize_Or_NonPred_Desc : String.valueOf(desc) + " " + ViperMessages.KernelSM_ExecEfficiency_BlockSize_Or_Pred_Desc)) : (this.nonPredExecEfficiency != null ? String.valueOf(desc) + " " + ViperMessages.KernelSM_ExecEfficiency_NonPred_Desc : String.valueOf(desc) + " " + ViperMessages.KernelSM_ExecEfficiency_Pred_Desc);
        desc = desc.replace("%MAX%", percentFormatter.format(this.maxExecEfficiency));
        desc = desc.replace("%EXEC%", percentFormatter.format(this.execEfficiency.doubleValue() / 100.0));
        if (this.nonPredExecEfficiency != null) {
            desc = desc.replace("%NOPRED%", percentFormatter.format(this.nonPredExecEfficiency.doubleValue() / 100.0));
        }
        return desc;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.BRANCHING_AND_DIVERGENCE);
            }
        };
    }
}

