/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class EngineIRTransferV221
extends DesignVisitor {
    protected static Logger logger = Logger.getLogger(EngineIRTransferV221.class.getName());
    protected Report report;
    protected ReportDesignHandle handle;
    long newCellId = -1L;

    public EngineIRTransferV221(ReportDesignHandle handle, Report report) {
        this.handle = handle;
        this.report = report;
    }

    public void transfer() {
        this.apply((DesignElementHandle)this.handle);
        this.report.setVersion("2.2.1");
    }

    public void visitReportDesign(ReportDesignHandle handle) {
        PageSetupDesign pageSetup;
        SlotHandle pageSlot = handle.getMasterPages();
        int i = 0;
        while (i < pageSlot.getCount()) {
            this.apply(pageSlot.get(i));
            ++i;
        }
        if (pageSlot.getCount() < 1 && (pageSetup = this.report.getPageSetup()).getMasterPageCount() > 0) {
            MasterPageDesign masterPage = pageSetup.getMasterPage(0);
            masterPage.setID(this.generateUniqueID());
        }
        SlotHandle bodySlot = handle.getBody();
        int i2 = 0;
        while (i2 < bodySlot.getCount()) {
            this.apply(bodySlot.get(i2));
            ++i2;
        }
    }

    public void visitList(ListHandle handle) {
        SlotHandle footerSlot;
        ListItemDesign listItem = (ListItemDesign)this.report.getReportItemByID(handle.getID());
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            BandDesign header = listItem.getHeader();
            this.handleBand(header, headerSlot);
        }
        SlotHandle groupsSlot = handle.getGroups();
        int i = 0;
        while (i < groupsSlot.getCount()) {
            this.apply(groupsSlot.get(i));
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            BandDesign detail = listItem.getDetail();
            this.handleBand(detail, detailSlot);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            BandDesign footer = listItem.getFooter();
            this.handleBand(footer, footerSlot);
        }
    }

    public void visitFreeForm(FreeFormHandle handle) {
        SlotHandle slot = handle.getReportItems();
        int i = 0;
        while (i < slot.getCount()) {
            this.apply(slot.get(i));
            ++i;
        }
    }

    public void visitGrid(GridHandle handle) {
        GridItemDesign grid = new GridItemDesign();
        SlotHandle columnSlot = handle.getColumns();
        int i = 0;
        while (i < columnSlot.getCount()) {
            ColumnHandle columnHandle = (ColumnHandle)columnSlot.get(i);
            this.apply((DesignElementHandle)columnHandle);
            ++i;
        }
        SlotHandle rowSlot = handle.getRows();
        int i2 = 0;
        while (i2 < rowSlot.getCount()) {
            this.apply(rowSlot.get(i2));
            ++i2;
        }
        this.fixGridDummyCell(grid);
    }

    public void visitTable(TableHandle handle) {
        SlotHandle footerSlot;
        TableItemDesign table = (TableItemDesign)this.report.getReportItemByID(handle.getID());
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            BandDesign header = table.getHeader();
            this.handleBand(header, headerSlot);
        }
        SlotHandle groupSlot = handle.getGroups();
        int i = 0;
        while (i < groupSlot.getCount()) {
            this.apply(groupSlot.get(i));
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            BandDesign detail = table.getDetail();
            this.handleBand(detail, detailSlot);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            BandDesign footer = table.getFooter();
            this.handleBand(footer, footerSlot);
        }
        this.fixTableDummyCell(table);
    }

    public void visitRow(RowHandle handle) {
        SlotHandle cellSlot = handle.getCells();
        int i = 0;
        while (i < cellSlot.getCount()) {
            this.apply(cellSlot.get(i));
            ++i;
        }
    }

    public void visitCell(CellHandle handle) {
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            ++i;
        }
    }

    private BandDesign handleBand(BandDesign band, SlotHandle elements) {
        band.setID(this.generateUniqueID());
        this.setupElementIDMap(band);
        int i = 0;
        while (i < elements.getCount()) {
            this.apply(elements.get(i));
            ++i;
        }
        return band;
    }

    public void visitListGroup(ListGroupHandle handle) {
        SlotHandle footerSlot;
        ListGroupDesign listGroup = (ListGroupDesign)this.report.getReportItemByID(handle.getID());
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            BandDesign header = listGroup.getHeader();
            this.handleBand(header, headerSlot);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            BandDesign footer = listGroup.getFooter();
            this.handleBand(footer, headerSlot);
        }
    }

    public void visitTableGroup(TableGroupHandle handle) {
        SlotHandle footerSlot;
        TableGroupDesign tableGroup = (TableGroupDesign)this.report.getReportItemByID(handle.getID());
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            BandDesign header = tableGroup.getHeader();
            this.handleBand(header, headerSlot);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            BandDesign footer = tableGroup.getFooter();
            this.handleBand(footer, footerSlot);
        }
    }

    private void setupElementIDMap(ReportElementDesign rptElement) {
        this.report.setReportItemInstanceID(rptElement.getID(), rptElement);
    }

    protected long generateUniqueID() {
        --this.newCellId;
        return this.newCellId;
    }

    private void fixGridDummyCell(GridItemDesign grid) {
        int i = 0;
        while (i < grid.getRowCount()) {
            RowDesign row = grid.getRow(i);
            int j = 0;
            while (j < row.getCellCount()) {
                CellDesign cell = row.getCell(j);
                if (cell.getHandle() == null) {
                    cell.setID(this.generateUniqueID());
                }
                ++j;
            }
            ++i;
        }
    }

    private void fixTableDummyCell(TableItemDesign table) {
        GroupDesign group;
        this.fixTableBandDummyCell((TableBandDesign)table.getHeader());
        int i = 0;
        while (i < table.getGroupCount()) {
            group = table.getGroup(i);
            TableBandDesign header = (TableBandDesign)group.getHeader();
            this.fixTableBandDummyCell(header);
            ++i;
        }
        this.fixTableBandDummyCell((TableBandDesign)table.getDetail());
        i = table.getGroupCount() - 1;
        while (i >= 0) {
            group = table.getGroup(i);
            TableBandDesign footer = (TableBandDesign)group.getFooter();
            this.fixTableBandDummyCell(footer);
            --i;
        }
        this.fixTableBandDummyCell((TableBandDesign)table.getFooter());
    }

    public void fixTableBandDummyCell(TableBandDesign band) {
        if (band != null) {
            int i = 0;
            while (i < band.getRowCount()) {
                RowDesign row = band.getRow(i);
                int j = 0;
                while (j < row.getCellCount()) {
                    CellDesign cell = row.getCell(j);
                    if (cell.getHandle() == null) {
                        cell.setID(this.generateUniqueID());
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

