/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.shells;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.rse.internal.services.Activator;
import org.eclipse.rse.services.shells.AbstractHostShellOutputReader;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.SimpleHostOutput;

public class TerminalServiceShellOutputReader
extends AbstractHostShellOutputReader {
    protected BufferedReader fReader;
    private volatile Thread fReaderThread = null;
    private volatile boolean isCanceled = false;
    private String fPromptChars = ">$%#]";

    public TerminalServiceShellOutputReader(IHostShell hostShell, BufferedReader reader, boolean isErrorReader) {
        super(hostShell, isErrorReader);
        this.setName("Terminal Service ShellOutputReader" + this.getName());
        this.fReader = reader;
    }

    protected IHostOutput internalReadLine() {
        if (this.fReader == null) {
            return null;
        }
        this.fReaderThread = Thread.currentThread();
        try {
            IHostOutput iHostOutput = this.interruptableReadLine();
            return iHostOutput;
        }
        finally {
            this.fReaderThread = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IHostOutput interruptableReadLine() {
        StringBuffer theLine = new StringBuffer();
        StringBuffer theDebugLine = null;
        theDebugLine = new StringBuffer();
        boolean done = false;
        while (!(done || this.isFinished() || this.isCanceled)) {
            try {
                int ch = this.fReader.read();
                switch (ch) {
                    case -1: 
                    case 65535: {
                        if (theLine.length() == 0) {
                            return null;
                        }
                        done = true;
                        break;
                    }
                    case 8: {
                        int len;
                        if (theDebugLine != null) {
                            theDebugLine.append((char)ch);
                        }
                        if ((len = theLine.length() - 1) < 0) break;
                        theLine.deleteCharAt(len);
                        break;
                    }
                    case 13: {
                        if (theDebugLine == null) break;
                        theDebugLine.append((char)ch);
                        break;
                    }
                    case 10: {
                        if (theDebugLine != null) {
                            theDebugLine.append((char)ch);
                        }
                        done = true;
                        break;
                    }
                    case 9: {
                        if (theDebugLine != null) {
                            theDebugLine.append((char)ch);
                        }
                        int tabIndex = theLine.length() % 8;
                        while (tabIndex < 8) {
                            theLine.append(' ');
                            ++tabIndex;
                        }
                        break;
                    }
                    default: {
                        char tch = (char)ch;
                        if (theDebugLine != null) {
                            theDebugLine.append(tch);
                        }
                        if (!Character.isISOControl(tch)) {
                            theLine.append(tch);
                            break;
                        }
                        if (ch != 27) break;
                        int nch = this.fReader.read();
                        if (theDebugLine != null) {
                            theDebugLine.append((char)nch);
                        }
                        if (nch != 91) break;
                        do {
                            nch = this.fReader.read();
                            if (theDebugLine == null) continue;
                            theDebugLine.append((char)nch);
                        } while (Character.isDigit((char)nch) || nch == 59);
                    }
                }
                if (done || this.fReader.ready()) continue;
                long waitIncrement = 500L;
                int len = theLine.length() - 1;
                while (len > 0 && Character.isSpaceChar(theLine.charAt(len))) {
                    --len;
                }
                if (len >= 0 && this.fPromptChars.indexOf(theLine.charAt(len)) >= 0) {
                    waitIncrement = 5L;
                }
                if (!this.isCanceled) {
                    try {
                        Thread.sleep(waitIncrement);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.fReader.ready()) continue;
                done = true;
            }
            catch (IOException e) {
                if (!this.isCanceled) {
                    Activator.getDefault().logException(e);
                }
                return null;
            }
        }
        if (theDebugLine != null) {
            String debugLine = theDebugLine.toString();
            debugLine.compareTo("");
        }
        return new SimpleHostOutput(theLine.toString());
    }

    public void stopThread() {
        this.isCanceled = true;
        if (this.fReaderThread != null) {
            this.fReaderThread.interrupt();
        }
    }
}

