/*   core_if.c:
 *	linux user mode interface for mars core
 *
 */

#include <stdio.h>
#include <sys/io.h>

#include "sysdep.h"
#include <asm/types.h>

/* Mcb */
#include <sys/ioctl.h>
#include "common.h"
#include "../martian.h"

#include "watch.h"
#include "core.h"
#include "overriden_core.h"

/* gives errors on suse 10.1 */
/* #include <asm/system.h> */ 


#include <sys/pci.h>
#include <sys/time.h>

#include "log.h"

extern mtimer_t vitimer;
void lt_add_timer(void (*timerfunction)(unsigned long)) {
	const struct timespec delay = {
		.tv_sec = 0,
		.tv_nsec = 10 * 1000000
	};
	const struct itimerspec vi_delay = {
		.it_value = delay,
		.it_interval = {0, 0}
	};

	int res = vitimer.settime (vitimer.id, 0, &vi_delay, NULL);
	if (res < 0) {
		LOGERR ("start timer error %d\n", res);
	}
}

void lt_add_timer_old(void (*timerfunction)(unsigned long)) {
	struct itimerval next_pulse;
	/*extern int pulse_core;
	pulse_core = 0;*/

	/* printf ("a"); fflush (stdout); */

	next_pulse.it_value.tv_sec = 0;
	next_pulse.it_value.tv_usec = 10000;

	next_pulse.it_interval.tv_sec = 0;
	next_pulse.it_interval.tv_usec = 0;

	setitimer (ITIMER_REAL, &next_pulse, NULL);
}


unsigned VMODEM_Get_System_Time(void)
{
        struct timeval time;

        gettimeofday (&time, NULL);
        return time.tv_usec / 1000 + time.tv_sec * 1000;
}


// memory

/***** IO functions *****/
/* those are not stubs
 * those are principle
 */

// low level io
__u8 inp (__u16 addr) {
	return inb (addr);
}

__u16 inpw (__u16 addr) {
	return inw (addr);
}

__u32 inpd (__u16 addr) {
	return inl (addr);
}


void outp (__u16 addr, __u8 value) {
	outb (value, addr);
}

void outpw (__u16 addr, __u16 value) {
	outw (value, addr);
}

void outpd (__u16 addr, __u32 value) {
	return outl (value, addr);
}

typedef unsigned char uint8_t;
extern void do_dp_modem_command (uint8_t cmd, uint8_t arg1, uint8_t arg2); 

int ioctl_cmd	  = 0;
int ioctl_longcmd = 0;
int ioctl_regw    = 0;
int ioctl_regr    = 0;
int ioctl_regao   = 0;
int ioctl_writew  = 0;
int ioctl_writeb  = 0;

void dp_modem_command_long (uint8_t cmd, uint8_t arg1, uint8_t arg2, uint8_t a3, uint8_t a4) {
	int res;
	struct _longcmd_params a = {
		.cmd = cmd,
		.a1  = arg1,
		.a2  = arg2,
		.a3  = a3,
		.a4  = a4
	};
	res = ioctl(mfd, MARTIAN_IOCTL_CMD_LONGCMD, &a);
	if (res != 0)
		LOGWARN("%x %x %x %x %x failed\n", cmd, arg1, arg2, a3, a4);
	ioctl_longcmd++;
}

void dp_modem_command (uint8_t cmd, uint8_t arg1, uint8_t arg2) {
	struct _command_params a = {
		.cmd = cmd,
		.a1  = arg1,
		.a2  = arg2
	};
	ioctl(mfd, MARTIAN_IOCTL_CMD_COMMAND, &a);
	ioctl_cmd++;

}

typedef unsigned short uint16_t;

void dump_dspop_profile(void )
{
}

__u8 dp_regread_kernel(__u8 reg)
{
	ioctl_regr++;
	return ioctl(mfd, MARTIAN_IOCTL_CMD_READREG, reg);
}

void dp_regwrite_kernel(__u8 reg, __u8 val)
{
	struct _mstore arg = {
		.addr	= reg,
		.val	= val
	};
	ioctl(mfd, MARTIAN_IOCTL_CMD_WRITEREG, &arg);
	ioctl_regw++;
}

void dp_regandor_kernel(__u8 reg, __u8 mand, __u8 mor)
{
	struct _andor_params arg = {
		.reg	  = reg,
		.mask_and = mand,
		.mask_or  = mor
	};
	ioctl(mfd, MARTIAN_IOCTL_CMD_REGANDOR, &arg);
	ioctl_regao++;
}

__u8 dp_regread(__u8 reg) {
	return dp_regread_kernel(reg);
}

void dp_regwrite(__u8 reg, __u8 val) {
	dp_regwrite_kernel(reg, val);
}

void dp_regandor(__u8 reg, __u8 mask_and, __u8 mask_or) {
	dp_regandor_kernel(reg, mask_and, mask_or);
}

void Write_mdm_byte(uint16_t addr, uint8_t val) {
	struct _write_params arg = {
		.addr	= addr,
		.val	= val,
		.type	= Byte
	};
	ioctl(mfd, MARTIAN_IOCTL_CMD_WRITE, &arg);
	ioctl_writeb++;
}

void Write_mdm_word(uint16_t addr, uint16_t val) {
	struct _write_params arg = {
		.addr	= addr,
		.val	= val,
		.type	= Word
	};
	ioctl(mfd, MARTIAN_IOCTL_CMD_WRITE, &arg);
	ioctl_writew++;
}

#define	DUMP_CORE_VAR(var)	LOGINFO("\t" #var "\t= %d\n", var)
void dump_core_vars2(void )
{
	LOGINFO("core vars:\n");
	LOGINFO("\ts_x82\t= %x\n", *(__u16 *)(&S[0x82]));
	LOGINFO("\ts_x84\t= %x\n", *(__u16 *)(&S[0x84]));
	LOGINFO("\ts_x86\t= %x\n", *(__u16 *)(&S[0x86]));
	LOGINFO("\ts_x88\t= %x\n", *(__u16 *)(&S[0x88]));
	DUMP_CORE_VAR(x_dsp_mars);
	DUMP_CORE_VAR(x_dsp_mars3);
	DUMP_CORE_VAR(BaseAddress);
	DUMP_CORE_VAR(ComAddress);
	DUMP_CORE_VAR(Irq);
	DUMP_CORE_VAR(S[0x7e]);
}

int dp_dsp_rom_checksum() {

	return ioctl(mfd, MARTIAN_IOCTL_CMD_CSUM);
}


unsigned ioctl_read = 0;
unsigned ioctl_write = 0;
unsigned ioctl_clear = 0;
unsigned ioctl_dload = 0;
int read_failure = 0;
uint16_t dp_read_dsp_ram (uint16_t addr) {
	int res;

	res = ioctl (mfd, MARTIAN_IOCTL_CMD_READ_DSP, addr);
	//dp_byte_f = Mcb->byte_f;
	if (res >= 0) {
		ioctl_read++;
		return res;
	}

	read_failure++;
	return do_dp_read_dsp_ram (addr);
}
#undef TEST_CORE_IF

void dp_write_dsp_ram (uint16_t addr, uint16_t val) {
	extern void do_dp_write_dsp_ram (uint16_t addr, uint16_t val);
	struct _mstore opd = {
		.addr	= addr,
		.val	= val
	};

	if (ioctl (mfd, MARTIAN_IOCTL_CMD_WRITE_DSP, &opd) < 0)
		do_dp_write_dsp_ram (addr, val);
	else 
		ioctl_write++;
}

void dp_clear_ram (void ) {
	extern void do_dp_clear_ram (void );

	if (ioctl (mfd, MARTIAN_IOCTL_CMD_CLEAR_DSP) < 0)
		do_dp_clear_ram();
	else 
		ioctl_clear++;
}

void dp_download_dsp (uint16_t *data, uint16_t num) {
	//extern uint8_t DCPAudioOn;
	struct _mdsp bundle = {
		.num	= num,
		.data	= data,
		.pdp_byte_f	= &dp_byte_f,
		//.DCPAudioOn	= DCPAudioOn
	};

	if (ioctl (mfd, MARTIAN_IOCTL_CMD_DLOAD_DSP, &bundle) < 0)
		do_dp_download_dsp (data, num);
	else {
		ioctl_dload++;
		LOGDEBUG (Event, "Successfully downloaded to dsp %d words\n", num);
	}
}

void x_output_init(void )
{
	ioctl(mfd, MARTIAN_IOCTL_CMD_OUTINIT);
	do_x_output_init();
}


static void DCPCheck(void)
{
	static uint8_t DCPAudioOn_cached = 0;

	if (DCPAudioOn_cached != DCPAudioOn) {
		ioctl(mfd, MARTIAN_IOCTL_CMD_DCPAUDIO);
		DCPAudioOn_cached = DCPAudioOn;
	}
}

void Start_DCP(void ) {
	do_Start_DCP();
	DCPCheck();
}

void Stop_DCP(void ) {
	do_Stop_DCP();
	DCPCheck();
}

#define SHOW_IOCTL_VAR(var)	LOGINFO("\t%s\t%d\n", #var, ioctl_##var)
void show_ioctl_profile(void )
{
	LOGINFO("redefined calls\n");
	SHOW_IOCTL_VAR(regr);
	SHOW_IOCTL_VAR(regw);
	SHOW_IOCTL_VAR(regao);
	SHOW_IOCTL_VAR(cmd);
	SHOW_IOCTL_VAR(longcmd);
	SHOW_IOCTL_VAR(read);
	SHOW_IOCTL_VAR(write);
	SHOW_IOCTL_VAR(dload);
	SHOW_IOCTL_VAR(writew);
	SHOW_IOCTL_VAR(writeb);
}
/**************************/



/* */
// stubs for pci routines
int lt_pci_present() {
	return 1;
}

#define EMIT_PCI_FUNC_COUPLE(dim, type) \
	int lt_pcibios_read_config_##dim (__u8 bus, __u8 dev_fn, __u8 where, type *val) \
	{ return 0; } \
	int lt_pcibios_write_config_##dim (__u8 bus, __u8 dev_fn, __u8 where, type *val) \
	{ return 0; } 

EMIT_PCI_FUNC_COUPLE (byte, __u8);
EMIT_PCI_FUNC_COUPLE (word, __u16);
EMIT_PCI_FUNC_COUPLE (dword, __u32);

void lt_init_timer (void ) {
	// initialize timer
}

unsigned char Get_PCI_INTERRUPT_LINE(void) {
	return PCI_INTERRUPT_LINE;
}

unsigned char Get_PCI_BASE_ADDRESS_1 (void) {
	return PCI_BASE_ADDRESS_1;
}

unsigned char Get_PCI_BASE_ADDRESS_2 (void) {
	return PCI_BASE_ADDRESS_2;
}

unsigned Get_PCI_BASE_ADDRESS_IO_MASK (void) {
	return PCI_BASE_ADDRESS_IO_MASK;
}

unsigned char Get_PCI_BASE_ADDRESS_SPACE_IO (void) {
	return PCI_BASE_ADDRESS_SPACE_IO;
}

///
int function_1(int (*fn)(void *), char *a) {return 0;}
void lin_interruptible_sleep_on(void) {}
int lin_signal_pending(void) {return 0;}
void lin_kill(void) {}
void lin_wake_up(void) {}
int function_2(char *p) {return 0;}


struct lt_pci_dev_info;
int lt_pci_find_device(struct lt_pci_dev_info *lt_dev, unsigned int id, unsigned int num)
{
	LOGERR ("Unexpected call lt_pci_find_device\n");
	return 0;
}

