//
// Copyright (c) 2021, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "cqi.hpp"

#include "nscq/nscq.h"

#include <memory>

namespace nscq::cqi {

struct nvswitch_nvlink_remote_dev;

struct nvswitch_nvlink_remote_dev : public cqi {
    using cqi_t = nvswitch_nvlink_remote_dev;
    using cqi::cqi;

    struct remote_location_field : public field<nvswitch_nvlink_remote_dev, readable<nscq_pcie_location_t>> {};
    virtual auto get(remote_location_field) -> nscq_pcie_location_t = 0;

    struct remote_type_field : public field<nvswitch_nvlink_remote_dev, readable<nscq_device_type_t>> {};
    virtual auto get(remote_type_field) -> nscq_device_type_t = 0;

    struct remote_link_id_field : public field<nvswitch_nvlink_remote_dev, readable<uint8_t>> {};
    virtual auto get(remote_link_id_field) -> uint8_t = 0;

    struct remote_link_sid_field : public field<nvswitch_nvlink_remote_dev, readable<uint64_t>> {};
    virtual auto get(remote_link_sid_field) -> uint64_t = 0;
    virtual auto has(remote_link_sid_field) -> bool = 0;

    struct remote_uuid_field : public field<nvswitch_nvlink_remote_dev, readable<nscq_uuid_t>> {};
    virtual auto get(remote_uuid_field) -> nscq_uuid_t = 0;
    virtual auto has(remote_uuid_field) -> bool = 0;

};
} // namespace nscq::cqi
