#include "geo_incode_defs.h"
datafile_rows_t datum_row_0[] = {"datum_code","datum_name","datum_type","origin_description","realization_epoch","ellipsoid_code","prime_meridian_code","area_of_use_code","datum_scope","remarks","information_source","data_source","revision_date","change_id","deprecated ",NULL};
datafile_rows_t datum_row_1[] = {"5100","Mean Sea Level","vertical","","","","","1262","Hydrography.","msl has geographic and temporal components.  Users are advised to not use this generic vertical datum but to define specific instances of msl based on knowledge of these components; for instance \"msl at xxx during 19yy\".","","EPSG","1996-04-12","","0 ",NULL};
datafile_rows_t datum_row_2[] = {"5101","Ordnance Datum Newlyn","vertical","Mean Sea Level at Newlyn between 1915 and 1921.","","","","2792","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2004-06-16","2004.10","0 ",NULL};
datafile_rows_t datum_row_3[] = {"5102","National Geodetic Vertical Datum 1929","vertical","26 tide gauges in the US and Canada.","1929","","","1323","Topographic mapping, geodetic survey.","Normal orthometric heights.","","EPSG","1996-09-12","","0 ",NULL};
datafile_rows_t datum_row_4[] = {"5103","North American Vertical Datum 1988","vertical","Father's Point, Rimouski, Quebec.","1988","","","1325","Topographic mapping, geodetic survey.","Helmert orthometric heights.","","EPSG","2006-01-16","2005.88","0 ",NULL};
datafile_rows_t datum_row_5[] = {"5104","Yellow Sea 1956","vertical","2 years tide readings at Qingdao.","1956","","","3228","Topographic mapping, geodetic survey.","Replaced by Yellow Sea 1985 datum.","","EPSG","2002-06-22","2002.16","0 ",NULL};
datafile_rows_t datum_row_6[] = {"5105","Baltic Sea","vertical","Datum: average water level at Kronstadt 1833. Network adjusted in 1977.","1977","","","1284","Topographic mapping, geodetic survey.","Uses Normal heights.","","EPSG","2005-05-27","2004.10 2005.18","0 ",NULL};
datafile_rows_t datum_row_7[] = {"5106","Caspian Sea","vertical","Defined as -28.0m Baltic datum","","","","1291","Hydrography.","","","EPSG","1996-09-12","","0 ",NULL};
datafile_rows_t datum_row_8[] = {"5107","Nivellement general de la France","vertical","Mean sea level at Marseille","","","","1326","Topographic mapping, geodetic survey.","The CNIG states that NGF is a general term applying to all vertical network readjustments of France and recommends more specific terminology. See codes 5118-5120.","Conseil National de l'Information Geographique groupe de travail \"Reseaux de Nivellement\" recommendations v5.1 April 1994.","EPSG","1996-09-12","","1 ",NULL};
datafile_rows_t datum_row_9[] = {"5109","Normaal Amsterdams Peil","vertical","Mean high tide at Amsterdams Peil in 1684.","","","","1275","Topographic mapping, geodetic survey, hydrography.","Orthometric heights.","Nederlandse Commissie voor Geodesie publication 30; 1993","EPSG","2006-01-16","2004.10 2005.88","0 ",NULL};
datafile_rows_t datum_row_10[] = {"5110","Oostende","vertical","Mean low water during 1958","1958","","","1347","Topographic mapping, geodetic survey.","","Nederlandse Commissie voor Geodesie publication 30; 1993","EPSG","2006-01-16","2005.88","0 ",NULL};
datafile_rows_t datum_row_11[] = {"5111","Australian Height Datum","vertical","MSL 1966-68 at 30 gauges around coast.","1968","","","1281","Topographic mapping, geodetic survey.","","Australian Land Information Group  www.auslig.gov.au","EPSG","2005-09-06","2005.46","0 ",NULL};
datafile_rows_t datum_row_12[] = {"5112","Australian Height Datum (Tasmania)","vertical","MSL 1972 at Hobart and Burnie.","1972","","","1282","Topographic mapping, geodetic survey.","","","EPSG","1996-09-12","","0 ",NULL};
datafile_rows_t datum_row_13[] = {"5113","Sea Level","vertical","","","","","1262","Hydrography.","An unspecified local vertical datum not recommended for use.","","EPSG","1996-09-12","","0 ",NULL};
datafile_rows_t datum_row_14[] = {"5114","Canadian Geodetic Vertical Datum of 1928","vertical","Based on the mean sea level determined from several tidal gauges located in strategic areas of the country","1928","","","1289","Topographic mapping, geodetic survey.","","Geodetic Survey Division, Natural Resources Canada. http://maps.nrcan.gc.ca/asdb/asdb_datum.html and http://www.geod.nrcan.gc.ca/index_e/help_e/acron_e.html","EPSG","2004-11-26","2004.723","0 ",NULL};
datafile_rows_t datum_row_15[] = {"5115","Piraeus Harbour 1986","vertical","MSL determined during 1986.","1986","","","3254","Topographic mapping, geodetic survey.","","Geodesy Department; Public Pertoleum Corporation of Greece","EPSG","1997-06-16","","0 ",NULL};
datafile_rows_t datum_row_16[] = {"5116","Helsinki 1960","vertical","MSL at Helsinki during 1960.","1960","","","3333","Topographic mapping, geodetic survey.","","National Land Survey of Finland; http://www.maanmittauslaitos.fi","EPSG","1997-07-22","","0 ",NULL};
datafile_rows_t datum_row_17[] = {"5117","Rikets hojdsystem 1970","vertical","Adjustment is referenced to mean high tide at Amsterdams Peil in 1684. To account for land level movements caused by isostatic rebound, heights are reduced to epoch 1970.0 using uplift values computed from repeated levelling observations.","1970","","","3313","Topographic mapping, geodetic survey.","Uses Normal heights.","National Land Survey of Sweden","EPSG","2004-06-16","2002.48 2004.10","0 ",NULL};
datafile_rows_t datum_row_18[] = {"5118","Nivellement General de la France - Lallemand","vertical","Rivet number M.ac O-VIII on the Marseille tide gauge site, with the height fixed in 1897 at 1.661 metre above mean sea level between February 2nd 1885 and January 1st 1897.","","","","1326","Geodetic survey, topographic mapping, engineering survey.","Orthometric heights.","Conseil National de l'Information Geographique groupe de travail \"Reseaux de Nivellement\" recommendations v5.1 April 1994.","EPSG","1997-11-13","2001.47 2004.06","0 ",NULL};
datafile_rows_t datum_row_19[] = {"5119","Nivellement General de la France - IGN69","vertical","Rivet number M.ac O-VIII on the Marseille tide gauge site, with the height fixed in 1897 at 1.661 metre above mean sea level between February 2nd 1885 and January 1st 1897.","1969","","","1326","Geodetic survey, topographic mapping, engineering survey.","Uses Normal heights.","Conseil National de l'Information Geographique groupe de travail \"Reseaux de Nivellement\" recommendations v5.1 April 1994.","EPSG","1997-11-13","2001.47","0 ",NULL};
datafile_rows_t datum_row_20[] = {"5120","IGN78 Corsica","vertical","Marker MM3 situated on the tide gauge site of Ajaccio. Height is 3.640 metre above mean sea level.","1978","","","1327","Geodetic survey, topographic mapping, engineering survey.","Uses Normal heights. Replaces NGC (datum code 5189).","Conseil National de l'Information Geographique groupe de travail \"Reseaux de Nivellement\" recommendations v5.1 April 1994.","EPSG","2004-10-14","2001.47 2004.06 2004.564","0 ",NULL};
datafile_rows_t datum_row_21[] = {"5121","Maputo","vertical","Mean sea level at Maputo.","","","","3281","Topographic mapping.","","Direcção Nacional de Geografia e Cadastral (DINAGECA).","EPSG","1998-04-16","","0 ",NULL};
datafile_rows_t datum_row_22[] = {"5122","Japanese Standard Levelling Datum 1949","vertical","24.4140 metres above mean sea level Tokyo Bay.","1949","","","3263","Topographic mapping, geodetic survey.","","Ministry of Construction; Japan.  http://vldb.gsi.go.jp/sokuchi/datum/tokyodatum.html","EPSG","2004-05-09","2002.08 2004.38","0 ",NULL};
datafile_rows_t datum_row_23[] = {"5123","PDO Height Datum 1993","vertical","","1993","","","3288","Oil industry mapping.","Misclosure between Muscat and Salalah less than .5 meters with differences from of up to 5 meters from old Fahud Datum.  The PHD93 adjustment was initially known as the Spine.  Replaces Fahud Vertical Datum (code 5124) from 1993.","Petroleum Development Oman","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_24[] = {"5124","Fahud Height Datum","vertical","Single MSL determination at Mina Al Fahal.","","","","3288","Oil industry mapping.","Based on reciprocal trigonometric heighting. Replaced by PHD93 Datum (code 5123) in 1993.","Petroleum Development Oman","EPSG","2004-04-07","2004.212","0 ",NULL};
datafile_rows_t datum_row_25[] = {"5125","Ha Tien 1960","vertical","","1960","","","1302","Topographic mapping, geodetic survey.","In Vietnam replaced by Hon Dau in 1992.","","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_26[] = {"5126","Hon Dau 1992","vertical","","1992","","","3328","Topographic mapping, geodetic survey.","Replaces Ha Tien in Vietnam.","","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_27[] = {"5127","Landesnivellement 1902","vertical","Origin at Repere Pierre du Niton (RPN) defined as 373.6 metres above msl. This value derived from msl at Marseille in 1897 through the French Lallemand network.","1902","","","1286","Topographic mapping, cadastral survey.","Levelling observations not corrected for gravity field. For scientific purposes, replaced by LHHN95.","Bundesamt für Landestopographie","EPSG","2004-06-16","2004.10","0 ",NULL};
datafile_rows_t datum_row_28[] = {"5128","Landeshohennetz 1995","vertical","Origin at Repere Pierre du Niton (RPN) defined as 373.6 metres above msl. This value derived from msl at Marseille in 1897 through the French Lallemand network.","1995","","","1286","Geodetic survey and scientific studies.","Orthometric heights. For scientific purposes only, replaces LN02.","Bundesamt für Landestopographie","EPSG","2004-06-16","2004.10","0 ",NULL};
datafile_rows_t datum_row_29[] = {"5129","European Vertical Reference Frame 2000","vertical","Height at Normaal Amsterdams Peil (NAP) is zero, defined through height at UELN bench mark 13600 (52°22'53\"N 4°54'34\"E) of 0.71599m. Datum at NAP is mean high tide in 1684.","2000","","","1299","Geodesy.","Realised by geopotential numbers and Normal heights of the United European Levelling Network.","European veritical data centre at Bundesamt für Kartographie und Geodäsie (BKG), Leipzig branch. http://crs.bkg.bund.de/evrs/","EPSG","2000-10-19","","0 ",NULL};
datafile_rows_t datum_row_30[] = {"5130","Malin Head","vertical","Mean sea level between January 1960 and December 1969.","1970","","","1305","Topographic mapping","Orthometric heights.","Ordnance Survey of Ireland","EPSG","2001-11-06","","0 ",NULL};
datafile_rows_t datum_row_31[] = {"5131","Belfast Lough","vertical","Mean sea level between 1951 and 1956 at Clarendon Dock, Belfast.","1957","","","2530","Large scale (1:1,250, 1:2,500 and 1:10,000) topographic mapping.","Orthometric heights. Malin Head (datum code 5130) used for 1:50,000 and smaller mapping.","Ordnance Survey of Northern Ireland","EPSG","2002-09-19","2002.62","0 ",NULL};
datafile_rows_t datum_row_32[] = {"5132","Dansk Normal Nul","vertical","Mean Sea Level at 10 gauges.","","","","3237","Topographic mapping and engineering survey","Orthometric heights.","Kort & Matrikelstyrelsen","EPSG","2001-11-06","","0 ",NULL};
datafile_rows_t datum_row_33[] = {"5133","AIOC 1995","vertical","Average level of Caspian Sea at the Oil Rocks tide gauge June-September 1995.","1995","","","2592","Oil industry mapping.","AIOC 1995 datum is 1.7m above Caspian datum and 26.3m below Baltic datum.","BP","EPSG","2002-02-12","","0 ",NULL};
datafile_rows_t datum_row_34[] = {"5134","Black Sea","vertical","","","","","1102","Hydrographic surveying and since break-up of Former Soviet Union also topographic mapping.","Black Sea datum is 0.4m below Baltic datum.","BP","EPSG","2002-02-12","","0 ",NULL};
datafile_rows_t datum_row_35[] = {"5135","Hong Kong Principal Datum","vertical","1.23m below the mean of 19 years (1965-83) observations of tide levels at North Point, Victoria Harbour.","1980","","","3334","Geodetic survey, engineering survey, cadastre.","","Survey and Mapping Office, Lands Department. Http://www.info.gov.hk/landsd/mapping/tindex.htm","EPSG","2002-06-22","","0 ",NULL};
datafile_rows_t datum_row_36[] = {"5136","Hong Kong Chart Datum","vertical","Approximates to Lowest Astronomic Tide level (LAT).","","","","3335","Hydrographic survey and charting.","Chart datum is 0.15 metres below Hong Kong Principal Datum (code 5135) and 1.38m below MSL at Quarry Bay.","Survey and Mapping Office, Lands Department. Http://www.info.gov.hk/landsd/mapping/tindex.htm","EPSG","2002-06-22","","0 ",NULL};
datafile_rows_t datum_row_37[] = {"5137","Yellow Sea 1985","vertical","20 years tide readings at Qingdao.","1985","","","3228","Topographic mapping, geodetic survey.","Replaces Yellow Sea 1956 datum.","Guangdong Province Land Resource Information Centre","EPSG","2002-06-22","","0 ",NULL};
datafile_rows_t datum_row_38[] = {"5138","Ordnance Datum Newlyn (Orkney Isles)","vertical","Connected to Newlyn datum by triangulation from the British mainland.","","","","2793","Topographic mapping, geodetic survey.","Considered as separate from Newlyn because the accuracy of the trigonometric connection across the Pentland Firth does not meet geodetic levelling specifications. Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2004-06-16","2004.10","0 ",NULL};
datafile_rows_t datum_row_39[] = {"5139","Fair Isle","vertical","","","","","2794","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_40[] = {"5140","Lerwick","vertical","","","","","2795","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_41[] = {"5141","Foula","vertical","","","","","2796","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_42[] = {"5142","Sule Skerry","vertical","","","","","2797","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_43[] = {"5143","North Rona","vertical","","","","","2798","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_44[] = {"5144","Stornoway","vertical","","","","","2799","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_45[] = {"5145","St. Kilda","vertical","","","","","2800","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_46[] = {"5146","Flannan Isles","vertical","","","","","2801","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2006-01-16","2005.88","0 ",NULL};
datafile_rows_t datum_row_47[] = {"5147","St. Marys","vertical","","","","","2802","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_48[] = {"5148","Douglas","vertical","","","","","2803","Topographic mapping, geodetic survey.","Orthometric heights.","Ordnance Survey of Great Britain","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_49[] = {"5149","Fao","vertical","","","","","2806","Topographic mapping, geodetic survey.","Established by Hunting Surveys for IPC. Replaced by Bandar Abbas (code 5150). At time of record creation NIOC data in Ahwaz area still usually referenced to Fao.","National Iranian Oil Company (NIOC).","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_50[] = {"5150","Bandar Abbas","vertical","Average sea level at Bandar Abbass 1995-2001.","2001","","","3336","Topographic mapping, geodetic survey.","Replaces Fao (code 5149).","National Cartographic Centre of Iran","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_51[] = {"5151","Nivellement General de Nouvelle Caledonie","vertical","Rivet AB01 established by SHOM (Service Hydrographique de la Marine)  in 1937 on the Quai des Volontaires in Noumea. Height i: 1.885 metre above mean sea level.","1969","","","2822","Geodetic survey, topographic mapping, engineering survey.","Orthometric heights.","Service Topographique de la Nouvelle Caledonie.","EPSG","2004-03-15","2004.06","0 ",NULL};
datafile_rows_t datum_row_52[] = {"5152","Poolbeg","vertical","Low water mark of the spring tide on the 8 April 1837 at Poolbeg Lighthouse, Dublin.","1837","","","1305","Topographic mapping before 1956 in Northern Ireland and 1970 in the Republic of Ireland.","Replaced by Belfast Lough and Malin Head (datum codes 5130-31).","\"The Irish Grid - A Description of the Co-ordinate Reference System\" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.","EPSG","2003-06-27","","0 ",NULL};
datafile_rows_t datum_row_53[] = {"5153","Nivellement General Guyanais 1977","vertical","","1977","","","3146","Geodetic survey, topographic mapping, engineering survey.","Normal heights.","IGN Paris","EPSG","2003-06-27","","0 ",NULL};
datafile_rows_t datum_row_54[] = {"5154","Martinique 1987","vertical","","","","","3276","Geodetic survey, topographic mapping, engineering survey.","Replaces Martinique 1955 (datum code 5192).","IGN Paris","EPSG","2004-10-14","2004.561","0 ",NULL};
datafile_rows_t datum_row_55[] = {"5155","Guadeloupe 1988","vertical","","","","","2829","Geodetic survey, topographic mapping, engineering survey.","Replaces Guadeloupe 1951 (datum code 5193).","IGN Paris","EPSG","2004-10-14","2004.561","0 ",NULL};
datafile_rows_t datum_row_56[] = {"5156","Reunion 1989","vertical","","","","","3337","Geodetic survey, topographic mapping, engineering survey.","","IGN Paris","EPSG","2004-10-14","2004.561","0 ",NULL};
datafile_rows_t datum_row_57[] = {"5157","Auckland","vertical","MSL at Auckland harbour 1909-1923.","1946","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_58[] = {"5158","Bluff","vertical","MSL at Invercargill harbour over 8 years between 1918 and 1934.","1955","","","1501","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_59[] = {"5159","Dunedin","vertical","MSL at Dunedin harbour 1918-1937.","1958","","","1501","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_60[] = {"5160","Gisborne","vertical","MSL at Gisborne harbour 1926.","1926","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_61[] = {"5161","Lyttleton","vertical","MSL at Lyttleton harbour over 9 years between 1918 and 1933.","1937","","","1501","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_62[] = {"5162","Moturiki","vertical","MSL at Moturiki Island February 1949 to December 1952.","1953","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_63[] = {"5163","Napier","vertical","MSL at Napier harbour. Period of derivation unknown.","1962","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_64[] = {"5164","Nelson","vertical","MSL at Nelson harbour 1939-1942.","1955","","","1501","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_65[] = {"5165","One Tree Point","vertical","MSL at Whangarei harbour 1960-1963.","1964","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_66[] = {"5166","Tararu","vertical","MSL at Tararu Point 1922-1923.","1952","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_67[] = {"5167","Taranaki","vertical","MSL at Taranaki harbour 1918-1921.","1970","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_68[] = {"5168","Wellington","vertical","MSL at Wellington harbour 1909-1946.","1953","","","1500","Geodetic survey, topographic mapping, engineering survey.","","OSG Technical Report #10, February 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_69[] = {"5169","Chatham Island","vertical","MSL at Waitangi harbour collected in 1959.","1959","","","2889","Geodetic survey, topographic mapping, engineering survey.","","Interim Report GEO/T1/19/51 for LINZ by John Hannah, \"An Assessment of New Zealand's Height Systems and Options for a Future Height System\", January 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_70[] = {"5170","Stewart Island","vertical","MSL at 3-5 high and low tides at two different locations.","1977","","","3338","Geodetic survey, topographic mapping, engineering survey.","","Interim Report GEO/T1/19/51 for LINZ by John Hannah, \"An Assessment of New Zealand's Height Systems and Options for a Future Height System\", January 2001.","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_71[] = {"5171","EGM96 geoid","vertical","WGS 84 ellipsoid.","1996","","","1262","Geodesy.","","NASA http://cddis.gsfc.nasa.gov/926/egm96/egm96.html","EPSG","2004-04-27","","0 ",NULL};
datafile_rows_t datum_row_72[] = {"5172","Nivellement General du Luxembourg","vertical","Reference point Wemperhardt defined as 528.030m above Normaal Amsterdams Peil (NAP). Datum at NAP is mean high tide in 1684. Network adjusted in 1995.","1995","","","1146","Geodetic survey, topographic mapping, engineering survey.","Orthometric heights.","Administration du Cadastre et de la Topographie. http://www.etat.lu/ACT","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_73[] = {"5173","Antalya","vertical","Mean sea Level at Antalya 1936-71.","","","","3322","Geodetic survey, topographic mapping, engineering survey.","Orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-11-26","2004.722","0 ",NULL};
datafile_rows_t datum_row_74[] = {"5174","Norway Normal Nul 1954","vertical","MSL defined by regression at 7 gauges with between 17 and 67 years observations.","1974","","","1352","Geodetic survey, topographic mapping, engineering survey.","Includes initial NN1954 system and NNN1957 system. Former name retained. Normal-orthometric heights.","Statoil","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_75[] = {"5175","Durres","vertical","Mean Sea Level at Durres.","","","","3212","Geodetic survey, topographic mapping, engineering survey.","Normal-orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_76[] = {"5176","Gebrauchshohen ADRIA","vertical","Reference point Hutbiegl defined relative to mean sea level at Trieste in 1875.","","","","1037","Geodetic survey, topographic mapping, engineering survey.","Normal-orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_77[] = {"5177","National Vertical Network 1999","vertical","Reference point Ruse defined relative to mean sea level at Trieste in 1875.","1999","","","3307","Geodetic survey, topographic mapping, engineering survey.","Normal-orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_78[] = {"5178","Cascais","vertical","Mean Sea Level at Cascais 1938.","1938","","","1294","Geodetic survey, topographic mapping, engineering survey.","Orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_79[] = {"5179","Constanta","vertical","Mean Sea Level at Constanta.","","","","3295","Geodetic survey, topographic mapping, engineering survey.","Normal-orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/evrs/Relations.html","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_80[] = {"5180","Alicante","vertical","Mean Sea Level at Alicante between 1870 and 1882.","","","","2366","Geodetic survey, topographic mapping, engineering survey.","Orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_81[] = {"5181","Deutches Haupthohennetz 1992","vertical","Network adjusted in 1992. Geopotential number at reference point Wallenhorst defined as value from the UELN-73/86 adjustment. Datum at Normaal Amsterdams Peil (NAP) is mean high tide in 1684.","1992","","","3339","Geodetic survey, topographic mapping, engineering survey.","Replaces DHHN85 in West Germany and SNN76 in East Germany. Uses Normal heights.","Bundesamt für Kartographie und Geodäsie (BKG), http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_82[] = {"5182","Deutches Haupthohennetz 1985","vertical","Network adjusted in 1985. Height of reference point Wallenhorst defined as value from 1928 adjustment. Datum at Normaal Amsterdams Peil (NAP) is mean high tide in 1684.","1985","","","2326","Geodetic survey, topographic mapping, engineering survey.","Replaced by DHHN92. Uses Normal-orthometric heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_83[] = {"5183","SNN76","vertical","Network adjusted in 1976. Height at reference point Hoppegarten defined as 1957 value from the UPLN adjustment. Datum at Kronstadt is mean sea level of Baltic in 1833.","1976","","","1343","Geodetic survey, topographic mapping, engineering survey.","Uses Normal heights. Replaced by DHHN92.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_84[] = {"5184","Baltic 1982","vertical","Network adjusted in 1982. Height at reference point Varna defined as 1958 value from the UPLN adjustment. Datum at Kronstadt is mean sea level of Baltic in 1833.","1982","","","3224","Geodetic survey, topographic mapping, engineering survey.","Uses Normal heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_85[] = {"5185","Baltic 1980","vertical","","","","","1119","Geodetic survey, topographic mapping, engineering survey.","Uses Normal heights.","Eurogeographics, http://crs.bkg.bund.de/crs-eu/","EPSG","2004-03-09","","0 ",NULL};
datafile_rows_t datum_row_86[] = {"5186","Kuwait PWD","vertical","Mean Low Low Water (MLLW) at Kuwait City.","","","","3267","Municipality and military purposes.","Approximately 1.03m below MSL.","Kuwait Oil Company.","EPSG","2004-06-16","","0 ",NULL};
datafile_rows_t datum_row_87[] = {"5187","KOC Well Datum","vertical","","1937","","","3267","KOC exploration and field development subsurface work.","Approximately 3.22m above MSL.","Kuwait Oil Company.","EPSG","2004-06-16","","0 ",NULL};
datafile_rows_t datum_row_88[] = {"5188","KOC Construction Datum","vertical","","1952","","","3267","KOC survey control and facilities engineering.","Approximately 1.52m below MSL. Created for the construction of the Mina al Ahmadi refinery.","Kuwait Oil Company.","EPSG","2004-06-16","","0 ",NULL};
datafile_rows_t datum_row_89[] = {"5189","Nivellement General de la Corse 1948","vertical","Mean sea level at Ajaccio between 1912 and 1937.","1948","","","1327","Geodetic survey, topographic mapping, engineering survey.","Replaced by IGN78 Corsica (datum 5120).","IGN Paris","EPSG","2004-10-14","","0 ",NULL};
datafile_rows_t datum_row_90[] = {"5190","Danger 1950","vertical","Marker near tide gauge at port of Saint Pierre. Height is 1.26 metres above zero of tide gauge.","1950","","","3299","Geodetic survey, topographic mapping, engineering survey.","","IGN Paris","EPSG","2004-10-14","","0 ",NULL};
datafile_rows_t datum_row_91[] = {"5191","Mayotte 1950","vertical","Marker on Issoufali jetty at Dzaoudzi. Height is 2.18m above zero of tide gauge.","1950","","","3340","Geodetic survey, topographic mapping, engineering survey.","","IGN Paris","EPSG","2004-10-14","","0 ",NULL};
datafile_rows_t datum_row_92[] = {"5192","Martinique 1955","vertical","Marker N.BC-2 situated at the port of Fort de France.","1955","","","3276","Geodetic survey, topographic mapping, engineering survey.","Replaced by Martinique 1987 (datum code 5154).","IGN Paris","EPSG","2004-10-14","","0 ",NULL};
datafile_rows_t datum_row_93[] = {"5193","Guadeloupe 1951","vertical","At the port of Pointe-a-Pitre.","1955","","","2892","Geodetic survey, topographic mapping, engineering survey.","Replaced by Guadeloupe 1988 (datum code 5155).","IGN Paris","EPSG","2004-10-14","","0 ",NULL};
datafile_rows_t datum_row_94[] = {"5194","Lagos 1955","vertical","Mean sea level at Lagos, 1912-1928.","1955","","","3287","Geodetic survey, topographic mapping, engineering survey.","","Ebong et al, AVN International, 1991.","EPSG","2004-10-14","","0 ",NULL};
datafile_rows_t datum_row_95[] = {"5195","Nivellement General de Polynesie Francaise","vertical","","","","","3134","Geodetic survey, topographic mapping, engineering survey.","The collection of heterogeneous levelling networks throughout the Society Islands of French Polynesia.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_96[] = {"5196","IGN 1966","vertical","Fundamental benchmark: RN501","1966","","","3124","Geodetic survey, topographic mapping, engineering survey.","Included as part of NGPF - see datum code 5195.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_97[] = {"5197","Moorea SAU 1981","vertical","Fundamental benchmark: RN225","1981","","","3125","Geodetic survey, topographic mapping, engineering survey.","Included as part of NGPF - see datum code 5195.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_98[] = {"5198","Raiatea SAU 2001","vertical","Fundamental benchmark: RN1","2001","","","3136","Geodetic survey, topographic mapping, engineering survey.","Included as part of NGPF - see datum code 5195.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_99[] = {"5199","Maupiti SAU 2001","vertical","Fundamental benchmark: RN11","2001","","","3126","Geodetic survey, topographic mapping, engineering survey.","Included as part of NGPF - see datum code 5195.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_100[] = {"5200","Huahine SAU 2001","vertical","Fundamental benchmark: SHOM B3","2001","","","3135","Geodetic survey, topographic mapping, engineering survey.","Included as part of NGPF - see datum code 5195.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_101[] = {"5201","Tahaa SAU 2001","vertical","Fundamental benchmark: RN16","2001","","","3138","Geodetic survey, topographic mapping, engineering survey.","Included as part of NGPF - see datum code 5195.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_102[] = {"5202","Bora Bora SAU 2001","vertical","Fundamental benchmark: Vaitape quay SHOM benchmark B.","2001","","","3137","Geodetic survey, topographic mapping, engineering survey.","Included as part of NGPF - see datum code 5195.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_103[] = {"5203","EGM84 geoid","vertical","WGS 84 ellipsoid.","1984","","","1262","Geodesy.","","US National Geospatial-Intelligence Agency (NGA); http://earth-info.nga.mil/GandG/","EPSG","2005-09-30","","0 ",NULL};
datafile_rows_t datum_row_104[] = {"5204","International Great Lakes Datum 1955","vertical","Pointe-au-Père (Father's Point), Quebec","1955","","","3468","Hydrology.","Dynamic heights. Adopted in 1962. Replaced by IGLD 1985 in January 1992.","Coordinating Committee on Great Lakes Basic Hydraulic and Hydrologic Data","OGP","2006-11-11","","0 ",NULL};
datafile_rows_t datum_row_105[] = {"5205","International Great Lakes Datum 1985","vertical","Rimouski, Quebec.","1985","","","3468","Hydrology.","Dynamic heights. Replaces IGLD 1955 from January 1992.","Coordinating Committee on Great Lakes Basic Hydraulic and Hydrologic Data","OGP","2006-11-11","","0 ",NULL};
datafile_rows_t datum_row_106[] = {"5206","Dansk Vertikal Reference 1990","vertical","Benchmark at Århus cathedral referenced to mean sea level determined during 1990 at 10 tide gauges: Esbjerg, Fredericia, Frederikshavn, Gedser, Hirtshals, Hornbæk, Korsør, København, Slipshavn and Århus.","","","","3237","Topographic mapping and engineering survey","Normal Orthometric heights.","Kort & Matrikelstyrelsen","OGP","2006-12-01","","0 ",NULL};
datafile_rows_t datum_row_107[] = {"6001","Not specified (based on Airy 1830 ellipsoid)","geodetic","","","7001","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_108[] = {"6002","Not specified (based on Airy Modified 1849 ellipsoid)","geodetic","","","7002","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_109[] = {"6003","Not specified (based on Australian National Spheroid)","geodetic","","","7003","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_110[] = {"6004","Not specified (based on Bessel 1841 ellipsoid)","geodetic","","","7004","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_111[] = {"6005","Not specified (based on Bessel Modified ellipsoid)","geodetic","","","7005","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_112[] = {"6006","Not specified (based on Bessel Namibia ellipsoid)","geodetic","","","7046","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2001-01-21","96.08  2000.42  2001.15","0 ",NULL};
datafile_rows_t datum_row_113[] = {"6007","Not specified (based on Clarke 1858 ellipsoid)","geodetic","","","7007","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_114[] = {"6008","Not specified (based on Clarke 1866 ellipsoid)","geodetic","","","7008","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_115[] = {"6009","Not specified (based on Clarke 1866 Michigan ellipsoid)","geodetic","","","7009","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_116[] = {"6010","Not specified (based on Clarke 1880 (Benoit) ellipsoid)","geodetic","","","7010","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_117[] = {"6011","Not specified (based on Clarke 1880 (IGN) ellipsoid)","geodetic","","","7011","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_118[] = {"6012","Not specified (based on Clarke 1880 (RGS) ellipsoid)","geodetic","","","7012","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_119[] = {"6013","Not specified (based on Clarke 1880 (Arc) ellipsoid)","geodetic","","","7013","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_120[] = {"6014","Not specified (based on Clarke 1880 (SGA 1922) ellipsoid)","geodetic","","","7014","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_121[] = {"6015","Not specified (based on Everest 1830 (1937 Adjustment) ellipsoid)","geodetic","","","7015","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_122[] = {"6016","Not specified (based on Everest 1830 (1967 Definition) ellipsoid)","geodetic","","","7016","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_123[] = {"6018","Not specified (based on Everest 1830 Modified ellipsoid)","geodetic","","","7018","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_124[] = {"6019","Not specified (based on GRS 1980 ellipsoid)","geodetic","","","7019","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_125[] = {"6020","Not specified (based on Helmert 1906 ellipsoid)","geodetic","","","7020","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_126[] = {"6021","Not specified (based on Indonesian National Spheroid)","geodetic","","","7021","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_127[] = {"6022","Not specified (based on International 1924 ellipsoid)","geodetic","","","7022","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_128[] = {"6024","Not specified (based on Krassowsky 1940 ellipsoid)","geodetic","","","7024","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_129[] = {"6025","Not specified (based on NWL 9D ellipsoid)","geodetic","","","7025","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_130[] = {"6027","Not specified (based on Plessis 1817 ellipsoid)","geodetic","","","7027","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_131[] = {"6028","Not specified (based on Struve 1860 ellipsoid)","geodetic","","","7028","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_132[] = {"6029","Not specified (based on War Office ellipsoid)","geodetic","","","7029","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_133[] = {"6030","Not specified (based on WGS 84 ellipsoid)","geodetic","","","7030","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_134[] = {"6031","Not specified (based on GEM 10C ellipsoid)","geodetic","","","7031","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_135[] = {"6032","Not specified (based on OSU86F ellipsoid)","geodetic","","","7032","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_136[] = {"6033","Not specified (based on OSU91A ellipsoid)","geodetic","","","7033","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_137[] = {"6034","Not specified (based on Clarke 1880 ellipsoid)","geodetic","","","7034","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","96.08  2000.42","0 ",NULL};
datafile_rows_t datum_row_138[] = {"6035","Not specified (based on Authalic Sphere)","geodetic","","","7035","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown. Deprecated and replaced by 6047.","EPSG","EPSG","2001-06-05","96.08  2000.42","1 ",NULL};
datafile_rows_t datum_row_139[] = {"6036","Not specified (based on GRS 1967 ellipsoid)","geodetic","","","7036","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","2000.42","0 ",NULL};
datafile_rows_t datum_row_140[] = {"6041","Not specified (based on Average Terrestrial System 1977 ellipsoid)","geodetic","","","7041","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","2000.42","0 ",NULL};
datafile_rows_t datum_row_141[] = {"6042","Not specified (based on Everest (1830 Definition) ellipsoid)","geodetic","","","7042","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","2000.42","0 ",NULL};
datafile_rows_t datum_row_142[] = {"6043","Not specified (based on WGS 72 ellipsoid)","geodetic","","","7043","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","2000.42","0 ",NULL};
datafile_rows_t datum_row_143[] = {"6044","Not specified (based on Everest 1830 (1962 Definition) ellipsoid)","geodetic","","","7044","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","2000.42","0 ",NULL};
datafile_rows_t datum_row_144[] = {"6045","Not specified (based on Everest 1830 (1975 Definition) ellipsoid)","geodetic","","","7045","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2000-05-03","2000.42","0 ",NULL};
datafile_rows_t datum_row_145[] = {"6047","Not specified (based on GRS 1980 Authalic Sphere)","geodetic","","","7048","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2004-04-27","2001.19 2003.33","0 ",NULL};
datafile_rows_t datum_row_146[] = {"6052","Not specified (based on Clarke 1866 Authalic Sphere)","geodetic","","","7052","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","EPSG","EPSG","2004-04-27","","0 ",NULL};
datafile_rows_t datum_row_147[] = {"6053","Not specified (based on International 1924 Authalic Sphere)","geodetic","","","7057","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","OGP","OGP","2006-09-22","","0 ",NULL};
datafile_rows_t datum_row_148[] = {"6054","Not specified (based on Hughes 1980 ellipsoid)","geodetic","","","7058","8901","1263","Not a valid datum.","Included for coordinate reference systems where datum is unknown.","OGP","OGP","2006-09-22","","0 ",NULL};
datafile_rows_t datum_row_149[] = {"6120","Greek","geodetic","Fundamental point: Athens Observatory; latitude 37 deg 58 min 20.132 sec N; longitude 23 deg 42 min 58.815 sec E of Greenwich","","7004","8901","1106","Topographic mapping.","See geodetic datum alias 6404.  Used as basis of topographic mapping based on Hatt projection. Replaced by GGRS87 (code 6121).","Topography Department; National Technical University of Athens","EPSG","2004-03-26","2004.183","0 ",NULL};
datafile_rows_t datum_row_150[] = {"6121","Greek Geodetic Reference System 1987","geodetic","Fundamental point: Dionysos; latitude 38 deg 04 min 33.8 sec N; longitude 23 deg 55 min 51.0 sec E of Greenwich; geoid height 7.0 m.","1987","7019","8901","1106","Topographic mapping.","Replaced (old) Greek datum.  Oil industry work based on ED50.","L. Portokalakis; Public Petroleum Corporation of Greece","EPSG","1997-06-16","","0 ",NULL};
datafile_rows_t datum_row_151[] = {"6122","Average Terrestrial System 1977","geodetic","","1977","7041","8901","1283","Topographic mapping.","In use from 1979.  To be phased out in late 1990's.","New Brunswick Geographic Information Corporation land and water information standards manual.","EPSG","1997-07-02","","0 ",NULL};
datafile_rows_t datum_row_152[] = {"6123","Kartastokoordinaattijarjestelma (1966)","geodetic","Adjustment with fundamental point SF31 based on ED50 transformed to best fit the older VVJ adjustment.","1966","7022","8901","1095","Geodetic survey, cadastre, topographic mapping, engineering survey.","Adopted in 1970.","National Land Survey of Finland; http://www.maanmittauslaitos.fi","EPSG","2006-03-31","2006.27","0 ",NULL};
datafile_rows_t datum_row_153[] = {"6124","Rikets koordinatsystem 1990","geodetic","","1982","7004","8901","1225","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces RT38 adjustment (datum code 6308)","National Land Survey of Sweden","EPSG","1997-11-13","","0 ",NULL};
datafile_rows_t datum_row_154[] = {"6125","Samboja","geodetic","Original origin station P2 Exc now destroyed.  Extensions recomputed using Toran station T9 as origin.","","7004","8901","1328","Topographic mapping.","","Total Indonesia.","EPSG","1997-11-13","","1 ",NULL};
datafile_rows_t datum_row_155[] = {"6126","Lithuania 1994 (ETRS89)","geodetic","Constrained to 4 ETRS89 points in Lithuania from the EUREF Baltic 1992 campaign..","1994","7019","8901","1145","Topographic mapping, geodetic survey.","Densification of ETRS89 during the 1992 Baltic campaign.","HNIT-Baltic GeoInfoServisas","EPSG","1998-03-12","","0 ",NULL};
datafile_rows_t datum_row_156[] = {"6127","Tete","geodetic","Fundamental point: Tete.","","7008","8901","3281","Topographic mapping.","","Mozambique Direcção Nacional de Geografia e Cadastral (DINAGECA).","EPSG","1998-04-16","","0 ",NULL};
datafile_rows_t datum_row_157[] = {"6128","Madzansua","geodetic","Fundamental point: Madzansua.","","7008","8901","1315","Topographic mapping.","Replaced by transformation to Tete datum (datum code 6127).","Mozambique Direcção Nacional de Geografia e Cadastral (DINAGECA).","EPSG","1998-04-16","","0 ",NULL};
datafile_rows_t datum_row_158[] = {"6129","Observatario","geodetic","Fundamental point: Maputo observatory.","","7008","8901","1329","Topographic mapping.","Replaced by transformation to Tete datum (datum code 6127).","Mozambique Direcção Nacional de Geografia e Cadastral (DINAGECA).","EPSG","1998-04-16","","0 ",NULL};
datafile_rows_t datum_row_159[] = {"6130","Moznet (ITRF94)","geodetic","ITRF94 at epoch 1996.9","","7030","8901","1167","Topographic mapping.","","Mozambique Direcção Nacional de Geografia e Cadastral (DINAGECA).","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_160[] = {"6131","Indian 1960","geodetic","DMA extension over IndoChina of the Indian 1954 network adjusted  to better fit local geoid.","","7015","8901","1302","Topographic mapping.","Also known as Indian (DMA Reduced).","","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_161[] = {"6132","Final Datum 1958","geodetic","Fundamental point: Maniyur.  Latitude: 31 deg 23 min 59.19 sec N; Longitude: 48 deg 32 min 31.38 sec E (of Greenwich).","","7012","8901","1300","Oil industry mapping.","Network included in Nahrwan 1967 adjustment.","IOEPC records","EPSG","1998-11-11","","0 ",NULL};
datafile_rows_t datum_row_162[] = {"6133","Estonia 1992","geodetic","Densification from 4 ETRS89 points.","1992","7019","8901","1090","Topographic mapping, Geodetic survey.","Based on ETRS89 as established during the 1992 Baltic campaign. Replaced by Estonia 1997 adjustment (code 6180).","http://www.geo.ut.ee","EPSG","2005-09-06","2005.46","0 ",NULL};
datafile_rows_t datum_row_163[] = {"6134","PDO Survey Datum 1993","geodetic","Adjustment best fitted to Fahud network.","1993","7012","8901","3288","Oil industry mapping.","Replaces Fahud datum (code 6232). Maximum differences to Fahud adjustment are 20 metres.","Petroleum Development Oman","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_164[] = {"6135","Old Hawaiian","geodetic","Fundamental point: Oahu West Base Astro.  Latitude: 21 deg 18 min 13.89 sec N; longitude 157 deg 50 min 55.79 sec W (of Greenwich)","","7008","8901","1334","Topographic mapping.","Hawaiian Islands were never on NAD27 but rather on Old Hawaiian Datum.  NADCON conversion program provides transformation from Old Hawaiian Datum to NAD83 (original 1986 realization) but making the transformation appear to user as if from NAD27.","http://www.ngs.noaa.gov/ (NADCON readme file).","EPSG","2005-09-05","2005.46","0 ",NULL};
datafile_rows_t datum_row_165[] = {"6136","St. Lawrence Island","geodetic","","","7008","8901","1332","Topographic mapping.","Many Alaskan islands were never on NAD27 but rather on independent datums.  NADCON conversion program provides transformation from St. Lawrence Island Datum to NAD83 (original 1986 realization) - making the transformation appear to user as if from NAD27.","http://www.ngs.noaa.gov/ (NADCON readme file)","EPSG","1999-05-24","","0 ",NULL};
datafile_rows_t datum_row_166[] = {"6137","St. Paul Island","geodetic","Fundamental point latitude: 57 deg 07 min 16.86 sec N; longitude: 170 deg 16 min 24.00 sec W (of Greenwich).","","7008","8901","1333","Topographic mapping.","Many Alaskan islands were never on NAD27 but rather on independent datums.  NADCON conversion program provides transformation from St. Paul Island Datum to NAD83 (original 1986 realization) - making the transformation appear to user as if from NAD27.","http://www.ngs.noaa.gov/ (NADCON readme file)","EPSG","1999-05-24","","0 ",NULL};
datafile_rows_t datum_row_167[] = {"6138","St. George Island","geodetic","Fundamental point latitude: 56 deg 36 min 11.31 sec N; longitude: 169 deg 32 min 36.00 sec W (of Greenwich).","","7008","8901","1331","Topographic mapping.","Many Alaskan islands were never on NAD27 but rather on independent datums.  NADCON conversion program provides transformation from St. George Island Datum to NAD83 (original 1986 realization) - making the transformation appear to user as if from NAD27.","http://www.ngs.noaa.gov/ (NADCON readme file)","EPSG","2003-12-31","2003.362","0 ",NULL};
datafile_rows_t datum_row_168[] = {"6139","Puerto Rico","geodetic","Fundamental point: Cardona Island Lighthouse. Latitude:17 deg 57 min 31.40 sec N; Longitude: 66 deg 38 min 07.53 sec W (of Greenwich).","1901","7008","8901","1335","Topographic mapping.","NADCON conversion program provides transformation from Puerto Rico Datum to NAD83 (original 1986 realization) but making the transformation appear to user as if from NAD27.","Ordnance Survey of Great Britain and http://www.ngs.noaa.gov/ (NADCON readme file).","EPSG","2003-12-31","2003.362","0 ",NULL};
datafile_rows_t datum_row_169[] = {"6140","NAD83 Canadian Spatial Reference System","geodetic","","1998","7019","8901","1061","Geodetic survey.","","Natural Resources of Canada, CSRS website.  http://www.geod.nrcan.gc.ca","EPSG","2007-05-29","2005.88 2006.461 2007.026","0 ",NULL};
datafile_rows_t datum_row_170[] = {"6141","Israel","geodetic","Fundamental point:  Latitude: 31 deg 44 min 03.817 sec N; Longitude: 35 deg 12 min 16.261 sec E (of Greenwich).","","7019","8901","2603","Topographic mapping.","","Survey of Israel.","EPSG","2004-04-14","2002.34 2004.15","0 ",NULL};
datafile_rows_t datum_row_171[] = {"6142","Locodjo 1965","geodetic","Fundamental point: T5 Banco. Latitude: 5 deg 18 min 50.5 sec N; Longitude: 4 deg 02 min 05.1 sec W (of Greenwich).","1965","7012","8901","1075","Topographic mapping.","","IGN Paris.","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_172[] = {"6143","Abidjan 1987","geodetic","Fundamental point: Abidjan I. Latitude: 5 deg 18 min 51.01 sec N; Longitude: 4 deg 02 min 06.04 sec W (of Greenwich).","1987","7012","8901","1075","Topographic mapping.","","IGN Paris.","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_173[] = {"6144","Kalianpur 1937","geodetic","Fundamental point: Kalianpur. Latitude: 24 deg  07 min 11.260 sec N; Longitude: 77 deg 39 min 17.570 sec E (of Greenwich).","1937","7015","8901","1308","Topographic mapping.","Replaces 1880 adjustment except for topographic mapping.  Replaced in Bangladesh and Pakistan by 1962 metrication conversion and in India by 1975 metrication conversion.","G. Bomford; \"The Re-adjustment of the Indian Triangulation\"; Survey of India Professional Paper 28; 1939.","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_174[] = {"6145","Kalianpur 1962","geodetic","Fundamental point: Kalianpur. Latitude: 24 deg  07 min 11.260 sec N; Longitude: 77 deg 39 min 17.570 sec E (of Greenwich).","1962","7044","8901","3289","Topographic mapping.","1937 adjustment rescaled by ratio metric conversions of Indian foot (1937) to Indian foot (1962).","","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_175[] = {"6146","Kalianpur 1975","geodetic","Fundamental point: Kalianpur. Latitude: 24 deg  07 min 11.260 sec N; Longitude: 77 deg 39 min 17.570 sec E (of Greenwich).","1975","7045","8901","3341","Topographic mapping.","1937 adjustment rescaled by ratio metric conversions of Indian foot (1937) to Indian foot (1975).","","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_176[] = {"6147","Hanoi 1972","geodetic","","1972","7024","8901","3328","Geodetic survey, cadastre, topographic mapping, engineering survey.","","PetroVietnam","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_177[] = {"6148","Hartebeesthoek94","geodetic","Coincident with ITRF91 at epoch 1994.0 at Hartebeesthoek astronomical observatory near Pretoria.","1994","7030","8901","1215","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces Cape datum (code 6222).","Directorate of Surveys and Mapping; http://w3sli.wcape.gov.za/surveys/mapping/wgs84.htm","EPSG","2006-08-18","99.96 2006.77","0 ",NULL};
datafile_rows_t datum_row_178[] = {"6149","CH1903","geodetic","Fundamental point: Old Bern observatory. Latitude: 46 deg 57 min 08.660 sec N; Longitude: 7 deg 26 min 22.500 sec E (of Greenwich).","1903","7004","8901","1286","Topographic mapping.","","Bundesamt für Landestopographie","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_179[] = {"6150","CH1903+","geodetic","Fundamental point: Zimmerwald observatory.","","7004","8901","1286","Geodetic survey, topographic mapping.","","Bundesamt für Landestopographie.  Aufbau der Landesvermessung der Schweiz 'LV95' Teil 3: Terrestrische Bezugssysteme und Bezugsrahmen. L+T 1999.","EPSG","2001-11-06","2001.52","0 ",NULL};
datafile_rows_t datum_row_180[] = {"6151","Swiss Terrestrial Reference Frame 1995","geodetic","ETRF89 at epoch 1993.0","1995","7019","8901","1286","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Bundesamt für Landestopographie.  Aufbau der Landesvermessung der Schweiz 'LV95' Teil 3: Terrestrische Bezugssysteme und Bezugsrahmen. L+T 1999.","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_181[] = {"6152","NAD83 (High Accuracy Regional Network)","geodetic","","","7019","8901","1337","Geodetic survey.","","National Geodetic Survey","EPSG","1999-10-20","","0 ",NULL};
datafile_rows_t datum_row_182[] = {"6153","Rassadiran","geodetic","Fundamental point: Total1. Latitude: 27 deg 31 min 07.784 sec N; Longitude: 52 deg 36 min 12.741 sec E (of Greenwich).","1998","7022","8901","1338","Oil industry mapping.","","Total-Fina","EPSG","1999-11-20","","0 ",NULL};
datafile_rows_t datum_row_183[] = {"6154","European Datum 1950(1977)","geodetic","Extension of ED50 over Iran.","1977","7022","8901","1123","Topographic mapping.","Sometimes referred to as ED50-ED77.","National Cartographic Centre of Iran","EPSG","1999-11-20","","0 ",NULL};
datafile_rows_t datum_row_184[] = {"6155","Dabola 1981","geodetic","","1981","7011","8901","3257","Topographic mapping.","","IGN Paris","EPSG","1999-12-09","","0 ",NULL};
datafile_rows_t datum_row_185[] = {"6156","Jednotne Trigonometricke Site Katastralni","geodetic","Modification of Austrian MGI datum, code 6312.","","7004","8901","1306","Geodetic survey, cadastre, topographic mapping, engineering survey.","S-JTSK = System of the Unified Trigonometrical Cadastral Network.","Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.","EPSG","2001-11-06","2001.26  2001.51","0 ",NULL};
datafile_rows_t datum_row_186[] = {"6157","Mount Dillon","geodetic","Fundamental point: Mount Dillon triangulation station. Latitude: 11 deg 15 min 07.843 sec N; Longitude: 60 deg 41 min 09.632 sec W (of Greenwich).","","7007","8901","1322","Topographic mapping.","","University of the West Indies Geodetic Services.","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_187[] = {"6158","Naparima 1955","geodetic","Fundamental point: Naparima. Latitude: 10 deg 16 min 44.860 sec N; Longitude: 61 deg 27 min 34.620 sec W (of Greenwich).","1955","7022","8901","3143","Topographic mapping.","Naparima 1972 is an extension of the Naparima 1955 network of Trinidad to include Tobago.","Ordnance Survey International.","EPSG","2000-03-07","","0 ",NULL};
datafile_rows_t datum_row_188[] = {"6159","European Libyan Datum 1979","geodetic","Extension of ED50 over Libya.","1979","7022","8901","1143","Topographic mapping.","","Brown and Root","EPSG","2003-12-31","2003.362","0 ",NULL};
datafile_rows_t datum_row_189[] = {"6160","Chos Malal 1914","geodetic","Chos Malal police station.","1914","7022","8901","1292","Oil industry mapping.","Also known as Quini-Huao.  Replaced by Campo Inchauspe (code 6221).","Various oil company records.","EPSG","2000-03-07","","0 ",NULL};
datafile_rows_t datum_row_190[] = {"6161","Pampa del Castillo","geodetic","","","7022","8901","1265","Oil industry mapping.","Used in Comodoro Rivadavia area.  Replaced by Campo Inchauspe (code 6221).","Various oil company records.","EPSG","2000-03-07","","0 ",NULL};
datafile_rows_t datum_row_191[] = {"6162","Korean Datum 1985","geodetic","Fundamental point: Suwon; latitude 37 deg 16 min 31.9034 sec N; longitude 127 deg 03 min 05.1451 sec E of Greenwich.","1985","7004","8901","3266","Topographic mapping.","","Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1999. http://www.asprs.org/","EPSG","2005-09-05","2001.28 2005.46","0 ",NULL};
datafile_rows_t datum_row_192[] = {"6163","Yemen National Geodetic Network 1996","geodetic","Sana'a IGN reference marker","1996","7030","8901","1257","Topographic mapping.","","IGN Paris","EPSG","2000-03-07","","0 ",NULL};
datafile_rows_t datum_row_193[] = {"6164","South Yemen","geodetic","","","7024","8901","1340","Topographic mapping.","","IGN Paris","EPSG","2000-03-07","","0 ",NULL};
datafile_rows_t datum_row_194[] = {"6165","Bissau","geodetic","","","7022","8901","3258","Topographic mapping.","","NIMA TR8350.2  ftp://164.214.2.65/pub/gig/tr8350.2/changes.pdf","EPSG","2005-09-05","2005.46","0 ",NULL};
datafile_rows_t datum_row_195[] = {"6166","Korean Datum 1995","geodetic","","1995","7030","8901","3266","Topographic mapping.","","NIMA TR8350.2  ftp://164.214.2.65/pub/gig/tr8350.2/changes.pdf","EPSG","2005-09-05","2005.46","0 ",NULL};
datafile_rows_t datum_row_196[] = {"6167","New Zealand Geodetic Datum 2000","geodetic","Based on ITRF96 at epoch 2000.0","2000","7019","8901","3285","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces New Zealand Geodetic Datum 1949 (code 6272) and Chatham Islands Datum 1979 (code 6673) from March 2000.","Land Information New Zealand. http://www.linz.govt.nz/rcs/linz/pub/web/root/core/SurveySystem/GeodeticInfo/GeodeticDatums/nzgd2000factsheet/index.jsp","EPSG","2004-03-26","2004.11","0 ",NULL};
datafile_rows_t datum_row_197[] = {"6168","Accra","geodetic","Fundamental point: GCS Station 547. Latitude: 5 deg 23 min 43.3 sec N; Longitude: 0 deg 11 min 52.3 sec W (of Greenwich).","","7029","8901","1104","Topographic mapping.","Replaced in 1978 by Leigon datum (code 6250).","Ordnance Survey International","EPSG","2000-10-12","","0 ",NULL};
datafile_rows_t datum_row_198[] = {"6169","American Samoa 1962","geodetic","Fundamental point: Betty 13 eccentric. Latitude: 14 deg 20 min 08.34 sec S; longitude: 170 deg 42 min 52.25 sec W","1962","7008","8901","3109","Topographic mapping.","","NIMA TR8350.2 revision of January 2000. Oil industry sources for origin description details.","EPSG","2005-05-21","2003.362 2005.23","0 ",NULL};
datafile_rows_t datum_row_199[] = {"6170","Sistema de Referencia Geocentrico para America del Sur 1995","geodetic","ITRF94 at epoch 1995.42.","1995","7019","8901","3448","Geodetic survey.","Realised by a frame of 58 stations observed in 1995 and adjusted in the ITRF94. Replaced by SIRGAS 2000.","NIMA TR8350.2 revision of January 2000. Also http://www1.ibge.gov.br/","EPSG","2006-08-18","2004.25 2005.46 2006.465 2006.77","0 ",NULL};
datafile_rows_t datum_row_200[] = {"6171","Reseau Geodesique Francais 1993","geodetic","Coincident with ETRS89 at epoch 1993.0","1993","7019","8901","1096","Geodetic survey.","","http://www.ign.fr/ via TotalFinaElf","EPSG","2005-09-05","2001.51 2005.46","0 ",NULL};
datafile_rows_t datum_row_201[] = {"6172","Posiciones Geodesicas Argentinas","geodetic","","1994","7019","8901","1033","Topographic mapping, geodetic survey.","Una red geodésica de 127 puntos materializados en el terreno que definen el Sistema Geodésico Nacional.  [A geodetic network of 127 points defining the National Geodetic System.] Replaced by POSGAR98 (code 6190).","http://www.igm.gov.ar/posgar.html","EPSG","2000-10-19","","1 ",NULL};
datafile_rows_t datum_row_202[] = {"6173","IRENET95","geodetic","ETRS89 stations in Ireland","1995","7019","8901","1305","Geodetic survey.","Densification of ETRS89","Ordnance Survey of Ireland","EPSG","2004-04-07","2004.22","0 ",NULL};
datafile_rows_t datum_row_203[] = {"6174","Sierra Leone Colony 1924","geodetic","Fundamental point: Kortright. Latitude: 8 deg 28 min 44.4 sec N; Longitude: 13 deg 13 min 03.81 sec W (of Greenwich).","1924","7029","8901","1342","Topographic mapping, engineering survey.","","Ordnance Survey International.","EPSG","2001-06-05","","0 ",NULL};
datafile_rows_t datum_row_204[] = {"6175","Sierra Leone 1968","geodetic","Fundamental point: SLX2 Astro. Latitude: 8 deg 27 min 17.567 sec N; Longitude: 12 deg 49 min 40.186 sec W (of Greenwich).","1968","7012","8901","3306","Topographic mapping, engineering survey.","Extension and readjustment with additional observations of 1960 network.  Coordinates of 1960 stations change by less than 3 metres.","Ordnance Survey International.","EPSG","2001-06-05","","0 ",NULL};
datafile_rows_t datum_row_205[] = {"6176","Australian Antarctic Datum 1998","geodetic","","1998","7019","8901","1278","Topographic mapping.","","Standards Australia","EPSG","2006-01-30","2006.08","0 ",NULL};
datafile_rows_t datum_row_206[] = {"6178","Pulkovo 1942/83","geodetic","Fundamental point: Pulkovo observatory. Latitude: 59 deg 46 min 18.550 sec N; Longitude: 30 deg 19 min 42.090 sec E (of Greenwich).","1983","7024","8901","1343","Geodetic survey, cadastre, topographic mapping, engineering survey.","International adjustment of Uniforrm Astro-Geodetic Network of countries of central and eastern Europe.","Bundesamt für Kartographie und Geodäsie via EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2001-06-05","","0 ",NULL};
datafile_rows_t datum_row_207[] = {"6179","Pulkovo 1942/58","geodetic","Fundamental point: Pulkovo observatory. Latitude: 59 deg 46 min 18.550 sec N; Longitude: 30 deg 19 min 42.090 sec E (of Greenwich).","1958","7024","8901","1192","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Glowny Urzad Geodezji i Kartografii via EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2001-06-05","","0 ",NULL};
datafile_rows_t datum_row_208[] = {"6180","Estonia 1997","geodetic","Densification of ETRS89 during EUREF-ESTONIA97 campaign through transformation from ITRF96 at epoch 1997.56.","1997","7019","8901","1090","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces Estonia 1992 adjustment (code 6133).","Estonian National Land Board via EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_209[] = {"6181","Luxembourg 1930","geodetic","Fundamental point: northern station of Habay-la-Neuve baseline in Belgium. Latitude: 49 deg 43 min 24.408 sec N; longitude: 5 deg 38 min 22.470 sec E (of Greenwich)","1930","7022","8901","1146","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Administration du Cadastre et de la Topographie via EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2001-06-05","","0 ",NULL};
datafile_rows_t datum_row_210[] = {"6182","Azores Occidental Islands 1939","geodetic","Fundamental point: Observatario Meteorologico Flores.","1939","7022","8901","1344","Topographic mapping.","","Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2005-12-30","2005.85","0 ",NULL};
datafile_rows_t datum_row_211[] = {"6183","Azores Central Islands 1948","geodetic","Fundamental point: Graciosa south west base. Latitude: 39 deg 03 min 54.934 sec N; longitude: 28 deg 02 min 23.882 sec W","1948","7022","8901","1301","Topographic mapping.","Replaced by 1995 adjustment (datum code 6665).","Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.bkg.bund.de/crs-eu/  Oil industry sources for origin description details.","EPSG","2003-12-31","2002.25 2003.231 2003.362","0 ",NULL};
datafile_rows_t datum_row_212[] = {"6184","Azores Oriental Islands 1940","geodetic","Fundamental point: Forte de São Bras.","1940","7022","8901","1345","Topographic mapping.","Replaced by 1995 adjustment (datum code 6664).","Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2003-08-14","2003.231","0 ",NULL};
datafile_rows_t datum_row_213[] = {"6185","Madeira 1936","geodetic","Fundamental point: Madeira SE Base.","1936","7022","8901","1314","Topographic mapping.","","Instituto Geografico e Cadastral Lisbon via EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2001-06-05","","1 ",NULL};
datafile_rows_t datum_row_214[] = {"6188","OSNI 1952","geodetic","Position fixed to the coordinates from the 19th century Principle Triangulation of station Divis. Scale and orientation controlled by position of Principle Triangulation stations Knocklayd and Trostan.","1952","7001","8901","2530","Geodetic survey and topographic mapping.","Replaced by Geodetic Datum of 1965 alias 1975 Mapping Adjustment or TM75 (datum code 6300).","Ordnance Survey of Northern Ireland.","EPSG","2001-11-06","","0 ",NULL};
datafile_rows_t datum_row_215[] = {"6189","Red Geodesica Venezolana","geodetic","Realised by a frame of 67 stations observed in 1995 as a densification of the SIRGAS campaign and adjusted in the ITRF94.","2000","7019","8901","1251","Geodetic survey.","","Servicio Autonomo de Geografia y Cartografia Nacional.","EPSG","2001-06-11","","0 ",NULL};
datafile_rows_t datum_row_216[] = {"6190","Posiciones Geodesicas Argentinas 1998","geodetic","A geodetic network of 136 high accuracy surveyed points. Densification of SIRGAS 1995; ITRF94 at epoch 1995.42.","1998","7019","8901","1033","Geodetic survey.","Technically, but at this record revision date not legally, replaces the 1994 POSGAR adjustment (code 6694).","Instituto Geográfico Militar de la República Argentina, http://www.igm.gov.ar","EPSG","2005-09-12","2003.372 2005.46 2005.48 2006.77","0 ",NULL};
datafile_rows_t datum_row_217[] = {"6191","Albanian 1987","geodetic","","1987","7024","8901","1025","Geodetic survey, cadastre, topographic mapping, engineering survey.","","EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2001-11-06","","0 ",NULL};
datafile_rows_t datum_row_218[] = {"6192","Douala 1948","geodetic","South pillar of Douala base; 4deg 00min 40.64sec N, 9deg 42min 30.41sec E","1948","7022","8901","2555","Topographic mapping.","Replaced  by Manoca 1962 datum (code 6193).","TotalFinaElf","EPSG","2005-12-30","2005.83","0 ",NULL};
datafile_rows_t datum_row_219[] = {"6193","Manoca 1962","geodetic","Reservoir centre at the  Manoca tower (\"tube Suel\"), 3deg 51min 49.896sec N, 9deg 36min 49.347sec E.","1962","7011","8901","2555","Topographic mapping.","The intent of the Bukavu 1953 conference was to adopt the Clarke 1880 (RGS) ellipsoid (code 7012) but in practice this datum has used the IGN version.  Replaces Douala 1948 (code 6192).","TotalFinaElf","EPSG","2002-01-18","","0 ",NULL};
datafile_rows_t datum_row_220[] = {"6194","Qornoq 1927","geodetic","Fundamental point: Station 7008. Latitude: 64 deg 31 min 06.27 sec N; Longitude: 51 deg 12 min 24.86 sec W (of Greenwich).","1927","7022","8901","3362","Topographic mapping.","","Kort & Matrikelstyrelsen, Copenhagen. Origin coordinates from NIMA http://earth-info.nima.mil/","EPSG","2006-03-16","2003.362 2005.46 2006.22","0 ",NULL};
datafile_rows_t datum_row_221[] = {"6195","Scoresbysund 1952","geodetic","","1952","7022","8901","2570","Topographic mapping.","","Kort & Matrikelstyrelsen, Copenhagen.","EPSG","2002-01-18","","0 ",NULL};
datafile_rows_t datum_row_222[] = {"6196","Ammassalik 1958","geodetic","","1958","7022","8901","2571","Topographic mapping.","","Kort & Matrikelstyrelsen, Copenhagen.","EPSG","2002-01-18","","0 ",NULL};
datafile_rows_t datum_row_223[] = {"6197","Garoua","geodetic","Fundamental point: IGN astronomical station and benchmark no. 16 at Tongo. Latitude 8 deg 55 min 08.74 sec N; longitude 13 deg 30 min 43.19 sec E (of Greenwich).","","7012","8901","2590","Topographic mapping.","","TotalFinaElf","EPSG","2002-02-12","","0 ",NULL};
datafile_rows_t datum_row_224[] = {"6198","Kousseri","geodetic","IGN astronomical station Dabanga; 11deg 55min 05.9sec N  14deg 38min 40.8sec E.","","7012","8901","2591","Topographic mapping.","","TotalFinaElf","EPSG","2002-02-12","","0 ",NULL};
datafile_rows_t datum_row_225[] = {"6199","Egypt 1930","geodetic","Fundamental point: Station F1 (Venus). Latitude: 30 deg 01 min 42.86 sec N; Longitude: 31 deg 16 min 37.05 sec E (of Greenwich).","1930","7022","8901","3242","Used for scientific purposes only.","Note that Egypt 1930 uses the International 1924 ellipsoid, unlike the Egypt 1907 datum (code 6229) which uses the Helmert ellipsoid. Oil industry references to the Egypt 1930 datum name and the Helmert ellipsoid probably mean Egypt 1907 datum.","","EPSG","2002-02-12","","0 ",NULL};
datafile_rows_t datum_row_226[] = {"6200","Pulkovo 1995","geodetic","Fundamental point: Pulkovo observatory. Latitude: 59 deg 46 min 15.359 sec N; Longitude: 30 deg 19 min 28.318 sec E (of Greenwich).","1995","7024","8901","1198","Scientific adjustment.","","\"Main Terms of Reference for the State Geodetic Network\"; Federal Geodetic Service of Russia; 1994","EPSG","1996-09-12","","0 ",NULL};
datafile_rows_t datum_row_227[] = {"6201","Adindan","geodetic","Fundamental point: Station 15; Adindan. Latitude: 22 deg 10 min 07.110 sec N; Longitude: 31 deg 29 min 21.608 sec E (of Greenwich).","","7012","8901","1271","Topographic mapping.","The 12th parallel traverse of 1966-70 (Point 58 datum, code 6620) is connected to the Adindan network in western Sudan. This has given rise to misconceptions that the Adindan network is used in west Africa.","","EPSG","2003-12-31","2002.431 2003.361","0 ",NULL};
datafile_rows_t datum_row_228[] = {"6202","Australian Geodetic Datum 1966","geodetic","Fundamental point: Johnson Memorial Cairn. Latitude: 25 deg 56 min 54.5515 sec S; Longitude: 133 deg 12 min 30.0771 sec E (of Greenwich).","1966","7003","8901","1279","Topographic mapping.","","Australian Map Grid Technical Manual. National Mapping Council of Australia Technical Publication 7; 1972.","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_229[] = {"6203","Australian Geodetic Datum 1984","geodetic","Fundamental point: Johnson Memorial Cairn. Latitude: 25 deg 56 min 54.5515 sec S; Longitude: 133 deg 12 min 30.0771 sec E (of Greenwich).","1984","7003","8901","2576","Topographic mapping.","Uses all data from 1966 adjustment with additional observations, improved software and a geoid model.","\"GDA technical manual v2_2\", Intergovernmental Committee on Surveying and Mapping. www.anzlic.org.au/icsm/gdtm/","EPSG","2003-12-31","2003.29 2003.361","0 ",NULL};
datafile_rows_t datum_row_230[] = {"6204","Ain el Abd 1970","geodetic","Fundamental point: Ain El Abd.  Latitude: 28 deg 14 min 06.171 sec N; Longitude: 48 deg 16 min 20.906 sec E (of Greenwich).","1970","7022","8901","1272","Topographic mapping.","","","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_231[] = {"6205","Afgooye","geodetic","","","7024","8901","1214","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_232[] = {"6206","Agadez","geodetic","","","7011","8901","1177","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_233[] = {"6207","Lisbon 1937","geodetic","Fundamental point: Castelo Sao Jorge; Lisbon. Latitude: 38 deg 42 min 43.631 sec N; Longitude: 9 deg 07 min 54.862 sec W (of Greenwich).","1937","7022","8901","1294","Topographic mapping.","Replaces Lisbon 1890 adjustment (which used Bessel 1841 ellipsoid).","Instituto Geografico e Cadastral; Lisbon","EPSG","1995-06-02","2001.551","0 ",NULL};
datafile_rows_t datum_row_234[] = {"6208","Aratu","geodetic","","","7022","8901","1274","Oil industry geodetic purposes.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_235[] = {"6209","Arc 1950","geodetic","Fundamental point: Buffelsfontein. Latitude: 33 deg 59 min 32.000 sec S; Longitude: 25 deg 30 min 44.622 sec E (of Greenwich).","1950","7013","8901","1276","Topographic mapping, geodetic survey.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_236[] = {"6210","Arc 1960","geodetic","Fundamental point: Buffelsfontein. Latitude: 33 deg 59 min 32.000 sec S; Longitude: 25 deg 30 min 44.622 sec E (of Greenwich).","1960","7012","8901","1277","Topographic mapping, geodetic survey.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_237[] = {"6211","Batavia","geodetic","Fundamental point: Longitude at Batavia Astro. Station. Latitude: 6 deg  7 min 39.522 sec S; Longitude: 106 deg 48 min 27.790 sec E (of Greenwich). Latitude and azimuth at Genuk.","","7004","8901","1285","Topographic mapping.","","","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_238[] = {"6212","Barbados 1938","geodetic","Fundamental point: HMS Challenger astro station M1, St. Anne's Tower; latitude 13 deg 04 min 32.53 sec N; longitude 59 deg 36 min 29.34 sec W (of Greenwich).","1938","7012","8901","1042","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","1999-04-22","99.171 2005.","0 ",NULL};
datafile_rows_t datum_row_239[] = {"6213","Beduaram","geodetic","","","7011","8901","2771","Topographic mapping.","","","EPSG","2004-09-01","2004.49","0 ",NULL};
datafile_rows_t datum_row_240[] = {"6214","Beijing 1954","geodetic","","1954","7024","8901","1067","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_241[] = {"6215","Reseau National Belge 1950","geodetic","Fundamental point: Lommel (tower). Latitude: 51 deg 13 min 47.334 sec N; Longitude: 5 deg 18 min 49.483 sec E (of Greenwich).","1950","7022","8901","1347","Topographic mapping.","","","EPSG","2003-12-18","2003.361","0 ",NULL};
datafile_rows_t datum_row_242[] = {"6216","Bermuda 1957","geodetic","Fundamental point: Fort George base. Latitude 32 deg 22 min 44.36 sec N; longitude 64 deg 40 min 58.11 sec W (of Greenwich).","1957","7008","8901","1047","Topographic mapping.","","Various oil industry sources.","EPSG","2003-12-31","2003.362","0 ",NULL};
datafile_rows_t datum_row_243[] = {"6218","Bogota 1975","geodetic","Fundamental point: Bogota observatory. Latitude: 4 deg 35 min 56.570 sec N; Longitude: 74 deg  4 min 51.300 sec W (of Greenwich).","1975","7022","8901","3229","Topographic mapping.","Replaces 1951 adjustment. Replaced by MAGNA-SIRGAS (datum code 6685).","Instituto Geografico Agustin Codazzi (IGAC) special publication no. 1, 4th edition (1975) \"Geodesia: Resultados Definitvos de Parte de las Redes Geodesicas Establecidas en el Pais\".","EPSG","2007-07-02","2000.20 2005.06 2007.060","0 ",NULL};
datafile_rows_t datum_row_244[] = {"6219","Bukit Rimpah","geodetic","2deg 00min 40.16sec S  105deg 51min 39.76sec E (of Greenwich).","","7004","8901","1287","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_245[] = {"6220","Camacupa","geodetic","Fundamental point: Campo de Aviaçao. Latitude: 12 deg 01 min 09.070 sec South, Longitude = 17 deg 27 min 19.800 sec East of Greenwich","1948","7012","8901","1288","Coastal hydrography.","","Portuguese Hydrographic Institute and Clifford J. Mugnier, PE&RS journal, March 2001.","EPSG","2006-12-05","2003.361 2006.973","0 ",NULL};
datafile_rows_t datum_row_246[] = {"6221","Campo Inchauspe","geodetic","Fundamental point: Campo Inchauspe. Latitude: 35 deg 58 min 16.56 sec S; Longitude: 62 deg 10 min 12.03 sec W (of Greenwich).","","7022","8901","1033","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-09-05","2003.361 2005.46","0 ",NULL};
datafile_rows_t datum_row_247[] = {"6222","Cape","geodetic","Fundamental point: Buffelsfontein. Latitude: 33 deg 59 min 32.000 sec S; Longitude: 25 deg 30 min 44.622 sec E (of Greenwich).","","7013","8901","1290","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Private Communication, Directorate of Surveys and Land Information, Cape Town.","EPSG","1996-10-18","96.25  99.69","0 ",NULL};
datafile_rows_t datum_row_248[] = {"6223","Carthage","geodetic","Fundamental point: Carthage. Latitude: 40.9464506g = 36 deg 51 min 06.50 sec N; Longitude: 8.8724368g E of Paris = 10 deg 19 min 20.72 sec E of Greenwich.","1925","7011","8901","1236","Topographic mapping.","Fundamental point astronomic coordinates determined in 1878.","","EPSG","2004-01-15","2003.362 2003.05","0 ",NULL};
datafile_rows_t datum_row_249[] = {"6224","Chua","geodetic","Fundamental point: Chua. Latitude: 19 deg 45 min 41.160 sec S; Longitude: 48 deg 06 min 07.560 sec W (of Greenwich).","","7022","8901","3356","Geodetic survey.","The Chua origin and associated triangulation network is in Brazil, but with a connecting traverse through northern Paraguay. The Chua system was used in Brazil only as input into the Corrego Allegre adjustment (datum code 6225).","NIMA http://earth-info.nima.mil/","EPSG","2006-07-14","2003.361 2005.46 2005.84 2006.49","0 ",NULL};
datafile_rows_t datum_row_250[] = {"6225","Corrego Alegre","geodetic","Fundamental point: Corrego Alegre. Latitude: 19 deg 50 min 15.140 sec S; Longitude: 48 deg 57 min 42.750 sec W (of Greenwich).","","7022","8901","1293","Topographic mapping, geodetic survey. Superseded by SAD69.","NIMA gives coordinates of origin as Latitude: 19 deg 50 min 15.140 sec S; Longitude: 48 deg 57 min 42.750 sec W.","IGBE and NIMA http://earth-info.nima.mil/","EPSG","2006-02-09","2005.841","0 ",NULL};
datafile_rows_t datum_row_251[] = {"6226","Cote d'Ivoire","geodetic","","","7011","8901","1075","Topographic mapping.","","","EPSG","1995-06-02","2001.11","1 ",NULL};
datafile_rows_t datum_row_252[] = {"6227","Deir ez Zor","geodetic","Fundamental point: Trig. 254 Deir. Latitude: 35 deg 21 min 49.975 sec N; Longitude: 40 deg 05 min 46.770 sec E (of Greenwich).","","7011","8901","1623","Topographic mapping.","","","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_253[] = {"6228","Douala","geodetic","","","7011","8901","1060","Topographic mapping.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_254[] = {"6229","Egypt 1907","geodetic","Fundamental point: Station F1 (Venus). Latitude: 30 deg 01 min 42.86 sec N; Longitude: 31 deg 16 min 33.60 sec E (of Greenwich).","1907","7020","8901","1086","Geodetic survey, cadastre, topographic mapping, engineering survey.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_255[] = {"6230","European Datum 1950","geodetic","Fundamental point: Potsdam (Helmert Tower). Latitude: 52 deg 22 min 51.4456 sec N; Longitude: 13 deg  3 min 58.9283 sec E (of Greenwich).","1950","7022","8901","1296","Topographic mapping, geodetic survey.","","EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_256[] = {"6231","European Datum 1987","geodetic","Fundamental point: Potsdam (Helmert Tower). Latitude: 52 deg 22 min 51.4456 sec N; Longitude: 13 deg  3 min 58.9283 sec E (of Greenwich).","1987","7022","8901","1297","Scientific network.","","","EPSG","2003-12-31","2003.362","0 ",NULL};
datafile_rows_t datum_row_257[] = {"6232","Fahud","geodetic","Fundamental point: Station NO68-024 Fahud. Latitude: 22 deg 17 min 31.182 sec N; Longitude: 56 deg 29 min 18.820 sec E (of Greenwich).","","7012","8901","3288","Oil industry mapping.","Replaced by PSD93 (code 6134).","Petroleum Development Oman.","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_258[] = {"6233","Gandajika 1970","geodetic","","1970","7022","8901","1152","Topographic mapping.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_259[] = {"6234","Garoua","geodetic","","","7011","8901","1060","Topographic mapping.","The intent of the Bukavu 1953 conference was to adopt the Clarke 1880 (RGS) ellipsoid (code 7012) but in practice this datum has used the IGN version.","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_260[] = {"6235","Guyane Francaise","geodetic","","","7022","8901","1097","Topographic mapping.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_261[] = {"6236","Hu Tzu Shan","geodetic","Fundamental point: Hu Tzu Shan. Latitude: 23 deg 58 min 32.34 sec N; Longitude: 120 deg 58 min 25.975 sec E (of Greenwich).","","7022","8901","3315","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-12-30","2003.362 2005.46 2005.83","0 ",NULL};
datafile_rows_t datum_row_262[] = {"6237","Hungarian Datum 1972","geodetic","Fundamental point: Szolohegy. Latitude: 47 deg 17 min 32,6156 sec N; Longitude 19 deg 36 min 09.9865 sec E; geoid height 6.56m.","1972","7036","8901","1119","Topographic mapping.","","http://lazarus.elte.hu/gb/geodez/geod3.htm","EPSG","1996-10-18","96.09","0 ",NULL};
datafile_rows_t datum_row_263[] = {"6238","Indonesian Datum 1974","geodetic","Fundamental point: Padang. Latitude: 0 deg 56 min 38.414 sec S; Longitude: 100 deg 22 min  8.804 sec E (of Greenwich). Ellipsoidal height 3.190m, gravity-related height 14.0m above mean sea level.","1974","7021","8901","1122","Topographic mapping.","Replaced by DGN95.","Bakosurtanal 1979 paper by Jacob Rais.","EPSG","2006-08-25","2002.151 2006.81","0 ",NULL};
datafile_rows_t datum_row_264[] = {"6239","Indian 1954","geodetic","Extension of Kalianpur 1937 over Myanmar and Thailand.","1954","7015","8901","1304","Topographic mapping.","","","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_265[] = {"6240","Indian 1975","geodetic","Fundamental point: Khau Sakaerang","1975","7015","8901","1231","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_266[] = {"6241","Jamaica 1875","geodetic","Fundamental point: Fort Charles Flagstaff. Latitude: 17 deg 55 min 55.800 sec N; Longitude: 76 deg 56 min 37.260 sec W (of Greenwich).","1875","7034","8901","3342","Topographic mapping.","","Survey Department, Government of Jamaica, 1983.","EPSG","2004-09-12","2004.51","0 ",NULL};
datafile_rows_t datum_row_267[] = {"6242","Jamaica 1969","geodetic","Fundamental point: Fort Charles Flagstaff. Latitude: 17 deg 55 min 55.800 sec N; Longitude: 76 deg 56 min 37.260 sec W (of Greenwich).","1969","7008","8901","3342","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Survey Department, Government of Jamaica, 1983.","EPSG","2004-09-12","2004.51","0 ",NULL};
datafile_rows_t datum_row_268[] = {"6243","Kalianpur 1880","geodetic","Fundamental point: Kalianpur. Latitude: 24 deg  07 min 11.260 sec N; Longitude: 77 deg 39 min 17.570 sec E (of Greenwich).","1880","7042","8901","1307","Topographic mapping.","Includes 1916 extension into Burma (Myanmar).  Replaced by 1937 adjustment.","G. Bomford; \"The Re-adjustment of the Indian Triangulation\"; Survey of India Professional Paper 28; 1939.","EPSG","2004-04-27","97.23 2004.27","0 ",NULL};
datafile_rows_t datum_row_269[] = {"6244","Kandawala","geodetic","","","7015","8901","3310","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_270[] = {"6245","Kertau 1968","geodetic","Fundamental point: Kertau. Latitude: 3 deg 27 min 50.710 sec N; Longitude: 102 deg 37 min 24.550 sec E (of Greenwich).","1968","7018","8901","1309","Geodetic survey, cadastre.","Replaces MRT48 and earlier adjustments. Adopts metric conversion of 39.370113 inches per metre. Not used for 1969 metrication of RSO grid - see Kertau (RSO) (code 6751).","Defence Geographic Centre.","EPSG","2006-07-31","2006.251","0 ",NULL};
datafile_rows_t datum_row_271[] = {"6246","Kuwait Oil Company","geodetic","Fundamental point: K28.  Latitude: 29 deg 03 min 42.348 sec N; Longitude: 48 deg 08 min 42.558 sec E (of Greenwich).","1952","7012","8901","3267","Oil industry mapping.","","","EPSG","2004-06-16","2004.41","0 ",NULL};
datafile_rows_t datum_row_272[] = {"6247","La Canoa","geodetic","Fundamental point: La Canoa. Latitude: 8 deg 34 min 17.170 sec N; Longitude: 63 deg 51 min 34.880 sec W (of Greenwich).","","7022","8901","3327","Geodetic survey, topographic mapping, engineering survey.","Origin also adopted for PSAD56.","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_273[] = {"6248","Provisional South American Datum 1956","geodetic","Fundamental point: La Canoa. Latitude: 8 deg 34 min 17.170 sec N; Longitude: 63 deg 51 min 34.880 sec W (of Greenwich).","1956","7022","8901","1348","Topographic mapping.","Same origin as La Canoa datum.","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_274[] = {"6249","Lake","geodetic","Fundamental point: Maracaibo Cathedral. Latitude: 10 deg 38 min 34.678 sec N; Longitude: 71 deg 36 min 20.224 sec W (of Greenwich).","","7022","8901","1312","Oil industry mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_275[] = {"6250","Leigon","geodetic","Fundamental point: GCS Station 121, Leigon. Latitude: 5 deg 38 min 52.27 sec N; Longitude: 0 deg 11 min 46.08 sec W (of Greenwich).","","7012","8901","1104","Topographic mapping.","Replaced Accra datum (code 6168) from 1978.  Coordinates at Leigon fundamental point defined as Accra datum values for that point.","Ordnance Survey International","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_276[] = {"6251","Liberia 1964","geodetic","Fundamental point: Robertsfield. Latitude: 6 deg 13 min 53.02 sec N; Longitude: 10 deg 21 min 35.44 sec W (of Greenwich).","1964","7012","8901","3270","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-09-05","2003.362 2005.46","0 ",NULL};
datafile_rows_t datum_row_277[] = {"6252","Lome","geodetic","","","7011","8901","1232","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_278[] = {"6253","Luzon 1911","geodetic","Fundamental point: Balacan. Latitude: 13 deg 33 min 41.000 sec N; Longitude: 121 deg 52 min  03.000 sec E (of Greenwich).","1911","7008","8901","1190","Topographic mapping.","Replaced by Philippine Reference system of 1992 (datum code 6683).","Coast and Geodetic Survey","EPSG","2004-12-24","2004.73","0 ",NULL};
datafile_rows_t datum_row_279[] = {"6254","Hito XVIII 1963","geodetic","Chile-Argentina boundary survey.","1963","7022","8901","1303","Geodetic survey.","Used in Tierra del Fuego.","Various oil company records.","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_280[] = {"6255","Herat North","geodetic","Fundamental point: Herat North. Latitude: 34 deg 23 min 09.08 sec N; Longitude: 64 deg 10 min 58.94 sec E (of Greenwich).","","7022","8901","1024","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-09-05","2003.362 2005.46","0 ",NULL};
datafile_rows_t datum_row_281[] = {"6256","Mahe 1971","geodetic","Fundamental point: Mahe","1971","7012","8901","1208","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_282[] = {"6257","Makassar","geodetic","Fundamental point: station P1, Moncongloe. Latitude: 5 deg 08 min 41.42 sec S; long 119 deg 24 min 14.94 sec E of Greenwich.","","7004","8901","1316","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-09-05","2003.361 2005.46","0 ",NULL};
datafile_rows_t datum_row_283[] = {"6258","European Terrestrial Reference System 1989","geodetic","Fixed to the stable part of the Eurasian continental  plate and consistent with ITRS at the epoch 1989.0.","1989","7019","8901","1298","Geodetic survey.","The distinction in usage between ETRF89 and ETRS89 is confused: although in principle conceptually different in practice both are used for the realisation.","","EPSG","2003-08-14","97.11  97.55  99.111 2000.72 2003.26","0 ",NULL};
datafile_rows_t datum_row_284[] = {"6259","Malongo 1987","geodetic","Fundamental point: Station Y at Malongo base camp. Latitude: 5 deg 23 min 30.810 sec S; Longitude: 12 deg 12 min  01.590 sec E (of Greenwich).","1987","7022","8901","3180","Oil industry offshore exploration and production from 1987.","Replaced Mhast (offshore) (code 6705) in 1987. Origin coordinates constrained to those of Mhast (offshore) but other station coordinates differ. References to \"Mhast\" since 1987 often should have stated \"Malongo 1987\".","Chevron Petroleum Technology.","EPSG","2006-01-06","2005.751","0 ",NULL};
datafile_rows_t datum_row_285[] = {"6260","Manoca","geodetic","","","7012","8901","1060","Topographic mapping.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_286[] = {"6261","Merchich","geodetic","Fundamental point: Merchich. Latitude: 33 deg 26 min 59.672 sec N; Longitude: 7deg 33 min 27.295sec W (of Greenwich).","1922","7011","8901","3280","Topographic mapping.","","","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_287[] = {"6262","Massawa","geodetic","","","7004","8901","1089","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_288[] = {"6263","Minna","geodetic","Fundamental point: Minna base station L40. Latitude: 9 deg 38 min 08.87 sec N; Longitude: 6 deg 30 min 58.76 sec E (of Greenwich).","","7012","8901","1178","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-09-05","2003.361 2005.46","0 ",NULL};
datafile_rows_t datum_row_289[] = {"6264","Mhast","geodetic","","","7022","8901","1318","Coastal hydrography.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_290[] = {"6265","Monte Mario","geodetic","Fundamental point: Monte Mario. Latitude: 41 deg 55 min 25.51 sec N; Longitude: 12 deg  27 min  08.4 sec E (of Greenwich).","1940","7022","8901","3343","Topographic mapping.","Replaced Genova datum, Bessel 1841 ellipsoid, from 1940.","","EPSG","2003-12-31","2003.36","0 ",NULL};
datafile_rows_t datum_row_291[] = {"6266","M'poraloko","geodetic","","","7011","8901","1100","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_292[] = {"6267","North American Datum 1927","geodetic","Fundamental point: Meade's Ranch. Latitude: 39 deg 13 min 26.686 sec N; Longitude: 98 deg 32 min 30.506 sec W (of Greenwich).","1927","7008","8901","1349","Topographic mapping.","Replaced by North American Datum 1983 (NAD83)","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_293[] = {"6268","NAD Michigan","geodetic","Fundamental point: Meade's Ranch. Latitude: 39 deg 13 min 26.686 sec N; Longitude: 98 deg 32 min 30.506 sec W (of Greenwich).","","7009","8901","1391","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_294[] = {"6269","North American Datum 1983","geodetic","Origin at geocentre.","1986","7019","8901","1350","Topographic mapping.","Although the 1986 adjustment included connections to Greenland and Mexico, it has not been adopted there.","","EPSG","2006-07-19","2006.464","0 ",NULL};
datafile_rows_t datum_row_295[] = {"6270","Nahrwan 1967","geodetic","Fundamental point: Nahrwan south base.  Latitude: 33 deg 19 min 10.87 sec N; Longitude: 44 deg 43 min 25.54 sec E (of Greenwich).","1967","7012","8901","1351","Topographic mapping.","In Iraq, replaces Nahrwan 1934.","","EPSG","2006-06-02","2006.34","0 ",NULL};
datafile_rows_t datum_row_296[] = {"6271","Naparima 1972","geodetic","Fundamental point: Naparima. Latitude: 10 deg 16 min 44.860 sec N; Longitude: 61 deg 27 min 34.620 sec W (of Greenwich).","1972","7022","8901","1322","Topographic mapping.","Naparima 1972 is an extension of the Naparima 1955 network of Trinidad to include Tobago.","Ordnance Survey International.","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_297[] = {"6272","New Zealand Geodetic Datum 1949","geodetic","Fundamental point: Papatahi. Latitude: 41 deg 19 min  8.900 sec S; Longitude: 175 deg  02 min 51.000 sec E (of Greenwich).","1949","7022","8901","3285","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by New Zealand Geodetic Datum 2000 (code 6167) from March 2000.","Land Information New Zealand. http://www.linz.govt.nz/rcs/linz/pub/web/root/core/SurveySystem/GeodeticInfo/GeodeticDatums/nzgd2000factsheet/index.jsp","EPSG","2004-03-26","2000.702 2004.11","0 ",NULL};
datafile_rows_t datum_row_298[] = {"6273","NGO 1948","geodetic","Fundamental point: Oslo observatory. Latitude: 59 deg 54 min 43.7 sec N; Longitude: 10 deg 43 min 22.5 sec E (of Greenwich).","1948","7005","8901","1352","Geodetic survey, cadastre, topographic mapping, engineering survey.","","EuroGeographics; http://crs.bkg.bund.de/crs-eu/","EPSG","2004-01-05","2003.362","0 ",NULL};
datafile_rows_t datum_row_299[] = {"6274","Datum 73","geodetic","Fundamental point:  TF4, Melrica. Latitude: 39 deg 41 min 37.30 sec N; Longitude: 8 deg 07 min 53.31 sec W (of Greenwich).","1964","7022","8901","1294","Topographic mapping.","","Instituto Geografico e Cadastral; Lisbon","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_300[] = {"6275","Nouvelle Triangulation Francaise","geodetic","Fundamental point: Pantheon. Latitude: 48 deg 50 min 46.522 sec N; Longitude: 2 deg 20 min 48.667 sec E (of Greenwich).","1895","7011","8901","1326","Topographic mapping.","","","EPSG","2004-01-07","2003.361","0 ",NULL};
datafile_rows_t datum_row_301[] = {"6276","NSWC 9Z-2","geodetic","","","7025","8901","1262","Satellite navigation.","Transit precise ephemeris before 1991.","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_302[] = {"6277","OSGB 1936","geodetic","Fundamental point: Pre 2002: Herstmonceux, Latitude: 50 deg 51 min 55.271 sec N; Longitude: 0 deg 20 min 45.882 sec E (of Greenwich). From April 2002 the datum is defined through the application of the OSTN02 transformation (tfm code 1039) to ETRS89.","1936","7001","8901","1264","Topographic mapping.Topographic mapping.Topographic mapping.Topographic mapping.","","Ordnance Survey of Great Britain","EPSG","2002-09-19","2002.62","0 ",NULL};
datafile_rows_t datum_row_303[] = {"6278","OSGB 1970 (SN)","geodetic","Fundamental point: Herstmonceux. Latitude: 50 deg 51 min 55.271 sec N; Longitude: 0 deg 20 min 45.882 sec E (of Greenwich).","1970","7001","8901","1264","Scientific network.","","","EPSG","2006-01-16","2005.88","0 ",NULL};
datafile_rows_t datum_row_304[] = {"6279","OS (SN) 1980","geodetic","Fundamental point: Herstmonceux. Latitude: 50 deg 51 min 55.271 sec N; Longitude: 0 deg 20 min 45.882 sec E (of Greenwich).","1980","7001","8901","1354","Scientific network.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_305[] = {"6280","Padang 1884","geodetic","Fundamental point: Padang","1884","7004","8901","1355","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_306[] = {"6281","Palestine 1923","geodetic","Fundamental point: Point 82'M  Jerusalem. Latitude: 31 deg 44 min  2.749 sec N; Longitude: 35 deg 12 min 43.490 sec E (of Greenwich).","1923","7010","8901","1356","Topographic mapping.","","","EPSG","2004-04-14","2004.15","0 ",NULL};
datafile_rows_t datum_row_307[] = {"6282","Congo 1960 Pointe Noire","geodetic","Fundamental point: Point Noire Astro. Latitude: 4 deg 47 min 00.10 sec S; Longitude: 11 deg 51 min 01.55 sec E (of Greenwich).","1960","7011","8901","1072","Topographic mapping.","","Elf","EPSG","2003-12-31","2002.05 2003.361","0 ",NULL};
datafile_rows_t datum_row_308[] = {"6283","Geocentric Datum of Australia 1994","geodetic","ITRF92 at epoch 1994.0","1994","7019","8901","2575","Topographic mapping, geodetic survey.","Coincident with WGS84 to within 1 metre.","Australian Surveying and Land Information Group Internet WWW page. http://www.auslig.gov.au/geodesy/datums/gda.htm#specs","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_309[] = {"6284","Pulkovo 1942","geodetic","Fundamental point: Pulkovo observatory. Latitude: 59 deg 46 min 18.550 sec N; Longitude: 30 deg 19 min 42.090 sec E (of Greenwich).","1942","7024","8901","1357","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_310[] = {"6285","Qatar 1974","geodetic","Fundamental point: Station G3","1974","7022","8901","1346","Topographic mapping.","","","EPSG","2001-08-28","2001.27","0 ",NULL};
datafile_rows_t datum_row_311[] = {"6286","Qatar 1948","geodetic","Fundamental point: Sokey 0 M. Latitude: 25 deg 22 min 56.500 sec N; Longitude: 50 deg 45 min 41.000 sec E (of Greenwich).","1948","7020","8901","1346","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_312[] = {"6287","Qornoq","geodetic","","1927","7022","8901","1107","Topographic mapping.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_313[] = {"6288","Loma Quintana","geodetic","Fundamental point: Loma Quintana","","7022","8901","1313","Topographic mapping.","Replaced by La Canoa (code 6247).","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_314[] = {"6289","Amersfoort","geodetic","Fundamental point: Amersfoort. Latitude: 52 deg 09 min 22.178 sec N; Longitude: 5 deg 23 min 15.478 sec E (of Greenwich).","","7004","8901","1275","Geodetic survey, cadastre, topographic mapping, engineering survey.","","http://www.rdnap.nl/","EPSG","2005-09-29","2000.56 2003.361 2005.46","0 ",NULL};
datafile_rows_t datum_row_315[] = {"6291","South American Datum 1969","geodetic","","1969","7036","8901","1358","Topographic mapping.","SAD69 uses GRS67 ellipsoid with 1/f to exactly 2 decimal places.  Precision of ellipsoid entry increased from 2 to 5 dp with change id 97.252.  Error introduced if not using the truncated precision is 0 to 31mm.","","EPSG","1996-10-18","96.09  97.252","1 ",NULL};
datafile_rows_t datum_row_316[] = {"6292","Sapper Hill 1943","geodetic","","1943","7022","8901","3247","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_317[] = {"6293","Schwarzeck","geodetic","Fundamental point: Schwarzeck. Latitude: 22 deg 45 min 35.820 sec S; Longitude: 18 deg 40 min 34.549 sec E of Greenwich. Fixed during German South West Africa-British Bechuanaland boundary survey of 1898-1903.","","7046","8901","1169","Topographic mapping.","","Private Communication, Directorate of Surveys and Land Information, Cape Town.","EPSG","2004-04-09","2001.15 2003.362","0 ",NULL};
datafile_rows_t datum_row_318[] = {"6294","Segora","geodetic","","","7004","8901","1359","Topographic mapping.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_319[] = {"6295","Serindung","geodetic","Fundamental point: Ep A. Latitude: 1 deg 06 min 10.60 sec N; Longitude: 105 deg 00 min 59.82 sec E (of Greenwich).","","7004","8901","1360","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-09-05","2003.362 2005.46","0 ",NULL};
datafile_rows_t datum_row_320[] = {"6296","Sudan","geodetic","","","7011","8901","1361","Topographic mapping.","","","EPSG","1995-06-02","","1 ",NULL};
datafile_rows_t datum_row_321[] = {"6297","Tananarive 1925","geodetic","Fundamental point: Tananarive observatory. Latitude: 18 deg 55 min 02.10 sec S; Longitude: 47 deg 33 min 06.75 sec E (of Greenwich).","2025","7022","8901","3273","Topographic mapping.","","IGN Paris","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_322[] = {"6298","Timbalai 1948","geodetic","Fundamental point: Station P85 at Timbalai. Latitude: 5 deg 17 min  3.548 sec N; Longitude: 115 deg 10 min 56.409 sec E (of Greenwich).","1948","7016","8901","1362","Topographic mapping.","In 1968, the original adjustment was densified in Sarawak and extended to Sabah.","Defence Geographic Centre.","EPSG","2006-07-24","2006.252","0 ",NULL};
datafile_rows_t datum_row_323[] = {"6299","TM65","geodetic","Adjusted to best mean fit 12 stations of the OSNI 1952 primary adjustment.","1965","7002","8901","1305","Topographic mapping.","Differences between OSNI 1952 and TM65 at these stations are RMS 0.25m east, 0.23m north, maximum vector 0.57m. TM65 replaced by and not to be confused with Geodetic Datum of 1965 alias 1975 Mapping Adjustment or TM75 (datum code 6300).","\"The Irish Grid - A Description of the Co-ordinate Reference System\" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.","EPSG","2003-06-27","2002.621","0 ",NULL};
datafile_rows_t datum_row_324[] = {"6300","Geodetic Datum of 1965","geodetic","Adjusted to best mean fit 9 stations of the OSNI 1952 primary adjustment in Northern Ireland plus the 1965 values of 3 stations in the Republic of Ireland.","1975","7002","8901","1305","Geodetic survey, topographic mapping and engineering survey.","Differences from the 1965 adjustment (datum code 6299) are: average difference in Eastings 0.092m; average difference in Northings 0.108m; maximum vector difference 0.548m.","\"The Irish Grid - A Description of the Co-ordinate Reference System\" published by Ordnance Survey of Ireland, Dublin and Ordnance Survey of Northern Ireland, Belfast.","EPSG","2003-06-27","2002.621","0 ",NULL};
datafile_rows_t datum_row_325[] = {"6301","Tokyo","geodetic","Fundamental point: Nikon-Keido-Genten. Latitude: 35 deg 39 min 17.5148 sec N; Longitude: 139 deg 44 min 40.5020 sec E (of Greenwich).","","7004","8901","1364","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by Japanese Geodetic Datum 2000 (code 6611).","Geographic Survey Institute; Japan; Bulletin 40 (March 1994).  Also http://vldb.gsi.go.jp/sokuchi/datum/tokyodatum.html","EPSG","2002-06-22","98.46  2002.08","0 ",NULL};
datafile_rows_t datum_row_326[] = {"6302","Trinidad 1903","geodetic","Station 00, Harbour Master's Flagstaff, Port of Spain.  Trinidad 1903 / Trinidad Grid coordinates (Clarke's links): 333604.30 E, 436366.91 N (Latitude: 10 deg 38 min 39.01 sec N,  Longitude: 61 deg 30 min 38.00 sec W of Greenwich)","1903","7007","8901","1339","Topographic mapping.","","\"Land Surveyor's Handbook\", 1935, published under the direction of JW MacGillivray, Surveyor General, Land & Survey's Department, Trinidad & Tobago.","EPSG","2004-03-01","2003.362  2004.13","0 ",NULL};
datafile_rows_t datum_row_327[] = {"6303","Trucial Coast 1948","geodetic","Fundamental point: TC1. Latitude: 25 deg 23 min 50.190 sec N; Longitude: 55 deg 26 min 43.950 sec E (of Greenwich).","1948","7020","8901","1363","Oil industry mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_328[] = {"6304","Voirol 1875","geodetic","Fundamental point: Voirol. Latitude: 36 deg 45 min 07.927 sec N; Longitude: 3 deg 02 min 49.435 sec E of Greenwich. Uses RGS (and old IGN) value of 2 deg 20 min 13.95 sec for Greenwich-Paris meridian difference.","1875","7011","8901","1365","Topographic mapping.","Replaced by Voirol 1879 (code 6671).","IGN Paris","EPSG","2004-01-07","2003.361","0 ",NULL};
datafile_rows_t datum_row_329[] = {"6306","Bern 1938","geodetic","Fundamental point: Old Bern observatory. Latitude: 46 deg 57 min  7.890 sec N; Longitude: 7 deg 26 min 22.335 sec E (of Greenwich).","1938","7004","8901","1286","Topographic mapping.","This redetermination of the coordinates of fundamental point is used for scientific purposes and as the graticule overprinted on topographic maps constructed on the CH1903 / LV03 projected CS (code 21781).","\"Die Projektionen der schweizerischen Plan- und Kartenwerke\"; J. Bolliger 1967","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_330[] = {"6307","Nord Sahara 1959","geodetic","Coordinates of primary network readjusted on ED50 datum and then transformed conformally to Clarke 1880 (RGS) ellipsoid.","1959","7012","8901","1365","Topographic mapping.","Sometimes incorrectly referred to as Voirol Unifie 1960. Voirol Unifie 1960 is NOT a datum:  it is two projected coordinate systems based on  Nord Sahara 1959.  See coordinate system codes 30791 and 30792.","\"Le System Geodesique Nord-Sahara\"; IGN Paris","EPSG","2006-01-16","99.62 2003.361 2005.88","0 ",NULL};
datafile_rows_t datum_row_331[] = {"6308","Stockholm 1938","geodetic","Fundamental point: Stockholm observatory","1938","7004","8901","3313","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RT90 adjustment (datum code 6124)","","EPSG","1996-04-12","","0 ",NULL};
datafile_rows_t datum_row_332[] = {"6309","Yacare","geodetic","Fundamental point: Yacare. Latitude: 30 deg 35 min 53.68 sec S; Longitude: 57 deg 25 min 01.30 sec W of Greenwich.","","7022","8901","1247","Topographic mapping.","","NIMA http://earth-info.nima.mil/","EPSG","2005-09-05","2003.362 2005.46","0 ",NULL};
datafile_rows_t datum_row_333[] = {"6310","Yoff","geodetic","Fundamental point: Yoff. Latitude: 14 deg 44 min 41.62 sec N; Longitude: 17 deg 29 min 07.02 sec W of Greenwich.","","7011","8901","1207","Topographic mapping.","","","EPSG","2003-12-31","2003.362","0 ",NULL};
datafile_rows_t datum_row_334[] = {"6311","Zanderij","geodetic","","","7022","8901","1222","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_335[] = {"6312","Militar-Geographische Institut","geodetic","Fundamental point: Hermannskogel. Latitude: 48 deg 16 min 15.29 sec N; Longitude: 16 deg 17 min 41.06 sec E (of Greenwich).","1901","7004","8901","1321","Topographic mapping.","Croatia is planning to define a new modern datum to replace HR1901 (info from EuroGeographics; http://crs.ifag.de/).","Bundesamt fur Eich- und Vermessungswesen; Wien","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_336[] = {"6313","Reseau National Belge 1972","geodetic","Fundamental point: Uccle observatory. Latitude: 50 deg 47 min 57.704 sec N; Longitude: 4 deg 21 min 24.983 sec E (of Greenwich).","1972","7022","8901","1347","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_337[] = {"6314","Deutsches Hauptdreiecksnetz","geodetic","Fundamental point: Rauenberg. Latitude: 52 deg 27 min 12.021 sec N; Longitude: 13 deg 22 min 04.928 sec E (of Greenwich).  This station was destroyed in 1910 and the station at Potsdam substituted as the fundamental point.","","7004","8901","2326","Geodetic survey, cadastre, topographic mapping, engineering survey.","","BKG via EuroGeographics. http://crs.bkg.bund.de","EPSG","2006-06-12","2001.511 2006.41","0 ",NULL};
datafile_rows_t datum_row_338[] = {"6315","Conakry 1905","geodetic","Fundamental point: Conakry. Latitude: 10.573766g N; Longitude: 17.833682g W (of Paris).","1905","7011","8901","3257","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_339[] = {"6316","Dealul Piscului 1933","geodetic","Fundamental point: latitude 44 deg 24 min 33.9606 sec N; longitude 26 deg 06 min 44.8772 sec E (of Greenwich).","1933","7022","8901","3295","Topographic mapping.","Replaced by 1970 adjustment (datum code 6317)","Institute for Geodesy Photogrametry and Land Management","EPSG","1996-04-12","","0 ",NULL};
datafile_rows_t datum_row_340[] = {"6317","Dealul Piscului 1970","geodetic","Fundamental point: latitude 44 deg 24 min 23.7709 sec N; longitude 26deg 06 min 44.1265 sec E (of Greenwich).","1970","7024","8901","1197","Topographic mapping.","Replaces 1933 adjustment (datum code 6316)","Institute for Geodesy Photogrametry and Land Management","EPSG","1996-04-12","","0 ",NULL};
datafile_rows_t datum_row_341[] = {"6318","National Geodetic Network","geodetic","","1993","7030","8901","3267","Geodetic survey.","Replaces 1984 adjustment which used the WGS72 ellipsoid.","","EPSG","2004-06-16","2004.41","0 ",NULL};
datafile_rows_t datum_row_342[] = {"6319","Kuwait Utility","geodetic","","","7019","8901","1310","Cadastre, engineering survey.","","","EPSG","1996-04-12","","0 ",NULL};
datafile_rows_t datum_row_343[] = {"6322","World Geodetic System 1972","geodetic","Developed from a worldwide distribution of terrestrial and geodetic satellite observations and defined through a set of station coordinates.","1972","7043","8901","1262","Satellite navigation.","Used by GPS before 1987. For Transit satellite positioning see also WGS 72BE.","NIMA http://earth-info.nima.mil/","EPSG","2006-08-24","99.03 2003.362 2005.46 2006.82","0 ",NULL};
datafile_rows_t datum_row_344[] = {"6324","WGS 72 Transit Broadcast Ephemeris","geodetic","","1972","7043","8901","1262","Satellite navigation.","Alleged datum for use with Transit broadcast ephemeris prior to 1989. Relationship to WGS 72 has changed over time.","","EPSG","2006-08-24","99.03 2006.82","0 ",NULL};
datafile_rows_t datum_row_345[] = {"6326","World Geodetic System 1984","geodetic","Defined through a consistent set of station coordinates. These have changed with time: by 0.7m on 29/6/1994 [WGS 84 (G730)], a further 0.2m on 29/1/1997 [WGS 84 (G873)] and a further 0.06m on 20/1/2002 [WGS 84 (G1150)].","1984","7030","8901","1262","Satellite navigation.","EPSG's WGS 84 datum has been the then current realisation. No distinction is made between the original WGS 84 frame, WGS 84 (G730), WGS 84 (G873) and WGS 84 (G1150). Since 1997, WGS 84 has been maintained within 10cm of the then current ITRF.","NIMA TR8350.2 June 2004 revision. http://earth-info.nga.mil/GandG/publications/tr8350.2/tr8350_2.html and  http://gis-lab.info/docs/nima-tr8350.2-addendum.pdf","EPSG","2006-08-25","2002.151 2002.89 2003.27 2005.46 2005.55 2006.81","0 ",NULL};
datafile_rows_t datum_row_346[] = {"6600","Anguilla 1957","geodetic","Fundamental point: station A4, Police.","1957","7012","8901","3214","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_347[] = {"6601","Antigua 1943","geodetic","Fundamental point: station A14.","1943","7012","8901","1273","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_348[] = {"6602","Dominica 1945","geodetic","Fundamental point: station M12.","1945","7012","8901","3239","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_349[] = {"6603","Grenada 1953","geodetic","Fundamental point: station GS8, Sante Marie.","1953","7012","8901","1551","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","2006-02-09","2006.03","0 ",NULL};
datafile_rows_t datum_row_350[] = {"6604","Montserrat 1958","geodetic","Fundamental point: station M36.","1958","7012","8901","3279","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_351[] = {"6605","St. Kitts 1955","geodetic","Fundamental point: station K12.","1955","7012","8901","3297","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_352[] = {"6606","St. Lucia 1955","geodetic","Fundamental point: station DCS3.","1955","7012","8901","3298","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","1999-04-22","","0 ",NULL};
datafile_rows_t datum_row_353[] = {"6607","St. Vincent 1945","geodetic","Fundamental point: station V1, Fort Charlotte.","1945","7012","8901","3300","Topographic mapping.","","Ordnance Survey of Great Britain.","EPSG","2006-02-09","2006.03","0 ",NULL};
datafile_rows_t datum_row_354[] = {"6608","North American Datum 1927 (1976)","geodetic","Fundamental point: Meade's Ranch. Latitude: 39 deg 13 min 26.686 sec N; Longitude: 98 deg 32 min 30.506 sec W (of Greenwich).","1976","7008","8901","1367","Geodetic survey, cadastre, topographic mapping, engineering survey.","NAD27(76) used in Ontario for all maps at scale 1/20 000 and larger; elsewhere in Canada for selected purposes.","Geodetic Survey of Canada.","EPSG","1999-05-12","","0 ",NULL};
datafile_rows_t datum_row_355[] = {"6609","North American Datum 1927 (CGQ77)","geodetic","Fundamental point: Meade's Ranch. Latitude: 39 deg 13 min 26.686 sec N; Longitude: 98 deg 32 min 30.506 sec W (of Greenwich).","1977","7008","8901","1368","Geodetic survey, cadastre, topographic mapping, engineering survey.","NAD27 (CGQ77) used in Quebec for all maps at scale 1/20 000 and larger; generally for maps issued by the Quebec cartography office whose reference system is CGQ77.","Geodetic Service of Quebec.  Contact alain.bernard@mrn.gouv.qc.ca","EPSG","1999-05-12","","0 ",NULL};
datafile_rows_t datum_row_356[] = {"6610","Xian 1980","geodetic","","1980","7049","8901","3228","Geodetic survey, topographic and engineering survey.","","BP","EPSG","2002-02-12","","0 ",NULL};
datafile_rows_t datum_row_357[] = {"6611","Hong Kong 1980","geodetic","Fundamental point: Trig \"Zero\", 38.4 feet south along the transit circle of the Kowloon Observatory. Latitude 22deg 18min 12.82sec North, longitude 114deg 10min 18.75sec East.","1980","7022","8901","1118","Geodetic survey, topgraphic and engineering survey, cadastre.","Replaces Hong Kong 1963 and Hong Kong 1963(67).","Survey and Mapping Office, Lands Department. http://www.info.gov.hk/landsd/mapping/tindex.htm","EPSG","2006-02-06","2005.26","0 ",NULL};
datafile_rows_t datum_row_358[] = {"6612","Japanese Geodetic Datum 2000","geodetic","ITRF94 at epoch 1997.0","2000","7019","8901","1129","Geodetic survey, topographic and engineering survey.","Instigated under amendment to the Japanese Surveying Law with effect from April 2002. Replaces Tokyo datum (code 6301).","Japanese Survey Federation and Geographical Survey Institute http://www.gsi.go.jp/ENGLISH/RESEARCH/BULLETIN/vol-45/45abst1.htm","EPSG","2002-06-22","","0 ",NULL};
datafile_rows_t datum_row_359[] = {"6613","Gunung Segara","geodetic","Station P5 (Gunung Segara). Latitude 0deg 32min 12.83sec S, longitude  117deg 08min 48.47sec E (of Greenwich).","","7004","8901","1360","Topographic mapping.","","TotalFinaElf.","EPSG","2002-06-22","","0 ",NULL};
datafile_rows_t datum_row_360[] = {"6614","Qatar National Datum 1995","geodetic","Defined by transformation from WGS 84 - see coordinate operation code 1840.","1995","7022","8901","1346","Topographic mapping.","","Qatar Centre for Geographic Information.","EPSG","2002-06-28","","0 ",NULL};
datafile_rows_t datum_row_361[] = {"6615","Porto Santo 1936","geodetic","SE Base on Porto Santo island.","1936","7022","8901","1314","Topographic mapping.","Replaced by 1995 adjustment (datum code 6663). For Selvagens see Selvagem Grande (code 6616).","Instituto Geografico e Cadastral Lisbon http://www.igeo.pt","EPSG","2003-08-14","2003.231 2003.232","0 ",NULL};
datafile_rows_t datum_row_362[] = {"6616","Selvagem Grande","geodetic","","","7022","8901","2779","Topographic mapping.","","Instituto Geografico e Cadastral Lisbon http://www.igeo.pt","EPSG","2003-08-14","2003.232","0 ",NULL};
datafile_rows_t datum_row_363[] = {"6618","South American Datum 1969","geodetic","Fundamental point: Chua. Geodetic latitude: 19 deg 45 min 41.6527 sec S; geodetic longitude: 48 deg 06 min 04.0639 sec W (of Greenwich). (Astronomic coordinates: Latitude 19 deg 45 min 41.34 +/- 0.05 sec S; Longitude 48 deg 06 min 07.80 +/- 0.08 sec W).","1969","7050","8901","1358","Topographic mapping.","SAD69 uses GRS 1967 ellipsoid but with 1/f to exactly 2 decimal places.","DMA 1974.","EPSG","2004-01-09","2003.362","0 ",NULL};
datafile_rows_t datum_row_364[] = {"6619","SWEREF99","geodetic","Densification of ETRS89.","1982","7019","8901","1225","Geodetic survey, cadastre, topographic mapping, engineering survey.","","National Land Survey of Sweden http://www.lantmateriet.se","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_365[] = {"6620","Point 58","geodetic","Fundamental point: Point 58. Latitude: 3 deg 58 min 37.040 sec N; Longitude: 12 deg 52 min 44.045 sec E (of Greenwich).","1969","7012","8901","2790","Geodetic survey","Used as the basis for computation of the 12th Parallel traverse conducted 1966-70 from Senegal to Chad and connecting to the Adindan triangulation in Sudan.","IGN Paris.","EPSG","2002-09-19","","0 ",NULL};
datafile_rows_t datum_row_366[] = {"6621","Fort Marigot","geodetic","","","7022","8901","2828","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RRAF 1991 (datum code 6640).","IGN Paris.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_367[] = {"6622","Guadeloupe 1948","geodetic","","1948","7022","8901","2829","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RRAF 1991 (datum code 6640).","IGN Paris.","EPSG","2004-10-14","2004.561","0 ",NULL};
datafile_rows_t datum_row_368[] = {"6623","Centre Spatial Guyanais 1967","geodetic","Fundamental point: Kourou-Diane. Latitude: 5 deg 15 min 53.699 sec N; Longitude: 52 deg 48 min 09.149 sec W (of Greenwich).","1967","7022","8901","3105","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RGFG95 (code 6624).","IGN Paris.","EPSG","2005-04-24","2004.562","0 ",NULL};
datafile_rows_t datum_row_369[] = {"6624","Reseau Geodesique Francais Guyane 1995","geodetic","ITRF93 at epoch 1995.0","1995","7019","8901","1097","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces CSG67 (datum code 6623).","IGN Paris.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_370[] = {"6625","Martinique 1938","geodetic","Fundamental point: Fort Desaix. Latitude: 14 deg 36 min 54.090 sec N; Longitude: 61 deg 04 min 04.030 sec W (of Greenwich).","1938","7022","8901","3276","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RRAF 1991 (datum code 6640).","IGN Paris.","EPSG","2004-10-14","2004.561","0 ",NULL};
datafile_rows_t datum_row_371[] = {"6626","Reunion 1947","geodetic","Fundamental point: Piton des Neiges (Borne). Latitude: 21 deg 05 min 13.119 sec S; Longitude: 55 deg 29 min 09.193 sec E (of Greenwich).","1947","7022","8901","3337","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RGR92 (datum code 6627).","IGN Paris.","EPSG","2004-10-14","2004.561","0 ",NULL};
datafile_rows_t datum_row_372[] = {"6627","Reseau Geodesique de la Reunion 1992","geodetic","ITRF91 at epoch 1993.0","1992","7019","8901","1196","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces Piton des Neiges (code 6626).","IGN Paris.","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_373[] = {"6628","Tahiti 52","geodetic","Fundamental point: Tahiti North Base. Latitude: 17 deg 38 min 10.0 sec S; Longitude: 149 deg 36 min 57.8 sec W (of Greenwich).","1952","7022","8901","2811","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by Tahiti 79 (datum code 6690) in Tahiti and Moorea 87 (code 6691) in Moorea.","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2002-11-29","2005.38","0 ",NULL};
datafile_rows_t datum_row_374[] = {"6629","Tahaa 54","geodetic","Fundamental point: Tahaa East Base. Latitude: 16 deg 33 min 20.97 sec S; Longitude: 151 deg 29 min 06.25 sec W (of Greenwich).","1954","7022","8901","2812","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RGPF (datum code 6687).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","2005.38","0 ",NULL};
datafile_rows_t datum_row_375[] = {"6630","IGN72 Nuku Hiva","geodetic","Fundamental point: Taiohae. Latitude: 8 deg 55 min 03.97 sec S; Longitude: 140 deg 05 min 36.24 sec W (of Greenwich).","1972","7022","8901","3129","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RGPF (datum code 6687).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","2005.38","0 ",NULL};
datafile_rows_t datum_row_376[] = {"6631","K0 1949","geodetic","","1949","7022","8901","2816","Geodetic survey, cadastre, topographic mapping, engineering survey.","","IGN Paris.","EPSG","2002-11-29","","1 ",NULL};
datafile_rows_t datum_row_377[] = {"6632","Combani 1950","geodetic","","1950","7022","8901","3340","Geodetic survey, cadastre, topographic mapping, engineering survey.","","IGN Paris.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_378[] = {"6633","IGN56 Lifou","geodetic","South end of the Goume base.","1956","7022","8901","2814","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie, Direction des Infrastructures, de la Topografie et des Transports Terrestres. www.dittt.gouv.nc","EPSG","2006-07-21","2006.62","0 ",NULL};
datafile_rows_t datum_row_379[] = {"6634","IGN72 Grande Terre","geodetic","North end of Gomen base.","1972","7022","8901","2822","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie, Direction des Infrastructures, de la Topografie et des Transports Terrestres. www.dittt.gouv.nc","EPSG","2006-07-21","2006.62","0 ",NULL};
datafile_rows_t datum_row_380[] = {"6635","ST87 Ouvea","geodetic","","1987","7022","8901","2813","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie.","EPSG","2002-11-29","","1 ",NULL};
datafile_rows_t datum_row_381[] = {"6636","Petrels 1972","geodetic","Fundamental point: Astro station DZ on Ile de Petrels. Latitude: 66 deg 40 min 00 sec S; Longitude: 140 deg 00 min 46 sec E (of Greenwich).","1972","7022","8901","2817","Geodetic survey,  topographic mapping.","","IGN Paris.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_382[] = {"6637","Pointe Geologie Perroud 1950","geodetic","Fundamental point: Astro station G.0 on Pointe Geologie. Latitude: 66 deg 39 min 30 sec S; Longitude: 140 deg 01 min 00 sec E (of Greenwich).","1950","7022","8901","2818","Geodetic survey,  topographic mapping.","","IGN Paris.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_383[] = {"6638","Saint Pierre et Miquelon 1950","geodetic","","1950","7008","8901","1220","Geodetic survey, cadastre, topographic mapping, engineering survey.","","IGN Paris.","EPSG","2006-02-03","2006.06","0 ",NULL};
datafile_rows_t datum_row_384[] = {"6639","MOP78","geodetic","","1978","7022","8901","2815","Geodetic survey, cadastre, topographic mapping, engineering survey.","","IGN Paris.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_385[] = {"6640","Reseau de Reference des Antilles Francaises 1991","geodetic","WGS 84 coordinates of a single station determined during the 1988 Tango mission.","1991","7030","8901","2824","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces Fort Marigot and Sainte Anne (datum codes 6621-22) in Guadeloupe and Fort Desaix (datum code 6625) in Martinique.","IGN Paris.","EPSG","2004-03-26","2004.20","0 ",NULL};
datafile_rows_t datum_row_386[] = {"6641","IGN53 Mare","geodetic","South-east end of the La Roche base.","1953","7022","8901","2819","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie, Direction des Infrastructures, de la Topografie et des Transports Terrestres. www.dittt.gouv.nc","EPSG","2006-07-21","2006.62","0 ",NULL};
datafile_rows_t datum_row_387[] = {"6642","ST84 Ile des Pins","geodetic","Pic Nga","1984","7022","8901","2820","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie, Direction des Infrastructures, de la Topografie et des Transports Terrestres. www.dittt.gouv.nc","EPSG","2006-07-21","2006.62","0 ",NULL};
datafile_rows_t datum_row_388[] = {"6643","ST71 Belep","geodetic","","1971","7022","8901","2821","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_389[] = {"6644","NEA74 Noumea","geodetic","Noumea old signal station.","1974","7022","8901","2823","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie, Direction des Infrastructures, de la Topografie et des Transports Terrestres. www.dittt.gouv.nc","EPSG","2006-07-21","2006.62","0 ",NULL};
datafile_rows_t datum_row_390[] = {"6645","Reseau Geodesique Nouvelle Caledonie 1991","geodetic","ITRF90 at epoch 1989.0","1989","7022","8901","1174","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie.","EPSG","2002-11-29","","1 ",NULL};
datafile_rows_t datum_row_391[] = {"6646","Grand Comoros","geodetic","Fundamental point: M'Tsaoueni.  Latitude: 11 deg 28 min 32.200 sec S; Longitude: 43 deg 15 min 42.315 sec E (of Greenwich).","","7022","8901","2807","Geodetic survey, cadastre, topographic mapping, engineering survey.","","IGN Paris.","EPSG","2002-11-29","","0 ",NULL};
datafile_rows_t datum_row_392[] = {"6647","International Terrestrial Reference Frame 1988","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1988","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1988.0. Replaced by ITRF89 (code 6648).","International Earth Rotation Service (IERS) Annual Report for 1988. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_393[] = {"6648","International Terrestrial Reference Frame 1989","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1989","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1989.0. Replaces ITRF88 (code 6647). Replaced by ITRF90 (code 6649).","International Earth Rotation Service (IERS) Technical Note No. 6. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_394[] = {"6649","International Terrestrial Reference Frame 1990","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1990","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1990.0. Replaces ITRF89 (code 6648). Replaced by ITRF91 (code 6650).","International Earth Rotation Service (IERS) Technical Note No. 9. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_395[] = {"6650","International Terrestrial Reference Frame 1991","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1991","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1991.0. Replaces ITRF90 (code 6649). Replaced by ITRF92 (code 6651).","International Earth Rotation Service (IERS) Technical Note No. 12. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_396[] = {"6651","International Terrestrial Reference Frame 1992","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1992","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1992.0. Replaces ITRF91 (code 6650). Replaced by ITRF93 (code 6652).","International Earth Rotation Service (IERS) Technical Note No. 15. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_397[] = {"6652","International Terrestrial Reference Frame 1993","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1993","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1993.0. Replaces ITRF92 (code 6651). Replaced by ITRF94 (code 6653).","International Earth Rotation Service (IERS) Technical Note No. 18. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_398[] = {"6653","International Terrestrial Reference Frame 1994","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1994","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1994.0. Replaces ITRF93 (code 6652). Replaced by ITRF96 (code 6654).","International Earth Rotation Service (IERS) Technical Note No. 20. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_399[] = {"6654","International Terrestrial Reference Frame 1996","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1996","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1996.0. Replaces ITRF94 (code 6653). Replaced by ITRF97 (code 6655).","International Earth Rotation Service (IERS) Technical Note No. 24. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_400[] = {"6655","International Terrestrial Reference Frame 1997","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","1997","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 1997.0. Replaces ITRF96 (code 6654). Replaced by ITRF2000 (code 6656).","International Earth Rotation Service (IERS) Technical Note No. 27. Also IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_401[] = {"6656","International Terrestrial Reference Frame 2000","geodetic","Origin at geocentre, orientated to the BIH Terrestrial System at epoch 1984.0. Datum defined by a set of 3-dimensional Cartesian station coordinates (SCS).","2000","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 2000.0. Replaces ITRF97 (code 6655). Replaced by ITRF2005 (code 6758).","IGN Paris http://lareg.ensg.ign.fr/ITRF","EPSG","2006-10-13","2006.77 2006.892","0 ",NULL};
datafile_rows_t datum_row_402[] = {"6657","Reykjavik 1900","geodetic","Fundamental point:  Latitude: 64 deg 08 min 31.88 sec N; Longitude: 21 deg 55 min 51.15 sec W (of Greenwich).","1900","7051","8901","3262","Medium scale topographic mapping.","","Landmaelingar Islands (National Survey of Iceland).","EPSG","2003-06-27","","0 ",NULL};
datafile_rows_t datum_row_403[] = {"6658","Hjorsey 1955","geodetic","Fundamental point:  Latitude: 64 deg 31 min 29.26 sec N; Longitude: 22 deg 22 min 05.84 sec W (of Greenwich).","1955","7022","8901","3262","1/50,000 scale topographic mapping.","","Landmaelingar Islands (National Survey of Iceland).","EPSG","2003-06-27","","0 ",NULL};
datafile_rows_t datum_row_404[] = {"6659","Islands Network 1993","geodetic","ITRF93 at epoch 1993.6.","1996","7019","8901","1120","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Landmaelingar Islands (National Survey of Iceland).","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_405[] = {"6660","Helle 1954","geodetic","","1954","7022","8901","2869","Geodetic survey, topographic mapping..","","Statens kartverk.","EPSG","2003-06-27","","0 ",NULL};
datafile_rows_t datum_row_406[] = {"6661","Latvia 1992","geodetic","Constrained to 4 ETRS89 points in Latvia from the EUREF Baltic 1992 campaign.","1992","7019","8901","1139","Topographic mapping, geodetic survey.","Densification of ETRS89 during the 1992 Baltic campaign.","Latvijas Republikas Valsts zemes dienests (State Land Service of the Republic of Latvia) via EuroGeographics. http://crs.bkg.bund.de/crs-eu/","EPSG","2003-06-27","","0 ",NULL};
datafile_rows_t datum_row_407[] = {"6663","Porto Santo 1995","geodetic","SE Base on Porto Santo island. Origin and orientation constrained to those of the 1936 adjustment.","1995","7022","8901","1314","Topographic mapping.","Classical and GPS observations. Replaces 1936 adjustment (datum code 6615).  For Selvagens see Selvagem Grande (datum code 6616).","Instituto Geografico e Cadastral Lisbon; http://www.igeo.pt/","EPSG","2005-09-06","2005.46","0 ",NULL};
datafile_rows_t datum_row_408[] = {"6664","Azores Oriental Islands 1995","geodetic","Fundamental point: Forte de São Bras. Origin and orientation constrained to those of the 1940 adjustment.","1940","7022","8901","1345","Topographic mapping.","Classical and GPS observations. Replaces 1940 adjustment (datum code 6184).","Instituto Geografico e Cadastral Lisbon; http://www.igeo.pt/","EPSG","2005-09-06","2005.46","0 ",NULL};
datafile_rows_t datum_row_409[] = {"6665","Azores Central Islands 1995","geodetic","Fundamental point: Graciosa south west base. Origin and orientation constrained to those of the 1948 adjustment.","1948","7022","8901","1301","Topographic mapping.","Classical and GPS observations. Replaces 1948 adjustment (datum code 6183).","Instituto Geografico e Cadastral Lisbon; http://www.igeo.pt/","EPSG","2005-09-06","2005.46","0 ",NULL};
datafile_rows_t datum_row_410[] = {"6666","Lisbon 1890","geodetic","Fundamental point: Castelo Sao Jorge; Lisbon. Latitude: 38 deg 42 min 43.631 sec N; Longitude: 9 deg 07 min 54.862 sec W of Greenwich.","1937","7004","8901","1294","Topographic mapping.","Replaced by Lisbon 1937 adjustment (which uses International 1924 ellipsoid).","Instituto Geografico e Cadastral Lisbon http://www.igeo.pt","EPSG","2003-12-18","2003.361","0 ",NULL};
datafile_rows_t datum_row_411[] = {"6667","Iraq-Kuwait Boundary Datum 1992","geodetic","Four stations established between September and December 1991 determined by GPS and Doppler observations.","1992","7030","8901","2876","International boundary demarcation","","United Nations Iraq-Kuwait Boundary Demarcation Commission, Final Report, May 1993.","EPSG","2003-09-01","","0 ",NULL};
datafile_rows_t datum_row_412[] = {"6668","European Datum 1979","geodetic","Fundamental point: Potsdam (Helmert Tower). Latitude: 52 deg 22 min 51.4456 sec N; Longitude: 13 deg  3 min 58.9283 sec E (of Greenwich).","1979","7022","8901","1297","Scientific network.","Replaced by 1987 adjustment.","","EPSG","2003-12-31","","0 ",NULL};
datafile_rows_t datum_row_413[] = {"6670","Istituto Geografico Militaire 1995","geodetic","Network of 1296 points observed 1992-1995 and adjusted in 1996 constrained to 9 ETRS89 points. Densification of ETRS89 in Italy.","1995","7030","8901","1127","Geodetic survey and scientific study.","","ENI","EPSG","2004-01-07","","0 ",NULL};
datafile_rows_t datum_row_414[] = {"6671","Voirol 1879","geodetic","Fundamental point: Voirol. Latitude: 36 deg 45 min 08.199 sec N; Longitude: 3 deg 02 min 49.435 sec E of Greenwich. Uses RGS (and old IGN) value of 2 deg 20 min 13.95 sec for Greenwich-Paris meridian difference.","1879","7011","8901","1365","Topographic mapping.","Replaces Voirol 1875 (code 6304).","IGN Paris","EPSG","2004-01-07","","0 ",NULL};
datafile_rows_t datum_row_415[] = {"6672","Chatham Islands Datum 1971","geodetic","","1971","7022","8901","2889","Geodetic survey, topographic mapping, engineering survey.","Replaced by Chatham Islands Datum 1979 (code 6673).","Office of Surveyor General (OSG) Technical Report 14, June 2001.","EPSG","2004-02-17","","0 ",NULL};
datafile_rows_t datum_row_416[] = {"6673","Chatham Islands Datum 1979","geodetic","Fundamental point: station Astro. Latitude: 43 deg 57 min 23.60 sec S; Longitude: 176 deg 34 min 28.65 sec W (of Greenwich).","1979","7022","8901","2889","Geodetic survey, topographic mapping, engineering survey.","Replaces Chatham Islands Datum 1971 (code 6672). Replaced by New Zealand Geodetic Datum 2000 (code 6167) from March 2000.","Office of Surveyor General (OSG) Technical Report 14, June 2001.","EPSG","2004-02-17","","0 ",NULL};
datafile_rows_t datum_row_417[] = {"6674","Sistema de Referencia Geocentrico para America del Sur 2000","geodetic","ITRF2000 at epoch 2000.40.","2000","7019","8901","3418","Geodetic survey.","Realised by a frame of 184 stations observed in 2000 and adjusted in the ITRF2000. Includes ties to tide gauges. Replaces SIRGAS 1995 system for South America; expands SIRGAS to Mexico and Central America.","IBGE Brazil,  http://www1.ibge.gov.br/","EPSG","2006-08-18","2005.46 2005.83 2006.465 2006.77","0 ",NULL};
datafile_rows_t datum_row_418[] = {"6675","Guam 1963","geodetic","Fundamental point: Tagcha. Latitude: 13 deg 22 min 38.49 sec N; Longitude: 144 deg 45 min 51.56 sec E (of Greenwich).","1963","7008","8901","3255","Topographic mapping.","Replaced by NAD83(HARN)","US National Geospatial Intelligence Agency (NGA). http://earth-info.nga.mil/","EPSG","2005-09-06","2005.46","0 ",NULL};
datafile_rows_t datum_row_419[] = {"6676","Vientiane 1982","geodetic","Fundamental point: Vientiane (Nongteng) Astro Pillar. Latitude: 18 deg 01 min 31.6301 sec N; Longitude: 102 deg 30 min 56.6999 sec E (of Greenwich).","1982","7024","8901","1138","Topographic mapping.","Replaced by Lao 1993.","National Geographic Department","EPSG","2004-04-27","","0 ",NULL};
datafile_rows_t datum_row_420[] = {"6677","Lao 1993","geodetic","Fundamental point: Lao 1982 coordinates of Pakxa pillar. Latitude: 18 deg 23 min 57.0056 sec N; Longitude: 103 deg 38 min 41.8020 sec E (of Greenwich). Orientation parallel with WGS 84.","1993","7024","8901","1138","Topographic mapping.","Replaces Vientiane 1982. Replaced by Lao 1997","National Geographic Department","EPSG","2004-04-27","","0 ",NULL};
datafile_rows_t datum_row_421[] = {"6678","Lao National Datum 1997","geodetic","Fundamental point: Vientiane (Nongteng) Astro Pillar. Latitude: 18 deg 01 min 31.3480 sec N; Longitude: 102 deg 30 min 57.1376 sec E (of Greenwich).","1997","7024","8901","1138","Cadastre, topographic mapping, engineering survey.","Replaces Lao 1993.","National Geographic Department","EPSG","2004-04-27","","0 ",NULL};
datafile_rows_t datum_row_422[] = {"6679","Jouik 1961","geodetic","","1961","7012","8901","2967","Hydrographic charting.","Replaced by Mauritania 1999 (datum code 6702).","Woodside","EPSG","2006-06-12","2006.44","0 ",NULL};
datafile_rows_t datum_row_423[] = {"6680","Nouakchott 1965","geodetic","Nouakchott astronomical point.","1965","7012","8901","2968","Topographic survey.","Triangulation limited to environs of Nouakchott. Extended in 1982 by satellite translocation from a single station \"Ruines\" to support Syledis chain for offshore operations. Replaced by Mauritania 1999 (datum code 6602).","IGN Paris and various industry sources.","EPSG","2006-06-12","2006.44","0 ",NULL};
datafile_rows_t datum_row_424[] = {"6681","Mauritania 1999","geodetic","","1999","7012","8901","1157","Minerals management, topographic mapping.","A network of 36 GPS stations tied to ITRF96, 8 of which are IGN astronomic points.","Woodside","EPSG","2004-10-14","","1 ",NULL};
datafile_rows_t datum_row_425[] = {"6682","Gulshan 303","geodetic","Gulshan garden, Dhaka.","1995","7015","8901","1041","Geodetic survey, cadastre, topographic mapping, engineering survey.","Network of more than 140 control points observed and adjusted in 1995 by Japan International Cooperation Agency (JICA).","Survey of Bangladesh via IGN Paris and Tullow Oil.","EPSG","2006-06-22","2006.47","0 ",NULL};
datafile_rows_t datum_row_426[] = {"6683","Philippine Reference System 1992","geodetic","Fundamental point: Balacan. Latitude: 13 deg 33 min 41.000 sec N; Longitude: 121 deg 52 min  03.000 sec E (of Greenwich), geoid-ellipsoid separation 0.34m.","1992","7008","8901","1190","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces Luzon 1911 datum (code 6253).","National Mapping and Resource Information Authority, Coast and Geodetic Survey Department.","EPSG","2004-12-24","","0 ",NULL};
datafile_rows_t datum_row_427[] = {"6684","Gan 1970","geodetic","","1970","7022","8901","3274","Topographic mapping.","In some references incorrectly named \"Gandajika 1970\". See datum code 6685.","Various industry sources.","EPSG","2005-04-14","","0 ",NULL};
datafile_rows_t datum_row_428[] = {"6685","Gandajika","geodetic","Gandajika base","1953","7022","8901","1259","Topographic mapping.","In some references incorrectly attributed to the Maldives. See datum code 6684.","Various industry sources.","EPSG","2005-04-14","","1 ",NULL};
datafile_rows_t datum_row_429[] = {"6686","Marco Geocentrico Nacional de Referencia","geodetic","ITRF94 at epoch 1995.4.  Bogota observatory coordinates: Latitude: 4 deg 35 min 46.3215 sec N; Longitude: 74 deg 04 min 39.0285 sec W (of Greenwich).","2004","7019","8901","3229","Geodetic survey.","Densification of SIRGAS 1995 within Colombia. Replaces Bogota 1975 (datum code 6218).","Instituto Geografico Agustin Codazzi (IGAC) publication \"Aspectos prácticos de la adopción del Marco Geocéntrico Nacional de Referencia MAGNA-SIRGAS como datum oficial de Colombia\". http://www.igac.gov.co/MAGNAWEB/DocumentosMAGNA.htm","EPSG","2007-07-02","2006.77 2007.060","0 ",NULL};
datafile_rows_t datum_row_430[] = {"6687","Reseau Geodesique de la Polynesie Francaise","geodetic","ITRF92 at epoch 1993.0. Densification by GPS of the Reference Network of French Polynesia, a coordinate set of 13 stations determined through DORIS observations.","1993","7019","8901","1098","Geodetic survey.","Replaces Tahaa 54 (datum code 6629), IGN 63 Hiva Oa (6689), IGN 72 Nuku Hiva (6630), Maupiti 83 (6692), MHEFO 55 (6688), Moorea 87 (6691) and Tahiti 79 (6690).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie. Also www.shom.fr, technical report 002/199.","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_431[] = {"6688","Fatu Iva 72","geodetic","Fundamental point: Latitude: 9 deg 25 min 58.00 sec S; Longitude: 138 deg 55 min 06.25 sec W (of Greenwich).","1972","7022","8901","3133","Hydrographic and topographic survey.","Recomputed by IGN in 1972 using origin and observations of 1953-1955 Mission Hydrographique des Establissements Francais d'Oceanie (MHEFO 55). Replaced by RGPF (datum code 6687).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_432[] = {"6689","IGN63 Hiva Oa","geodetic","Fundamental point: Atuona. Latitude: 9 deg 48 min 27.20 sec S; Longitude: 139 deg 02 min 15.45 sec W (of Greenwich).","1963","7022","8901","3130","Hydrographic and topographic survey.","Replaced by RGPF (datum code 6687).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_433[] = {"6690","Tahiti 79","geodetic","Fundamental point: Tahiti North Base. Latitude: 17 deg 38 min 10.0 sec S; Longitude: 149 deg 36 min 57.8 sec W (of Greenwich).","1979","7022","8901","3124","Hydrographic and topographic survey.","Replaces Tahiti 52 (datum code 6628) in Tahiti. Replaced by RGPF (datum code 6687).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_434[] = {"6691","Moorea 87","geodetic","Two stations on Tahiti whose coordinates from the Tahiti 1979 adjustment were held fixed.","1987","7022","8901","3125","Hydrographic and topographic survey.","Replaces Tahiti 52 (datum code 6628) in Moorea. Replaced by RGPF (datum code 6687).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_435[] = {"6692","Maupiti 83","geodetic","Fundamental point: Pitiahe South Base. Latitude: 16 deg 28 min 28.942 sec S; Longitude: 152 deg 14 min 55.059 sec W (of Greenwich).","1983","7022","8901","3126","Hydrographic and topographic survey.","Replaced by RGPF (datum code 6687).","Gouvernement de la Polynésie Française, Service  de l'Urbanisme, Section topographie.","EPSG","2005-08-12","","0 ",NULL};
datafile_rows_t datum_row_436[] = {"6693","Nakhl-e Ghanem","geodetic","Coordinates of two stations determined with respect to ITRF 2000 at epoch 2005.2: BMT1 latitude 27 deg 42 min 09.8417 sec N, longitude 52 deg 12 min 11.0362 sec E; Total1 latitude 27 deg 31 min 03.8896 sec N, longitude 52 deg 36 min 13.1312 sec E.","2005","7030","8901","2362","Engineering survey for onshore facilities for South Pars phase 11 and Pars LNG.","","Total","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_437[] = {"6694","Posiciones Geodesicas Argentinas 1994","geodetic","A geodetic network of 127 high accuracy surveyed points based on WGS 84 that define the National Geodetic System (Sistema Geodésico Nacional).","1994","7019","8901","1033","Topographic mapping, geodetic survey.","Una red geodésica de 127 puntos materializados en el terreno que definen el Sistema Geodésico Nacional.  Technically, but at this record revision date not legally, replaced by POSGAR 98 (code 6190).","Instituto Geográfico Militar de la República Argentina, http://www.igm.gov.ar","EPSG","2005-09-12","","0 ",NULL};
datafile_rows_t datum_row_438[] = {"6695","Katanga 1955","geodetic","Fundamental point: Tshinsenda A. Latitude: 12 deg 20 min 31.568 sec S; Longitude: 28 deg 01 min 02.971 sec E.","1955","7008","8901","3147","Cadastre, topographic mapping, engineering survey.","Replaces earlier adjustments.","Clifford J. Mugnier, in Photogrammetric Engineering and Remote Sensing, June 2005.","EPSG","2005-09-30","","0 ",NULL};
datafile_rows_t datum_row_439[] = {"6696","Kasai 1953","geodetic","Two stations of the Katanga triangulation with ellipsoid change applied: Kabila, latitude 6 deg 58 min 34.023 sec S, longitude 23 deg 50 min 24.028 sec E; and Gandajika NW base, latitude 6 deg 45 min 01.057 sec S, longitude 23 deg 57 min 03.038 sec E.","1955","7012","8901","3148","Cadastre, topographic mapping, engineering survey.","Replaced by IGC 1962 Arc of the 6th Parallel South.","Institute Geographique du Congo","EPSG","2005-09-30","","0 ",NULL};
datafile_rows_t datum_row_440[] = {"6697","IGC 1962 Arc of the 6th Parallel South","geodetic","Coordinates of 3 stations determined with respect to Arc 1950: Mulungu 4deg 47min 39.2325sec S, 29deg 59min 37.5864sec E; Nyakawembe 4deg 14min 57.3618sec S, 29deg 42min 52.8032sec E; Kavula 4deg 35min 15.8634sec S, 29deg 41min 14.2693sec E.","1962","7012","8901","3149","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Institute Geographique du Congo","EPSG","2006-08-25","2006.721","0 ",NULL};
datafile_rows_t datum_row_441[] = {"6698","IGN 1962 Kerguelen","geodetic","K0 1949.","1949","7022","8901","2816","Geodetic survey, cadastre, topographic mapping, engineering survey.","","IGN Paris.","OGP","2005-11-23","","0 ",NULL};
datafile_rows_t datum_row_442[] = {"6699","Le Pouce 1934","geodetic","Fundamental point: Le Pouce. Latitude: 20 deg 11 min 42.25 sec S; Longitude: 57 deg 31 min 18.58 sec E.","1934","7012","8901","3209","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Cartography Section, Ministry of Housing and Land.","OGP","2006-01-16","","0 ",NULL};
datafile_rows_t datum_row_443[] = {"6700","IGN Astro 1960","geodetic","Realised through a set of independent astronomically-positioned points.","1960","7012","8901","1157","Small scale topographic mapping.","Observed during 1959-1960. Independent points not connected through a network. Relative accuracy estimated at 50-100m. Replaced by Mauritania 1999 (datum code 6702).","Ministry of Works and Transport, Topography and Cartography Directive.","OGP","2006-06-12","2006.44","0 ",NULL};
datafile_rows_t datum_row_444[] = {"6701","Institut Geographique du Congo Belge 1955","geodetic","Fundamental point: Yella east base. Latitude: 6 deg 00 min 53.139 sec S; Longitude: 12 deg 58 min 29.287 sec E.","1955","7012","8901","3171","Cadastre, topographic mapping, engineering survey.","Replaced by IGC 1962 Arc of the 6th Parallel South, except for oil industry activities.","Institut Geographique du Congo Belge.","OGP","2005-11-28","","0 ",NULL};
datafile_rows_t datum_row_445[] = {"6702","Mauritania 1999","geodetic","ITRF96 at epoch 1997.0","1999","7019","8901","1157","Geodesy.","A network of 36 GPS stations tied to ITRF96, 8 of which are IGN 1962 astronomic points.","Ministry of Works and Transport, Topography and Cartography Directive.","EPSG","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_446[] = {"6703","Missao Hidrografico Angola y Sao Tome 1951","geodetic","Extension of Camacupa datum into Cabinda.","1951","7012","8901","1318","Coastal hydrography.","A variation of this datum has been adopted by the oil industry but incorrectly using the International 1924 ellipsoid and not tied to the official Portuguese triangulation - see Mhast (onshore) and Mhast (offshore) (codes 6704 and 6705).","Various industry sources.","OGP","2006-01-03","","0 ",NULL};
datafile_rows_t datum_row_447[] = {"6704","Mhast (onshore)","geodetic","Probably adopted a Mhast 1951 coordinate set but associated an incorrect ellipsoid with it.","","7022","8901","3179","Oil industry exploration and production. From 1979, offshore use superseded by Mhast (offshore) (code 6705).","Adopted by oil industry with intention of being Mhast 1951 (code 6703) but incorrectly (for Mhast 1951) used the International 1924 ellipsoid. This datum differs by about 400 metres from the Portuguese Mhast 1951 and Camacupa datums.","ChevronTexaco.","OGP","2006-01-03","","0 ",NULL};
datafile_rows_t datum_row_448[] = {"6705","Mhast (offshore)","geodetic","Fundamental point: Station Y at Malongo base camp. Latitude: 5 deg 23 min 30.810 sec S; Longitude: 12 deg 12 min  01.590 sec E (of Greenwich).","1979","7022","8901","3180","Oil industry offshore exploration and production between 1979 and 1987.","Origin coordinates determined by Transit single point position using 32 passes and transformed from WGS72BE using transformation code 15790. Differs from Mhast (onshore) by approximately 10m. Replaced in 1987 by Malongo 1987 (code 6259).","ChevronTexaco.","OGP","2006-01-03","","0 ",NULL};
datafile_rows_t datum_row_449[] = {"6706","Egypt Gulf of Suez S-650 TL","geodetic","Fundamental point: Station S-650 DMX. Adopted coordinates: latitude: 28 deg 19 min 02.1907 sec N; Longitude: 33 deg 06 min  36.6344 sec E (of Greenwich). The proper Egypt 1907 coordinates for S-650 differ from these by about 20m.","1980","7020","8901","2341","Oil industry offshore exploration and production in Gulf of Suez after 1980.","A coherent set of stations bordering the Gulf of Suez coordinated by Transit translocation (\"TL\") between 1980 and 1984. Based on incorrect Egypt 1907 values for origin station S-650. Differs from true Egypt 1907 by approximately 20m.","Various industry sources.","OGP","2006-01-11","","0 ",NULL};
datafile_rows_t datum_row_450[] = {"6707","Tern Island 1961","geodetic","Fundamental point: station FRIG on tern island, station B4 on Sorol Atoll.","1961","7022","8901","3181","Military and topographic mapping","Two independent astronomic determinations considered to be consistent through adoption of common transformation to WGS 84 (see tfm code 15795).","DMA / NIMA / NGA TR8350.2 (original 1987 first edition and 3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_451[] = {"6708","Cocos Islands 1965","geodetic","Fundamental point: Anna 1.","1965","7003","8901","1069","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_452[] = {"6709","Iwo Jima 1945","geodetic","Fundamental point: Beacon \"E\".","1945","7022","8901","3200","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_453[] = {"6710","St. Helena 1971","geodetic","Fundamental point: DOS 71/4.","1971","7022","8901","3183","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_454[] = {"6711","Marcus Island 1952","geodetic","Marcus Island Astronomic Station.","1952","7022","8901","3203","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_455[] = {"6712","Ascension Island 1958","geodetic","","1958","7022","8901","3182","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_456[] = {"6713","Ayabelle Lighthouse","geodetic","Fundamental point: Ayabelle Lighthouse.","","7012","8901","1081","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_457[] = {"6714","Bellevue","geodetic","","1960","7022","8901","3193","Military and topographic mapping","Datum covers all the major islands of Vanuatu in two different adjustment blocks, but practical usage is as given in the area of use.","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-07-29","2006.51","0 ",NULL};
datafile_rows_t datum_row_458[] = {"6715","Camp Area Astro","geodetic","","","7022","8901","3205","Geodetic and topographic survey","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_459[] = {"6716","Phoenix Islands 1966","geodetic","","1966","7022","8901","3196","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_460[] = {"6717","Cape Canaveral","geodetic","Fundamental point: Central 1950.  Latitude: 28 deg 29 min 32.36555 sec N; longitude 80 deg 34 min 38.77362 sec W (of Greenwich)","1963","7008","8901","3206","US space and military operations.","","US NGS and DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-09-28","2006.87","0 ",NULL};
datafile_rows_t datum_row_461[] = {"6718","Solomon 1968","geodetic","Fundamental point: GUX 1.","1968","7022","8901","1213","Military and topographic mapping, +/- 25 meters in each component","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_462[] = {"6719","Easter Island 1967","geodetic","","1967","7022","8901","3188","Military and topographic mapping, +/- 25 meters in each component","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_463[] = {"6720","Fiji Geodetic Datum 1986","geodetic","NWL 9D coordinates of 6 stations on Vitu Levu and Vanua Levu.","1986","7043","8901","1094","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces Viti Levu 1912, Vanua Levu 1915 and Fiji 1956.","Survey Review 30,231 (January 1989).","OGP","2006-07-19","2006.50","0 ",NULL};
datafile_rows_t datum_row_464[] = {"6721","Fiji 1956","geodetic","Latitude origin was obtained astronomically at station Rasusuva = 17 deg 49 min 03.13 sec South,   Longitude origin was obtained astronomically at station Suva = 178 deg 25 min 35.835 sec East.","1956","7022","8901","3398","Military and topographic mapping","For topographic mapping replaces Viti Levu 1912 and Vanua Levu 1915. Replaced by Fiji Geodetic Datum 1986.","SOPAC, www.sopac.org, and Clifford J. Mugnier in Photogrammetric Engineering and Remote Sensing, October 2000, www.asprs.org.","OGP","2006-07-19","2006.50","0 ",NULL};
datafile_rows_t datum_row_465[] = {"6722","South Georgia 1968","geodetic","Fundamental point: ISTS 061.","1968","7022","8901","3187","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_466[] = {"6723","Grand Cayman 1959","geodetic","Fundamental point: GC1. Latitude: 19deg 17min 54.43sec North, longitude: 81deg 22min 37.17sec West.","1959","7008","8901","3185","Topographic mapping","","Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1998. http://www.asprs.org/","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_467[] = {"6724","Diego Garcia 1969","geodetic","Fundamental point: ISTS 073","1969","7022","8901","3189","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_468[] = {"6725","Johnston Island 1961","geodetic","","1961","7022","8901","3201","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_469[] = {"6726","Little Cayman 1961","geodetic","Fundamental point: LC5. Latitude: 19deg 39min 46.324sec North, longitude: 81deg 203min 47.910sec West.","1961","7008","8901","3186","Military and topographic mapping","","Clifford J. Mugnier; in Photogrammetric Engineering & Remote Sensing November 1998. http://www.asprs.org/","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_470[] = {"6727","Midway 1961","geodetic","","1961","7022","8901","3202","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_471[] = {"6728","Pico de la Nieves","geodetic","","","7022","8901","3199","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_472[] = {"6729","Pitcairn 1967","geodetic","","1967","7022","8901","3208","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_473[] = {"6730","Santo 1965","geodetic","","1965","7022","8901","3194","Military and topographic mapping","Datum covers all the major islands of Vanuatu in two different adjustment blocks, but practical usage is as given in the area of use.","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-07-29","2006.51","0 ",NULL};
datafile_rows_t datum_row_474[] = {"6731","Viti Levu 1916","geodetic","","1916","7012","8901","3195","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","1 ",NULL};
datafile_rows_t datum_row_475[] = {"6732","Marshall Islands 1960","geodetic","","1960","7053","8901","3191","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_476[] = {"6733","Wake Island 1952","geodetic","","1952","7022","8901","3190","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_477[] = {"6734","Tristan 1968","geodetic","","1968","7022","8901","3184","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_478[] = {"6735","Kusaie 1951","geodetic","","1951","7022","8901","3192","Military and topographic mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_479[] = {"6736","Deception Island","geodetic","","","7012","8901","3204","Military and scientific mapping","","DMA / NIMA / NGA TR8350.2 (3rd edition, Amendment 1, 3 January 2000).","OGP","2006-01-26","","0 ",NULL};
datafile_rows_t datum_row_480[] = {"6737","Geocentric datum of Korea","geodetic","ITRF2000 at epoch 2002.0","2002","7019","8901","1135","Geodetic survey.","","Permanent Committee for GIS Infrastructure for Asia and the Pacific (PCGIAP), http://www.gsi.go.jp/PCGIAP","OGP","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_481[] = {"6738","Hong Kong 1963","geodetic","Fundamental point: Trig \"Zero\", 38.4 feet south along the transit circle of the Kowloon Observatory. Latitude 22deg 18min 12.82sec North, longitude 114deg 10min 18.75sec East.","1963","7007","8901","1118","Topographic mapping and hydrographic charting.","Replaced by Hong Kong 1963(67) for military purposes only in 1967.  Replaced by Hong Kong 1980.","Survey and Mapping Office, Lands Department. http://www.info.gov.hk/landsd/","OGP","2006-02-03","","0 ",NULL};
datafile_rows_t datum_row_482[] = {"6739","Hong Kong 1963(67)","geodetic","Fundamental point: Trig \"Zero\", 38.4 feet south along the transit circle of the Kowloon Observatory. Latitude 22deg 18min 12.82sec North, longitude 114deg 10min 18.75sec East.","1967","7022","8901","1118","Military mapping and charting.","Replaces Hong Kong 1963 for military purposes only in 1967.  Replaced by Hong Kong 1980.","UK Hydrographic Office.","OGP","2006-02-03","","0 ",NULL};
datafile_rows_t datum_row_483[] = {"6740","Parametrop Zemp 1990","geodetic","Geocentre.","1990","7054","8901","1262","Geodetic survey.","Derived through satellite tracking techniques.","Geodeziya i Katografiya, 1993.","OGP","2006-02-03","","0 ",NULL};
datafile_rows_t datum_row_484[] = {"6741","Faroe Datum 1954","geodetic","Astronomical observations at 3 points.","1954","7022","8901","3248","Geodetic survey, topographic mapping, engineering and cadastral survey.","Replaced by ED50 in late 1970's for all purposes other than cadastre. Replaced by fk89 for cadastre.","Kort & Matrikelstyrelsen (KMS), Copenhagen.","OGP","2006-08-04","2005.472","0 ",NULL};
datafile_rows_t datum_row_485[] = {"6742","Geodetic Datum of Malaysia 2000","geodetic","ITRF2000, epoch 2000.0","2000","7019","8901","1151","Geodetic survey, topographic mapping, engineering and cadastrral survey.","Replaces all older Malaysian datums.","GDM2000 Technical Manual; Department of Survey and Mapping Malaysia. www.jupem.gov.my","OGP","2006-03-16","","0 ",NULL};
datafile_rows_t datum_row_486[] = {"6743","Karbala 1979 (Polservice)","geodetic","Karbala.","1979","7012","8901","1124","Geodetic survey.","National geodetic network established by Polservice consortium.","Various industry sources.","OGP","2006-06-02","","0 ",NULL};
datafile_rows_t datum_row_487[] = {"6744","Nahrwan 1934","geodetic","Fundamental point: Nahrwan south base.  Latitude: 33 deg 19 min 10.87 sec N; Longitude: 44 deg 43 min 25.54 sec E (of Greenwich).","1934","7012","8901","3390","Oil exploration and production.","This adjustment later discovered to have a significant orientation error. In Iran replaced by FD58. In Iraq, replaced by Nahrwan 1967.","Various industry sources.","OGP","2006-06-02","","0 ",NULL};
datafile_rows_t datum_row_488[] = {"6745","Rauenberg Datum/83","geodetic","Fundamental point: Rauenberg. Latitude: 52 deg 27 min 12.021 sec N; Longitude: 13 deg 22 min 04.928 sec E (of Greenwich). This station was destroyed in 1910 and the station at Potsdam substituted as the fundamental point.","1990","7004","8901","2545","Geodetic survey, cadastre, topographic mapping, engineering survey.","RD/83 is the realisation of DHDN in Saxony. It is the resultant of applying a transformation derived at 106 points throughout former East Germany to Pulkovo 1942/83 points in Saxony.","BKG via EuroGeographics. http://crs.bkg.bund.de","OGP","2006-06-12","","0 ",NULL};
datafile_rows_t datum_row_489[] = {"6746","Potsdam Datum/83","geodetic","Fundamental point: Rauenberg. Latitude: 52 deg 27 min 12.021 sec N; Longitude: 13 deg 22 min 04.928 sec E (of Greenwich). This station was destroyed in 1910 and the station at Potsdam substituted as the fundamental point.","1990","7004","8901","2544","Geodetic survey, cadastre, topographic mapping, engineering survey.","PD/83 is the realisation of DHDN in Thuringen. It is the resultant of applying a transformation derived at 13 points on the border between East and West Germany to Pulkovo 1942/83 points in Thuringen.","BKG via EuroGeographics. http://crs.bkg.bund.de","OGP","2006-06-12","","0 ",NULL};
datafile_rows_t datum_row_490[] = {"6747","Greenland 1996","geodetic","ITRF94 at epoch 1996.62","1996","7019","8901","1107","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaces Ammassalik 1958, Qornoq 1927 and Scoresbysund 1952.","Kort & Matrikelstyrelsen (KMS), Copenhagen.","OGP","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_491[] = {"6748","Vanua Levu 1915","geodetic","Latitude origin was obtained astronomically at station Numuiloa = 16 deg 23 min 38.36 sec South,   Longitude origin was obtained astronomically at station Suva = 178 deg 25 min 35.835 sec East.","1915","7055","8901","3401","Geodetic survey, cadastre, topographic mapping, engineering survey.","For topographic mapping, replaced by Fiji 1956. For other purposes, replaced by Fiji 1986.","Clifford J. Mugnier in Photogrammetric Engineering and Remote Sensing, October 2000, www.asprs.org.","OGP","2006-07-19","","0 ",NULL};
datafile_rows_t datum_row_492[] = {"6749","Reseau Geodesique de Nouvelle Caledonie 91-93","geodetic","ITRF90 at epoch 1989.0","1989","7019","8901","1174","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie, Direction des Infrastructures, de la Topografie et des Transports Terrestres. www.dittt.gouv.nc","OGP","2006-08-18","2006.77","0 ",NULL};
datafile_rows_t datum_row_493[] = {"6750","ST87 Ouvea","geodetic","Ouloup.","1987","7030","8901","2813","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Service Topographique de la Nouvelle Caledonie, Direction des Infrastructures, de la Topografie et des Transports Terrestres. www.dittt.gouv.nc","OGP","2006-07-21","","0 ",NULL};
datafile_rows_t datum_row_494[] = {"6751","Kertau (RSO)","geodetic","","1969","7056","8901","1309","Metrication of RSO grid.","Adopts metric conversion of 0.914398 metres per yard exactly. This is a truncation of the Sears 1922 ratio.","Defence Geographic Centre.","OGP","2006-07-24","","0 ",NULL};
datafile_rows_t datum_row_495[] = {"6752","Viti Levu 1912","geodetic","Latitude origin was obtained astronomically at station Monavatu = 17 deg 53 min 28.285 sec South,   Longitude origin was obtained astronomically at station Suva = 178 deg 25 min 35.835 sec East.","1912","7055","8901","3195","Geodetic survey, cadastre, topographic mapping, engineering survey.","For topographic mapping, replaced by Fiji 1956. For other purposes, replaced by Fiji 1986.","Clifford J. Mugnier in Photogrammetric Engineering and Remote Sensing, October 2000, www.asprs.org.","OGP","2006-07-30","","0 ",NULL};
datafile_rows_t datum_row_496[] = {"6753","fk89","geodetic","","1989","7022","8901","3248","Cadastre","Replaces FD54 for cadastre.","Kort & Matrikelstyrelsen (KMS), Copenhagen.","OGP","2006-08-04","","0 ",NULL};
datafile_rows_t datum_row_497[] = {"6754","Libyan Geodetic Datum 2006","geodetic","5 stations tied to ITRF2000 through 8 days of continuous observations in May 2006.","2006","7022","8901","1143","Geodetic survey, topographic mapping, engineering survey.","Replaces ELD79.","Survey Department of Libya.","OGP","2006-08-25","","0 ",NULL};
datafile_rows_t datum_row_498[] = {"6755","Datum Geodesi Nasional 1995","geodetic","ITRF91at epoch 1992.0.","1995","7030","8901","1122","Geodetic survey, topographic mapping, engineering survey.","Replaces ID74 and all older datums.","Bakosurtanal.","OGP","2006-08-25","","0 ",NULL};
datafile_rows_t datum_row_499[] = {"6756","Vietnam 2000","geodetic","Point N00, located in the premises of the Land Administration Research Institute, Hoang Quoc Viet Street, Hanoi.","2000","7030","8901","1252","Geodetic survey, topographic mapping, engineering survey.","Replaces Hanoi 1972.","General Director of Land Administration.","OGP","2006-09-13","","0 ",NULL};
datafile_rows_t datum_row_500[] = {"6757","SVY21","geodetic","Fundamental point: Base 7 at Pierce Resevoir. Latitude: 1 deg 22 min 02.9154 sec N; Longitude: 103 deg 49 min 31.9752 sec E (of Greenwich).","2004","7030","8901","1210","Cadastre.","Replaces Kertau 1968 for cadastral purposes from August 2004.","Singapore Land Authority","OGP","2006-10-13","","0 ",NULL};
datafile_rows_t datum_row_501[] = {"6758","Jamaica 2001","geodetic","Aligned to WGS 84.","2001","7030","8901","1128","Geodetic survey, cadastre, topographic mapping, hydrographic charting, engineering survey.","","National Land Agency.","OGP","2007-01-19","","0 ",NULL};
datafile_rows_t datum_row_502[] = {"6759","NAD83 (National Spatial Reference System 2007)","geodetic","Coordinates of 486 national continually operating reference system (CORS) and 195 collaborative GPS (CGPS) sites constrained to their CORS96 values, ITRF2000 at epoch 2002.0.","2007","7019","8901","1511","Geodetic survey.","","U.S. National Geodetic Survey, http://www.ngs.noaa.gov/","OGP","2007-03-13","","0 ",NULL};
datafile_rows_t datum_row_503[] = {"6760","World Geodetic System 1966","geodetic","Developed from a worldwide distribution of terrestrial and geodetic satellite observations and defined through a set of station coordinates.","1966","7025","8901","1262","Geodesy.","A worldwide 5° × 5° mean free air gravity anomaly field provided the basic data for producing the WGS 66 gravimetric geoid. Replaced by WGS 72.","US DMA/NIMA/NGA","OGP","2007-03-25","","0 ",NULL};
datafile_rows_t datum_row_504[] = {"6801","CH1903 (Bern)","geodetic","Fundamental point: Old Bern observatory. Latitude: 46 deg 57 min 08.660 sec N; Longitude: 0 deg E of Bern.","1903","7004","8907","1286","Topographic mapping.","","Bundesamt für Landestopographie","EPSG","2003-12-18","2003.361","0 ",NULL};
datafile_rows_t datum_row_505[] = {"6802","Bogota 1975 (Bogota)","geodetic","Fundamental point: Bogota observatory. Latitude: 4 deg 35 min 56.570 sec N; Longitude: 0 deg E of Bogota.","1975","7022","8904","3229","Topographic mapping.","","","EPSG","2003-12-18","2000.20 2003.361","0 ",NULL};
datafile_rows_t datum_row_506[] = {"6803","Lisbon 1937 (Lisbon)","geodetic","Fundamental point: Castelo Sao Jorge; Lisbon. Latitude: 38 deg 42 min 43.631 sec N; Longitude: 0","1937","7022","8902","1294","Topographic mapping.","Replaces Lisbon 1890 adjustment (which used Bessel 1841 ellipsoid).","Instituto Geografico e Cadastral; Lisbon","EPSG","1995-06-02","2001.551","0 ",NULL};
datafile_rows_t datum_row_507[] = {"6804","Makassar (Jakarta)","geodetic","Fundamental point: station P1, Moncongloe. Latitude 5 deg 08 min 41.42 sec S; longitude 12 deg 35 min 47.15 sec E of Jakarta.","","7004","8908","1316","Topographic mapping.","","EPSG","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_508[] = {"6805","Militar-Geographische Institut (Ferro)","geodetic","Fundamental point: Hermannskogel. Latitude: 48 deg 16 min 15.29 sec N; Longitude: 33 deg 57 min 41.06 sec E of Ferro.","1901","7004","8909","1321","Topographic mapping.","","Bundesamt fur Eich- und Vermessungswesen; Wien","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_509[] = {"6806","Monte Mario (Rome)","geodetic","Fundamental point: Monte Mario. Latitude: 41 deg 55 min 25.51 sec N; Longitude: 0 deg  00 min  00.00 sec E (of Rome).","","7022","8906","3343","Topographic mapping.","Replaced Genova datum, Bessel 1841 ellipsoid, from 1940.","","EPSG","2003-12-31","2003.36","0 ",NULL};
datafile_rows_t datum_row_510[] = {"6807","Nouvelle Triangulation Francaise (Paris)","geodetic","Fundamental point: Pantheon. Latitude: 54.273618g N; Longitude: 0.0106921g E (of Paris).","1895","7011","8903","1326","Topographic mapping.","","","EPSG","2004-01-07","2003.361","0 ",NULL};
datafile_rows_t datum_row_511[] = {"6808","Padang 1884 (Jakarta)","geodetic","Fundamental point: Padang","1884","7004","8908","1355","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_512[] = {"6809","Reseau National Belge 1950 (Brussels)","geodetic","Fundamental point: Lommel (tower). Latitude: 51 deg 13 min 47.334 sec N; Longitude: 0 deg 56 min 44.773 sec E (of Brussels).","1950","7022","8910","1347","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_513[] = {"6810","Tananarive 1925 (Paris)","geodetic","Fundamental point: Tananarive observatory. Latitude: 21.0191667g S; Longitude: 50.23849537g E (of Paris)","1925","7022","8903","3273","Topographic mapping.","","IGN Paris","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_514[] = {"6811","Voirol 1875 (Paris)","geodetic","Fundamental point: Voirol. Latitude: 40.83578 grads N; Longitude: 0.78873 grads E of Paris.","1875","7011","8903","1365","Topographic mapping.","","IGN Paris","EPSG","2004-01-07","2003.361","0 ",NULL};
datafile_rows_t datum_row_515[] = {"6813","Batavia (Jakarta)","geodetic","Fundamental point: Longitude at Batavia Astro. Station. Latitude: 6 deg  7 min 39.522 sec S; Longitude: 0 deg 00 min 00.0 sec E (of Jakarta). Latitude and azimuth at Genuk.","","7004","8908","1285","Topographic mapping.","","","EPSG","2003-12-31","2003.361","0 ",NULL};
datafile_rows_t datum_row_516[] = {"6814","Stockholm 1938 (Stockholm)","geodetic","Fundamental point: Stockholm observatory","1938","7004","8911","3313","Geodetic survey, cadastre, topographic mapping, engineering survey.","Replaced by RT90 adjustment (datum code 6124)","","EPSG","1996-04-12","","0 ",NULL};
datafile_rows_t datum_row_517[] = {"6815","Greek (Athens)","geodetic","Fundamental point: Athens Observatory; latitude 37 deg 58 min 20.132 sec N; longitude 0 deg E of Athens.","","7004","8912","1106","Topographic mapping.","See geodetic datum alias 6404.  Used as basis of topographic mapping based on Hatt projection.","Topography Department; National Technical University of Athens","EPSG","1997-06-16","","0 ",NULL};
datafile_rows_t datum_row_518[] = {"6816","Carthage (Paris)","geodetic","Fundamental point: Carthage. Latitude: 40.9464506g N; Longitude: 8.8724368g E (of Paris).","1925","7011","8903","1618","Topographic mapping.","Fundamental point astronomic coordinates determined in 1878.","","EPSG","2004-01-15","2003.362 2003.05","0 ",NULL};
datafile_rows_t datum_row_519[] = {"6817","NGO 1948 (Oslo)","geodetic","Fundamental point: Oslo observatory. Latitude: 59 deg 54 min 43.7 sec N; Longitude: 0 deg 00 min 00.0 sec E (of Oslo).","1948","7005","8913","1352","Geodetic survey, cadastre, topographic mapping, engineering survey.","","","EPSG","2004-01-05","2003.362","0 ",NULL};
datafile_rows_t datum_row_520[] = {"6818","S-JTSK (Ferro)","geodetic","Modification of Austrian MGI (Ferro) datum.","1920","7004","8909","1306","Geodetic survey, cadastre, topographic mapping, engineering survey.","","Research Institute for Geodesy Topography and Cartography (VUGTK); Prague.","EPSG","2001-08-28","2001.26","0 ",NULL};
datafile_rows_t datum_row_521[] = {"6819","Nord Sahara 1959 (Paris)","geodetic","Coordinates of primary network readjusted on ED50 datum and then transformed conformally to Clarke 1880 (RGS) ellipsoid.","1959","7012","8903","1366","Topographic mapping.","","\"Le System Geodesique Nord-Sahara\"; IGN Paris","EPSG","2000-06-23","","1 ",NULL};
datafile_rows_t datum_row_522[] = {"6820","Gunung Segara (Jakarta)","geodetic","Station P5 (Gunung Segara) 0deg 32min 12.83sec S  117deg 08min 48.47sec E of Greenwich (8deg 20min 20.68sec E of Jakarta).","","7004","8908","1360","Topographic mapping.","","","EPSG","2002-06-22","","0 ",NULL};
datafile_rows_t datum_row_523[] = {"6821","Voirol 1879 (Paris)","geodetic","Fundamental point: Voirol. Latitude: 40.835864 grads N; Longitude: 0.788735 grads E of Paris.","1879","7011","8903","1365","Topographic mapping.","Replaces Voirol 1875 (Paris) (code 6811).","IGN Paris","EPSG","2004-01-07","","0 ",NULL};
datafile_rows_t datum_row_524[] = {"6896","International Terrestrial Reference Frame 2005","geodetic","Origin at geocentre, originally orientated to the BIH Terrestrial System at epoch 1984.0 then adjusted to ensure zero net rotation to earth's overall tectonic motion. Defined by time series of Cartesian station coordinates and Earth Rotation parameters.","2005","7019","8901","1262","Geodesy.","Realisation of the IERS Terrestrial Reference System (ITRS) at epoch 2005.0. Replaces ITRF2000 (code 6656).","IGN Paris http://itrf.ensg.ign.fr/itrs_itrf.php","OGP","2007-01-19","","0 ",NULL};
datafile_rows_t datum_row_525[] = {"6901","Ancienne Triangulation Francaise (Paris)","geodetic","","","7027","8903","1326","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_526[] = {"6902","Nord de Guerre (Paris)","geodetic","","","7027","8903","1369","Topographic mapping.","","","EPSG","1995-06-02","","0 ",NULL};
datafile_rows_t datum_row_527[] = {"6903","Madrid 1870 (Madrid)","geodetic","Fundamental point: Madrid observatory.","1870","7028","8905","2366","Topographic mapping.","","Institut de Geomatica; Barcelona","EPSG","1998-11-11","","0 ",NULL};
datafile_rows_t datum_row_528[] = {"6904","Lisbon 1890 (Lisbon)","geodetic","Fundamental point: Castelo Sao Jorge; Lisbon. Latitude: 38 deg 42 min 43.631 sec N; Longitude: 0 deg E of Lisbon.","1937","7004","8902","1294","Topographic mapping.","Replaced by Lisbon 1937 adjustment (which uses International 1924 ellipsoid).","Instituto Geografico e Cadastral Lisbon http://www.igeo.pt","EPSG","2003-08-14","2003.232","0 ",NULL};
datafile_rows_t datum_row_529[] = {"9300","Astra Minas","engineering","Origin at 45 deg 59 min 54.79 sec S; 67 deg 34 min 38.94 sec W.","","","","1265","Oil industry mapping.","","","EPSG","2000-03-07","","0 ",NULL};
datafile_rows_t datum_row_530[] = {"9301","Barcelona","engineering","Centre of the gateway of San Cristobal chuch; Plaza Boyaca; Barcelona.","","","","1266","Oil industry mapping.","Coordinates variously given as 10deg 08min 06sec N  64deg 41min 17sec W and 10deg 08min 06sec N  64deg 41min 07.5sec W.  It is not clear whether there should be two local datums.","Ministry of Mines standards manual, 1974.","EPSG","2000-03-07","","0 ",NULL};
datafile_rows_t datum_row_531[] = {"9302","Maturin","engineering","Concrete post PR-1 in Plaza Bolivar; Maturin.  9deg 44min 55sec N  63deg 10min 40sec W.","","","","1320","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_532[] = {"9303","Maracaibo Cross","engineering","Cruz Canada Morillo in Maracaibo; 10deg 38min 32.328sec N  71deg 37min 12.12sec W  Loma Quintana datum.","","","","1319","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_533[] = {"9304","La Rosa","engineering","Monument in La Rosa; 10deg 22min 40.417sec N  71deg 26min 59.488sec W  Loma Quintana datum.","","","","1311","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_534[] = {"9305","Mene Grande","engineering","Monument in Santa Barbara; Mene Grande.  9deg 52min 25.488sec N  70deg 54min 35.310sec W.","","","","1270","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_535[] = {"9306","El Cubo","engineering","8deg 44min 17.258sec N  72deg 30min 09.01sec W.","","","","1269","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_536[] = {"9307","Dabajuro","engineering","Church tower at Dabajuro; 11deg 01min 19sec N  70deg 40min 40sec W.","","","","1268","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_537[] = {"9308","Tucupita","engineering","Centre of Plaza Bolivar; Tucupita; 9deg 03min 32sec N  62deg 03min 07.6sec W.","","","","1370","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_538[] = {"9309","El Mene","engineering","10deg 04min 49.1sec N  71deg 02min 10sec W.","","","","1270","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_539[] = {"9310","Santa Maria de Ipire","engineering","Concrete post PR-1 in Plaza Bolivar; Santa Maria de Ipire; 8deg 40min 06sec N  65deg 19min 09sec W.","","","","1371","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_540[] = {"9311","Barinas west base","engineering","Concrete pillar","","","","1267","Oil industry mapping.","","Ministry of Mines standards manual, 1974.","EPSG","2000-06-10","","0 ",NULL};
datafile_rows_t datum_row_541[] = {"9312","EPSG example  X","engineering","Bin grid I=J=1 at WGS 84 / UTM zone 31N 456781E 5836723N.","","","","1263","Example only.","Example only!","Bin grid orientation = 20 degrees grid.  Bin width I=25m, J=12.5m.  Bin increment I=1, J=1.  Scale factor at origin 0.99984.  Example only!","EPSG","2000-06-23","","1 ",NULL};
datafile_rows_t datum_row_542[] = {"9313","EPSG example Platform Y","engineering","Conductor slot A1","","","","1263","Example only.","Example only","EPSG","EPSG","2000-06-23","","0 ",NULL};
datafile_rows_t datum_row_543[] = {"9314","Tombak LNG plant","engineering","Plant grid coordinates of x=20000m, y=10000m at Nakhl-e Ghanem / UTM zone 39 coordinates 618336.784E, 3067774.21N. Plant grid x orientated at UTM grid bearing of 45 deg., plant grid y orientated at UTM grid bearing of 315 deg.","","","","2362","Engineering survey.","","Total","EPSG","2005-08-18","","0 ",NULL};
datafile_rows_t datum_row_544[] = {"9315","UKOOA P6 seismic bin grid example","engineering","Centre of bin grid I=J=1.","","","","1263","Example only.","","UKOOA Data Exchange Format P6/98 \"Definition of 3D Seismic Binning Grids\".","EPSG","2005-09-08","","0 ",NULL};
datafile_rows_t *datum_rows[] = {datum_row_0 ,datum_row_1 ,datum_row_2 ,datum_row_3 ,datum_row_4 ,datum_row_5 ,datum_row_6 ,datum_row_7 ,datum_row_8 ,datum_row_9 ,datum_row_10 ,datum_row_11 ,datum_row_12 ,datum_row_13 ,datum_row_14 ,datum_row_15 ,datum_row_16 ,datum_row_17 ,datum_row_18 ,datum_row_19 ,datum_row_20 ,datum_row_21 ,datum_row_22 ,datum_row_23 ,datum_row_24 ,datum_row_25 ,datum_row_26 ,datum_row_27 ,datum_row_28 ,datum_row_29 ,datum_row_30 ,datum_row_31 ,datum_row_32 ,datum_row_33 ,datum_row_34 ,datum_row_35 ,datum_row_36 ,datum_row_37 ,datum_row_38 ,datum_row_39 ,datum_row_40 ,datum_row_41 ,datum_row_42 ,datum_row_43 ,datum_row_44 ,datum_row_45 ,datum_row_46 ,datum_row_47 ,datum_row_48 ,datum_row_49 ,datum_row_50 ,datum_row_51 ,datum_row_52 ,datum_row_53 ,datum_row_54 ,datum_row_55 ,datum_row_56 ,datum_row_57 ,datum_row_58 ,datum_row_59 ,datum_row_60 ,datum_row_61 ,datum_row_62 ,datum_row_63 ,datum_row_64 ,datum_row_65 ,datum_row_66 ,datum_row_67 ,datum_row_68 ,datum_row_69 ,datum_row_70 ,datum_row_71 ,datum_row_72 ,datum_row_73 ,datum_row_74 ,datum_row_75 ,datum_row_76 ,datum_row_77 ,datum_row_78 ,datum_row_79 ,datum_row_80 ,datum_row_81 ,datum_row_82 ,datum_row_83 ,datum_row_84 ,datum_row_85 ,datum_row_86 ,datum_row_87 ,datum_row_88 ,datum_row_89 ,datum_row_90 ,datum_row_91 ,datum_row_92 ,datum_row_93 ,datum_row_94 ,datum_row_95 ,datum_row_96 ,datum_row_97 ,datum_row_98 ,datum_row_99 ,datum_row_100 ,datum_row_101 ,datum_row_102 ,datum_row_103 ,datum_row_104 ,datum_row_105 ,datum_row_106 ,datum_row_107 ,datum_row_108 ,datum_row_109 ,datum_row_110 ,datum_row_111 ,datum_row_112 ,datum_row_113 ,datum_row_114 ,datum_row_115 ,datum_row_116 ,datum_row_117 ,datum_row_118 ,datum_row_119 ,datum_row_120 ,datum_row_121 ,datum_row_122 ,datum_row_123 ,datum_row_124 ,datum_row_125 ,datum_row_126 ,datum_row_127 ,datum_row_128 ,datum_row_129 ,datum_row_130 ,datum_row_131 ,datum_row_132 ,datum_row_133 ,datum_row_134 ,datum_row_135 ,datum_row_136 ,datum_row_137 ,datum_row_138 ,datum_row_139 ,datum_row_140 ,datum_row_141 ,datum_row_142 ,datum_row_143 ,datum_row_144 ,datum_row_145 ,datum_row_146 ,datum_row_147 ,datum_row_148 ,datum_row_149 ,datum_row_150 ,datum_row_151 ,datum_row_152 ,datum_row_153 ,datum_row_154 ,datum_row_155 ,datum_row_156 ,datum_row_157 ,datum_row_158 ,datum_row_159 ,datum_row_160 ,datum_row_161 ,datum_row_162 ,datum_row_163 ,datum_row_164 ,datum_row_165 ,datum_row_166 ,datum_row_167 ,datum_row_168 ,datum_row_169 ,datum_row_170 ,datum_row_171 ,datum_row_172 ,datum_row_173 ,datum_row_174 ,datum_row_175 ,datum_row_176 ,datum_row_177 ,datum_row_178 ,datum_row_179 ,datum_row_180 ,datum_row_181 ,datum_row_182 ,datum_row_183 ,datum_row_184 ,datum_row_185 ,datum_row_186 ,datum_row_187 ,datum_row_188 ,datum_row_189 ,datum_row_190 ,datum_row_191 ,datum_row_192 ,datum_row_193 ,datum_row_194 ,datum_row_195 ,datum_row_196 ,datum_row_197 ,datum_row_198 ,datum_row_199 ,datum_row_200 ,datum_row_201 ,datum_row_202 ,datum_row_203 ,datum_row_204 ,datum_row_205 ,datum_row_206 ,datum_row_207 ,datum_row_208 ,datum_row_209 ,datum_row_210 ,datum_row_211 ,datum_row_212 ,datum_row_213 ,datum_row_214 ,datum_row_215 ,datum_row_216 ,datum_row_217 ,datum_row_218 ,datum_row_219 ,datum_row_220 ,datum_row_221 ,datum_row_222 ,datum_row_223 ,datum_row_224 ,datum_row_225 ,datum_row_226 ,datum_row_227 ,datum_row_228 ,datum_row_229 ,datum_row_230 ,datum_row_231 ,datum_row_232 ,datum_row_233 ,datum_row_234 ,datum_row_235 ,datum_row_236 ,datum_row_237 ,datum_row_238 ,datum_row_239 ,datum_row_240 ,datum_row_241 ,datum_row_242 ,datum_row_243 ,datum_row_244 ,datum_row_245 ,datum_row_246 ,datum_row_247 ,datum_row_248 ,datum_row_249 ,datum_row_250 ,datum_row_251 ,datum_row_252 ,datum_row_253 ,datum_row_254 ,datum_row_255 ,datum_row_256 ,datum_row_257 ,datum_row_258 ,datum_row_259 ,datum_row_260 ,datum_row_261 ,datum_row_262 ,datum_row_263 ,datum_row_264 ,datum_row_265 ,datum_row_266 ,datum_row_267 ,datum_row_268 ,datum_row_269 ,datum_row_270 ,datum_row_271 ,datum_row_272 ,datum_row_273 ,datum_row_274 ,datum_row_275 ,datum_row_276 ,datum_row_277 ,datum_row_278 ,datum_row_279 ,datum_row_280 ,datum_row_281 ,datum_row_282 ,datum_row_283 ,datum_row_284 ,datum_row_285 ,datum_row_286 ,datum_row_287 ,datum_row_288 ,datum_row_289 ,datum_row_290 ,datum_row_291 ,datum_row_292 ,datum_row_293 ,datum_row_294 ,datum_row_295 ,datum_row_296 ,datum_row_297 ,datum_row_298 ,datum_row_299 ,datum_row_300 ,datum_row_301 ,datum_row_302 ,datum_row_303 ,datum_row_304 ,datum_row_305 ,datum_row_306 ,datum_row_307 ,datum_row_308 ,datum_row_309 ,datum_row_310 ,datum_row_311 ,datum_row_312 ,datum_row_313 ,datum_row_314 ,datum_row_315 ,datum_row_316 ,datum_row_317 ,datum_row_318 ,datum_row_319 ,datum_row_320 ,datum_row_321 ,datum_row_322 ,datum_row_323 ,datum_row_324 ,datum_row_325 ,datum_row_326 ,datum_row_327 ,datum_row_328 ,datum_row_329 ,datum_row_330 ,datum_row_331 ,datum_row_332 ,datum_row_333 ,datum_row_334 ,datum_row_335 ,datum_row_336 ,datum_row_337 ,datum_row_338 ,datum_row_339 ,datum_row_340 ,datum_row_341 ,datum_row_342 ,datum_row_343 ,datum_row_344 ,datum_row_345 ,datum_row_346 ,datum_row_347 ,datum_row_348 ,datum_row_349 ,datum_row_350 ,datum_row_351 ,datum_row_352 ,datum_row_353 ,datum_row_354 ,datum_row_355 ,datum_row_356 ,datum_row_357 ,datum_row_358 ,datum_row_359 ,datum_row_360 ,datum_row_361 ,datum_row_362 ,datum_row_363 ,datum_row_364 ,datum_row_365 ,datum_row_366 ,datum_row_367 ,datum_row_368 ,datum_row_369 ,datum_row_370 ,datum_row_371 ,datum_row_372 ,datum_row_373 ,datum_row_374 ,datum_row_375 ,datum_row_376 ,datum_row_377 ,datum_row_378 ,datum_row_379 ,datum_row_380 ,datum_row_381 ,datum_row_382 ,datum_row_383 ,datum_row_384 ,datum_row_385 ,datum_row_386 ,datum_row_387 ,datum_row_388 ,datum_row_389 ,datum_row_390 ,datum_row_391 ,datum_row_392 ,datum_row_393 ,datum_row_394 ,datum_row_395 ,datum_row_396 ,datum_row_397 ,datum_row_398 ,datum_row_399 ,datum_row_400 ,datum_row_401 ,datum_row_402 ,datum_row_403 ,datum_row_404 ,datum_row_405 ,datum_row_406 ,datum_row_407 ,datum_row_408 ,datum_row_409 ,datum_row_410 ,datum_row_411 ,datum_row_412 ,datum_row_413 ,datum_row_414 ,datum_row_415 ,datum_row_416 ,datum_row_417 ,datum_row_418 ,datum_row_419 ,datum_row_420 ,datum_row_421 ,datum_row_422 ,datum_row_423 ,datum_row_424 ,datum_row_425 ,datum_row_426 ,datum_row_427 ,datum_row_428 ,datum_row_429 ,datum_row_430 ,datum_row_431 ,datum_row_432 ,datum_row_433 ,datum_row_434 ,datum_row_435 ,datum_row_436 ,datum_row_437 ,datum_row_438 ,datum_row_439 ,datum_row_440 ,datum_row_441 ,datum_row_442 ,datum_row_443 ,datum_row_444 ,datum_row_445 ,datum_row_446 ,datum_row_447 ,datum_row_448 ,datum_row_449 ,datum_row_450 ,datum_row_451 ,datum_row_452 ,datum_row_453 ,datum_row_454 ,datum_row_455 ,datum_row_456 ,datum_row_457 ,datum_row_458 ,datum_row_459 ,datum_row_460 ,datum_row_461 ,datum_row_462 ,datum_row_463 ,datum_row_464 ,datum_row_465 ,datum_row_466 ,datum_row_467 ,datum_row_468 ,datum_row_469 ,datum_row_470 ,datum_row_471 ,datum_row_472 ,datum_row_473 ,datum_row_474 ,datum_row_475 ,datum_row_476 ,datum_row_477 ,datum_row_478 ,datum_row_479 ,datum_row_480 ,datum_row_481 ,datum_row_482 ,datum_row_483 ,datum_row_484 ,datum_row_485 ,datum_row_486 ,datum_row_487 ,datum_row_488 ,datum_row_489 ,datum_row_490 ,datum_row_491 ,datum_row_492 ,datum_row_493 ,datum_row_494 ,datum_row_495 ,datum_row_496 ,datum_row_497 ,datum_row_498 ,datum_row_499 ,datum_row_500 ,datum_row_501 ,datum_row_502 ,datum_row_503 ,datum_row_504 ,datum_row_505 ,datum_row_506 ,datum_row_507 ,datum_row_508 ,datum_row_509 ,datum_row_510 ,datum_row_511 ,datum_row_512 ,datum_row_513 ,datum_row_514 ,datum_row_515 ,datum_row_516 ,datum_row_517 ,datum_row_518 ,datum_row_519 ,datum_row_520 ,datum_row_521 ,datum_row_522 ,datum_row_523 ,datum_row_524 ,datum_row_525 ,datum_row_526 ,datum_row_527 ,datum_row_528 ,datum_row_529 ,datum_row_530 ,datum_row_531 ,datum_row_532 ,datum_row_533 ,datum_row_534 ,datum_row_535 ,datum_row_536 ,datum_row_537 ,datum_row_538 ,datum_row_539 ,datum_row_540 ,datum_row_541 ,datum_row_542 ,datum_row_543 ,datum_row_544,NULL};
