/**
 * @file   feature_postprocess.c
 * 
 * <EN>
 * @brief  A sample plugin for feature vector postprocessing
 * </EN>
 * 
 * <JA>
 * @brief  ħ̤θץ饰Υץ
 * </JA>
 * 
 * @author Akinobu Lee
 * @date   Sun Aug 10 15:14:19 2008
 * 
 * $Revision: 1.1 $
 * 
 */

/**
 * Required for a file
 *   - get_plugin_info()
 *
 * Optional for a file
 *   - initialize()
 * 
 */
/**
 * Feature vector input postprocessing functions
 * 
 * Required:
 *   - fvin_postprocess()
 *   
 */

/***************************************************************************/

#include <stdio.h>
#include <string.h>
#include "plugin_defs.h"

#define PLUGIN_TITLE "feature vector postprocess plugin for Julius"

/** 
 * <EN>
 * @brief  Initialization at loading time (optional)
 * 
 * If defined, this will be called just before this plugin is loaded to Julius.
 * if this returns -1, the whole functions in this file will not be loaded.
 *
 * This function is OPTIONAL.
 * </EN>
 * <JA>
 * @brief  ɤ߹߻νǤա
 *
 * ưJulius Υץ饰ɤ߹ݤ˺ǽ˸ƤФ롥
 * -1 ֤ȡΥץ饰Τɤ߹ޤʤʤ롥
 * ¹ԲǽΥå˻Ȥ롥
 *
 * </JA>
 * 
 * 
 * @return 0 on success, -1 on failure.
 * 
 */
int
initialize()
{
  return 0;
}

/** 
 * <EN>
 * @brief  Get information of this plugin (required)
 *
 * This function should return informations of this plugin file.
 * The required info will be specified by opcode:
 *  - 0: return description string of this file into buf
 *
 * This will be called just after Julius find this file and after
 * initialize().
 *
 * @param opcode [in] requested operation code
 * @param buf [out] buffer to store the return string
 * @param buflen [in] maximum length of buf
 *
 * @return 0 on success, -1 on failure.  On failure, Julius will ignore this
 * plugin.
 * 
 * </EN>
 * <JA>
 * @brief  ץ饰ɬܡ
 *
 * Υץ饰˴ؤ֤Ϳ줿 opcode ˤäư롥
 *  - 0 ξ硤Υץ饰ե̾ΤͿ줿Хåե˳Ǽ
 *
 * δؿϡJulius Υץ饰ɤ߹ľ˸ƤФ롥
 * 
 * @param opcode [in] ׵ư ( 0 Τ߼)
 * @param buf [out] ͤǼХåե
 * @param buflen [in] buf κĹ
 * 
 * @return 顼 -1,  0 ֤顼Ȥ -1 ֤硤
 * Υץ饰Τɤ߹ޤʤ
 * </JA>
 * 
 */
int
get_plugin_info(int opcode, char *buf, int buflen)
{
  switch(opcode) {
  case 0:
    /* plugin description string */
    strncpy(buf, PLUGIN_TITLE, buflen);
    break;
  }

  return 0;
}

/** 
 * <EN>
 * @brief  Post-processing function for a feature vector
 *
 * When defined, this function will be called at every input vector
 * before recognition.  This will be called successively for every input
 * at each frame.
 *
 * You can monitor the feature vector to be recognized, and also can
 * modify or overwrite the content to do some transformation like a
 * feature-space adaptation.
 *
 * If multiple plugins have this functions, they are all executed in order
 * of loading.
 * 
 * @param vecbuf [i/o] a feature vector
 * @param veclen [in] length of @a vecbuf
 * @param nframe [in] frame number in a recognition, staring with 0.
 * 
 * </EN>
 * <JA>
 * @brief  ħ̥٥ȥФؿ
 *
 * δؿ줿硤Julius ϸġħ̥٥ȥˤĤơ
 * ǧԤˤδؿƤӽФδؿϡϤʤिӤ
 * γƥե졼ħ̥٥ȥˤĤƸƤФ롥
 *
 * δؿȤäϤħ̥٥ȥ˥ǤۤХåե
 * ǡľܽ񤭴뤳ȤǤ롥ǧϤδؿäȤ
 * ǡФƹԤΤǡ㤨üŬüΤ褦ʽ
 * ǹԤȤǽǤ롥
 *
 * ʣΥץ饰ǤδؿꤵƤ硤ɤ߹߽
 * ¹Ԥ롥
 * 
 * @param vecbuf [i/o] ħ̥٥ȥ
 * @param veclen [in] @a vecbuf Ĺ
 * @param nframe [in] ե졼ֹ
 * 
 * </JA>
 * 
 */
void
fvin_postprocess(float *vecbuf, int veclen, int nframe)
{
  int i;
  /* just output the vectors to stdout */
  printf("%d:", nframe);
  for(i=0;i<veclen;i++) {
    printf(" %f", vecbuf[i]);
  }
  printf("\n");
}
/* end of file */
