/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumUseChecker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ParameterVisitor {
    private static final boolean DEBUG = false;
    private final PartialEvaluator partialEvaluator;
    private final MemberVisitor methodCodeChecker = new AllAttributeVisitor(this);
    private final ConstantVisitor invokedMethodChecker = new ReferencedMemberVisitor(this);
    private final ConstantVisitor parameterChecker = new ReferencedMemberVisitor(new AllParameterVisitor(false, this));
    private final ClassVisitor complexEnumMarker = new OptimizationInfoClassFilter(new SimpleEnumMarker(false));
    private final ReferencedClassVisitor referencedComplexEnumMarker = new ReferencedClassVisitor(this.complexEnumMarker);
    private int invocationOffset;

    public SimpleEnumUseChecker() {
        this(new PartialEvaluator(new TypedReferenceValueFactory()));
    }

    public SimpleEnumUseChecker(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if ((programClass.getAccessFlags() & 0x2000) != 0) {
            programClass.methodsAccept(this.referencedComplexEnumMarker);
        } else {
            programClass.methodsAccept(this.methodCodeChecker);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n = codeAttribute.u4codeLength;
        for (int i = 0; i < n; ++i) {
            if (!this.partialEvaluator.isTraced(i)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, i);
            instruction.accept(clazz, method, codeAttribute, i, this);
            if (!this.partialEvaluator.isBranchOrExceptionTarget(i)) continue;
            this.checkMixedStackEntriesBefore(i);
            this.checkMixedVariablesBefore(i);
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 83: {
                if (this.isPoppingSimpleEnumType(n, 2)) break;
                this.markPoppedComplexEnumType(n);
                break;
            }
            case -80: {
                if (this.isReturningSimpleEnumType(clazz, method)) break;
                this.markPoppedComplexEnumType(n);
                break;
            }
            case -62: 
            case -61: {
                this.markPoppedComplexEnumType(n);
            }
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -77: 
            case -75: {
                this.invocationOffset = n;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.parameterChecker);
                break;
            }
            case -74: {
                String string = clazz.getRefName(constantInstruction.constantIndex);
                String string2 = clazz.getRefType(constantInstruction.constantIndex);
                int n2 = ClassUtil.internalMethodParameterSize(string2);
                if (this.isPoppingSimpleEnumType(n, n2) && !this.isSupportedMethod(string, string2)) {
                    this.markPoppedComplexEnumType(n, n2);
                }
                this.invocationOffset = n;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.parameterChecker);
                break;
            }
            case -73: 
            case -72: 
            case -71: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.invokedMethodChecker);
                this.invocationOffset = n;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.parameterChecker);
                break;
            }
            case -64: 
            case -63: {
                if (this.isPoppingExpectedType(n, clazz, constantInstruction.constantIndex)) break;
                this.markPoppedComplexEnumType(n);
                if (constantInstruction.opcode == -64 && this.isSimpleEnum(clazz) && (method.getAccessFlags() & 8) != 0 && this.isMethodSkippedForCheckcast(method.getName(clazz), method.getDescriptor(clazz))) break;
                this.markConstantComplexEnumType(clazz, constantInstruction.constantIndex);
            }
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -91: 
            case -90: {
                if (this.isPoppingIdenticalTypes(n, 0, 1)) break;
                this.markPoppedComplexEnumType(n, 0);
                this.markPoppedComplexEnumType(n, 1);
            }
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.isSimpleEnum(programClass) && this.isUnsupportedMethod(programMethod.getName(programClass), programMethod.getDescriptor(programClass))) {
            this.complexEnumMarker.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitParameter(Clazz clazz, Member member, int n, int n2, int n3, int n4, String string, Clazz clazz2) {
        int n5 = n4 - n3 - 1;
        if (ClassUtil.isInternalClassType(string) && !this.isPoppingExpectedType(this.invocationOffset, n5, ClassUtil.isInternalArrayType(string) ? string : ClassUtil.internalClassNameFromClassType(string))) {
            this.markPoppedComplexEnumType(this.invocationOffset, n5);
        }
    }

    private boolean isSupportedMethod(String string, String string2) {
        return string.equals("ordinal") && string2.equals("()I") || string.equals("clone") && string2.equals("()Ljava/lang/Object;");
    }

    private boolean isUnsupportedMethod(String string, String string2) {
        return string.equals("valueOf");
    }

    private boolean isMethodSkippedForCheckcast(String string, String string2) {
        return string.equals("valueOf") || string.equals("values");
    }

    private void checkMixedStackEntriesBefore(int n) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        int n2 = tracedStack.size();
        for (int i = 0; i < n2; ++i) {
            ReferenceValue referenceValue;
            InstructionOffsetValue instructionOffsetValue;
            int n3;
            Value value = tracedStack.getBottom(i);
            if (value.computationalType() != 5 || (n3 = (instructionOffsetValue = tracedStack.getBottomActualProducerValue(i).instructionOffsetValue()).instructionOffsetCount()) <= 1 || this.isSimpleEnumType(referenceValue = value.referenceValue())) continue;
            for (int j = 0; j < n3; ++j) {
                if (instructionOffsetValue.isExceptionHandler(j)) continue;
                int n4 = instructionOffsetValue.instructionOffset(j);
                this.markPushedComplexEnumType(n4);
            }
        }
    }

    private void checkMixedVariablesBefore(int n) {
        TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(n);
        int n2 = tracedVariables.size();
        for (int i = 0; i < n2; ++i) {
            ReferenceValue referenceValue;
            InstructionOffsetValue instructionOffsetValue;
            int n3;
            Value value = tracedVariables.getValue(i);
            if (value == null || value.computationalType() != 5 || (n3 = (instructionOffsetValue = tracedVariables.getProducerValue(i).instructionOffsetValue()).instructionOffsetCount()) <= 1 || this.isSimpleEnumType(referenceValue = value.referenceValue())) continue;
            for (int j = 0; j < n3; ++j) {
                if (instructionOffsetValue.isMethodParameter(j)) continue;
                int n4 = instructionOffsetValue.instructionOffset(j);
                this.markStoredComplexEnumType(n4, i);
            }
        }
    }

    private boolean isPoppingIdenticalTypes(int n, int n2, int n3) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        String string = tracedStack.getTop(n2).referenceValue().getType();
        String string2 = tracedStack.getTop(n3).referenceValue().getType();
        return string == null ? string2 == null : string.equals(string2);
    }

    private boolean isPoppingExpectedType(int n, Clazz clazz, int n2) {
        return this.isPoppingExpectedType(n, 0, clazz, n2);
    }

    private boolean isPoppingExpectedType(int n, int n2, Clazz clazz, int n3) {
        return this.isPoppingExpectedType(n, n2, clazz.getClassName(n3));
    }

    private boolean isPoppingExpectedType(int n, int n2, String string) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        String string2 = tracedStack.getTop(n2).referenceValue().getType();
        return string.equals(string2);
    }

    private boolean isReturningSimpleEnumType(Clazz clazz, Method method) {
        Clazz[] clazzArray;
        String string = method.getDescriptor(clazz);
        String string2 = ClassUtil.internalMethodReturnType(string);
        if (ClassUtil.isInternalClassType(string2) && (clazzArray = ((ProgramMethod)method).referencedClasses) != null) {
            Clazz clazz2 = clazzArray[clazzArray.length - 1];
            return this.isSimpleEnum(clazz2);
        }
        return false;
    }

    private boolean isPoppingSimpleEnumType(int n) {
        return this.isPoppingSimpleEnumType(n, 0);
    }

    private boolean isPoppingSimpleEnumType(int n, int n2) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(n).getTop(n2).referenceValue();
        return this.isSimpleEnumType(referenceValue);
    }

    private boolean isSimpleEnumType(ReferenceValue referenceValue) {
        return this.isSimpleEnum(referenceValue.getReferencedClass());
    }

    private boolean isSimpleEnum(Clazz clazz) {
        return clazz != null && SimpleEnumMarker.isSimpleEnum(clazz);
    }

    private void markConstantComplexEnumType(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this.referencedComplexEnumMarker);
    }

    private void markPoppedComplexEnumType(int n) {
        this.markPoppedComplexEnumType(n, 0);
    }

    private void markPoppedComplexEnumType(int n, int n2) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(n).getTop(n2).referenceValue();
        this.markComplexEnumType(referenceValue);
    }

    private void markPushedComplexEnumType(int n) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackAfter(n).getTop(0).referenceValue();
        this.markComplexEnumType(referenceValue);
    }

    private void markStoredComplexEnumType(int n, int n2) {
        ReferenceValue referenceValue = this.partialEvaluator.getVariablesAfter(n).getValue(n2).referenceValue();
        this.markComplexEnumType(referenceValue);
    }

    private void markComplexEnumType(ReferenceValue referenceValue) {
        Clazz clazz = referenceValue.getReferencedClass();
        if (clazz != null) {
            clazz.accept(this.complexEnumMarker);
        }
    }
}

