/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.analysis;

import java.util.HashMap;
import org.broadinstitute.sting.utils.analysis.AminoAcid;

public class AminoAcidTable {
    public HashMap<String, AminoAcid> tableByCodon = new HashMap(21);
    public HashMap<String, AminoAcid> tableByCode = new HashMap(21);

    public AminoAcidTable() {
        for (AminoAcid acid : AminoAcid.values()) {
            this.tableByCode.put(acid.getCode(), acid);
            for (String codon : acid.codons) {
                this.tableByCodon.put(codon, acid);
            }
        }
    }

    public AminoAcid getEukaryoticAA(String codon) {
        return this.tableByCodon.get(codon.toUpperCase());
    }

    public AminoAcid getMitochondrialAA(String codon, boolean isFirst) {
        String upperCodon = codon.toUpperCase();
        if (isFirst && upperCodon.equals("ATT") || upperCodon.equals("ATA")) {
            return AminoAcid.Methionine;
        }
        if (upperCodon.equals("AGA") || upperCodon.equals("AGG")) {
            return AminoAcid.Stop_codon;
        }
        if (upperCodon.equals("TGA")) {
            return AminoAcid.Tryptophan;
        }
        return this.tableByCodon.get(upperCodon);
    }

    public AminoAcid getAminoAcidByCode(String code) {
        return this.tableByCode.get(code);
    }
}

