/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.AnalyzeString;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.regex.JRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class XSLAnalyzeString
extends StyleElement {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private StyleElement matching;
    private StyleElement nonMatching;
    private RegularExpression pattern;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainFallback() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        String regexAtt = null;
        String flagsAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("regex")) {
                regexAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("flags")) {
                flagsAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
            selectAtt = ".";
        }
        this.select = this.makeExpression(selectAtt);
        if (regexAtt == null) {
            this.reportAbsence("regex");
            regexAtt = "xxx";
        }
        this.regex = this.makeAttributeValueTemplate(regexAtt);
        if (flagsAtt == null) {
            flagsAtt = "";
        }
        this.flags = this.makeAttributeValueTemplate(flagsAtt);
        if (this.regex instanceof StringLiteral && this.flags instanceof StringLiteral) {
            try {
                Platform platform = Configuration.getPlatform();
                String regex = ((StringLiteral)this.regex).getStringValue();
                String flagstr = ((StringLiteral)this.flags).getStringValue();
                int xmlVersion = this.getConfiguration().getXMLVersion();
                int flagBits = JRegularExpression.setFlags(flagstr);
                this.pattern = new JRegularExpression(regex, xmlVersion, 0, flagBits);
                if (this.pattern.matches("")) {
                    this.invalidRegex("The regular expression must not be one that matches a zero-length string", "XTDE1150");
                }
            }
            catch (XPathException err) {
                if ("FORX0001".equals(err.getErrorCodeLocalPart())) {
                    this.invalidRegex("Error in regular expression flags: " + err, "XTDE1145");
                }
                this.invalidRegex("Error in regular expression: " + err, "XTDE1140");
            }
        }
    }

    private void invalidRegex(String message, String errorCode) throws XPathException {
        this.compileError(message, errorCode);
        Platform platform = Configuration.getPlatform();
        int xmlVersion = this.getConfiguration().getXMLVersion();
        int flagBits = JRegularExpression.setFlags("");
        this.pattern = new JRegularExpression("x", xmlVersion, 0, flagBits);
    }

    public void validate() throws XPathException {
        NodeInfo curr;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = (NodeInfo)kids.next()) != null) {
            if (curr instanceof XSLFallback) continue;
            if (curr instanceof XSLMatchingSubstring) {
                boolean b = curr.getLocalPart().equals("matching-substring");
                if (b) {
                    if (this.matching != null) {
                        this.compileError("xsl:matching-substring element must only appear once", "XTSE0010");
                    }
                    this.matching = (StyleElement)curr;
                    continue;
                }
                if (this.nonMatching != null) {
                    this.compileError("xsl:non-matching-substring element must only appear once", "XTSE0010");
                }
                this.nonMatching = (StyleElement)curr;
                continue;
            }
            this.compileError("Only xsl:matching-substring and xsl:non-matching-substring are allowed here", "XTSE0010");
        }
        if (this.matching == null && this.nonMatching == null) {
            this.compileError("At least one xsl:matching-substring or xsl:non-matching-substring element must be present", "XTSE1130");
        }
        this.select = this.typeCheck("select", this.select);
        this.regex = this.typeCheck("regex", this.regex);
        this.flags = this.typeCheck("flags", this.flags);
        try {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:analyze-string/select"), 0);
            ExpressionLocation locator = new ExpressionLocation(this);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, role, visitor);
            role = new RoleLocator(4, (Serializable)((Object)"xsl:analyze-string/regex"), 0);
            this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, role, visitor);
            role = new RoleLocator(4, (Serializable)((Object)"xsl:analyze-string/flags"), 0);
            this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, role, visitor);
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        Expression matchingBlock = null;
        if (this.matching != null) {
            matchingBlock = this.matching.compileSequenceConstructor(exec, this.matching.iterateAxis((byte)3), false);
        }
        Expression nonMatchingBlock = null;
        if (this.nonMatching != null) {
            nonMatchingBlock = this.nonMatching.compileSequenceConstructor(exec, this.nonMatching.iterateAxis((byte)3), false);
        }
        try {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            return new AnalyzeString(this.select, this.regex, this.flags, matchingBlock == null ? null : matchingBlock.simplify(visitor), nonMatchingBlock == null ? null : nonMatchingBlock.simplify(visitor), this.pattern);
        }
        catch (XPathException e) {
            this.compileError(e);
            return null;
        }
    }
}

