/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.type.BuiltInAtomicType;

public abstract class AbstractStaticContext
implements StaticContext {
    private String baseURI = null;
    private Configuration config;
    private LocationMap locationMap = new LocationMap();
    private Executable executable;
    private String defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
    private String defaultElementNamespace = "";
    private boolean backwardsCompatible = false;

    protected void setConfiguration(Configuration config) {
        this.config = config;
        this.executable = new Executable(config);
        this.executable.setHostLanguage(54);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    protected final void setDefaultFunctionLibrary() {
        FunctionLibraryList lib = new FunctionLibraryList();
        lib.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(0));
        lib.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        if (this.config.isAllowExternalFunctions()) {
            Configuration.getPlatform().addFunctionLibraries(lib, this.config);
        }
        this.setFunctionLibrary(lib);
    }

    protected final void addFunctionLibrary(FunctionLibrary library) {
        FunctionLibrary libraryList = this.executable.getFunctionLibrary();
        if (!(libraryList instanceof FunctionLibraryList)) {
            throw new IllegalStateException("Registered function library cannot be extended");
        }
        ((FunctionLibraryList)libraryList).addFunctionLibrary(library);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public int getHostLanguage() {
        return 54;
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.executable.getCollationTable());
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.executable.getFunctionLibrary();
    }

    public void setFunctionLibrary(FunctionLibrary lib) {
        this.executable.setFunctionLibrary(lib);
    }

    public void declareCollation(String name, StringCollator comparator, boolean isDefault) {
        CollationMap collations = this.executable.getCollationTable();
        collations.setNamedCollation(name, comparator);
        if (isDefault) {
            collations.setDefaultCollationName(name);
        }
    }

    public StringCollator getCollation(String name) {
        return this.executable.getCollationTable().getNamedCollation(name);
    }

    public String getDefaultCollationName() {
        return this.executable.getCollationTable().getDefaultCollationName();
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void issueWarning(String s, SourceLocator locator) {
        System.err.println("Warning: " + s);
    }

    public String getSystemId() {
        return "";
    }

    public int getLineNumber() {
        return -1;
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setBackwardsCompatibilityMode(boolean compatible) {
        this.backwardsCompatible = compatible;
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.backwardsCompatible;
    }

    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return true;
    }

    public LocationProvider getLocationProvider() {
        return this.locationMap;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        throw new UnsupportedOperationException();
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }
}

