.TH MPOST 1 "5 April 2011" "MetaPost 1.504"
.\"=====================================================================
.de URL
\\$2 \(laURL: \\$1 \(ra\\$3
..
.if \n[.g] .mso www.tmac
.if n .ds MP MetaPost
.if t .ds MP MetaPost
.if n .ds MF Metafont
.if t .ds MF M\s-2ETAFONT\s0
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP for troff
.el .ds OX TeX for nroff
.\" the same but obliqued
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
mpost \- MetaPost, a system for creating graphics
.SH SYNOPSIS
.B mpost
.RI [ options ]
.RI [ commands ]
.PP
.B mpost 
.B --dvitomp
.IR dvifile [\fB.dvi\fP]
.RI [ mpxfile [\fB.mpx\fP]]

.\"=====================================================================
.SH DESCRIPTION
\*(MP interprets the \*(MP language and produces PostScript (EPS)
or Scalable Vector Graphics (SVG) pictures.  The \*(MP language is similar 
to Knuth's \*(MF with additional features for including
.BR tex (1)
or
.BR troff (1)
commands and accessing features of PostScript not found in \*(MF. 
.PP
\*(MP is normally used with some preloaded macros, and it 
will use its executable name as the name of the preload 
file to use.   For example, when called as
.B mpost
the
.I mpost.mp
file is used, which is identical to
.I plain.mp.
When the
.B --ini
option is given, preloading does not happen.  
.PP
The
.I commands
given on the command line to the \*(MP program are passed to it as the
first input line.  (But it is often easier to type extended arguments
as the first input line, since UNIX shells tend to gobble up or
misinterpret \*(MP's favorite symbols, like semicolons, unless you
quote them.) The normal usage is to say
.I mpost figs
to process the file
.IR figs.mp .
The basename of
.I figs
becomes the ``jobname'',
and is used in forming output file names.  If no file is named, the
jobname becomes
.IR mpout .
The default extension,
.IR .mp ,
can be overridden by specifying an extension explicitly.
.PP
When the
.B --dvitomp
option is given, \*(MP acts as DVI-to-MPX converter only.
See dvitomp (1) for details.
.PP
This manual page is not meant to be exhaustive.  The complete
documentation for this version of \*(MP can be found in the
User Manual that should have been installed along with the program and
is also available from http://tug.org/metapost.
See the FILES section below.
.PP
The \*(MP language is similar to \*(MF, but the manual
assumes no knowledge of \*(MF.  \*(MP does not have bitmap
output commands or \*(MF's online display mechanism.

.\"=====================================================================
.SH FILES
.TP
.I plain.mp
The standard preload file.
.TP
.I mfplain.mp
The \*(MF-compatible preload file. 
.TP
.I $TEXMFMAIN/metapost/base/*.mp
The standard \*(MP macros included in the original distribution.
.TP
.I $TEXMFMAIN/metapost/support/*
Various tables for handling included
.I tex
and
.IR troff .
.TP
.I $TEXMFMAIN/metapost/support/trfonts.map
Table of corresponding font names for
.I troff 
and PostScript.
.TP
.I psfonts.map
Table of corresponding font names for
.I tex
and PostScript.
.TP
.I $TEXMFMAIN/doc/metapost/*
The \*(MP manual and tutorial source, also including sample figures
.\"=====================================================================
.SH "SUGGESTED READING"
Donald E. Knuth,
.I "The \*(MF\^book"
(Volume C of
.IR "Computers and Typesetting" ),
Addison-Wesley, 1986, ISBN 0-201-13445-4.
.br
.I TUGboat
(the journal of the \*(TX Users Group).
.\"=====================================================================
.SH "SEE ALSO"
.PP
.BR dvitomp (1),
.BR epstopdf (1),
.BR mf (1),
.BR mptopdf (1),
.BR tex (1),
.PP
.URL "http://foundry.supelec.fr/gf/project/metapost/" "MetaPost source code" .
.br
.URL "http://tug.org/metapost/" "MetaPost home page" .
.\"=====================================================================
.SH AUTHORS
\*(MP was designed by John D. Hobby, incorporating algorithms from 
\*(MF by Donald E. Knuth.  It was originally implemented on Unix,
incorporating system-dependent routines from
.BR web2c ,
while not relying on it except for the actual \*(WB-to-C translator.
.PP
Ulrik Vieth adapted \*(MP to take advantage of the advanced path 
searching features in more recent versions of
.B web2c
and worked towards fully integrating \*(MP into the canonical Unix 
\*(TX distribution.
.PP
The current, CWEB based version of MetaPost is maintained by 
Taco Hoekwater.
.PP
The manual and tutorial are maintained by Stephan Hennig and
Troy Henderson.
.\"=====================================================================
.SH BUGS
Email bug reports to metapost@tug.org.
