RabbitMQ `3.9.8` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.1.2 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

* When the mandatory flag was used when publishing to classic queues,
  but publisher confirms were not, channels memory usage would grow indefinitely.

  GitHub issue: [#3560](https://github.com/rabbitmq/rabbitmq-server/issues/3560)

* `rabbitmq-diagnostics memory_breakdown` failed to read memory of connection
  reader, writer and channel processes.

  GitHub issue: [#3570](https://github.com/rabbitmq/rabbitmq-server/issues/3570)

* In some environments, Stream replicas advertised IP addresses that could not be reached by cluster peers
  (eg. IP addresses behind a NAT in a Docker deployment). RabbitMQ node hostnames are now advertised as well
  so that other peers can resolve them to get an externally visible IP address.

  GitHub issue: [rabbitmq/osiris#53](https://github.com/rabbitmq/osiris/issues/53)


### Prometheus Plugin

#### Enhancements

 * More data is exposed via the `GET /metrics/detailed` endpoint.

   GitHub issue: [#3520](https://github.com/rabbitmq/rabbitmq-server/pull/3520)


### Management Plugin

#### Bug Fixes

 * When setting topic permissions, the list of exchanges in the UI now honors the
   currently selected virtual host.

   Contributed by @LuisCusihuaman.

   GitHub issue: [#3545](https://github.com/rabbitmq/rabbitmq-server/pull/3545)


### AWS Peer Discovery Plugin

#### Enhancements

 * The plugin now logs more details for failed AWS API requests.

   Contributed by @tvhong-amazon (AWS)

   GitHub issue: [#3579](https://github.com/rabbitmq/rabbitmq-server/pull/3579)


### Web STOMP Plugin

#### Enhancements

 * STOMP-over-WebSockets connections now can consume from [streams](https://rabbitmq.com/streams.html).

   GitHub issue: [#3509](https://github.com/rabbitmq/rabbitmq-server/pull/3509)


## Dependency Upgrades

* Osiris was [upgraded to `1.2.2`](https://github.com/rabbitmq/osiris/compare/v1.2.0...v1.2.2)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.8.tar.xz` instead of the source tarball produced by GitHub.
