/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.OutputUtils;
import org.apache.jena.atlas.io.StringWriterI;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.Hex;

public class EscapeStr {
    public static String stringEsc(String s) {
        StringWriterI w = new StringWriterI();
        EscapeStr.stringEsc(w, s, '\"', true, CharSpace.UTF8);
        return ((Object)w).toString();
    }

    public static void stringEsc(AWriter out, String s, boolean asciiOnly) {
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                out.print('\\');
                out.print(c);
                continue;
            }
            switch (c) {
                case '\n': {
                    out.print("\\n");
                    continue block6;
                }
                case '\t': {
                    out.print("\\t");
                    continue block6;
                }
                case '\r': {
                    out.print("\\r");
                    continue block6;
                }
                case '\f': {
                    out.print("\\f");
                    continue block6;
                }
                default: {
                    if (!asciiOnly) {
                        out.print(c);
                        continue block6;
                    }
                    EscapeStr.writeCharAsASCII(out, c);
                }
            }
        }
    }

    public static void stringEsc(AWriter out, String s, char quoteChar, boolean singleLineString) {
        EscapeStr.stringEsc(out, s, quoteChar, singleLineString, CharSpace.UTF8);
    }

    /*
     * Unable to fully structure code
     */
    public static void stringEsc(AWriter out, String s, char quoteChar, boolean singleLineString, CharSpace charSpace) {
        ascii = CharSpace.ASCII == charSpace;
        len = s.length();
        quotesInARow = 0;
        block6: for (i = 0; i < len; ++i) {
            block13: {
                c = s.charAt(i);
                if (c == '\\') {
                    out.print('\\');
                    out.print(c);
                    continue;
                }
                if (singleLineString) break block13;
                if (c == quoteChar) {
                    if (++quotesInARow == 3) {
                        out.print("\\");
                        out.print(quoteChar);
                        quotesInARow = 0;
                        continue;
                    }
                } else {
                    quotesInARow = 0;
                }
                ** GOTO lbl-1000
            }
            if (c == quoteChar) {
                out.print("\\");
                out.print(c);
                continue;
            }
            switch (c) {
                case '\n': {
                    out.print("\\n");
                    continue block6;
                }
                case '\t': {
                    out.print("\\t");
                    continue block6;
                }
                case '\r': {
                    out.print("\\r");
                    continue block6;
                }
                case '\f': {
                    out.print("\\f");
                    continue block6;
                }
                default: lbl-1000:
                // 3 sources

                {
                    if (!ascii) {
                        out.print(c);
                        continue block6;
                    }
                    EscapeStr.writeCharAsASCII(out, c);
                }
            }
        }
    }

    public static void writeASCII(AWriter out, String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            EscapeStr.writeCharAsASCII(out, c);
        }
    }

    public static void writeCharAsASCII(AWriter out, char c) {
        if (c >= ' ' && c < '\u007f') {
            out.print(c);
        } else {
            out.print("\\u");
            OutputUtils.printHex(out, (int)c, 4);
        }
    }

    public static String unescapeStr(String s) {
        return EscapeStr.unescapeStr(s, '\\');
    }

    public static String unescapeStr(String s, char escapeChar) {
        return EscapeStr.unescape(s, escapeChar, false);
    }

    public static String unescape(String s, char escape, boolean pointCodeOnly) {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= s.length() - 1) {
                    throw new AtlasException("Illegal escape at end of string");
                }
                char ch2 = s.charAt(i + 1);
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= s.length()) {
                        throw new AtlasException("\\u escape too short");
                    }
                    x = Hex.hexStringToInt(s, i + 1, 4);
                    sb.append((char)x);
                    i += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= s.length()) {
                        throw new AtlasException("\\U escape too short");
                    }
                    x = Hex.hexStringToInt(s, i + 1, 8);
                    sb.append((char)x);
                    i += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            throw new AtlasException("Unknown escape: \\" + ch2);
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

