// RUN: llvm-mc -arch=amdgcn -mcpu=gfx906 -show-encoding %s | FileCheck %s

//
// VOP2 Instructions.
//

// CHECK: encoding: [0x01,0x05,0x0a,0x76]
v_fmac_f32 v5, v1, v2
// CHECK: encoding: [0x01,0x05,0xfe,0x77]
v_fmac_f32 v255, v1, v2
// CHECK: encoding: [0xff,0x05,0x0a,0x76]
v_fmac_f32 v5, v255, v2
// CHECK: encoding: [0x01,0x04,0x0a,0x76]
v_fmac_f32 v5, s1, v2
// CHECK: encoding: [0x65,0x04,0x0a,0x76]
v_fmac_f32 v5, s101, v2
// CHECK: encoding: [0x66,0x04,0x0a,0x76]
v_fmac_f32 v5, flat_scratch_lo, v2
// CHECK: encoding: [0x67,0x04,0x0a,0x76]
v_fmac_f32 v5, flat_scratch_hi, v2
// CHECK: encoding: [0x6a,0x04,0x0a,0x76]
v_fmac_f32 v5, vcc_lo, v2
// CHECK: encoding: [0x6b,0x04,0x0a,0x76]
v_fmac_f32 v5, vcc_hi, v2
// CHECK: encoding: [0x7c,0x04,0x0a,0x76]
v_fmac_f32 v5, m0, v2
// CHECK: encoding: [0x7e,0x04,0x0a,0x76]
v_fmac_f32 v5, exec_lo, v2
// CHECK: encoding: [0x7f,0x04,0x0a,0x76]
v_fmac_f32 v5, exec_hi, v2
// CHECK: encoding: [0x80,0x04,0x0a,0x76]
v_fmac_f32 v5, 0, v2
// CHECK: encoding: [0xc1,0x04,0x0a,0x76]
v_fmac_f32 v5, -1, v2
// CHECK: encoding: [0xf0,0x04,0x0a,0x76]
v_fmac_f32 v5, 0.5, v2
// CHECK: encoding: [0xf7,0x04,0x0a,0x76]
v_fmac_f32 v5, -4.0, v2
// CHECK: encoding: [0xff,0x04,0x0a,0x76,0x56,0x34,0x12,0xaf]
v_fmac_f32 v5, 0xaf123456, v2
// CHECK: encoding: [0xff,0x04,0x0a,0x76,0x73,0x72,0x71,0x3f]
v_fmac_f32 v5, 0x3f717273, v2
// CHECK: encoding: [0x01,0xff,0x0b,0x76]
v_fmac_f32 v5, v1, v255

// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x02,0x00]
v_fmac_f32_e64 v5, v1, v2
// CHECK: encoding: [0xff,0x00,0x3b,0xd1,0x01,0x05,0x02,0x00]
v_fmac_f32_e64 v255, v1, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0xff,0x05,0x02,0x00]
v_fmac_f32_e64 v5, v255, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x04,0x02,0x00]
v_fmac_f32_e64 v5, s1, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x65,0x04,0x02,0x00]
v_fmac_f32_e64 v5, s101, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x66,0x04,0x02,0x00]
v_fmac_f32_e64 v5, flat_scratch_lo, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x67,0x04,0x02,0x00]
v_fmac_f32_e64 v5, flat_scratch_hi, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x6a,0x04,0x02,0x00]
v_fmac_f32_e64 v5, vcc_lo, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x6b,0x04,0x02,0x00]
v_fmac_f32_e64 v5, vcc_hi, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x7c,0x04,0x02,0x00]
v_fmac_f32_e64 v5, m0, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x7e,0x04,0x02,0x00]
v_fmac_f32_e64 v5, exec_lo, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x7f,0x04,0x02,0x00]
v_fmac_f32_e64 v5, exec_hi, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x80,0x04,0x02,0x00]
v_fmac_f32_e64 v5, 0, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0xc1,0x04,0x02,0x00]
v_fmac_f32_e64 v5, -1, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0xf0,0x04,0x02,0x00]
v_fmac_f32_e64 v5, 0.5, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0xf7,0x04,0x02,0x00]
v_fmac_f32_e64 v5, -4.0, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xff,0x03,0x00]
v_fmac_f32_e64 v5, v1, v255
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x00,0x00]
v_fmac_f32_e64 v5, v1, s2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xcb,0x00,0x00]
v_fmac_f32_e64 v5, v1, s101
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xcd,0x00,0x00]
v_fmac_f32_e64 v5, v1, flat_scratch_lo
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xcf,0x00,0x00]
v_fmac_f32_e64 v5, v1, flat_scratch_hi
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xd5,0x00,0x00]
v_fmac_f32_e64 v5, v1, vcc_lo
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xd7,0x00,0x00]
v_fmac_f32_e64 v5, v1, vcc_hi
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xf9,0x00,0x00]
v_fmac_f32_e64 v5, v1, m0
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xfd,0x00,0x00]
v_fmac_f32_e64 v5, v1, exec_lo
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xff,0x00,0x00]
v_fmac_f32_e64 v5, v1, exec_hi
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x01,0x01,0x00]
v_fmac_f32_e64 v5, v1, 0
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x83,0x01,0x00]
v_fmac_f32_e64 v5, v1, -1
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xe1,0x01,0x00]
v_fmac_f32_e64 v5, v1, 0.5
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0xef,0x01,0x00]
v_fmac_f32_e64 v5, v1, -4.0
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x02,0x20]
v_fmac_f32_e64 v5, -v1, v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x02,0x40]
v_fmac_f32_e64 v5, v1, -v2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x02,0x60]
v_fmac_f32_e64 v5, -v1, -v2
// CHECK: encoding: [0x05,0x01,0x3b,0xd1,0x01,0x05,0x02,0x00]
v_fmac_f32_e64 v5, |v1|, v2
// CHECK: encoding: [0x05,0x02,0x3b,0xd1,0x01,0x05,0x02,0x00]
v_fmac_f32_e64 v5, v1, |v2|
// CHECK: encoding: [0x05,0x03,0x3b,0xd1,0x01,0x05,0x02,0x00]
v_fmac_f32_e64 v5, |v1|, |v2|
// CHECK: encoding: [0x05,0x80,0x3b,0xd1,0x01,0x05,0x02,0x00]
v_fmac_f32_e64 v5, v1, v2 clamp
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x02,0x08]
v_fmac_f32_e64 v5, v1, v2 mul:2
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x02,0x10]
v_fmac_f32_e64 v5, v1, v2 mul:4
// CHECK: encoding: [0x05,0x00,0x3b,0xd1,0x01,0x05,0x02,0x18]
v_fmac_f32_e64 v5, v1, v2 div:2

// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x00]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0xfe,0x77,0x01,0xe4,0x00,0x00]
v_fmac_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0xff,0xe4,0x00,0x00]
v_fmac_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0xfe,0x0b,0x76,0x01,0xe4,0x00,0x00]
v_fmac_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x1b,0x00,0x00]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x40,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x41,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x42,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x43,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x30,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x34,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x38,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x3c,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x01,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x0f,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x11,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x1f,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x21,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0x2f,0x01,0x00]
v_fmac_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x10]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x30]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0xf0]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0xf0]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x01]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x03]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x0f]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x00,0x0f]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x08,0x00]
v_fmac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x10,0x00]
v_fmac_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x20,0x00]
v_fmac_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x40,0x00]
v_fmac_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x76,0x01,0xe4,0x80,0x00]
v_fmac_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0x01,0x05,0x0a,0x7a]
v_xnor_b32 v5, v1, v2
// CHECK: encoding: [0x01,0x05,0xfe,0x7b]
v_xnor_b32 v255, v1, v2
// CHECK: encoding: [0xff,0x05,0x0a,0x7a]
v_xnor_b32 v5, v255, v2
// CHECK: encoding: [0x01,0x04,0x0a,0x7a]
v_xnor_b32 v5, s1, v2
// CHECK: encoding: [0x65,0x04,0x0a,0x7a]
v_xnor_b32 v5, s101, v2
// CHECK: encoding: [0x66,0x04,0x0a,0x7a]
v_xnor_b32 v5, flat_scratch_lo, v2
// CHECK: encoding: [0x67,0x04,0x0a,0x7a]
v_xnor_b32 v5, flat_scratch_hi, v2
// CHECK: encoding: [0x6a,0x04,0x0a,0x7a]
v_xnor_b32 v5, vcc_lo, v2
// CHECK: encoding: [0x6b,0x04,0x0a,0x7a]
v_xnor_b32 v5, vcc_hi, v2
// CHECK: encoding: [0x7c,0x04,0x0a,0x7a]
v_xnor_b32 v5, m0, v2
// CHECK: encoding: [0x7e,0x04,0x0a,0x7a]
v_xnor_b32 v5, exec_lo, v2
// CHECK: encoding: [0x7f,0x04,0x0a,0x7a]
v_xnor_b32 v5, exec_hi, v2
// CHECK: encoding: [0x80,0x04,0x0a,0x7a]
v_xnor_b32 v5, 0, v2
// CHECK: encoding: [0xc1,0x04,0x0a,0x7a]
v_xnor_b32 v5, -1, v2
// CHECK: encoding: [0xf0,0x04,0x0a,0x7a]
v_xnor_b32 v5, 0.5, v2
// CHECK: encoding: [0xf7,0x04,0x0a,0x7a]
v_xnor_b32 v5, -4.0, v2
// CHECK: encoding: [0xff,0x04,0x0a,0x7a,0x56,0x34,0x12,0xaf]
v_xnor_b32 v5, 0xaf123456, v2
// CHECK: encoding: [0xff,0x04,0x0a,0x7a,0x73,0x72,0x71,0x3f]
v_xnor_b32 v5, 0x3f717273, v2
// CHECK: encoding: [0x01,0xff,0x0b,0x7a]
v_xnor_b32 v5, v1, v255

// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0x05,0x02,0x00]
v_xnor_b32_e64 v5, v1, v2
// CHECK: encoding: [0xff,0x00,0x3d,0xd1,0x01,0x05,0x02,0x00]
v_xnor_b32_e64 v255, v1, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0xff,0x05,0x02,0x00]
v_xnor_b32_e64 v5, v255, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0x04,0x02,0x00]
v_xnor_b32_e64 v5, s1, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x65,0x04,0x02,0x00]
v_xnor_b32_e64 v5, s101, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x66,0x04,0x02,0x00]
v_xnor_b32_e64 v5, flat_scratch_lo, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x67,0x04,0x02,0x00]
v_xnor_b32_e64 v5, flat_scratch_hi, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x6a,0x04,0x02,0x00]
v_xnor_b32_e64 v5, vcc_lo, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x6b,0x04,0x02,0x00]
v_xnor_b32_e64 v5, vcc_hi, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x7c,0x04,0x02,0x00]
v_xnor_b32_e64 v5, m0, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x7e,0x04,0x02,0x00]
v_xnor_b32_e64 v5, exec_lo, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x7f,0x04,0x02,0x00]
v_xnor_b32_e64 v5, exec_hi, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x80,0x04,0x02,0x00]
v_xnor_b32_e64 v5, 0, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0xc1,0x04,0x02,0x00]
v_xnor_b32_e64 v5, -1, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0xf0,0x04,0x02,0x00]
v_xnor_b32_e64 v5, 0.5, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0xf7,0x04,0x02,0x00]
v_xnor_b32_e64 v5, -4.0, v2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xff,0x03,0x00]
v_xnor_b32_e64 v5, v1, v255
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0x05,0x00,0x00]
v_xnor_b32_e64 v5, v1, s2
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xcb,0x00,0x00]
v_xnor_b32_e64 v5, v1, s101
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xcd,0x00,0x00]
v_xnor_b32_e64 v5, v1, flat_scratch_lo
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xcf,0x00,0x00]
v_xnor_b32_e64 v5, v1, flat_scratch_hi
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xd5,0x00,0x00]
v_xnor_b32_e64 v5, v1, vcc_lo
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xd7,0x00,0x00]
v_xnor_b32_e64 v5, v1, vcc_hi
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xf9,0x00,0x00]
v_xnor_b32_e64 v5, v1, m0
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xfd,0x00,0x00]
v_xnor_b32_e64 v5, v1, exec_lo
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xff,0x00,0x00]
v_xnor_b32_e64 v5, v1, exec_hi
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0x01,0x01,0x00]
v_xnor_b32_e64 v5, v1, 0
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0x83,0x01,0x00]
v_xnor_b32_e64 v5, v1, -1
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xe1,0x01,0x00]
v_xnor_b32_e64 v5, v1, 0.5
// CHECK: encoding: [0x05,0x00,0x3d,0xd1,0x01,0xef,0x01,0x00]
v_xnor_b32_e64 v5, v1, -4.0

// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0xfe,0x7b,0x01,0x06,0x06,0x06]
v_xnor_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0xff,0x06,0x06,0x06]
v_xnor_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, s1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x65,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, s101, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x66,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, flat_scratch_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x67,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, flat_scratch_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x6a,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, vcc_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x6b,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, vcc_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x7c,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, m0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x7e,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, exec_lo, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x7f,0x06,0x86,0x06]
v_xnor_b32_sdwa v5, exec_hi, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0xfe,0x0b,0x7a,0x01,0x06,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x00,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x01,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x02,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x03,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x04,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x05,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x0e,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x16,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x16,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x00,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x01,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x02,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x03,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x04,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x05,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x0e,0x06]
v_xnor_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x06]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x00]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x01]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x02]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x03]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x04]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x05]
v_xnor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: encoding: [0xf9,0x04,0x0a,0x7a,0x01,0x06,0x06,0x0e]
v_xnor_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD

//
// VOP3P Instructions.
//

// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3
// CHECK: encoding: [0x00,0x40,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3
// CHECK: encoding: [0x00,0x40,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3
// CHECK: encoding: [0x00,0x40,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3
// CHECK: encoding: [0x00,0x40,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3
// CHECK: encoding: [0x00,0x40,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3
// CHECK: encoding: [0x00,0x40,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3

//
// Test op_sel/op_sel_hi.
//

// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,0]
// CHECK: encoding: [0x00,0x50,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,1]
// CHECK: encoding: [0x00,0x48,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,0]
// CHECK: encoding: [0x00,0x58,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,1]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x10,0xa3,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x10,0xa3,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x10,0xa3,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x10,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x08,0xa3,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x08,0xa3,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x08,0xa3,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x08,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x18,0xa3,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x18,0xa3,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x18,0xa3,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x18,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x40,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,0]
// CHECK: encoding: [0x00,0x50,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,1]
// CHECK: encoding: [0x00,0x48,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,0]
// CHECK: encoding: [0x00,0x58,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,1]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x10,0xa6,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x10,0xa6,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x10,0xa6,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x10,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x08,0xa6,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x08,0xa6,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x08,0xa6,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x08,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x18,0xa6,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x18,0xa6,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x18,0xa6,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x18,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x40,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,0]
// CHECK: encoding: [0x00,0x50,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,1]
// CHECK: encoding: [0x00,0x48,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,0]
// CHECK: encoding: [0x00,0x58,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,1]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x10,0xa7,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x10,0xa7,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x10,0xa7,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x10,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x08,0xa7,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x08,0xa7,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x08,0xa7,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x08,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x18,0xa7,0xd3,0x01,0x05,0x0e,0x04]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x18,0xa7,0xd3,0x01,0x05,0x0e,0x14]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x18,0xa7,0xd3,0x01,0x05,0x0e,0x0c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x18,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x40,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,0]
// CHECK: encoding: [0x00,0x50,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,1]
// CHECK: encoding: [0x00,0x48,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,0]
// CHECK: encoding: [0x00,0x58,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,1]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x10,0xa8,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x10,0xa8,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x10,0xa8,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x10,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x08,0xa8,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x08,0xa8,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x08,0xa8,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x08,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x18,0xa8,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x18,0xa8,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x18,0xa8,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x18,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x40,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,0]
// CHECK: encoding: [0x00,0x50,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,1]
// CHECK: encoding: [0x00,0x48,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,0]
// CHECK: encoding: [0x00,0x58,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,1]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x10,0xa9,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x10,0xa9,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x10,0xa9,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x10,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x08,0xa9,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x08,0xa9,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x08,0xa9,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x08,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x18,0xa9,0xd3,0x01,0x05,0x0e,0x04]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x18,0xa9,0xd3,0x01,0x05,0x0e,0x14]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x18,0xa9,0xd3,0x01,0x05,0x0e,0x0c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x18,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x40,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,0]
// CHECK: encoding: [0x00,0x50,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,1]
// CHECK: encoding: [0x00,0x48,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,0]
// CHECK: encoding: [0x00,0x58,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,1]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x10,0xaa,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x10,0xaa,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x10,0xaa,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x10,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x08,0xaa,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x08,0xaa,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x08,0xaa,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x08,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x18,0xaa,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x18,0xaa,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x18,0xaa,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x18,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x40,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,0]
// CHECK: encoding: [0x00,0x50,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,1]
// CHECK: encoding: [0x00,0x48,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,0]
// CHECK: encoding: [0x00,0x58,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,1]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x00,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x10,0xab,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x10,0xab,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x10,0xab,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x10,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[0,1] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x08,0xab,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x08,0xab,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x08,0xab,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x08,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,0] op_sel_hi:[1,1]
// CHECK: encoding: [0x00,0x18,0xab,0xd3,0x01,0x05,0x0e,0x04]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,0]
// CHECK: encoding: [0x00,0x18,0xab,0xd3,0x01,0x05,0x0e,0x14]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[0,1]
// CHECK: encoding: [0x00,0x18,0xab,0xd3,0x01,0x05,0x0e,0x0c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,0]
// CHECK: encoding: [0x00,0x18,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 op_sel:[1,1] op_sel_hi:[1,1]

//
// Test clamp.
//

// CHECK: encoding: [0x00,0xc0,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 clamp
// CHECK: encoding: [0x00,0xc0,0xa6,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_i32_i16 v0, v1, v2, v3 clamp
// CHECK: encoding: [0x00,0xc0,0xa7,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_u32_u16 v0, v1, v2, v3 clamp
// CHECK: encoding: [0x00,0xc0,0xa8,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_i32_i8 v0, v1, v2, v3 clamp
// CHECK: encoding: [0x00,0xc0,0xa9,0xd3,0x01,0x05,0x0e,0x1c]
v_dot4_u32_u8 v0, v1, v2, v3 clamp
// CHECK: encoding: [0x00,0xc0,0xaa,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_i32_i4 v0, v1, v2, v3 clamp
// CHECK: encoding: [0x00,0xc0,0xab,0xd3,0x01,0x05,0x0e,0x1c]
v_dot8_u32_u4 v0, v1, v2, v3 clamp

//
// Test neg_lo/neg_hi.
//

// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_hi:[1,1,1]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0] neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0] neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0] neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1] neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0] neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1] neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x40,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1] neg_hi:[0,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0] neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0] neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0] neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1] neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0] neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1] neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x41,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1] neg_hi:[1,0,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0] neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0] neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0] neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1] neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0] neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1] neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x42,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1] neg_hi:[0,1,0]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0] neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0] neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0] neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1] neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0] neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1] neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x44,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1] neg_hi:[0,0,1]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0] neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0] neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0] neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1] neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0] neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1] neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x43,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1] neg_hi:[1,1,0]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0] neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0] neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0] neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1] neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0] neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1] neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x45,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1] neg_hi:[1,0,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0x1c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,0] neg_hi:[1,1,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0x3c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,0] neg_hi:[1,1,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0x5c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,1,0] neg_hi:[1,1,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0x9c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[0,0,1] neg_hi:[1,1,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0x7c]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,0] neg_hi:[1,1,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0xbc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,0,1] neg_hi:[1,1,1]
// CHECK: encoding: [0x00,0x47,0xa3,0xd3,0x01,0x05,0x0e,0xfc]
v_dot2_f32_f16 v0, v1, v2, v3 neg_lo:[1,1,1] neg_hi:[1,1,1]
