/* gnome-mines.c generated by valac 0.30.0, the Vala compiler
 * generated from gnome-mines.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_MINES (mines_get_type ())
#define MINES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINES, Mines))
#define MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINES, MinesClass))
#define IS_MINES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINES))
#define IS_MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINES))
#define MINES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINES, MinesClass))

typedef struct _Mines Mines;
typedef struct _MinesClass MinesClass;
typedef struct _MinesPrivate MinesPrivate;

#define TYPE_THEME_SELECTOR_DIALOG (theme_selector_dialog_get_type ())
#define THEME_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialog))
#define THEME_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialogClass))
#define IS_THEME_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_SELECTOR_DIALOG))
#define IS_THEME_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_SELECTOR_DIALOG))
#define THEME_SELECTOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialogClass))

typedef struct _ThemeSelectorDialog ThemeSelectorDialog;
typedef struct _ThemeSelectorDialogClass ThemeSelectorDialogClass;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _Block1Data Block1Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _Mines {
	GtkApplication parent_instance;
	MinesPrivate * priv;
};

struct _MinesClass {
	GtkApplicationClass parent_class;
};

struct _MinesPrivate {
	GSettings* settings;
	GtkWidget* main_screen;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkButton* replay_button;
	GtkButton* high_scores_button;
	GtkButton* new_game_button;
	GtkAspectFrame* minefield_aspect;
	GtkOverlay* minefield_overlay;
	GtkBox* aspect_child;
	GtkBox* buttons_box;
	GtkBox* paused_box;
	GtkScrolledWindow* scrolled;
	GtkStack* stack;
	ThemeSelectorDialog* theme_dialog;
	GtkLabel* clock_label;
	GMenu* app_main_menu;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	gboolean is_tiled;
	gboolean pause_requested;
	gboolean window_skip_configure;
	History* history;
	Minefield* minefield;
	MinefieldView* minefield_view;
	GtkLabel* flag_label;
	GtkSpinButton* mines_spin;
	GSimpleAction* new_game_action;
	GSimpleAction* repeat_size_action;
	GSimpleAction* pause_action;
	GtkAspectFrame* new_game_screen;
	GtkAspectFrame* custom_game_screen;
	GtkCssProvider* theme_provider;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean exploded;
	gboolean placed_mines;
	gboolean _use_autoflag;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	Mines* self;
	gint x;
	gint y;
	guint width;
};


static gpointer mines_parent_class = NULL;
static gint mines_game_mode;
static gint mines_game_mode = -1;

GType mines_get_type (void) G_GNUC_CONST;
GType theme_selector_dialog_get_type (void) G_GNUC_CONST;
GType history_get_type (void) G_GNUC_CONST;
GType minefield_get_type (void) G_GNUC_CONST;
GType minefield_view_get_type (void) G_GNUC_CONST;
#define MINES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINES, MinesPrivate))
enum  {
	MINES_DUMMY_PROPERTY
};
#define MINES_KEY_XSIZE "xsize"
#define MINES_XSIZE_MIN 4
#define MINES_XSIZE_MAX 100
#define MINES_KEY_YSIZE "ysize"
#define MINES_YSIZE_MIN 4
#define MINES_YSIZE_MAX 100
#define MINES_KEY_NMINES "nmines"
#define MINES_KEY_MODE "mode"
#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_OVERMINE_WARNING "use-overmine-warning"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
#define MINES_KEY_THEME "theme"
#define MINES_KEY_USE_ANIMATIONS "use-animations"
static void mines_new_game_cb (Mines* self);
static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_silent_new_game_cb (Mines* self);
static void _mines_silent_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_repeat_size_cb (Mines* self);
static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_small_size_clicked_cb (Mines* self);
static void _mines_small_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_medium_size_clicked_cb (Mines* self);
static void _mines_medium_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_large_size_clicked_cb (Mines* self);
static void _mines_large_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_show_custom_game_screen (Mines* self);
static void _mines_show_custom_game_screen_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_toggle_pause_cb (Mines* self);
static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_scores_cb (Mines* self);
static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_preferences_cb (Mines* self);
static void _mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_quit_cb (Mines* self);
static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_help_cb (Mines* self);
static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_about_cb (Mines* self);
static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Mines* mines_new (void);
Mines* mines_construct (GType object_type);
static void mines_set_game_theme (Mines* self, const gchar* theme);
void minefield_view_refresh (MinefieldView* self);
static void mines_real_startup (GApplication* base);
static void __lambda19_ (Mines* self);
static void ___lambda19__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void mines_size_allocate_cb (Mines* self, GtkAllocation* allocation);
static void _mines_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event);
static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
MinefieldView* minefield_view_new (GSettings* settings);
MinefieldView* minefield_view_construct (GType object_type, GSettings* settings);
static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder);
static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static void mines_start_game (Mines* self);
static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines);
static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_set_mines_limit (Mines* self);
static void mines_show_new_game_screen (Mines* self);
static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_custom_size_clicked_cb (Mines* self);
static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean minefield_is_clock_started (Minefield* self);
void minefield_set_paused (Minefield* self, gboolean value);
void mines_start (Mines* self);
static void mines_real_shutdown (GApplication* base);
static gint mines_real_handle_local_options (GApplication* base, GVariantDict* options);
static void mines_real_activate (GApplication* base);
gboolean minefield_get_paused (Minefield* self);
static void mines_update_flag_label (Mines* self);
guint minefield_get_n_flags (Minefield* self);
GType location_get_type (void) G_GNUC_CONST;
static gint mines_show_theme_selector (Mines* self);
ThemeSelectorDialog* theme_selector_dialog_new (GtkWindow* parent);
ThemeSelectorDialog* theme_selector_dialog_construct (GType object_type, GtkWindow* parent);
GType history_entry_get_type (void) G_GNUC_CONST;
static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_close);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_close);
static gboolean mines_can_start_new_game (Mines* self);
guint minefield_get_n_cleared (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
static void mines_marks_changed_cb (Mines* self, Minefield* minefield);
static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self);
static void mines_explode_cb (Mines* self, Minefield* minefield);
static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void mines_cleared_cb (Mines* self, Minefield* minefield);
static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self);
static void mines_tick_cb (Mines* self);
static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self);
static void mines_paused_changed_cb (Mines* self);
static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self);
static void mines_clock_started_cb (Mines* self);
static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
guint minefield_view_get_mine_size (MinefieldView* self);
static void __lambda18_ (Block1Data* _data1_, GtkAllocation* allocation);
static void ___lambda18__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
gdouble minefield_get_elapsed (Minefield* self);
static void mines_game_ended (Mines* self);
HistoryEntry* history_entry_new (GDateTime* date, guint width, guint height, guint n_mines, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint width, guint height, guint n_mines, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gfloat mines_percent_mines (Mines* self);
static void mines_set_mode (Mines* self, gint mode);
gint mines_main (gchar** args, int args_length1);
static void mines_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MINES_option_entries[5] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {"small", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Small game", NULL}, {"medium", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Medium game", NULL}, {"big", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Big game", NULL}, {NULL}};
static const GActionEntry MINES_action_entries[13] = {{"new-game", _mines_new_game_cb_gsimple_action_activate_callback}, {"silent-new-game", _mines_silent_new_game_cb_gsimple_action_activate_callback}, {"repeat-size", _mines_repeat_size_cb_gsimple_action_activate_callback}, {"small-size", _mines_small_size_clicked_cb_gsimple_action_activate_callback}, {"medium-size", _mines_medium_size_clicked_cb_gsimple_action_activate_callback}, {"large-size", _mines_large_size_clicked_cb_gsimple_action_activate_callback}, {"custom-size", _mines_show_custom_game_screen_gsimple_action_activate_callback}, {"pause", _mines_toggle_pause_cb_gsimple_action_activate_callback}, {"scores", _mines_scores_cb_gsimple_action_activate_callback}, {"preferences", _mines_preferences_cb_gsimple_action_activate_callback}, {"quit", _mines_quit_cb_gsimple_action_activate_callback}, {"help", _mines_help_cb_gsimple_action_activate_callback}, {"about", _mines_about_cb_gsimple_action_activate_callback}};

static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_new_game_cb ((Mines*) self);
}


static void _mines_silent_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_silent_new_game_cb ((Mines*) self);
}


static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_repeat_size_cb ((Mines*) self);
}


static void _mines_small_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_small_size_clicked_cb ((Mines*) self);
}


static void _mines_medium_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_medium_size_clicked_cb ((Mines*) self);
}


static void _mines_large_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_large_size_clicked_cb ((Mines*) self);
}


static void _mines_show_custom_game_screen_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_show_custom_game_screen ((Mines*) self);
}


static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_toggle_pause_cb ((Mines*) self);
}


static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_scores_cb ((Mines*) self);
}


static void _mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_preferences_cb ((Mines*) self);
}


static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_quit_cb ((Mines*) self);
}


static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_help_cb ((Mines*) self);
}


static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_about_cb ((Mines*) self);
}


Mines* mines_construct (GType object_type) {
	Mines * self = NULL;
	self = (Mines*) g_object_new (object_type, "application-id", "org.gnome.mines", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, MINES_option_entries);
	return self;
}


Mines* mines_new (void) {
	return mines_construct (TYPE_MINES);
}


static void mines_set_game_theme (Mines* self, const gchar* theme) {
	gchar* theme_path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean is_switch = FALSE;
	GtkCssProvider* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar* theme_css_path = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkWindow* _tmp33_ = NULL;
	GdkScreen* _tmp37_ = NULL;
	ThemeSelectorDialog* _tmp38_ = NULL;
	MinefieldView* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = theme;
	_tmp1_ = g_strdup (_tmp0_);
	theme_path = _tmp1_;
	_tmp2_ = self->priv->theme_provider;
	is_switch = _tmp2_ != NULL;
	_tmp3_ = theme_path;
	_tmp4_ = g_path_is_absolute (_tmp3_);
	if (!_tmp4_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = theme;
		_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, DATA_DIRECTORY, "themes", _tmp5_, NULL);
		_g_free0 (theme_path);
		theme_path = _tmp6_;
	}
	_tmp7_ = is_switch;
	if (!_tmp7_) {
		GtkIconTheme* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = gtk_icon_theme_get_default ();
		_tmp9_ = theme_path;
		gtk_icon_theme_append_search_path (_tmp8_, _tmp9_);
	} else {
		gchar** icon_search_path = NULL;
		gint icon_search_path_length1 = 0;
		gint _icon_search_path_size_ = 0;
		GtkIconTheme* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GtkIconTheme* _tmp18_ = NULL;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		_tmp10_ = gtk_icon_theme_get_default ();
		gtk_icon_theme_get_search_path (_tmp10_, &_tmp11_, &_tmp12_);
		icon_search_path = (_vala_array_free (icon_search_path, icon_search_path_length1, (GDestroyNotify) g_free), NULL);
		icon_search_path = _tmp11_;
		icon_search_path_length1 = _tmp12_;
		_icon_search_path_size_ = icon_search_path_length1;
		_tmp13_ = icon_search_path;
		_tmp13__length1 = icon_search_path_length1;
		_tmp14_ = icon_search_path;
		_tmp14__length1 = icon_search_path_length1;
		_tmp15_ = theme_path;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (_tmp13_[_tmp14__length1 - 1]);
		_tmp13_[_tmp14__length1 - 1] = _tmp16_;
		_tmp17_ = _tmp13_[_tmp14__length1 - 1];
		_tmp18_ = gtk_icon_theme_get_default ();
		_tmp19_ = icon_search_path;
		_tmp19__length1 = icon_search_path_length1;
		gtk_icon_theme_set_search_path (_tmp18_, _tmp19_, _tmp19__length1);
		icon_search_path = (_vala_array_free (icon_search_path, icon_search_path_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp20_ = theme_path;
	_tmp21_ = g_build_filename (_tmp20_, "theme.css", NULL);
	theme_css_path = _tmp21_;
	{
		gboolean _tmp22_ = FALSE;
		GtkCssProvider* _tmp25_ = NULL;
		GtkCssProvider* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GdkScreen* _tmp28_ = NULL;
		GtkCssProvider* _tmp29_ = NULL;
		_tmp22_ = is_switch;
		if (_tmp22_) {
			GdkScreen* _tmp23_ = NULL;
			GtkCssProvider* _tmp24_ = NULL;
			_tmp23_ = gdk_screen_get_default ();
			_tmp24_ = self->priv->theme_provider;
			gtk_style_context_remove_provider_for_screen (_tmp23_, (GtkStyleProvider*) _tmp24_);
		}
		_tmp25_ = gtk_css_provider_new ();
		_g_object_unref0 (self->priv->theme_provider);
		self->priv->theme_provider = _tmp25_;
		_tmp26_ = self->priv->theme_provider;
		_tmp27_ = theme_css_path;
		gtk_css_provider_load_from_path (_tmp26_, _tmp27_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp28_ = gdk_screen_get_default ();
		_tmp29_ = self->priv->theme_provider;
		gtk_style_context_add_provider_for_screen (_tmp28_, (GtkStyleProvider*) _tmp29_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = theme_css_path;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("gnome-mines.vala:148: Error loading css styles from %s: %s", _tmp30_, _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (theme_css_path);
		_g_free0 (theme_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp33_ = self->priv->window;
	if (_tmp33_ != NULL) {
		GtkWindow* _tmp34_ = NULL;
		GdkWindow* _tmp35_ = NULL;
		GtkWindow* _tmp36_ = NULL;
		_tmp34_ = self->priv->window;
		_tmp35_ = gtk_widget_get_window ((GtkWidget*) _tmp34_);
		gdk_window_invalidate_rect (_tmp35_, NULL, TRUE);
		_tmp36_ = self->priv->window;
		gtk_widget_queue_draw ((GtkWidget*) _tmp36_);
	}
	_tmp37_ = gdk_screen_get_default ();
	gtk_style_context_reset_widgets (_tmp37_);
	_tmp38_ = self->priv->theme_dialog;
	if (_tmp38_ != NULL) {
		ThemeSelectorDialog* _tmp39_ = NULL;
		_tmp39_ = self->priv->theme_dialog;
		gtk_widget_queue_draw ((GtkWidget*) _tmp39_);
	}
	_tmp40_ = self->priv->minefield_view;
	if (_tmp40_ != NULL) {
		MinefieldView* _tmp41_ = NULL;
		_tmp41_ = self->priv->minefield_view;
		minefield_view_refresh (_tmp41_);
	}
	_g_free0 (theme_css_path);
	_g_free0 (theme_path);
}


static void __lambda19_ (Mines* self) {
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, MINES_KEY_THEME);
	_tmp2_ = _tmp1_;
	mines_set_game_theme (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void ___lambda19__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda19_ ((Mines*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _mines_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	mines_size_allocate_cb ((Mines*) self, allocation);
}


static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = mines_window_state_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_out_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_in_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mines_view_button_press_event ((Mines*) self, _sender, event);
	return result;
}


static void mines_real_startup (GApplication* base) {
	Mines * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp6_ = NULL;
	gchar* css_path = NULL;
	gchar* _tmp7_ = NULL;
	GdkScreen* _tmp10_ = NULL;
	GtkBuilder* ui_builder = NULL;
	GtkBuilder* _tmp11_ = NULL;
	GSettings* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GAction* _tmp21_ = NULL;
	GSimpleAction* _tmp22_ = NULL;
	GSimpleAction* _tmp23_ = NULL;
	GAction* _tmp24_ = NULL;
	GSimpleAction* _tmp25_ = NULL;
	GSimpleAction* _tmp26_ = NULL;
	GAction* _tmp27_ = NULL;
	GSimpleAction* _tmp28_ = NULL;
	GSimpleAction* _tmp29_ = NULL;
	GSettings* _tmp30_ = NULL;
	GAction* _tmp31_ = NULL;
	GAction* _tmp32_ = NULL;
	GSettings* _tmp33_ = NULL;
	GAction* _tmp34_ = NULL;
	GAction* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkWindow* _tmp37_ = NULL;
	GtkWindow* _tmp38_ = NULL;
	GtkWindow* _tmp39_ = NULL;
	GtkWindow* _tmp40_ = NULL;
	GtkWindow* _tmp41_ = NULL;
	GtkWindow* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GtkSettings* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	GSettings* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	GtkWindow* _tmp53_ = NULL;
	gchar* desktop = NULL;
	const gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	const gchar* _tmp57_ = NULL;
	gboolean shell_shows_menubar = FALSE;
	GtkSettings* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	gchar* _tmp127_ = NULL;
	gchar** _tmp128_ = NULL;
	gchar** _tmp129_ = NULL;
	gint _tmp129__length1 = 0;
	gchar* _tmp130_ = NULL;
	gchar** _tmp131_ = NULL;
	gchar** _tmp132_ = NULL;
	gint _tmp132__length1 = 0;
	gchar* _tmp133_ = NULL;
	gchar** _tmp134_ = NULL;
	gchar** _tmp135_ = NULL;
	gint _tmp135__length1 = 0;
	gchar* _tmp136_ = NULL;
	gchar** _tmp137_ = NULL;
	gchar** _tmp138_ = NULL;
	gint _tmp138__length1 = 0;
	gchar* _tmp139_ = NULL;
	gchar** _tmp140_ = NULL;
	gchar** _tmp141_ = NULL;
	gint _tmp141__length1 = 0;
	gchar* _tmp142_ = NULL;
	gchar** _tmp143_ = NULL;
	gchar** _tmp144_ = NULL;
	gint _tmp144__length1 = 0;
	gchar* _tmp145_ = NULL;
	gchar** _tmp146_ = NULL;
	gchar** _tmp147_ = NULL;
	gint _tmp147__length1 = 0;
	gchar* _tmp148_ = NULL;
	gchar** _tmp149_ = NULL;
	gchar** _tmp150_ = NULL;
	gint _tmp150__length1 = 0;
	gchar* _tmp151_ = NULL;
	gchar** _tmp152_ = NULL;
	gchar** _tmp153_ = NULL;
	gint _tmp153__length1 = 0;
	gchar* _tmp154_ = NULL;
	gchar* _tmp155_ = NULL;
	gchar** _tmp156_ = NULL;
	gchar** _tmp157_ = NULL;
	gint _tmp157__length1 = 0;
	GSettings* _tmp158_ = NULL;
	MinefieldView* _tmp159_ = NULL;
	MinefieldView* _tmp160_ = NULL;
	GObject* _tmp161_ = NULL;
	GtkStack* _tmp162_ = NULL;
	GObject* _tmp163_ = NULL;
	GtkScrolledWindow* _tmp164_ = NULL;
	GtkScrolledWindow* _tmp165_ = NULL;
	MinefieldView* _tmp166_ = NULL;
	GtkScrolledWindow* _tmp167_ = NULL;
	GObject* _tmp168_ = NULL;
	GtkOverlay* _tmp169_ = NULL;
	GtkOverlay* _tmp170_ = NULL;
	GObject* _tmp171_ = NULL;
	GtkAspectFrame* _tmp172_ = NULL;
	GtkAspectFrame* _tmp173_ = NULL;
	GObject* _tmp174_ = NULL;
	GtkBox* _tmp175_ = NULL;
	GObject* _tmp176_ = NULL;
	GtkBox* _tmp177_ = NULL;
	GObject* _tmp178_ = NULL;
	GtkBox* _tmp179_ = NULL;
	GObject* _tmp180_ = NULL;
	GtkBox* _tmp181_ = NULL;
	GtkBox* _tmp182_ = NULL;
	GtkOverlay* _tmp183_ = NULL;
	GtkBox* _tmp184_ = NULL;
	GObject* _tmp185_ = NULL;
	GtkWidget* _tmp186_ = NULL;
	GtkWidget* _tmp187_ = NULL;
	const gchar* _tmp188_ = NULL;
	gchar* _tmp189_ = NULL;
	gchar* _tmp190_ = NULL;
	History* _tmp191_ = NULL;
	History* _tmp192_ = NULL;
	GObject* _tmp193_ = NULL;
	GtkLabel* _tmp194_ = NULL;
	GObject* _tmp195_ = NULL;
	GtkLabel* _tmp196_ = NULL;
	GObject* _tmp197_ = NULL;
	GtkButton* _tmp198_ = NULL;
	GObject* _tmp199_ = NULL;
	GtkLabel* _tmp200_ = NULL;
	GObject* _tmp201_ = NULL;
	GtkButton* _tmp202_ = NULL;
	GObject* _tmp203_ = NULL;
	GtkButton* _tmp204_ = NULL;
	GObject* _tmp205_ = NULL;
	GtkButton* _tmp206_ = NULL;
	gint _tmp207_ = 0;
	GError * _inner_error_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = _ ("Mines");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_settings_new ("org.gnome.mines");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_delay (_tmp2_);
	_tmp3_ = mines_game_mode;
	if (_tmp3_ != -1) {
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = mines_game_mode;
		g_settings_set_int (_tmp4_, MINES_KEY_MODE, _tmp5_);
	}
	gtk_window_set_default_icon_name ("gnome-mines");
	_tmp6_ = gtk_css_provider_new ();
	css_provider = _tmp6_;
	_tmp7_ = g_build_filename (DATA_DIRECTORY, "gnome-mines.css", NULL);
	css_path = _tmp7_;
	{
		gtk_css_provider_load_from_path (css_provider, css_path, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("gnome-mines.vala:185: Error loading css styles from %s: %s", css_path, _tmp9_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (css_path);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp10_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp11_ = gtk_builder_new ();
	ui_builder = _tmp11_;
	{
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp12_ = g_build_filename (DATA_DIRECTORY, "interface.ui", NULL, NULL);
		_tmp13_ = _tmp12_;
		gtk_builder_add_from_file (ui_builder, _tmp13_, &_inner_error_);
		_g_free0 (_tmp13_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("gnome-mines.vala:196: Could not load game UI: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (ui_builder);
		_g_free0 (css_path);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = self->priv->settings;
	_tmp17_ = g_strconcat ("changed::", MINES_KEY_THEME, NULL);
	g_signal_connect_object (_tmp16_, _tmp17_, (GCallback) ___lambda19__g_settings_changed, self, 0);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->settings;
	_tmp19_ = g_settings_get_string (_tmp18_, MINES_KEY_THEME);
	_tmp20_ = _tmp19_;
	mines_set_game_theme (self, _tmp20_);
	_g_free0 (_tmp20_);
	g_action_map_add_action_entries ((GActionMap*) self, MINES_action_entries, G_N_ELEMENTS (MINES_action_entries), self);
	_tmp21_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp22_;
	_tmp23_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp23_, TRUE);
	_tmp24_ = g_action_map_lookup_action ((GActionMap*) self, "repeat-size");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->repeat_size_action);
	self->priv->repeat_size_action = _tmp25_;
	_tmp26_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp26_, FALSE);
	_tmp27_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp28_;
	_tmp29_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp29_, FALSE);
	_tmp30_ = self->priv->settings;
	_tmp31_ = g_settings_create_action (_tmp30_, MINES_KEY_USE_OVERMINE_WARNING);
	_tmp32_ = _tmp31_;
	g_action_map_add_action ((GActionMap*) self, _tmp32_);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = self->priv->settings;
	_tmp34_ = g_settings_create_action (_tmp33_, MINES_KEY_USE_QUESTION_MARKS);
	_tmp35_ = _tmp34_;
	g_action_map_add_action ((GActionMap*) self, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = gtk_builder_get_object (ui_builder, "main_window");
	_tmp37_ = _g_object_ref0 ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp37_;
	_tmp38_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp38_, "size-allocate", (GCallback) _mines_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp39_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp39_, "window-state-event", (GCallback) _mines_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp40_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "focus-out-event", (GCallback) _mines_window_focus_out_event_cb_gtk_widget_focus_out_event, self, 0);
	_tmp41_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp41_, "focus-in-event", (GCallback) _mines_window_focus_in_event_cb_gtk_widget_focus_in_event, self, 0);
	_tmp42_ = self->priv->window;
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_int (_tmp43_, "window-width");
	_tmp45_ = self->priv->settings;
	_tmp46_ = g_settings_get_int (_tmp45_, "window-height");
	gtk_window_set_default_size (_tmp42_, _tmp44_, _tmp46_);
	_tmp47_ = gtk_settings_get_default ();
	_tmp48_ = self->priv->settings;
	_tmp49_ = g_settings_get_boolean (_tmp48_, "use-animations");
	g_object_set (_tmp47_, "gtk-enable-animations", _tmp49_, NULL);
	_tmp50_ = self->priv->settings;
	_tmp51_ = g_settings_get_boolean (_tmp50_, "window-is-maximized");
	if (_tmp51_) {
		GtkWindow* _tmp52_ = NULL;
		_tmp52_ = self->priv->window;
		gtk_window_maximize (_tmp52_);
	}
	_tmp53_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp53_);
	_tmp54_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp55_ = g_strdup (_tmp54_);
	desktop = _tmp55_;
	_tmp57_ = desktop;
	if (_tmp57_ == NULL) {
		_tmp56_ = TRUE;
	} else {
		const gchar* _tmp58_ = NULL;
		_tmp58_ = desktop;
		_tmp56_ = g_strcmp0 (_tmp58_, "Unity") != 0;
	}
	if (_tmp56_) {
		GtkHeaderBar* headerbar = NULL;
		GtkHeaderBar* _tmp59_ = NULL;
		GtkHeaderBar* _tmp60_ = NULL;
		GtkHeaderBar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		GtkHeaderBar* _tmp63_ = NULL;
		GtkWindow* _tmp64_ = NULL;
		GtkHeaderBar* _tmp65_ = NULL;
		_tmp59_ = (GtkHeaderBar*) gtk_header_bar_new ();
		g_object_ref_sink (_tmp59_);
		headerbar = _tmp59_;
		_tmp60_ = headerbar;
		gtk_header_bar_set_show_close_button (_tmp60_, TRUE);
		_tmp61_ = headerbar;
		_tmp62_ = _ ("Mines");
		gtk_header_bar_set_title (_tmp61_, _tmp62_);
		_tmp63_ = headerbar;
		gtk_widget_show ((GtkWidget*) _tmp63_);
		_tmp64_ = self->priv->window;
		_tmp65_ = headerbar;
		gtk_window_set_titlebar (_tmp64_, (GtkWidget*) _tmp65_);
		_g_object_unref0 (headerbar);
	}
	_tmp66_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp66_, "gtk-shell-shows-menubar", &shell_shows_menubar, NULL);
	_tmp67_ = shell_shows_menubar;
	if (!_tmp67_) {
		GMenu* menu = NULL;
		GMenu* _tmp68_ = NULL;
		GMenu* _tmp69_ = NULL;
		GMenu* _tmp70_ = NULL;
		GMenu* _tmp71_ = NULL;
		GMenu* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		GMenu* _tmp74_ = NULL;
		const gchar* _tmp75_ = NULL;
		GMenu* section = NULL;
		GMenu* _tmp76_ = NULL;
		GMenu* _tmp77_ = NULL;
		GMenu* _tmp78_ = NULL;
		GMenu* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		GMenu* _tmp83_ = NULL;
		const gchar* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		gchar* _tmp86_ = NULL;
		GMenu* _tmp87_ = NULL;
		GMenu* _tmp88_ = NULL;
		GMenu* _tmp89_ = NULL;
		GMenu* _tmp90_ = NULL;
		const gchar* _tmp91_ = NULL;
		GMenu* _tmp92_ = NULL;
		const gchar* _tmp93_ = NULL;
		GMenu* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
		GMenu* _tmp96_ = NULL;
		_tmp68_ = g_menu_new ();
		menu = _tmp68_;
		_tmp69_ = g_menu_new ();
		_g_object_unref0 (self->priv->app_main_menu);
		self->priv->app_main_menu = _tmp69_;
		_tmp70_ = menu;
		_tmp71_ = self->priv->app_main_menu;
		g_menu_append_section (_tmp70_, NULL, (GMenuModel*) _tmp71_);
		_tmp72_ = self->priv->app_main_menu;
		_tmp73_ = _ ("_Scores");
		g_menu_append (_tmp72_, _tmp73_, "app.scores");
		_tmp74_ = self->priv->app_main_menu;
		_tmp75_ = _ ("A_ppearance");
		g_menu_append (_tmp74_, _tmp75_, "app.preferences");
		_tmp76_ = g_menu_new ();
		section = _tmp76_;
		_tmp77_ = menu;
		_tmp78_ = section;
		g_menu_append_section (_tmp77_, NULL, (GMenuModel*) _tmp78_);
		_tmp79_ = section;
		_tmp80_ = _ ("_Show Warnings");
		_tmp81_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp82_ = _tmp81_;
		g_menu_append (_tmp79_, _tmp80_, _tmp82_);
		_g_free0 (_tmp82_);
		_tmp83_ = section;
		_tmp84_ = _ ("_Use Question Flags");
		_tmp85_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp86_ = _tmp85_;
		g_menu_append (_tmp83_, _tmp84_, _tmp86_);
		_g_free0 (_tmp86_);
		_tmp87_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp87_;
		_tmp88_ = menu;
		_tmp89_ = section;
		g_menu_append_section (_tmp88_, NULL, (GMenuModel*) _tmp89_);
		_tmp90_ = section;
		_tmp91_ = _ ("_Help");
		g_menu_append (_tmp90_, _tmp91_, "app.help");
		_tmp92_ = section;
		_tmp93_ = _ ("_About");
		g_menu_append (_tmp92_, _tmp93_, "app.about");
		_tmp94_ = section;
		_tmp95_ = _ ("_Quit");
		g_menu_append (_tmp94_, _tmp95_, "app.quit");
		_tmp96_ = menu;
		gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) _tmp96_);
		_g_object_unref0 (section);
		_g_object_unref0 (menu);
	} else {
		GMenu* menu = NULL;
		GMenu* _tmp97_ = NULL;
		GMenu* mines_menu = NULL;
		GMenu* _tmp98_ = NULL;
		GMenu* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		GMenu* _tmp101_ = NULL;
		GMenu* _tmp102_ = NULL;
		const gchar* _tmp103_ = NULL;
		GMenu* _tmp104_ = NULL;
		const gchar* _tmp105_ = NULL;
		GMenu* _tmp106_ = NULL;
		const gchar* _tmp107_ = NULL;
		GMenu* _tmp108_ = NULL;
		const gchar* _tmp109_ = NULL;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_ = NULL;
		GMenu* _tmp112_ = NULL;
		const gchar* _tmp113_ = NULL;
		gchar* _tmp114_ = NULL;
		gchar* _tmp115_ = NULL;
		GMenu* _tmp116_ = NULL;
		const gchar* _tmp117_ = NULL;
		GMenu* help_menu = NULL;
		GMenu* _tmp118_ = NULL;
		GMenu* _tmp119_ = NULL;
		const gchar* _tmp120_ = NULL;
		GMenu* _tmp121_ = NULL;
		GMenu* _tmp122_ = NULL;
		const gchar* _tmp123_ = NULL;
		GMenu* _tmp124_ = NULL;
		const gchar* _tmp125_ = NULL;
		GMenu* _tmp126_ = NULL;
		_tmp97_ = g_menu_new ();
		menu = _tmp97_;
		_tmp98_ = g_menu_new ();
		mines_menu = _tmp98_;
		_tmp99_ = menu;
		_tmp100_ = _ ("_Mines");
		_tmp101_ = mines_menu;
		g_menu_append_submenu (_tmp99_, _tmp100_, (GMenuModel*) _tmp101_);
		_tmp102_ = mines_menu;
		_tmp103_ = _ ("_New Game");
		g_menu_append (_tmp102_, _tmp103_, "app.new-game");
		_tmp104_ = mines_menu;
		_tmp105_ = _ ("_Scores");
		g_menu_append (_tmp104_, _tmp105_, "app.scores");
		_tmp106_ = mines_menu;
		_tmp107_ = _ ("A_ppearance");
		g_menu_append (_tmp106_, _tmp107_, "app.preferences");
		_tmp108_ = mines_menu;
		_tmp109_ = _ ("_Show Warnings");
		_tmp110_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp111_ = _tmp110_;
		g_menu_append (_tmp108_, _tmp109_, _tmp111_);
		_g_free0 (_tmp111_);
		_tmp112_ = mines_menu;
		_tmp113_ = _ ("_Use Question Flags");
		_tmp114_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp115_ = _tmp114_;
		g_menu_append (_tmp112_, _tmp113_, _tmp115_);
		_g_free0 (_tmp115_);
		_tmp116_ = mines_menu;
		_tmp117_ = _ ("_Quit");
		g_menu_append (_tmp116_, _tmp117_, "app.quit");
		_tmp118_ = g_menu_new ();
		help_menu = _tmp118_;
		_tmp119_ = menu;
		_tmp120_ = _ ("_Help");
		_tmp121_ = help_menu;
		g_menu_append_submenu (_tmp119_, _tmp120_, (GMenuModel*) _tmp121_);
		_tmp122_ = help_menu;
		_tmp123_ = _ ("_Contents");
		g_menu_append (_tmp122_, _tmp123_, "app.help");
		_tmp124_ = help_menu;
		_tmp125_ = _ ("_About");
		g_menu_append (_tmp124_, _tmp125_, "app.about");
		_tmp126_ = menu;
		gtk_application_set_menubar ((GtkApplication*) self, (GMenuModel*) _tmp126_);
		_g_object_unref0 (help_menu);
		_g_object_unref0 (mines_menu);
		_g_object_unref0 (menu);
	}
	_tmp127_ = g_strdup ("<Primary>n");
	_tmp128_ = g_new0 (gchar*, 1 + 1);
	_tmp128_[0] = _tmp127_;
	_tmp129_ = _tmp128_;
	_tmp129__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp129_);
	_tmp129_ = (_vala_array_free (_tmp129_, _tmp129__length1, (GDestroyNotify) g_free), NULL);
	_tmp130_ = g_strdup ("Escape");
	_tmp131_ = g_new0 (gchar*, 1 + 1);
	_tmp131_[0] = _tmp130_;
	_tmp132_ = _tmp131_;
	_tmp132__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.silent-new-game", _tmp132_);
	_tmp132_ = (_vala_array_free (_tmp132_, _tmp132__length1, (GDestroyNotify) g_free), NULL);
	_tmp133_ = g_strdup ("<Primary>r");
	_tmp134_ = g_new0 (gchar*, 1 + 1);
	_tmp134_[0] = _tmp133_;
	_tmp135_ = _tmp134_;
	_tmp135__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.repeat-size", _tmp135_);
	_tmp135_ = (_vala_array_free (_tmp135_, _tmp135__length1, (GDestroyNotify) g_free), NULL);
	_tmp136_ = g_strdup ("1");
	_tmp137_ = g_new0 (gchar*, 1 + 1);
	_tmp137_[0] = _tmp136_;
	_tmp138_ = _tmp137_;
	_tmp138__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.small-size", _tmp138_);
	_tmp138_ = (_vala_array_free (_tmp138_, _tmp138__length1, (GDestroyNotify) g_free), NULL);
	_tmp139_ = g_strdup ("2");
	_tmp140_ = g_new0 (gchar*, 1 + 1);
	_tmp140_[0] = _tmp139_;
	_tmp141_ = _tmp140_;
	_tmp141__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.medium-size", _tmp141_);
	_tmp141_ = (_vala_array_free (_tmp141_, _tmp141__length1, (GDestroyNotify) g_free), NULL);
	_tmp142_ = g_strdup ("3");
	_tmp143_ = g_new0 (gchar*, 1 + 1);
	_tmp143_[0] = _tmp142_;
	_tmp144_ = _tmp143_;
	_tmp144__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.large-size", _tmp144_);
	_tmp144_ = (_vala_array_free (_tmp144_, _tmp144__length1, (GDestroyNotify) g_free), NULL);
	_tmp145_ = g_strdup ("4");
	_tmp146_ = g_new0 (gchar*, 1 + 1);
	_tmp146_[0] = _tmp145_;
	_tmp147_ = _tmp146_;
	_tmp147__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.custom-size", _tmp147_);
	_tmp147_ = (_vala_array_free (_tmp147_, _tmp147__length1, (GDestroyNotify) g_free), NULL);
	_tmp148_ = g_strdup ("Pause");
	_tmp149_ = g_new0 (gchar*, 1 + 1);
	_tmp149_[0] = _tmp148_;
	_tmp150_ = _tmp149_;
	_tmp150__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp150_);
	_tmp150_ = (_vala_array_free (_tmp150_, _tmp150__length1, (GDestroyNotify) g_free), NULL);
	_tmp151_ = g_strdup ("F1");
	_tmp152_ = g_new0 (gchar*, 1 + 1);
	_tmp152_[0] = _tmp151_;
	_tmp153_ = _tmp152_;
	_tmp153__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp153_);
	_tmp153_ = (_vala_array_free (_tmp153_, _tmp153__length1, (GDestroyNotify) g_free), NULL);
	_tmp154_ = g_strdup ("<Primary>q");
	_tmp155_ = g_strdup ("<Primary>w");
	_tmp156_ = g_new0 (gchar*, 2 + 1);
	_tmp156_[0] = _tmp154_;
	_tmp156_[1] = _tmp155_;
	_tmp157_ = _tmp156_;
	_tmp157__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp157_);
	_tmp157_ = (_vala_array_free (_tmp157_, _tmp157__length1, (GDestroyNotify) g_free), NULL);
	_tmp158_ = self->priv->settings;
	_tmp159_ = minefield_view_new (_tmp158_);
	g_object_ref_sink (_tmp159_);
	_g_object_unref0 (self->priv->minefield_view);
	self->priv->minefield_view = _tmp159_;
	_tmp160_ = self->priv->minefield_view;
	gtk_widget_show ((GtkWidget*) _tmp160_);
	_tmp161_ = gtk_builder_get_object (ui_builder, "stack");
	_tmp162_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp162_;
	_tmp163_ = gtk_builder_get_object (ui_builder, "scrolled");
	_tmp164_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_g_object_unref0 (self->priv->scrolled);
	self->priv->scrolled = _tmp164_;
	_tmp165_ = self->priv->scrolled;
	_tmp166_ = self->priv->minefield_view;
	gtk_container_add ((GtkContainer*) _tmp165_, (GtkWidget*) _tmp166_);
	_tmp167_ = self->priv->scrolled;
	gtk_widget_show ((GtkWidget*) _tmp167_);
	_tmp168_ = gtk_builder_get_object (ui_builder, "minefield_overlay");
	_tmp169_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->minefield_overlay);
	self->priv->minefield_overlay = _tmp169_;
	_tmp170_ = self->priv->minefield_overlay;
	gtk_widget_show ((GtkWidget*) _tmp170_);
	_tmp171_ = gtk_builder_get_object (ui_builder, "minefield_aspect");
	_tmp172_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp171_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->minefield_aspect);
	self->priv->minefield_aspect = _tmp172_;
	_tmp173_ = self->priv->minefield_aspect;
	gtk_widget_show ((GtkWidget*) _tmp173_);
	_tmp174_ = gtk_builder_get_object (ui_builder, "paused_box");
	_tmp175_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp174_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->paused_box);
	self->priv->paused_box = _tmp175_;
	_tmp176_ = gtk_builder_get_object (ui_builder, "buttons_box");
	_tmp177_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp176_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->buttons_box);
	self->priv->buttons_box = _tmp177_;
	_tmp178_ = gtk_builder_get_object (ui_builder, "aspect_child");
	_tmp179_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp178_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->aspect_child);
	self->priv->aspect_child = _tmp179_;
	_tmp180_ = gtk_builder_get_object (ui_builder, "paused_box");
	_tmp181_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp180_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->paused_box);
	self->priv->paused_box = _tmp181_;
	_tmp182_ = self->priv->paused_box;
	g_signal_connect_object ((GtkWidget*) _tmp182_, "button-press-event", (GCallback) _mines_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp183_ = self->priv->minefield_overlay;
	_tmp184_ = self->priv->paused_box;
	gtk_overlay_add_overlay (_tmp183_, (GtkWidget*) _tmp184_);
	_tmp185_ = gtk_builder_get_object (ui_builder, "main_screen");
	_tmp186_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp185_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->main_screen);
	self->priv->main_screen = _tmp186_;
	_tmp187_ = self->priv->main_screen;
	gtk_widget_show_all (_tmp187_);
	mines_startup_new_game_screen (self, ui_builder);
	mines_startup_custom_game_screen (self, ui_builder);
	_tmp188_ = g_get_user_data_dir ();
	_tmp189_ = g_build_filename (_tmp188_, "gnome-mines", "history", NULL);
	_tmp190_ = _tmp189_;
	_tmp191_ = history_new (_tmp190_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp191_;
	_g_free0 (_tmp190_);
	_tmp192_ = self->priv->history;
	history_load (_tmp192_);
	_tmp193_ = gtk_builder_get_object (ui_builder, "flag_label");
	_tmp194_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->flag_label);
	self->priv->flag_label = _tmp194_;
	_tmp195_ = gtk_builder_get_object (ui_builder, "clock_label");
	_tmp196_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp195_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp196_;
	_tmp197_ = gtk_builder_get_object (ui_builder, "play_pause_button");
	_tmp198_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp198_;
	_tmp199_ = gtk_builder_get_object (ui_builder, "play_pause_label");
	_tmp200_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->play_pause_label);
	self->priv->play_pause_label = _tmp200_;
	_tmp201_ = gtk_builder_get_object (ui_builder, "high_scores_button");
	_tmp202_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp201_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->high_scores_button);
	self->priv->high_scores_button = _tmp202_;
	_tmp203_ = gtk_builder_get_object (ui_builder, "replay_button");
	_tmp204_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp203_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->replay_button);
	self->priv->replay_button = _tmp204_;
	_tmp205_ = gtk_builder_get_object (ui_builder, "new_game_button");
	_tmp206_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp205_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp206_;
	_tmp207_ = mines_game_mode;
	if (_tmp207_ != -1) {
		mines_start_game (self);
	}
	_g_free0 (desktop);
	_g_object_unref0 (ui_builder);
	_g_free0 (css_path);
	_g_object_unref0 (css_provider);
}


static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_small_size_clicked_cb ((Mines*) self);
}


static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_medium_size_clicked_cb ((Mines*) self);
}


static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_large_size_clicked_cb ((Mines*) self);
}


static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_custom_game_screen ((Mines*) self);
}


static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkButton* _tmp38_ = NULL;
	GtkButton* _tmp39_ = NULL;
	GtkLabel* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkButton* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkAspectFrame* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "new_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "small_size_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton));
	button = _tmp5_;
	_tmp6_ = button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) _mines_small_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	_tmp8_ = label;
	_tmp9_ = mines_make_minefield_description (self, 8, 8, 10);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = label;
	gtk_label_set_justify (_tmp11_, GTK_JUSTIFY_CENTER);
	_tmp12_ = button;
	_tmp13_ = label;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "medium_size_btn");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp16_;
	_tmp17_ = button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) _mines_medium_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp18_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (label);
	label = _tmp18_;
	_tmp19_ = label;
	_tmp20_ = mines_make_minefield_description (self, 16, 16, 40);
	_tmp21_ = _tmp20_;
	gtk_label_set_markup (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = label;
	gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_CENTER);
	_tmp23_ = button;
	_tmp24_ = label;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "large_size_btn");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp27_;
	_tmp28_ = button;
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) _mines_large_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp29_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (label);
	label = _tmp29_;
	_tmp30_ = label;
	_tmp31_ = mines_make_minefield_description (self, 30, 16, 99);
	_tmp32_ = _tmp31_;
	gtk_label_set_markup (_tmp30_, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = label;
	gtk_label_set_justify (_tmp33_, GTK_JUSTIFY_CENTER);
	_tmp34_ = button;
	_tmp35_ = label;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "custom_size_btn");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp38_;
	_tmp39_ = button;
	g_signal_connect_object (_tmp39_, "clicked", (GCallback) _mines_show_custom_game_screen_gtk_button_clicked, self, 0);
	_tmp40_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (label);
	label = _tmp40_;
	_tmp41_ = label;
	_tmp42_ = _ ("Custom");
	_tmp43_ = g_dpgettext2 (NULL, "board size", _tmp42_);
	_tmp44_ = g_strconcat ("<span size='xx-large' weight='heavy'>?</span>\n", _tmp43_, NULL);
	_tmp45_ = _tmp44_;
	gtk_label_set_markup_with_mnemonic (_tmp41_, _tmp45_);
	_g_free0 (_tmp45_);
	_tmp46_ = label;
	gtk_label_set_justify (_tmp46_, GTK_JUSTIFY_CENTER);
	_tmp47_ = button;
	_tmp48_ = label;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->new_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp49_);
	_g_object_unref0 (label);
	_g_object_unref0 (button);
}


static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_xsize_spin_cb ((Mines*) self, _sender);
}


static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_ysize_spin_cb ((Mines*) self, _sender);
}


static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_mines_spin_cb ((Mines*) self, _sender);
}


static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_new_game_screen ((Mines*) self);
}


static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_custom_size_clicked_cb ((Mines*) self);
}


static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	GtkSpinButton* field_width_entry = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkSpinButton* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkSpinButton* field_height_entry = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkSpinButton* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkSpinButton* _tmp15_ = NULL;
	GtkSpinButton* _tmp16_ = NULL;
	GtkSpinButton* _tmp17_ = NULL;
	GtkSpinButton* _tmp18_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkAspectFrame* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "custom_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->custom_game_screen);
	self->priv->custom_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "width_spin_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_spin_button_get_type (), GtkSpinButton));
	field_width_entry = _tmp5_;
	gtk_spin_button_set_range (field_width_entry, (gdouble) MINES_XSIZE_MIN, (gdouble) MINES_XSIZE_MAX);
	g_signal_connect_object (field_width_entry, "value-changed", (GCallback) _mines_xsize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_width_entry, (gdouble) 1, (gdouble) 1);
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, MINES_KEY_XSIZE);
	gtk_spin_button_set_value (field_width_entry, (gdouble) _tmp7_);
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "height_spin_btn");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_spin_button_get_type (), GtkSpinButton));
	field_height_entry = _tmp10_;
	gtk_spin_button_set_range (field_height_entry, (gdouble) MINES_YSIZE_MIN, (gdouble) MINES_YSIZE_MAX);
	g_signal_connect_object (field_height_entry, "value-changed", (GCallback) _mines_ysize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_height_entry, (gdouble) 1, (gdouble) 1);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_int (_tmp11_, MINES_KEY_YSIZE);
	gtk_spin_button_set_value (field_height_entry, (gdouble) _tmp12_);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "mines_spin_btn");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_spin_button_get_type (), GtkSpinButton));
	_g_object_unref0 (self->priv->mines_spin);
	self->priv->mines_spin = _tmp15_;
	_tmp16_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp16_, (gdouble) 1, (gdouble) 100);
	_tmp17_ = self->priv->mines_spin;
	gtk_spin_button_set_increments (_tmp17_, (gdouble) 1, (gdouble) 1);
	_tmp18_ = self->priv->mines_spin;
	g_signal_connect_object (_tmp18_, "value-changed", (GCallback) _mines_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	mines_set_mines_limit (self);
	_tmp19_ = builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "cancel_btn");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_button_get_type (), GtkButton));
	button = _tmp21_;
	_tmp22_ = button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) _mines_show_new_game_screen_gtk_button_clicked, self, 0);
	_tmp23_ = builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "play_game_btn");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp25_;
	_tmp26_ = button;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) _mines_custom_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp27_ = self->priv->custom_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp27_);
	_g_object_unref0 (button);
	_g_object_unref0 (field_height_entry);
	_g_object_unref0 (field_width_entry);
}


static void mines_size_allocate_cb (Mines* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp2_ = self->priv->is_maximized;
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->is_tiled;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->window_skip_configure;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkAllocation _tmp5_ = {0};
		gint _tmp6_ = 0;
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
		_tmp5_ = *allocation;
		_tmp6_ = _tmp5_.width;
		self->priv->window_width = _tmp6_;
		_tmp7_ = *allocation;
		_tmp8_ = _tmp7_.height;
		self->priv->window_height = _tmp8_;
	}
	self->priv->window_skip_configure = FALSE;
}


static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		Minefield* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->minefield;
		_tmp3_ = minefield_is_clock_started (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp4_ = NULL;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = self->priv->minefield;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->pause_requested;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		ThemeSelectorDialog* _tmp5_ = NULL;
		_tmp5_ = self->priv->theme_dialog;
		if (_tmp5_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			ThemeSelectorDialog* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			_tmp6_ = self->priv->theme_dialog;
			_tmp7_ = gtk_widget_get_visible ((GtkWidget*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp4_ = _tmp8_ == FALSE;
		}
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp9_ = NULL;
		_tmp9_ = self->priv->minefield;
		minefield_set_paused (_tmp9_, FALSE);
	}
	result = FALSE;
	return result;
}


static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines) {
	gchar* result = NULL;
	gchar* size_label = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* mines_label = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_strdup_printf ("%d × %d", _tmp0_, _tmp1_);
	size_label = _tmp2_;
	_tmp3_ = n_mines;
	_tmp4_ = ngettext ("<b>%d</b> mine", "<b>%d</b> mines", (gulong) _tmp3_);
	_tmp5_ = n_mines;
	_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_);
	mines_label = _tmp6_;
	_tmp7_ = g_strdup_printf ("<span size='x-large' weight='ultrabold'>%s</span>\n%s", size_label, mines_label);
	result = _tmp7_;
	_g_free0 (mines_label);
	_g_free0 (size_label);
	return result;
}


void mines_start (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	mines_show_new_game_screen (self);
}


static void mines_real_shutdown (GApplication* base) {
	Mines * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	GtkSettings* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GSettings* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GSettings* _tmp10_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = gtk_settings_get_default ();
	g_object_get (_tmp5_, "gtk-enable-animations", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	g_settings_set_boolean (_tmp4_, MINES_KEY_USE_ANIMATIONS, _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp8_, "window-is-maximized", _tmp9_);
	_tmp10_ = self->priv->settings;
	g_settings_apply (_tmp10_);
}


static gint mines_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Mines * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GVariantDict* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GVariantDict* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	self = (Mines*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%1$s %2$s\n", "gnome-mines", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp3_ = options;
	_tmp4_ = g_variant_dict_contains (_tmp3_, "small");
	if (_tmp4_) {
		mines_game_mode = 0;
	}
	_tmp5_ = options;
	_tmp6_ = g_variant_dict_contains (_tmp5_, "medium");
	if (_tmp6_) {
		mines_game_mode = 1;
	}
	_tmp7_ = options;
	_tmp8_ = g_variant_dict_contains (_tmp7_, "big");
	if (_tmp8_) {
		mines_game_mode = 2;
	}
	result = -1;
	return result;
}


static void mines_real_activate (GApplication* base) {
	Mines * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Mines*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present (_tmp0_);
}


static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Minefield* _tmp3_ = NULL;
		_tmp3_ = self->priv->minefield;
		minefield_set_paused (_tmp3_, FALSE);
		self->priv->pause_requested = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void mines_quit_cb (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void mines_update_flag_label (Mines* self) {
	GtkLabel* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Minefield* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flag_label;
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_n_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->minefield;
	_tmp5_ = _tmp4_->n_mines;
	_tmp6_ = g_strdup_printf ("%u/%u", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_text (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
}


static gint mines_show_theme_selector (Mines* self) {
	gint result = 0;
	GtkWindow* _tmp0_ = NULL;
	ThemeSelectorDialog* _tmp1_ = NULL;
	gint _result_ = 0;
	ThemeSelectorDialog* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ThemeSelectorDialog* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->window;
	_tmp1_ = theme_selector_dialog_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->theme_dialog);
	self->priv->theme_dialog = _tmp1_;
	_tmp2_ = self->priv->theme_dialog;
	_tmp3_ = gtk_dialog_run ((GtkDialog*) _tmp2_);
	_result_ = _tmp3_;
	_tmp4_ = self->priv->theme_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	result = _result_;
	return result;
}


static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_close;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static void mines_scores_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_show_scores (self, NULL, FALSE);
}


static void mines_preferences_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_show_theme_selector (self);
}


static void mines_show_custom_game_screen (Mines* self) {
	Minefield* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "custom_game");
}


static gboolean mines_can_start_new_game (Mines* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Minefield* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_n_cleared (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Minefield* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = self->priv->minefield;
		_tmp8_ = _tmp7_->exploded;
		_tmp1_ = !_tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Minefield* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_is_complete (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = !_tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean was_paused = FALSE;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		Minefield* _tmp15_ = NULL;
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GtkMessageDialog* _tmp18_ = NULL;
		GtkMessageDialog* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GtkMessageDialog* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _result_ = 0;
		GtkMessageDialog* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		GtkMessageDialog* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		_tmp12_ = self->priv->minefield;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		was_paused = _tmp14_;
		_tmp15_ = self->priv->minefield;
		minefield_set_paused (_tmp15_, TRUE);
		_tmp16_ = self->priv->window;
		_tmp17_ = _ ("Do you want to start a new game?");
		_tmp18_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp16_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp17_);
		g_object_ref_sink (_tmp18_);
		dialog = _tmp18_;
		_tmp19_ = dialog;
		_tmp20_ = _ ("If you start a new game, your current progress will be lost.");
		g_object_set (_tmp19_, "secondary-text", _tmp20_, NULL);
		_tmp21_ = dialog;
		_tmp22_ = _ ("Keep Current Game");
		_tmp23_ = _ ("Start New Game");
		gtk_dialog_add_buttons ((GtkDialog*) _tmp21_, _tmp22_, GTK_RESPONSE_DELETE_EVENT, _tmp23_, GTK_RESPONSE_ACCEPT, NULL, NULL);
		_tmp24_ = dialog;
		_tmp25_ = gtk_dialog_run ((GtkDialog*) _tmp24_);
		_result_ = _tmp25_;
		_tmp26_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp26_);
		_tmp27_ = _result_;
		if (_tmp27_ != ((gint) GTK_RESPONSE_ACCEPT)) {
			Minefield* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp28_ = self->priv->minefield;
			_tmp29_ = was_paused;
			minefield_set_paused (_tmp28_, _tmp29_);
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		_g_object_unref0 (dialog);
	}
	result = TRUE;
	return result;
}


static void mines_show_new_game_screen (Mines* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "new_game") == 0) {
		return;
	}
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_ = NULL;
		Minefield* _tmp5_ = NULL;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
		self->priv->pause_requested = FALSE;
		_tmp5_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp5_, NULL, self);
	}
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = NULL;
	_tmp6_ = self->priv->window;
	_tmp7_ = self->priv->window_width;
	_tmp8_ = self->priv->window_height;
	gtk_window_resize (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
	_tmp10_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp10_, FALSE);
	_tmp11_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp11_, "new_game");
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Mines* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self) {
	mines_marks_changed_cb ((Mines*) self, _sender);
}


static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	mines_explode_cb ((Mines*) self, _sender);
}


static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self) {
	mines_cleared_cb ((Mines*) self, _sender);
}


static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self) {
	mines_tick_cb ((Mines*) self);
}


static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self) {
	mines_paused_changed_cb ((Mines*) self);
}


static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self) {
	mines_clock_started_cb ((Mines*) self);
}


static void __lambda18_ (Block1Data* _data1_, GtkAllocation* allocation) {
	Mines* self;
	MinefieldView* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
	GtkBox* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
	GtkBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkAspectFrame* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gint _tmp13_ = 0;
	MinefieldView* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	self = _data1_->self;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = self->priv->minefield_view;
	_tmp1_ = minefield_view_get_mine_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data1_->x;
	_data1_->width = _tmp2_ * _tmp3_;
	_tmp4_ = _data1_->width;
	_tmp5_ = self->priv->aspect_child;
	_tmp6_ = gtk_box_get_spacing (_tmp5_);
	_tmp7_ = _tmp6_;
	_data1_->width = _tmp4_ + _tmp7_;
	_tmp8_ = _data1_->width;
	_tmp9_ = self->priv->buttons_box;
	_tmp10_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp9_);
	_data1_->width = _tmp8_ + _tmp10_;
	_tmp11_ = self->priv->minefield_aspect;
	_tmp12_ = _data1_->width;
	_tmp13_ = _data1_->y;
	_tmp14_ = self->priv->minefield_view;
	_tmp15_ = minefield_view_get_mine_size (_tmp14_);
	_tmp16_ = _tmp15_;
	g_object_set (_tmp11_, "ratio", ((gfloat) _tmp12_) / (_tmp13_ * _tmp16_), NULL);
}


static void ___lambda18__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda18_ (self, allocation);
}


static void mines_start_game (Mines* self) {
	Block1Data* _data1_;
	MinefieldView* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	gint n = 0;
	GSettings* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Minefield* _tmp21_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	Minefield* _tmp26_ = NULL;
	Minefield* _tmp27_ = NULL;
	Minefield* _tmp28_ = NULL;
	Minefield* _tmp29_ = NULL;
	Minefield* _tmp30_ = NULL;
	Minefield* _tmp31_ = NULL;
	Minefield* _tmp32_ = NULL;
	MinefieldView* _tmp33_ = NULL;
	Minefield* _tmp34_ = NULL;
	gint mine_size = 0;
	MinefieldView* _tmp35_ = NULL;
	guint _tmp36_ = 0U;
	guint _tmp37_ = 0U;
	gint _tmp38_ = 0;
	gint request_x = 0;
	gint request_y = 0;
	GtkWindow* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	GtkScrolledWindow* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	GtkBox* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	GtkBox* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	GtkWindow* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	GtkScrolledWindow* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	GtkAspectFrame* _tmp74_ = NULL;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	guint _tmp79_ = 0U;
	GtkBox* _tmp80_ = NULL;
	gint _tmp81_ = 0;
	gint _tmp82_ = 0;
	guint _tmp83_ = 0U;
	GtkBox* _tmp84_ = NULL;
	gint _tmp85_ = 0;
	guint _tmp86_ = 0U;
	GtkAspectFrame* _tmp87_ = NULL;
	guint _tmp88_ = 0U;
	gint _tmp89_ = 0;
	gint _tmp90_ = 0;
	GtkAspectFrame* _tmp91_ = NULL;
	Minefield* _tmp92_ = NULL;
	GtkStack* _tmp93_ = NULL;
	GSimpleAction* _tmp94_ = NULL;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	self->priv->window_skip_configure = TRUE;
	_tmp0_ = self->priv->minefield_view;
	g_object_set ((GtkWidget*) _tmp0_, "has-focus", TRUE, NULL);
	_tmp1_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->play_pause_label;
	_tmp3_ = _ ("_Pause");
	gtk_label_set_label (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->replay_button;
	_tmp5_ = _ ("St_art Over");
	gtk_button_set_label (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->high_scores_button;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = g_settings_get_int (_tmp8_, MINES_KEY_MODE);
	switch (_tmp9_) {
		case 0:
		{
			_data1_->x = 8;
			_data1_->y = 8;
			n = 10;
			break;
		}
		case 1:
		{
			_data1_->x = 16;
			_data1_->y = 16;
			n = 40;
			break;
		}
		case 2:
		{
			_data1_->x = 30;
			_data1_->y = 16;
			n = 99;
			break;
		}
		default:
		case 3:
		{
			GSettings* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			GSettings* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			GSettings* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp10_ = self->priv->settings;
			_tmp11_ = g_settings_get_int (_tmp10_, MINES_KEY_XSIZE);
			_tmp12_ = CLAMP (_tmp11_, MINES_XSIZE_MIN, MINES_XSIZE_MAX);
			_data1_->x = _tmp12_;
			_tmp13_ = self->priv->settings;
			_tmp14_ = g_settings_get_int (_tmp13_, MINES_KEY_YSIZE);
			_tmp15_ = CLAMP (_tmp14_, MINES_YSIZE_MIN, MINES_YSIZE_MAX);
			_data1_->y = _tmp15_;
			_tmp16_ = self->priv->settings;
			_tmp17_ = g_settings_get_int (_tmp16_, MINES_KEY_NMINES);
			_tmp18_ = _data1_->x;
			_tmp19_ = _data1_->y;
			_tmp20_ = CLAMP (_tmp17_, 1, (_tmp18_ * _tmp19_) - 10);
			n = _tmp20_;
			break;
		}
	}
	_tmp21_ = self->priv->minefield;
	if (_tmp21_ != NULL) {
		Minefield* _tmp22_ = NULL;
		_tmp22_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp22_, NULL, self);
	}
	_tmp23_ = _data1_->x;
	_tmp24_ = _data1_->y;
	_tmp25_ = n;
	_tmp26_ = minefield_new ((guint) _tmp23_, (guint) _tmp24_, (guint) _tmp25_);
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = _tmp26_;
	_tmp27_ = self->priv->minefield;
	g_signal_connect_object (_tmp27_, "marks-changed", (GCallback) _mines_marks_changed_cb_minefield_marks_changed, self, 0);
	_tmp28_ = self->priv->minefield;
	g_signal_connect_object (_tmp28_, "explode", (GCallback) _mines_explode_cb_minefield_explode, self, 0);
	_tmp29_ = self->priv->minefield;
	g_signal_connect_object (_tmp29_, "cleared", (GCallback) _mines_cleared_cb_minefield_cleared, self, 0);
	_tmp30_ = self->priv->minefield;
	g_signal_connect_object (_tmp30_, "tick", (GCallback) _mines_tick_cb_minefield_tick, self, 0);
	_tmp31_ = self->priv->minefield;
	g_signal_connect_object (_tmp31_, "paused-changed", (GCallback) _mines_paused_changed_cb_minefield_paused_changed, self, 0);
	_tmp32_ = self->priv->minefield;
	g_signal_connect_object (_tmp32_, "clock-started", (GCallback) _mines_clock_started_cb_minefield_clock_started, self, 0);
	_tmp33_ = self->priv->minefield_view;
	_tmp34_ = self->priv->minefield;
	minefield_view_set_minefield (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->minefield_view;
	_tmp36_ = minefield_view_get_mine_size (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = MAX ((gint) _tmp37_, 30);
	mine_size = _tmp38_;
	request_x = -1;
	request_y = -1;
	_tmp39_ = self->priv->window;
	_tmp40_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp39_);
	_tmp41_ = self->priv->scrolled;
	_tmp42_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp41_);
	_tmp43_ = _data1_->x;
	_tmp44_ = self->priv->aspect_child;
	_tmp45_ = gtk_box_get_spacing (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = self->priv->buttons_box;
	_tmp48_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp47_);
	_tmp49_ = gdk_screen_width ();
	if (((((_tmp40_ - _tmp42_) + (30 * _tmp43_)) + _tmp46_) + _tmp48_) < _tmp49_) {
		gint _tmp50_ = 0;
		GtkBox* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		_tmp50_ = _data1_->x;
		_tmp51_ = self->priv->aspect_child;
		_tmp52_ = gtk_box_get_spacing (_tmp51_);
		_tmp53_ = _tmp52_;
		request_x = ((_tmp50_ * 30) + _tmp53_) + 150;
	} else {
		gint _tmp54_ = 0;
		GtkWindow* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		GtkScrolledWindow* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		GtkBox* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		_tmp54_ = gdk_screen_width ();
		_tmp55_ = self->priv->window;
		_tmp56_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp55_);
		_tmp57_ = self->priv->scrolled;
		_tmp58_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp57_);
		_tmp59_ = self->priv->aspect_child;
		_tmp60_ = gtk_box_get_spacing (_tmp59_);
		_tmp61_ = _tmp60_;
		request_x = (((_tmp54_ - _tmp56_) + _tmp58_) + _tmp61_) + 150;
	}
	_tmp62_ = self->priv->window;
	_tmp63_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp62_);
	_tmp64_ = self->priv->scrolled;
	_tmp65_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp64_);
	_tmp66_ = _data1_->y;
	_tmp67_ = gdk_screen_height ();
	if (((_tmp63_ - _tmp65_) + (30 * _tmp66_)) < _tmp67_) {
		gint _tmp68_ = 0;
		_tmp68_ = _data1_->y;
		request_y = _tmp68_ * 30;
	} else {
		gint _tmp69_ = 0;
		GtkWindow* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		GtkScrolledWindow* _tmp72_ = NULL;
		gint _tmp73_ = 0;
		_tmp69_ = gdk_screen_height ();
		_tmp70_ = self->priv->window;
		_tmp71_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp70_);
		_tmp72_ = self->priv->scrolled;
		_tmp73_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp72_);
		request_y = (_tmp69_ - _tmp71_) + _tmp73_;
	}
	_tmp74_ = self->priv->minefield_aspect;
	_tmp75_ = request_x;
	_tmp76_ = request_y;
	gtk_widget_set_size_request ((GtkWidget*) _tmp74_, _tmp75_, _tmp76_);
	_tmp77_ = _data1_->x;
	_tmp78_ = mine_size;
	_data1_->width = (guint) (_tmp77_ * _tmp78_);
	_tmp79_ = _data1_->width;
	_tmp80_ = self->priv->aspect_child;
	_tmp81_ = gtk_box_get_spacing (_tmp80_);
	_tmp82_ = _tmp81_;
	_data1_->width = _tmp79_ + _tmp82_;
	_tmp83_ = _data1_->width;
	_tmp84_ = self->priv->buttons_box;
	_tmp85_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp84_);
	_tmp86_ = MAX ((guint) _tmp85_, (guint) 150);
	_data1_->width = _tmp83_ + _tmp86_;
	_tmp87_ = self->priv->minefield_aspect;
	_tmp88_ = _data1_->width;
	_tmp89_ = _data1_->y;
	_tmp90_ = mine_size;
	g_object_set (_tmp87_, "ratio", ((gfloat) _tmp88_) / (_tmp89_ * _tmp90_), NULL);
	_tmp91_ = self->priv->minefield_aspect;
	g_signal_connect_data ((GtkWidget*) _tmp91_, "size-allocate", (GCallback) ___lambda18__gtk_widget_size_allocate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	mines_update_flag_label (self);
	_tmp92_ = self->priv->minefield;
	minefield_set_paused (_tmp92_, FALSE);
	self->priv->pause_requested = FALSE;
	_tmp93_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp93_, "game");
	_tmp94_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp94_, FALSE);
	mines_tick_cb (self);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void mines_new_game_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}


static void mines_silent_new_game_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		_tmp2_ = self->priv->minefield;
		_tmp3_ = minefield_get_n_cleared (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == ((guint) 0);
	}
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}


static void mines_repeat_size_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_start_game (self);
	}
}


static void mines_toggle_pause_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->pause_requested;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->pause_requested = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		Minefield* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp5_ = self->priv->minefield;
		_tmp6_ = self->priv->minefield;
		_tmp7_ = minefield_get_paused (_tmp6_);
		_tmp8_ = _tmp7_;
		minefield_set_paused (_tmp5_, !_tmp8_);
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->pause_requested = _tmp11_;
	}
}


static void mines_paused_changed_cb (Mines* self) {
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkBox* _tmp10_ = NULL;
	Minefield* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkLabel* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->play_pause_label;
		_tmp4_ = _ ("_Resume");
		gtk_label_set_label (_tmp3_, _tmp4_);
	} else {
		Minefield* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp5_ = self->priv->minefield;
		_tmp6_ = minefield_get_elapsed (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ > ((gdouble) 0)) {
			GtkLabel* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			_tmp8_ = self->priv->play_pause_label;
			_tmp9_ = _ ("_Pause");
			gtk_label_set_label (_tmp8_, _tmp9_);
		}
	}
	_tmp10_ = self->priv->paused_box;
	_tmp11_ = self->priv->minefield;
	_tmp12_ = minefield_get_paused (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, _tmp13_);
}


static void mines_marks_changed_cb (Mines* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_update_flag_label (self);
}


static void mines_explode_cb (Mines* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_game_ended (self);
}


static void mines_game_ended (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->replay_button;
	_tmp1_ = _ ("Play _Again");
	gtk_button_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->play_pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->high_scores_button;
	gtk_widget_show ((GtkWidget*) _tmp4_);
}


static void mines_cleared_cb (Mines* self, Minefield* minefield) {
	GDateTime* date = NULL;
	GDateTime* _tmp0_ = NULL;
	guint duration = 0U;
	Minefield* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	Minefield* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	Minefield* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	HistoryEntry* _tmp12_ = NULL;
	History* _tmp13_ = NULL;
	HistoryEntry* _tmp14_ = NULL;
	History* _tmp15_ = NULL;
	HistoryEntry* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	date = _tmp0_;
	_tmp1_ = minefield;
	_tmp2_ = minefield_get_elapsed (_tmp1_);
	_tmp3_ = _tmp2_;
	duration = (guint) (_tmp3_ + 0.5);
	_tmp4_ = date;
	_tmp5_ = minefield;
	_tmp6_ = _tmp5_->width;
	_tmp7_ = minefield;
	_tmp8_ = _tmp7_->height;
	_tmp9_ = minefield;
	_tmp10_ = _tmp9_->n_mines;
	_tmp11_ = duration;
	_tmp12_ = history_entry_new (_tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp11_);
	entry = _tmp12_;
	_tmp13_ = self->priv->history;
	_tmp14_ = entry;
	history_add (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->history;
	history_save (_tmp15_);
	_tmp16_ = entry;
	_tmp17_ = mines_show_scores (self, _tmp16_, TRUE);
	if (_tmp17_ == ((gint) GTK_RESPONSE_OK)) {
		mines_show_new_game_screen (self);
	} else {
		mines_game_ended (self);
	}
	_g_object_unref0 (entry);
	_g_date_time_unref0 (date);
}


static void mines_clock_started_cb (Mines* self) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_label;
	_tmp1_ = _ ("_Pause");
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->replay_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
	_tmp4_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp4_, TRUE);
}


static void mines_tick_cb (Mines* self) {
	gint elapsed = 0;
	Minefield* _tmp0_ = NULL;
	gint hours = 0;
	gint _tmp4_ = 0;
	gint minutes = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint seconds = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->minefield;
		_tmp2_ = minefield_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	_tmp4_ = elapsed;
	hours = _tmp4_ / 3600;
	_tmp5_ = elapsed;
	_tmp6_ = hours;
	minutes = (_tmp5_ - (_tmp6_ * 3600)) / 60;
	_tmp7_ = elapsed;
	_tmp8_ = hours;
	_tmp9_ = minutes;
	seconds = (_tmp7_ - (_tmp8_ * 3600)) - (_tmp9_ * 60);
	_tmp10_ = hours;
	if (_tmp10_ > 0) {
		GtkLabel* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp11_ = self->priv->clock_label;
		_tmp12_ = hours;
		_tmp13_ = minutes;
		_tmp14_ = seconds;
		_tmp15_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp12_, _tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_text (_tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		GtkLabel* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp17_ = self->priv->clock_label;
		_tmp18_ = minutes;
		_tmp19_ = seconds;
		_tmp20_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	}
}


static void mines_about_cb (Mines* self) {
	gchar** authors = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Main game:");
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("Szekeres Istvan (Pista)");
	_tmp3_ = g_strdup ("Robert Ancell");
	_tmp4_ = g_strdup ("Robert Roth");
	_tmp5_ = g_strdup ("");
	_tmp6_ = _ ("Score:");
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_strdup ("Horacio J. Peña");
	_tmp9_ = g_strdup ("");
	_tmp10_ = _ ("Resizing and SVG support:");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_strdup ("Steve Chaplin");
	_tmp13_ = g_strdup ("Callum McKenzie");
	_tmp14_ = g_new0 (gchar*, 12 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp2_;
	_tmp14_[2] = _tmp3_;
	_tmp14_[3] = _tmp4_;
	_tmp14_[4] = _tmp5_;
	_tmp14_[5] = _tmp7_;
	_tmp14_[6] = _tmp8_;
	_tmp14_[7] = _tmp9_;
	_tmp14_[8] = _tmp11_;
	_tmp14_[9] = _tmp12_;
	_tmp14_[10] = _tmp13_;
	_tmp14_[11] = NULL;
	authors = _tmp14_;
	authors_length1 = 12;
	_authors_size_ = authors_length1;
	_tmp15_ = g_strdup ("Richard Hoelscher");
	_tmp16_ = g_new0 (gchar*, 2 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp16_[1] = NULL;
	artists = _tmp16_;
	artists_length1 = 2;
	_artists_size_ = artists_length1;
	_tmp17_ = g_strdup ("Ekaterina Gerasimova");
	_tmp18_ = g_new0 (gchar*, 2 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp18_[1] = NULL;
	documenters = _tmp18_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp19_ = self->priv->window;
	_tmp20_ = _ ("Mines");
	_tmp21_ = _ ("Clear explosive mines off the board");
	_tmp22_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp19_, "name", _tmp20_, "version", VERSION, "comments", _tmp21_, "copyright", "Copyright © 1997–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp22_, "logo-icon-name", "gnome-mines", "website", "https://wiki.gnome.org/Apps/Mines", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gfloat mines_percent_mines (Mines* self) {
	gfloat result = 0.0F;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_NMINES);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_XSIZE);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, MINES_KEY_YSIZE);
	result = (100.0f * ((gfloat) _tmp1_)) / (_tmp3_ * _tmp5_);
	return result;
}


static void mines_set_mines_limit (Mines* self) {
	gint size = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint max_mines = 0;
	gdouble _tmp4_ = 0.0;
	gint min_mines = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	GtkSpinButton* _tmp7_ = NULL;
	GtkSpinButton* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gdouble _tmp10_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_XSIZE);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_YSIZE);
	size = _tmp1_ * _tmp3_;
	_tmp4_ = round ((gdouble) ((100.0f * ((gfloat) (size - 10))) / size));
	max_mines = (gint) _tmp4_;
	_tmp5_ = round ((gdouble) (100.0f / size));
	_tmp6_ = MAX (1, (gint) _tmp5_);
	min_mines = _tmp6_;
	_tmp7_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp7_, (gdouble) min_mines, (gdouble) max_mines);
	_tmp8_ = self->priv->mines_spin;
	_tmp9_ = mines_percent_mines (self);
	_tmp10_ = round ((gdouble) _tmp9_);
	gtk_spin_button_set_value (_tmp8_, (gdouble) ((gint) _tmp10_));
}


static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint xsize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	xsize = _tmp1_;
	_tmp2_ = xsize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_XSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = xsize;
	g_settings_set_int (_tmp5_, MINES_KEY_XSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint ysize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	ysize = _tmp1_;
	_tmp2_ = ysize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_YSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = ysize;
	g_settings_set_int (_tmp5_, MINES_KEY_YSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin) {
	gfloat _tmp0_ = 0.0F;
	GtkSpinButton* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GSettings* _tmp4_ = NULL;
	GtkSpinButton* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gdouble _tmp11_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = mines_percent_mines (self);
	_tmp1_ = spin;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = fabs (_tmp0_ - _tmp2_);
	if (_tmp3_ <= ((gdouble) 0.5f)) {
		return;
	}
	_tmp4_ = self->priv->settings;
	_tmp5_ = spin;
	_tmp6_ = gtk_spin_button_get_value (_tmp5_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_int (_tmp7_, MINES_KEY_XSIZE);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, MINES_KEY_YSIZE);
	_tmp11_ = round ((_tmp6_ * (_tmp8_ * _tmp10_)) / 100.0f);
	g_settings_set_int (_tmp4_, MINES_KEY_NMINES, (gint) _tmp11_);
}


static void mines_set_mode (Mines* self, gint mode) {
	Minefield* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = mode;
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_MODE);
	if (_tmp1_ != _tmp3_) {
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = mode;
		g_settings_set_int (_tmp4_, MINES_KEY_MODE, _tmp5_);
	}
	mines_start_game (self);
}


static void mines_small_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 0);
}


static void mines_medium_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 1);
}


static void mines_large_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 2);
}


static void mines_custom_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 3);
}


static void mines_help_cb (Mines* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-mines", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-mines.vala:903: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gint mines_main (gchar** args, int args_length1) {
	gint result = 0;
	Mines* app = NULL;
	Mines* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = mines_new ();
	app = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) app, _tmp1__length1, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return mines_main (argv, argc);
}


static void mines_class_init (MinesClass * klass) {
	mines_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinesPrivate));
	((GApplicationClass *) klass)->startup = mines_real_startup;
	((GApplicationClass *) klass)->shutdown = mines_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = mines_real_handle_local_options;
	((GApplicationClass *) klass)->activate = mines_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mines_finalize;
}


static void mines_instance_init (Mines * self) {
	self->priv = MINES_GET_PRIVATE (self);
}


static void mines_finalize (GObject* obj) {
	Mines * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINES, Mines);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_screen);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->play_pause_label);
	_g_object_unref0 (self->priv->replay_button);
	_g_object_unref0 (self->priv->high_scores_button);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->minefield_aspect);
	_g_object_unref0 (self->priv->minefield_overlay);
	_g_object_unref0 (self->priv->aspect_child);
	_g_object_unref0 (self->priv->buttons_box);
	_g_object_unref0 (self->priv->paused_box);
	_g_object_unref0 (self->priv->scrolled);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->theme_dialog);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->app_main_menu);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->minefield);
	_g_object_unref0 (self->priv->minefield_view);
	_g_object_unref0 (self->priv->flag_label);
	_g_object_unref0 (self->priv->mines_spin);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->repeat_size_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->custom_game_screen);
	_g_object_unref0 (self->priv->theme_provider);
	G_OBJECT_CLASS (mines_parent_class)->finalize (obj);
}


GType mines_get_type (void) {
	static volatile gsize mines_type_id__volatile = 0;
	if (g_once_init_enter (&mines_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mines_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mines), 0, (GInstanceInitFunc) mines_instance_init, NULL };
		GType mines_type_id;
		mines_type_id = g_type_register_static (gtk_application_get_type (), "Mines", &g_define_type_info, 0);
		g_once_init_leave (&mines_type_id__volatile, mines_type_id);
	}
	return mines_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



