static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2008 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2013 Daniel Sabo                                                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (start_x, _(\"X1\"), 25.0)                                    \n"
"    ui_meta(\"unit\", \"pixel-coordinate\")                                   \n"
"    ui_meta(\"axis\", \"x\")                                                  \n"
"                                                                              \n"
"property_double (start_y, _(\"Y1\"), 25.0)                                    \n"
"    ui_meta(\"unit\", \"pixel-coordinate\")                                   \n"
"    ui_meta(\"axis\", \"y\")                                                  \n"
"                                                                              \n"
"property_double (end_x, _(\"X2\"), 150.0)                                     \n"
"    ui_meta(\"unit\", \"pixel-coordinate\")                                   \n"
"    ui_meta(\"axis\", \"x\")                                                  \n"
"                                                                              \n"
"property_double (end_y, _(\"Y2\"), 150.0)                                     \n"
"    ui_meta (\"unit\", \"pixel-coordinate\")                                  \n"
"    ui_meta (\"axis\", \"y\")                                                 \n"
"                                                                              \n"
"property_color (start_color, _(\"Start Color\"), \"black\")                   \n"
"    description (_(\"The color at (x1, y1)\"))                                \n"
"    ui_meta (\"role\", \"color-primary\")                                     \n"
"                                                                              \n"
"property_color  (end_color, _(\"End Color\"), \"white\")                      \n"
"    description (_(\"The color at (x2, y2)\"))                                \n"
"    ui_meta     (\"role\", \"color-secondary\")                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_C_SOURCE linear-gradient.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat         *out_pixel = out_buf;                                        \n"
"  gfloat          color1[4], color2[4], length, dx, dy;                       \n"
"                                                                              \n"
"  dx = o->end_x - o->start_x;                                                 \n"
"  dy = o->end_y - o->start_y;                                                 \n"
"                                                                              \n"
"  length = dx * dx + dy * dy;                                                 \n"
"                                                                              \n"
"  if (GEGL_FLOAT_IS_ZERO (length))                                            \n"
"    {                                                                         \n"
"      memset (out_buf, 0, n_pixels * sizeof(float) * 4);                      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gfloat vec0 = dx / length;                                              \n"
"      gfloat vec1 = dy / length;                                              \n"
"      gint x, y;                                                              \n"
"                                                                              \n"
"      gegl_color_get_pixel (o->start_color, babl_format (\"R'G'B'A float\"), color1);\n"
"      gegl_color_get_pixel (o->end_color, babl_format (\"R'G'B'A float\"), color2);\n"
"                                                                              \n"
"      for (y = roi->y; y < roi->y + roi->height; ++y)                         \n"
"        {                                                                     \n"
"          for (x = roi->x; x < roi->x + roi->width; ++x)                      \n"
"            {                                                                 \n"
"              gint c;                                                         \n"
"              gfloat v = vec0 * (x - o->start_x) + vec1 * (y - o->start_y);   \n"
"                                                                              \n"
"              if (v > 1.0f - GEGL_FLOAT_EPSILON)                              \n"
"                v = 1.0f;                                                     \n"
"              if (v < 0.0f + GEGL_FLOAT_EPSILON)                              \n"
"                v = 0.0f;                                                     \n"
"                                                                              \n"
"              for (c = 0; c < 4; c++)                                         \n"
"                out_pixel[c] = color1[c] * v + color2[c] * (1.0f - v);        \n"
"                                                                              \n"
"              out_pixel += 4;                                                 \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->no_cache = TRUE;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:linear-gradient\",                         \n"
"    \"title\",              _(\"Linear Gradient\"),                           \n"
"    \"categories\",         \"render:gradient\",                              \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\" , _(\"Linear gradient renderer\"),                        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
