.\" dpkg manual page - dpkg-deb(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-shlibdeps 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-shlibdeps \- générateur de variables de substitution de dépendances pour
bibliothèques partagées
.
.SH SYNOPSIS
\fBdpkg\-shlibdeps\fP [\fIoption\fP...] [\fB\-e\fP]\fIexécutable\fP [\fIoption\fP...]
.
.SH DESCRIPTION
\fBdpkg\-shlibdeps\fP calcule, pour les exécutables indiqués dans ses
paramètres, les dépendances envers les bibliothèques partagées. Ces
dépendances sont ajoutées au fichier de variables de substitution
\fBdebian/substvars\fP sous la forme \fBshlibs:\fP\fIdependencyfield\fP où
\fIdependencyfield\fP est le nom du champ de dépendance. Toute autre variable
après \fIshlibs:\fP est supprimée du fichier.
.P
\fBdpkg\-shlibdeps\fP a deux sources possibles pour créer les informations
concernant les dépendances. Soit les fichiers \fIsymbols\fP, soit les fichiers
\fIshlibs\fP. Pour chaque fichier binaire qu'il analyse, \fBdpkg\-shlibdeps\fP
recherche la liste des bibliothèques partagées qui lui sont liées. Puis,
pour chacune d'elles il analyse soit le fichier \fIsymbols\fP, soit le fichier
\fIshlibs\fP (si le premier n'existe pas ou si debian/shlibs.local contient les
dépendances appropriées). Ces deux fichiers sont sensés être fournis par le
paquet de la bibliothèque et disponibles dans
%ADMINDIR%/info/\fIpaquet\fP.\fIsymbols\fP ou
%ADMINDIR%/info/\fIpaquet\fP.\fIshlibs\fP. Le nom du paquet est trouvé en deux
étapes\ : en cherchant les fichiers de la bibliothèque sur le système, dans
le répertoire que \fBld.so\fP utiliserait, puis un utilisant \fBdpkg \-S
\fP\fIfichier\-bibliothèque\fP pour trouver le paquet qui fournit cette
bibliothèque.
.SS "Fichiers symboles"
Les fichiers symboles contiennent des informations de dépendances plus fines
en fournissant les dépendances minimales pour chaque symbole de la
bibliothèque exportée. Le script essaie de trouver un fichier de symboles
associé à un paquet de bibliothèque dans les emplacements suivants (le
premier trouvé est utilisé)\ :
.IP debian/*/DEBIAN/symbols
L'information des bibliothèques partagées générée par l'actuel processus de
construction qui invoque aussi \fBdpkg\-shlibdeps\fP. Elles sont générées par
\fBdpkg\-gensymbols\fP(1) et ne sont utilisées que si la bibliothèque se trouve
dans l'arbre de construction d'un paquet. Le fichier des symboles qui
construit l'arbre s'appuie sur les fichiers de symboles d'autres paquets
binaires.
.IP %PKGCONFDIR%/symbols/\fIpaquet\fP.symbols.\fIarchitecture\fP
.IP %PKGCONFDIR%/symbols/\fIpaquet\fP.symbols
L'information de dépendance des bibliothèques partagées associée aux
systèmes. \fIarch\fP est l'architecture du système actuel (obtenu par
\fBdpkg\-architecture \-qDEB_HOST_ARCH\fP).
.IP "Affichage de “\fBdpkg\-query \-\-control\-path\fP \fIpaquet\fP symbols”"
Paquet fournissant des informations concernant les dépendances envers des
bibliothèques partagées. Sauf indication contraire par le biais de
\fB\-\-admindir\fP, ces fichiers sont par défaut dans %ADMINDIR%.
.P
Lors de l'analyse des symboles utilisés par tous les binaires,
\fBdpkg\-shlibdeps\fP retient la (plus grande) version minimale nécessaire pour
chaque bibliothèque. À la fin du processus, il est capable d'écrire la
dépendance minimale pour toutes les bibliothèques utilisées (à condition que
l'information des fichiers \fIsymbols\fP soit exacte).
.P
Comme garde\-fou, un fichier de symboles peut fournir un champ
\fBBuild\-Depends\-Package\fP de méta\-information et \fBdpkg\-shlibdeps\fP en
extraira la version minimale requise par le paquet correspondant depuis ce
champ \fBBuild\-Depends\fP et utilisera cette version si elle est supérieure à
la version minimale calculée par l'examen des symboles.
.SS "Fichiers Shlibs"
Les fichiers Shlibs associent directement une bibliothèque à une dépendance
(sans regarder les symboles). Il agit donc souvent plus fortement que ce
dont on aurait besoin mais il reste très sûr et facile à manipuler.
.P
Les dépendances d'une bibliothèque sont recherchées à plusieurs endroits. Le
premier fichier d'informations trouvé qui concerne la bibliothèque est
utilisé\ :
.IP debian/shlibs.local
Fichier particulier à un paquet remplaçant les informations qui concernent
les dépendances envers des bibliothèques partagées.
.IP %PKGCONFDIR%/shlibs.override
Fichier système remplaçant les informations qui concernent les dépendances
envers des bibliothèques partagées.
.IP debian/*/DEBIAN/shlibs
Information sur la bibliothèque partagée générée par le processus actuel de
construction qui invoque aussi \fBdpkg\-shlibdeps\fP. Il n'est utilisé que si la
bibliothèque se trouve dans l'arbre de construction du paquet. Le fichier
shlibs qui construit l'arbre a priorité sur les fichiers shlibs des autres
paquets binaires.
.IP "Affichage de “\fBdpkg\-query \-\-control\-path\fP \fIpaquet\fP shlibs”"
Paquet fournissant des informations concernant les dépendances envers des
bibliothèques partagées. Sauf indication contraire par le biais de
\fB\-\-admindir\fP, ces fichiers sont par défaut dans %ADMINDIR%.
.IP %PKGCONFDIR%/shlibs.default
Fichier système par défaut concernant les informations de dépendance envers
des bibliothèques partagées.
.P
Les dépendances trouvées sont ensuite directement utilisées (sauf si elles
sont filtrées parce qu'elles ont été identifiées comme étant en double, ou
d'un niveau plus faible qu'une autre dépendance).
.SH OPTIONS
\fBdpkg\-shlibdeps\fP interprète des arguments sans option comme des commandes
exécutables, comme si on avait simplement donné \fB\-e\fP\fIexécutable\fP.
.TP 
\fB\-e\fP\fIexécutable\fP
Cette option inclut les bonnes dépendances envers les bibliothèques
partagées que demande \fIexécutable\fP. Cette option peut être utilisée
plusieurs fois.
.TP 
\fB\-l\fP\fIrépertoire\fP
Prepend \fIdirectory\fP to the list of directories to search for private shared
libraries (since dpkg 1.17.0). This option can be used multiple times.

Note\ : Utilisez cette option plutôt que le réglage de \fBLD_LIBRARY_PATH\fP,
parce que cette variable d'environnement est utilisé pour contrôler
l'éditeur de liens d'exécution et et servir d'elle pour définir les chemins
des bibliothèques partagées au moment de la construction peut être
problématique, par exemple, lors d'une compilation croisée.
.TP 
\fB\-d\fP\fIchamp\-dépendance\fP
Cette option ajoute les dépendances destinées au champ «\ dépendance\ » du
fichier de contrôle \fIchamp\-dépendance.\fP (Les dépendances pour ce champ sont
dans la variable \fBshlibs:\fP\fIchamp\-dépendance\fP.)

L'option \fB\-d\fP\fIchamp\-dépendance\fP concerne tous les exécutables qui suivent
l'option, jusqu'à la prochaine option \fB\-d\fP\fIchamp\-dépendance\fP. Par défaut,
\fIchamp\-dépendance\fP vaut \fBDepends\fP.

Quand, dans plusieurs champs reconnus ayant trait aux dépendances comme les
champs \fBPre\-Depends\fP, \fBDepends\fP, \fBRecommends\fP, \fBEnhances\fP ou \fBSuggests\fP
apparaît la même entrée (ou bien un ensemble d'alternatives),
\fBdpkg\-shlibdeps\fP supprime automatiquement les dépendances dans tous les
champs sauf celui qui représente les dépendances les plus importantes.
.TP 
\fB\-p\fP\fIpréfixe\-pour\-le\-nom\-des\-variables\fP
Fait commencer les variables de substitution par
\fIpréfixe\-pour\-le\-nom\-des\-variables\fP\fB:\fP au lieu de \fBshlibs:\fP. De même,
toute variable de substitution commençant par
\fIpréfixe\-pour\-le\-nom\-des\-variables\fP\fB:\fP (au lieu de \fBshlibs:\fP) est enlevée
du fichier de substitution des variables.
.TP 
\fB\-O\fP[\fInom\-de\-fichier\fP]
Print substitution variable settings to standard output (or \fIfilename\fP if
specified, since dpkg 1.17.2), rather than being added to the substitution
variables file (\fBdebian/substvars\fP by default).
.TP 
\fB\-t\fP\fItype\fP
Prefer shared library dependency information tagged for the given package
type. If no tagged information is available, falls back to untagged
information. The default package type is \fBdeb\fP. Shared library dependency
information is tagged for a given type by prefixing it with the name of the
type, a colon, and whitespace.
.TP 
\fB\-L\fP\fIfichier\-local\-shlibs\fP
Lire les informations de remplacement concernant les dépendances envers les
bibliothèques partagées dans \fIfichier\-local\-shlibs\fP au lieu de
\fBdebian/shlibs.local\fP.
.TP 
\fB\-T\fP\fIfichier/substvars\fP
Écrire les variables de substitution dans \fIfichier/substvars\fP\ ; le fichier
par défaut est \fBdebian/substvars\fP.
.TP 
\fB\-v\fP
Enable verbose mode (since dpkg 1.14.8).  Numerous messages are displayed to
explain what \fBdpkg\-shlibdeps\fP does.
.TP 
\fB\-x\fP\fIpackage\fP
Exclude the package from the generated dependencies (since dpkg 1.14.8).
This is useful to avoid self\-dependencies for packages which provide ELF
binaries (executables or library plugins) using a library contained in the
same package. This option can be used multiple times to exclude several
packages.
.TP 
\fB\-S\fP\fIrépertoire\-construction\-paquet\fP
Look into \fIpackage\-build\-dir\fP first when trying to find a library (since
dpkg 1.14.15).  This is useful when the source package builds multiple
flavors of the same library and you want to ensure that you get the
dependency from a given binary package. You can use this option multiple
times: directories will be tried in the same order before directories of
other binary packages.
.TP 
\fB\-I\fP\fIpackage\-build\-dir\fP
Ignore \fIpackage\-build\-dir\fP when looking for shlibs, symbols, and shared
library files (since dpkg 1.18.5).  You can use this option multiple times.
.TP 
\fB\-\-ignore\-missing\-info\fP
Do not fail if dependency information can't be found for a shared library
(since dpkg 1.14.8).  Usage of this option is discouraged, all libraries
should provide dependency information (either with shlibs files, or with
symbols files)  even if they are not yet used by other packages.
.TP 
\fB\-\-warnings=\fP\fIvaleur\fP
\fIvalue\fP is a bit field defining the set of warnings that can be emitted by
\fBdpkg\-shlibdeps\fP (since dpkg 1.14.17).  Bit 0 (value=1) enables the warning
“symbol \fIsym\fP used by \fIbinary\fP found in none of the libraries”, bit 1
(value=2) enables the warning “package could avoid a useless dependency” and
bit 2 (value=4) enables the warning “\fIbinary\fP should not be linked against
\fIlibrary\fP”.  The default \fIvalue\fP is 3: the first two warnings are active
by default, the last one is not. Set \fIvalue\fP to 7 if you want all warnings
to be active.
.TP 
\fB\-\-admindir\fP=\fIdir\fP
Change the location of the \fBdpkg\fP database (since dpkg 1.14.0).  The
default location is \fI%ADMINDIR%\fP.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH DIAGNOSTICS
.SS Avertissements
Depuis que \fBdpkg\-shlibdeps\fP analyse l'ensemble des symboles utilisés par
chaque binaire généré par le paquet, il est en mesure d'émettre des
avertissements dans plusieurs cas. Ils vous informent des choses qui peuvent
être améliorées dans le paquet. Dans la plupart des cas, ces améliorations
concernent directement les sources amont. Dans l'ordre d'importance
décroissant, voici les différents avertissements que vous pouvez
rencontrer\ :
.TP 
\fBsymbole\fP\fI sym\fP\fB utilisé par \fP\fIbinaire\fP\fB trouvé dans aucune des bibliothèques.\fP
Le symbole indiqué n'a pas été trouvé dans les bibliothèques liées au
binaire. Le \fIbinaire\fP est probablement plutôt une bibliothèque et elle doit
être liée avec une bibliothèque supplémentaire durant le processus de
construction (l'option \fB\-l\fP\fIbibliothèque\fP de l'éditeur de liens).
.TP 
\fIbinary\fP\fB contient une référence non résolue au symbole \fP\fIsym\fP\fB: il s'agit probablement d'un greffon (plugin)\fP
Le symbole indiqué n'a pas été trouvé dans les bilbiothèques liées avec le
fichier binaire. Le \fIbinaire\fP est très probablement un greffon (plugin) et
le symbole est probablement fourni par le programme qui charge ce
greffon. En théorie, un greffon n'a pas de «\ SONAME\ » mais ce binaire en
possède un et n'a pas pu être identifié en tant que tel. Cependant, le fait
que le binaire soit stocké dans un répertoire non public est une indication
forte qu'il ne s'agit pas d'une bibliothèque partagée normale. Si le binaire
est vraiment un greffon, vous pouvez ignorer cet avertissement. Il existe
cependant une possibilité qu'il s'agisse d'un vrai binaire et que les
programmes avec lequel il est lié utilisent un RPATH afin que le chargeur
dynamique le trouve. Dans ce cas, la bibliothèque est incorrecte et doit
être corrigée.
.TP 
\fBpaquet pourrait éviter une dépendance inutile si \fP\fIle binaire\fP\fB n'était pas lié avec \fP\fIbibliothèque\fP\fB (il ne fait usage d'aucun de ses symboles)\fP
Aucun des \fIbinaires\fP liés à la \fIbibliothèque\fP utilise les symboles qu'elle
fournit. En corrigeant tous les binaires, vous éviteriez la dépendance
associée à cette bibliothèque (à moins que la même dépendance soit également
liée à une autre bibliothèque qui est elle réellement utilisée).
.TP 
\fBpackage could avoid a useless dependency if \fP\fIbinaries\fP\fB were not linked against \fP\fIlibrary\fP\fB (they use none of the library's symbols)\fP
Identique à l'avertissement précédent, pour des binaires multiples.
.TP 
\fIle binaire\fP\fB ne devrait pas être lié avec la \fP\fIbibliothèque\fP\fB (il ne fait usage d'aucun de ses symboles)\fP
The \fIbinary\fP is linked to a library that it doesn't need. It's not a
problem but some small performance improvements in binary load time can be
obtained by not linking this library to this binary. This warning checks the
same information as the previous one but does it for each binary instead of
doing the check globally on all binaries analyzed.
.SS Erreurs
\fBdpkg\-shlibdeps\fP échouera s'il ne peut pas trouver de bibliothèque publique
utilisée par un binaire ou si cette bibliothèque n'a pas d'informations sur
les dépendances associées (soit les fichier shlibs, soit le fichier des
symboles). Une bibliothèque publique a un SONAME et un numéro de version
(libsomething.so.\fIX\fP). Une bibliothèque privée (comme un module
additionnel) ne devrait pas avoir de SONAME et n'a pas besoin d'avoir de
version.
.TP 
\fBimpossible de trouver la bibliothèque \fP\fIlibrary\-soname\fP \fBdemandée par le\fP \fIbinaire\fP \fB(son RPATH est '\fP\fIrpath\fP\fB')\fP
The \fIbinary\fP uses a library called \fIlibrary\-soname\fP but \fBdpkg\-shlibdeps\fP
has been unable to find the library.  \fBdpkg\-shlibdeps\fP creates a list of
directories to check as following: directories listed in the RPATH of the
binary, directories added by the \fB\-l\fP option, directories listed in the
\fBLD_LIBRARY_PATH\fP environment variable, cross multiarch directories
(ex. /lib/arm64\-linux\-gnu, /usr/lib/arm64\-linux\-gnu), standard public
directories (/lib, /usr/lib), directories listed in /etc/ld.so.conf, and
obsolete multilib directories (/lib32, /usr/lib32, /lib64, /usr/lib64).
Then it checks those directories in the package's build tree of the binary
being analyzed, in the packages' build trees indicated with the \fB\-S\fP
command\-line option, in other packages' build trees that contains a
DEBIAN/shlibs or DEBIAN/symbols file and finally in the root directory.  If
the library is not found in any of those directories, then you get this
error.

Si la bibliothèque non trouvée est cependant disponible dans le répertoire
privé de ce même paquet, alors il vous faut ajouter ce répertoire avec
\fB\-l\fP. S'il est dans un autre paquet binaire en cours de construction, alors
assurez\-vous que les fichiers shlibs/symbols de ce paquet sont déjà créés et
que \fB\-l\fP contient le répertoire approprié si c'est aussi un répertoire
privé.
.TP 
\fBaucune information de dépendance trouvée pour\fP \fIla bibliothèque\fP \fB(utilisée par le\fP \fIbinaire\fP\fB).\fP
The library needed by \fIbinary\fP has been found by \fBdpkg\-shlibdeps\fP in
\fIlibrary\-file\fP but \fBdpkg\-shlibdeps\fP has been unable to find any dependency
information for that library. To find out the dependency, it has tried to
map the library to a Debian package with the help of \fBdpkg \-S
\fP\fIlibrary\-file\fP.  Then it checked the corresponding shlibs and symbols
files in %ADMINDIR%/info/, and in the various package's build trees
(debian/*/DEBIAN/).

Cet échec peut être causé par un shlibs ou un fichier de symboles qui serait
mauvais ou manquant dans le paquet. Une autre cause serait que la
bibliothèque soit construite au sein du même paquet source et que les
fichiers shlibs n'aient pas encore été créés (dans ce cas debian/rules doit
être modifié pour créer le shlibs avant l'appel de \fBdpkg\-shlibdeps\fP). Un
mauvais RPATH peut aussi conduire à ce que la bibliothèque soit trouvée sous
un nom non\-canonique (comme\ : /usr/lib/openoffice.org/../lib/libssl.so.0.9.8
au lieu de /usr/lib/libssl.so.0.9.8) qui n'est associé à aucun paquet,
\fBdpkg\-shlibdeps\fP essaie de travailler sur ce nom non\-canonique (en
utilisant \fBrealpath\fP(3)), mais cela ne fonctionne pas toujours. Il est
toujours préférable de bien nettoyer le RPATH du binaire afin d'éviter ces
problèmes.

L'appel de \fBdpkg\-shlibdeps\fP en mode bavard (\fB\-v\fP) fournira beaucoup plus
d'informations sur l'endroit où il a essayé de trouver l'information sur les
dépendances. Ceci peut être utile si vous ne comprenez pas pourquoi vous
obtenez cette erreur.
.SH "VOIR AUSSI"
\fBdeb\-shlibs\fP(5), \fBdeb\-symbols\fP(5), \fBdpkg\-gensymbols\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
