/* Copyright (c) 2018 Dovecot authors, see the included COPYING file */

#include "lib.h"

#include "iostream-ssl.h"
#include "iostream-ssl-test.h"

static const char *test_ca_cert =
	"-----BEGIN CERTIFICATE-----\n"
	"MIIF4TCCA8mgAwIBAgICEAAwDQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAk5M\n"
	"MRMwEQYDVQQIDApHZWxkZXJsYW5kMRIwEAYDVQQHDAlCYXJuZXZlbGQxGjAYBgNV\n"
	"BAoMEUNoaWNrZW4gQ29vcCBCLlYuMR4wHAYDVQQLDBVDZXJ0aWZpY2F0ZSBBdXRo\n"
	"b3JpdHkxEDAOBgNVBAMMB1Jvb3QgQ0EwIBcNMTgwMjA4MjEyODE2WhgPMjExODAx\n"
	"MTUyMTI4MTZaMHgxCzAJBgNVBAYTAk5MMRMwEQYDVQQIDApHZWxkZXJsYW5kMRow\n"
	"GAYDVQQKDBFDaGlja2VuIENvb3AgQi5WLjEeMBwGA1UECwwVQ2VydGlmaWNhdGUg\n"
	"QXV0aG9yaXR5MRgwFgYDVQQDDA9JbnRlcm1lZGlhdGUgQ0EwggIiMA0GCSqGSIb3\n"
	"DQEBAQUAA4ICDwAwggIKAoICAQDgwuwUQ387ALkBO2YAvLiOi0rhQMis+TY34tpN\n"
	"96Xx9Jaa8gdiAW9y3l8hGFm1+Ens5ZukwMysUoP7rrI5s0XOgCTChzrB4dEnbWHj\n"
	"2YUYUBVLTLqZ4PTbY6xyrjYHKol1govkU+wclmyeI+Os946U0HFubg+KuXGZ2oLM\n"
	"iYAmur/oxickEwJX932KhzQS4xdT5o38cVv470ot6eNEAiZcufP/gBSjAyUd8Wge\n"
	"bwpW64fE/0LyCXYZrK5LWG1dMPC8MpETb8uLAB33r6q3yLTcEWg79bes7SgNrQdx\n"
	"ncUXBoh8YSJvniZQ6OhwENPGTNhZWzgltDZHASyKXY2ojV70D8iiy/uB+owPSTla\n"
	"txnu7z8B4kVCBWhCUizk7upjZNA0aFutjEHyYLtxqbTon+iLYm7M4iaga23YBdMU\n"
	"1QVtulmUY6dcjTJ8GG3uo+qglPKuSodLSb23ovxAdVdIF+BNukd18ZhEIAe08hbw\n"
	"YBHUYsKNkTMYcwxSgK3yQ4tQw0Cky4wAdsDv1XBK0LZ8+wnuWjnrnO/TRvgLWRU4\n"
	"qI36OEMk9T0bxi+UwP3mzu78OoMCCdf67ccZ2/zFfHg+dqTBc9zV0sYJ/RQvmEN1\n"
	"KDgqJAhz+VkDzTBiQYxoztTgBv9yxYufFvwZX4uhsvtMXUuRfvoVwK16vPXnMHwF\n"
	"muIvwwIDAQABo2YwZDAdBgNVHQ4EFgQUWv/zcVnDWf53C2iN9f6uyUmhp1EwHwYD\n"
	"VR0jBBgwFoAUsSOnSayEpzvbN21MEQGEyVKx+kIwEgYDVR0TAQH/BAgwBgEB/wIB\n"
	"ADAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADggIBAJUlgJIHnnclDQMn\n"
	"PSmruCl7bCRvLZYQtSiIv3/K4kPXJMYOvULoXGLA0+CdHoo06k8/TLk7gF1gNCPr\n"
	"23z2+SCIuvVrVlveWyqD684yQ3UYeWoJnOv90F19267uELrWX4UMVE+z1r7iULyw\n"
	"cxQokw6EGjw7xHiVETvNlHlmA0/8IuZv89CTztOP54NAXqu8WeloL/ipEhgj1HRx\n"
	"TkuDf6SlTQ+mXKbiVJFiEA6rOsYFGGWE/SDNbLfx60OoHz0rQ95zw0rv/wPs1Oai\n"
	"x71Ccuz/i2iI7ItXjQcUEcXvIDFJEMNXDaccIVmk1uda0Cm92W/sGc4vG2LUwEpl\n"
	"LRj/x4Q39WaZTCrZzd6p2+6tYA45VnoblZ0enYU5XcQzryR/GC7VWFH1OvzOcSG5\n"
	"NhpKIiWZvuMG5ilXyw7yh7cnWiPvGp8zCO7w1IOyk8sETQBstxuiALeEdrgdz6R5\n"
	"jV5oIqsCmsIihfRgNufx/SImTJvue4uYgrKa4jo1tw+CFkEWPd7zXjferkxyU8C5\n"
	"Y+Fr3yMuis5O4qa5mb94r0AQhc8MbCAuInSqNGX0Iu/UTg6Z+56omA2CnKGt6Rwd\n"
	"LxLo2vhT9gTF88QwTMBPlhVjBbjTRhmY+mHv9gh3GczQ/i5VRXyYQH4h7EBtKFFI\n"
	"t4mBWMavY+hS/zVkufYzUcUR7D1P\n"
	"-----END CERTIFICATE-----\n"
	"-----BEGIN CERTIFICATE-----\n"
	"MIIF8jCCA9qgAwIBAgIJAN0zFa9E/xyxMA0GCSqGSIb3DQEBCwUAMIGEMQswCQYD\n"
	"VQQGEwJOTDETMBEGA1UECAwKR2VsZGVybGFuZDESMBAGA1UEBwwJQmFybmV2ZWxk\n"
	"MRowGAYDVQQKDBFDaGlja2VuIENvb3AgQi5WLjEeMBwGA1UECwwVQ2VydGlmaWNh\n"
	"dGUgQXV0aG9yaXR5MRAwDgYDVQQDDAdSb290IENBMCAXDTE4MDIwODIxMjA1NloY\n"
	"DzIyMTcxMjIyMjEyMDU2WjCBhDELMAkGA1UEBhMCTkwxEzARBgNVBAgMCkdlbGRl\n"
	"cmxhbmQxEjAQBgNVBAcMCUJhcm5ldmVsZDEaMBgGA1UECgwRQ2hpY2tlbiBDb29w\n"
	"IEIuVi4xHjAcBgNVBAsMFUNlcnRpZmljYXRlIEF1dGhvcml0eTEQMA4GA1UEAwwH\n"
	"Um9vdCBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAKMvVLNtj1C+\n"
	"ZQ4ypNIA5+zB8oseN65k8VqpyhcPAQv0M/HvOB8jXzWH4v1VfKOYkTxQXqu4v0RP\n"
	"6k0awe/6FH0GDlYhKUuPNDH2djlGOVbq+qBdSXpC3UjEcksxIuigCmzdkuytnlhW\n"
	"qQYnLVl6kXwYtzjWsetTZBGseCpSYBWnvdtG/MGQNozi03VsGFkj/fbwuLK7ZHVp\n"
	"64QLk9j3IPZRPHUaFlnT+v2ySMjO8OncsZ/fMZ/nxmt8GJ/68cMy9czydauz2KZs\n"
	"pQEFS6s/HCmRXT1VQZ7zw5V/PBnF7ecveTaQtxJoNO4Pr7sh77El/ChUxN1Acw4N\n"
	"2UH/06k6xnirLsvJonCRbVX3bxPBoDzGHjPqb7r0AKD0WBvrzgjeooSjobEtcIvA\n"
	"LntiGKp4KtvWKcANPWkutH9X71U7M773oMmrz5fWvz9yv3wVuyblZSaMBwrV16GX\n"
	"mcym6KF+Oj7j86jNq4wxNtjiQVV0QZcBijtnWpHaD5EMhI/TZvLK9oCFyAL92Wzi\n"
	"t95r8g3D/8ue0CHqB/EpodH88MdVwr7sgxLQ40KibpErOXb93CJnq/7MVMO/EzTj\n"
	"4XiGGUOo0elLqEPjzBO6AiGEgXAE2iNoghX79cbMQFtk9sK7XdMVLoXwBvt+Naaz\n"
	"w96+7R+rZ4SsfrtlrP7xoCPJXbeQ4YI9AgMBAAGjYzBhMB0GA1UdDgQWBBSxI6dJ\n"
	"rISnO9s3bUwRAYTJUrH6QjAfBgNVHSMEGDAWgBSxI6dJrISnO9s3bUwRAYTJUrH6\n"
	"QjAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsF\n"
	"AAOCAgEAQ30mub/GBwThYX3h9p01kQh+/eXXQ47h1xG3B870EwJ2y36wlGbAhZmE\n"
	"7o1kDZwhNMR4NxT2PSWQHn8m6RiuSGAG9DU2q55tPEZg2DqkQmoCFvV3n2MVIAwL\n"
	"rZ8c9EaoM5RkeeDBmuVo8H1aCvd5oLJ5j64z6wkgsSRwVXkxQLOAEdmRSVHN/c/6\n"
	"QEdg0Uh5wkeC7R5wiwQUEkhLie+XwUPG7dIJHWp9g5oVO7IN+KWBLWiqbAJhVFhF\n"
	"evOSqGDRV/Q2kfwSqDRrokk7CaE8KO/i+AUTF4TFQc/ewCLSeBSkvV7ORXBbe7ob\n"
	"ShGViL7WEngpGAVoDZEsSViXQ36a5zxCvYcGjHcsKUITPMiD55x0aKNWjc0XfEg4\n"
	"JtWvYWwygxTcefbs9pxHrmEnyCPpyDB8cPj866JAeaEAhxhDtSqaBE/ek576aJ+Z\n"
	"ZaGjBQDDhRndLhTPAx1EXB8jgl/yjD+KMUqHs39UowKH25iBxMiW3R1XDIyYFGyi\n"
	"+UFP+5NgokW/z6JfpUYd4W3jRcareS10UrLQC8tk4vvixk+1MuNKmzBy2eRITYZz\n"
	"KiYX6NTvbvRt6XsKil8ypHKvWH+i2Cn3JrnTaCzJ4y66lnbRs4/ZnRceqRz35i39\n"
	"rNT5Ier3SjmyIulxnmoYXHInIcS0TSV1+byyaTUCHKHLx12RxAM=\n"
	"-----END CERTIFICATE-----\n";

static const char *test_server_cert =
	"-----BEGIN CERTIFICATE-----\n"
	"MIIF/jCCA+agAwIBAgICEAMwDQYJKoZIhvcNAQELBQAweDELMAkGA1UEBhMCTkwx\n"
	"EzARBgNVBAgMCkdlbGRlcmxhbmQxGjAYBgNVBAoMEUNoaWNrZW4gQ29vcCBCLlYu\n"
	"MR4wHAYDVQQLDBVDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxGDAWBgNVBAMMD0ludGVy\n"
	"bWVkaWF0ZSBDQTAgFw0xOTAyMTkxMDI2MzdaGA8yMTIxMTAyMjEwMjYzN1owgbUx\n"
	"CzAJBgNVBAYTAk5MMRMwEQYDVQQIDApHZWxkZXJsYW5kMRIwEAYDVQQHDAlCYXJu\n"
	"ZXZlbGQxGjAYBgNVBAoMEUNoaWNrZW4gQ29vcCBCLlYuMSIwIAYDVQQLDBlDaGlj\n"
	"a2VuIENvb3AgV2ViIFNlcnZpY2VzMRIwEAYDVQQDDAkxMjcuMC4wLjExKTAnBgkq\n"
	"hkiG9w0BCQEWGmhlbm5pZUBjaGlja2VuY29vcC5leGFtcGxlMIIBIjANBgkqhkiG\n"
	"9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3mNxJKdYUP88HHAPP8FWSDYKofxg2ECJsBQP\n"
	"cIEvhuDsOpU+kBp3CbVFL+it4kNq7KvYvQyGvag8JA3RFrvsj3/nFM99lPm6RP1y\n"
	"h9hNYVWRHHWKyOTdwqhk9bOrLk8j8fxw4NfQ/dkURYLJ0OtVTtJELJsxif5BfIAP\n"
	"ypHayfnFoNa3rFG3uGULzJlb5JOHJHr7vxOTrRUZGYFZeBFacKF14CHYMUkpr9dv\n"
	"BLaGqKFF0Lx2TU0tzRIXGu2AIFydcM0eGhCFLOV8YqxwT0R+XyNoNG9jRVSewWx0\n"
	"r7rAF/93vARdRQVDmVoLmxrUMldYN7mQ9MsuGkMBfecLO4HqrQIDAQABo4IBUDCC\n"
	"AUwwCQYDVR0TBAIwADARBglghkgBhvhCAQEEBAMCBkAwMwYJYIZIAYb4QgENBCYW\n"
	"JE9wZW5TU0wgR2VuZXJhdGVkIFNlcnZlciBDZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQU\n"
	"Ez4hL16BDA+GMrQs+g3/1Do4Vr4wgbIGA1UdIwSBqjCBp4AUWv/zcVnDWf53C2iN\n"
	"9f6uyUmhp1GhgYqkgYcwgYQxCzAJBgNVBAYTAk5MMRMwEQYDVQQIDApHZWxkZXJs\n"
	"YW5kMRIwEAYDVQQHDAlCYXJuZXZlbGQxGjAYBgNVBAoMEUNoaWNrZW4gQ29vcCBC\n"
	"LlYuMR4wHAYDVQQLDBVDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxEDAOBgNVBAMMB1Jv\n"
	"b3QgQ0GCAhAAMA4GA1UdDwEB/wQEAwIFoDATBgNVHSUEDDAKBggrBgEFBQcDATAN\n"
	"BgkqhkiG9w0BAQsFAAOCAgEAVbs9RDJiVvGAW2cQv5OvghvMECF2Lh0pxsyOeywz\n"
	"AQBBEaz85ZTRjtQjTWxpJwgwnIFEmfMEpuZoDoffCWDKUNkt24DD9TN8kriHplPK\n"
	"5P3qZsnuV/E6CiYxBNpYhEle001XO+sU3yjAMeynPZWSZVz1JnjAdh1+opVd62O8\n"
	"RX7twWdaSUBdsw7JJ2tdtTPeYkyRqDbfQWZSbA4/3VOwLuOs38zgy5ZqHy+YF/MM\n"
	"48D1cOI0K1qpJE4qYLzcoULSnJ6C8KsS9LsspiLSDGdEvFY0DnCOa/POG6WiuEGk\n"
	"JGRD+bDbEPZmNU0OLWjzM3vC2qxjF2PC8Q4chhkm4s4cAT7DMf+nnwqTPGK1U3N3\n"
	"S5xhHrQ1GMHDhrqmKIrBOxdc8Hg7CwCU+C7TXxIPuQlbdStqMW/lVfbRNKsm/Hr6\n"
	"smOC/hTxuned5DxRkDTCKNof3bZt8k9dqFLjqj14txmITq7MLhJLcsXgECWe7HmX\n"
	"imxYJzLHjJU6QoDqGXHEMNrIBp46aIOcTjJP6tfosgAzplj+o00xdpMH9Q9hG602\n"
	"lpgS9JfemZI68jPTZeGie9wXilPp4kE4qmlxhKSsjh3RVHo6ju7uKI5vCBkk15C6\n"
	"lQMIGAmkRJ5vkcpUWnO6dKCSQdru/gKn3X4JVAHwm4178gqfRkofT28xAZ+vZoFj\n"
	"L7M=\n"
	"-----END CERTIFICATE-----\n";

static const char *test_server_key =
	"-----BEGIN RSA PRIVATE KEY-----\n"
	"MIIEowIBAAKCAQEA3mNxJKdYUP88HHAPP8FWSDYKofxg2ECJsBQPcIEvhuDsOpU+\n"
	"kBp3CbVFL+it4kNq7KvYvQyGvag8JA3RFrvsj3/nFM99lPm6RP1yh9hNYVWRHHWK\n"
	"yOTdwqhk9bOrLk8j8fxw4NfQ/dkURYLJ0OtVTtJELJsxif5BfIAPypHayfnFoNa3\n"
	"rFG3uGULzJlb5JOHJHr7vxOTrRUZGYFZeBFacKF14CHYMUkpr9dvBLaGqKFF0Lx2\n"
	"TU0tzRIXGu2AIFydcM0eGhCFLOV8YqxwT0R+XyNoNG9jRVSewWx0r7rAF/93vARd\n"
	"RQVDmVoLmxrUMldYN7mQ9MsuGkMBfecLO4HqrQIDAQABAoIBAQCGV4Az6ju5wlXn\n"
	"v/IWS4751Fub+z/tox8KFTQ2fHPfgORzh1Dh8HrUjIKdLGxOcPeYvT8TBQwoagba\n"
	"qNYUa7W+Aj/wHF/6rNlPb+POGGa2U+BzVrZeIZOtUdibbMwOD5ThS+RMj1Ma5hYO\n"
	"37FW2bMRCIhSgfXtLIEW2q2va2jF9VI+c7F9dL01COG65nwUSJaRSLPrK5WbVNZE\n"
	"yNm2st88iiu3TtPJGty+wmFgyV0PjAYYqxVEPs6qcmYMuHrfKlrntDfYai6x7fb+\n"
	"RDfHhmqmn2oV/LGl7YtH+jBML9WG+Rfw+M7pYsd3ffRjG4aRxSTotu0QZfjduP0a\n"
	"NZL1C3OBAoGBAPrzC4X2/fPGfyHksg+ecPS2Pvnyr+L9Gtg2Dg9wAONbmYqGKYxa\n"
	"7DUBr6WWbOy9qJKk1CHR2Gn5FK3KbHG1PhLiOuG00kjm6imSCFTpJ3sBXUCl9qMk\n"
	"FJnBifT4//INLFIcLjFlygR20hHgqyLU8P2kKzM+7iPaF1GYdILYHnExAoGBAOLd\n"
	"PmKFcwuD4VfzTwK/Va0L8FFi3Oo7O4OE+9PyfTCJ8fH9PW03e4DiddjM0djDovWW\n"
	"sm1ySVTfHjE0rsnaMGngPvqhG5T6IMUtFowEa2VwqwfFrPzK4PUYeRV1G+rTL1ZX\n"
	"RGV1nPxCRXog91gzDCuyYB7jblrjG+DP+ZfGI5I9AoGAJc8Mg2iNJndXnDGqqjPC\n"
	"7PuwTVRFL7vWmZC7WZQUbizU20wPYngocmwInLgnPRvuE/oFg/rr0juW5ABFinQ2\n"
	"H/45xNvLevRff1fjLXfbXOr9s8nNeRLsj6XbNS920G8vqEdaplKhtz53s/3Xiu3u\n"
	"SSi84YGvu3MWZFLF6xjIrWECgYAI2tXahpbs9iLPigGle85eSL8CjjdNNS6nfYNO\n"
	"zIIyaM/2wAmrv6SkbTJoWeY+7bPong8s0m8mTucgyIuh+VA2cbhDlBI9iF3LFG1y\n"
	"3aFLflBOp1qPK2QIbQIc4ktKqR+J4TIcO7D676NClxLQcH2jHv09d2cRSRgHeFan\n"
	"o+YziQKBgEtqnknKgedinexHheBhE/fo49bHwNYZBfA5ZKqQDguNBafU1BUOmPEO\n"
	"eNb8S5cJDMR7zKeZJ9dHzf4j78sITigwxt8+Ee6VY92U/uTFkPKZNLpAr3OfDSdh\n"
	"z+M/zgztKqdrSKhr64g/3Dbbe+XqdeGe8MIx+P+QN+SrJNNaNZ1r\n"
	"-----END RSA PRIVATE KEY-----\n";

static const char *test_server_dh =
	"-----BEGIN DH PARAMETERS-----\n"
	"MIIBCAKCAQEA/muURoAR4sDHCMSibIwduxRDFA+rizt6TQC6OhNfZ6sOtX+mANdx\n"
	"otSZIca/q37dQs34ph+/9AHnL3li7I9aUC9XzThFyq7eoKrMs9VlDlA0z1gc+gMG\n"
	"FS+S4Dp4bjNmQ8lJz13+8CS6jKV2RVcqY5Qfjz4QYIk7bcF3PK8d/kJxnGtihhKh\n"
	"90Cu4ZiMqpcvkfKRxommk9HvN9ceeHn5Heey2TdAQ9ngF43Z+g++DPt7lYiedh/X\n"
	"N5SFUcR8ZRCzrccPhXIBUd9uZtgJTlxg2ZQ/WL0MKbJd+DeP/kUK+DPK+VDVUIwT\n"
	"UE2GG5y3YCQ4i2PEahXYpaJGk6tn2oMd2wIBAg==\n"
	"-----END DH PARAMETERS-----\n";

void ssl_iostream_test_settings_server(struct ssl_iostream_settings *test_set)
{
	i_zero(test_set);
	test_set->pool = null_pool;
	test_set->ca.content = test_ca_cert;
	test_set->cert.cert.content = test_server_cert;
	test_set->cert.key.content = test_server_key;
	test_set->dh.content = test_server_dh;
	test_set->skip_crl_check = TRUE;
}

void ssl_iostream_test_settings_client(struct ssl_iostream_settings *test_set)
{
	i_zero(test_set);
	test_set->pool = null_pool;
	test_set->ca.content = test_ca_cert;
	test_set->skip_crl_check = TRUE;
}
