#! /bin/sh

set -e

cd "`dirname $0`"

if [ -n "$*" ]; then
  tests=$(ls -1r "$@")
else
  tests=$(ls -1r *-tests.sh)
fi

for t in $tests; do
	printf "# # #\n# # # Test: $t\n# # #\n"
	printf "# #\n# # Shell: bash\n# #\n"
	bash $t
	printf "\n# #\n# # Shell: dash\n# #\n"
	dash $t
	printf "\n# #\n# # Shell: zsh\n# #\n"
	env SHUNIT_PARENT=$t zsh -y +o function_argzero $t
done
