#!../src/bltwish

package require BLT
namespace import blt::*


image create photo mini-apm-alert -data {
    R0lGODdhEAAQAPIAALLA3AAAAAAAoMDAwKCgoICAgP8AAP///ywAAAAAEAAQAAADSgiq1bGQ
    tTNKuBHMMmrwEdeMDfEAhqENROu2Z7q6xhurXJvWsCLnOpsPx3q5bjNjD0VULhdAJTJqnBZ0
    qZbgBAkIvuBtRnEpYyIJADs=
}

image create photo mini-apm-empty -data {
    R0lGODdhEAAQAPIAALLA3AAAAMDAwKCgoICAgP8AAP///wAAACwAAAAAEAAQAAADSQiq1LGQ
    NSNIuBFMImrwUVE0ZCNGhDisq/hAnNoWw7twgyrbjDDTK57Gl5PVUD4dUBgDFo8w40woZZ1g
    BJYWCglsgxnFZYyJJAAAOw==
}

image create photo mini-apm-full -data {
    R0lGODdhEAAQAPIAALLA3AAAAAAAoMDAwICAgP8AAP///wAAACwAAAAAEAAQAAADQAiq1LGQ
    NTNIuBFMMmrwEdeMjfBAnKCu6rmkasG6zBAXchva8byzPhQPaPoRi8Ij8jUE0jSEW265CByf
    1YsWmwAAOw==
}

image create photo mini-apm-half -data {
    R0lGODdhEAAQAPIAALLA3AAAAAAAoMDAwKCgoICAgP8AAP///ywAAAAAEAAQAAADRwiq1bGQ
    tTNKuBHMMmrwEdeMDfFAHKGu6rmkqsG6zBAbchva8byzKwFNMxAYj8YhB4lUFpnJHTSKKhhx
    huMQEJhuFZcwJpIAADs=
}

image create photo mini-apm-loading -data {
    R0lGODdhEAAQAPMAALLA3AAAAP//AMDAwKCgoICAgP8AAICAAP///wAAAAAAAAAAAAAAAAAA
    AAAAAAAAACwAAAAAEAAQAAAEXRBIWWo4oNyZKxqHcFzi5BUDKBYhRg1VFcqC9hJ4rFvZkH+p
    ICzQwxk0gaSSWDQWENCUrfkTTlGCbA0oZWK1ggBw2gNnl5yd9smkPKGI2KcNgCoH8AEdkOQv
    +xwAEQA7
}

image create photo mini-apm-online -data {
    R0lGODdhEAAQAPIAALLA3AAAAICAAMDAwICAgP//AP///wAAACwAAAAAEAAQAAADRQi6QCHt
    sSkKrHAuDLhWFUGEwSeeaMkQxuC+g6M5QW2rs6G7stm+vRwsqAn8iJ/bBLVg4RosneHUeups
    A+ngCagtblxAAgA7
}

image create photo mini-apm-unknown -data {
    R0lGODdhEAAQAPIAALLA3AAAAP//AMDAwICAgP8AAP///wAAACwAAAAAEAAQAAADRAiq1LGQ
    NTNIuBFMMmrwEdeMjfBAnKCu6rmkQiGvLjPEa9GGt676Nc0tR+MRi6ghDvlSskzGHytYeu4i
    ASs0A7h4MZEEADs=
}

image create photo mini-folder -data {
    R0lGODdhIAAbAPIAALLA3ICAgP//////AMDAwAAAAICAAAAAACwAAAAAIAAbAAADeQgK0e4r
    yhmDuBgHyqUdBCiGxNZxHzmO5lkRcCzPT10XTKbvPF8UqZVqKBQagAKisrg8BpdQpjPJrEan
    1qxyGu0Wsd4wiKsth8BmLVnsRbOt6/QVKVcj3206Hn6vz59+Rn17TXqBW0AGiouMjY6Pijg/
    k5SVlpeTAAkAOw==
}

image create photo mini-arch -data {
    R0lGODdhEAAQAPEAAICAgAAAAMBkMv+gMiwAAAAAEAAQAAACQQSCqXoi46B7YtlVA51Q1sxN
    EaQhmyKWmoMYzTCoZOUes/kF9SrHtKvxIW47mIr1M/AyxqQtF2wVYzpG7ZC4arcFADs=
}

image create photo mini-asmail -data {
    R0lGODdhEAAQAPMAAJSUlP///97e3mNjYzz4NK2trfgUQL29vXNzc0JCQoCAgAAAAAAAAAAA
    AAAAAAAAACwAAAAAEAAQAAAEVFDJOYGgmA5iMwaGIYwfAAzDqJLT6q4ScMyvOsSyW9i3MhwC
    hGo3GhR6JuHLeEAoAgUTcGVEWA9Q089WOCQTWROgcBxYv2GxWoxIeK3weDzhqdvrEQA7
}

image create photo mini-audiovol -data {
    R0lGODdhDgAOAPEAALLA3AAA7v///2ZmZiwAAAAADgAOAAACMYQdcxgLkdhQK8E0oIMz4+19
    ztMNwohQ5zkmK8BK0Xtel0I/tgv3uq3y7SiGmARlKAAAOw==
}

image create photo mini-ball -data {
    R0lGODdhEAAQAPEAALLA3AAAAP///4CAgCwAAAAAEAAQAAACG4SPqcvtD1mYMAhBncVh6Dl5
    Xyc6wxml6so+BQA7
}

image create photo mini-bball -data {
    R0lGODdhEAAQAPEAALLA3AAA/////4CAgCwAAAAAEAAQAAACG4SPqcvtD1mYMAhBncVh6Dl5
    Xyc6wxml6so+BQA7
}

image create photo mini-bomb -data {
    R0lGODdhEAAQAPIAALLA3AAAAICAgMDAwP//AP///wAAAAAAACwAAAAAEAAQAAADPAi63K4h
    vhZWneDaGTV0nbQxgVAMHbkIQcF2wpgFw5sqBJCHHVHlhNwsJEDhggpbhBXTUXgeh62JqVon
    CQA7
}

image create photo mini-book1 -data {
    R0lGODdhEAAQAPIAALLA3AAAAP8AAP//AICAgP///wAAAAAAACwAAAAAEAAQAAADPAi63K4h
    vBaFkLNai5neWwcEwwCeXVSeIBZcK8uNXNymtckFBeHlkUKPIHpdeMOI48UjEEWUwHPigVKv
    CQA7
}

image create photo mini-book2 -data {
    R0lGODdhEAAQAPEAAL+/vwAAAICAgP///ywAAAAAEAAQAAACOYSPeRHqIUZbLMEhAcNzRf5J
    lXFxGNiVUgil7Lm6p9p6M1zbK5fbgYgRdDwMgdE4JLUYzKTSAY0CCgA7
}

image create photo mini-books -data {
    R0lGODdhEAAQAPIAAICAgP////8AAAAA/wAAAP//AAAAAAAAACwAAAAAEAAQAAADSgi63B3B
    wRdFGGoSBy5exaYIwjJgRQGECwlgJ0Bs7FjGqFoDLgGvOhGvJIgBV0KXwKdIIVtEX+6Zqcww
    k11PQVMJZbPG7MspmzkJADs=
}

image create photo mini-briefcase -data {
    R0lGODdhEAAQAPIAALLA3ICAAMDAwAAAAICAgP///wAAAAAAACwAAAAAEAAQAAADSQi63B4Q
    OhaKuCJMFcT4g9ZEZFgClWANAuGpahBegTsUa1eHRY17v5lMRyrWCLwOZpnJzJo6aAZZiVqh
    z6uVauzKAKCw+LMpJwAAOw==
}

image create photo mini-bug1 -data {
    R0lGODdhEAAQAPIAALLA3AAAAMDAwICAgP///wAAAAAAAAAAACwAAAAAEAAQAAADNAi63P5Q
    hTWjDDUKzEUcAcENEChiIOlgxCCA2MoF2yxjddwEMD1mjA4H4ituLDygZckEJAAAOw==
}

image create photo mini-bug2 -data {
    R0lGODdhEAAQAPIAALLA3AAAAICAgMDAwP///wAAAAAAAAAAACwAAAAAEAAQAAADOAi63A5h
    xceCpUvYLajQW/A9FsFdjWZ+oFiV1hCiyiyHjT1XbXBbmtzmN+ENTw/QrYMBCAbMZjMBADs=
}

image create photo mini-bx2 -data {
    R0lGODdhEAAQAPAAALLA3AAAACwAAAAAEAAQAAACIoSPqcuNAeEKL9Kn7AU7ae5EoAOKDfVN
    R4pVptGtFknXdQEAOw==
}

image create photo mini-calc -data {
    R0lGODdhEAAQAPIAALLA3ICAgP///wAAANnZ2QAAAAAAAAAAACwAAAAAEAAQAAADRAi63Bow
    SgmCuDjjUQUhQyiKYPcN2hWU1jdJrPfN9NkFA4Hr+c5ZIVAuSLz1jrwYcciM7Z7In2AprP5q
    WBtgxB05vo0EADs=
}

image create photo mini-camera -data {
    R0lGODdhEAAQAPEAALLA3AAAAP///4CAgCwAAAAAEAAQAAACNYSPqRDta4KYNCAnhxviyYo1
    YBgMJplp5XSWqtByptrC9HyLc7O7bx/q2YA4DQNFgiiXTGYBADs=
}

image create photo mini-cat -data {
    R0lGODdhEAAQAPEAAICAgAAAAP//AP8AACwAAAAAEAAQAAACOYSPecGqIUR4YNZoEdw36yh1
    FTNBoGSa2Cah5xsN2AW/llqHHYjPdErydTiblCG1wvhIo2PJ44gWAAA7
}

image create photo mini-cave -data {
    R0lGODdhEAAQAPMAAAD//wBy/QAA/AAAuAD/jwD/Cv+EAHL/AP//AA8Pbf8AAP9FAP/HAAAA
    AAAAAAAAACwAAAAAEAAQAAAEWhBIGaq4I+c5a7iCNhBEYRzGCFjggCAJARCJ8hKskOwJIAAw
    Cc5C4yVgiUEBODHydL9dgVRw8haJxeKAtO4WBgSDofAaGYcD1sxD49iJwAE9hbcRZXtPz7dH
    AAA7
}

image create photo mini-cd -data {
    R0lGODdhEAAQAPIAALLA3ICAgP//AMDAwAAAAAD//wD/AP///ywAAAAAEAAQAAADUQiq0b2Q
    BSGGJSSCUGi1FxQYRfdZx5AxBkmBqcpYbYeCcgCSAaHjmR8tQ8DlcIceB7iBoQyCAmili9Gi
    0tXGesVqm7gW5SvZGTCaRQNDTrsVCQA7
}

image create photo mini-cdlabel -data {
    R0lGODdhEAAQAPEAALLA3AAAAICAgAAAACwAAAAAEAAQAAACM4SPecEg8SJcIFQpqVWpsfcx
    21aVBmmlZTqpbinE66yeVUt7NC2/qAkciYYQEeeITCoTBQA7
}

image create photo mini-chinese -data {
    R0lGODdhEAAQAPAAAICAgAAA/ywAAAAAEAAQAAACJoQdB6kXrx5ri0FapZ4R2baFEpVAHFkt
    WCaunuuFcDq/NV1f91oAADs=
}

image create photo mini-clipboard -data {
    R0lGODdhEAAQAPIAALLA3AAAAP//AICAAICAgMDAwAAAgP///ywAAAAAEAAQAAADUgi63B4w
    OBWhEFXSQUbAX9ARmkgWaCp6BBBwWUSQ7TpyeCe6+WD8QMPOxjEcjsdfrWdEHowG141gjDyB
    r1vTmSRSD7Gnq7LlRgGzWXB9bqTfswQAOw==
}

image create photo mini-clock -data {
    R0lGODdhEAAQAPEAALLA3AAAAP///8DAwCwAAAAAEAAQAAACMoSPqRDda5qY86UwaKAjXCps
    GiJqYHiU1elFoPSmrNoybDjKZ55me6eAaWpBBxGCTCoKADs=
}

image create photo mini-colors -data {
    R0lGODdhEAAQAPIAALLA3ICAgP8AAP//AAAA/wAAAP///wAAACwAAAAAEAAQAAADPgi63P4w
    skCrtSqILYYfREgEBaBxHyiSJtd94lieWxqzgaEbVuEXuB2v8gPOhL1fcJf04S5QSglQrFYl
    WGwCADs=
}

image create photo mini-connect -data {
    R0lGODdhEAAQAPIAALLA3AAAAICAgP8AAP//AAAAAAAAAAAAACwAAAAAEAAQAAADLwi63P7Q
    hbgECJaKMfJ8GzdcWROKHXSKpYl2n7MKsUkIOK3edFAzAh6l0tIMj44EADs=
}

image create photo mini-crosbone -data {
    R0lGODdhEAAQAPEAAICAgAAAAP///8DAwCwAAAAAEAAQAAACQUQCqXqMu5qRMJ0HxBV8jygM
    4jhoUPAhKTBgVnvAqGtkIcrVJ1uKeoUi0Rwz2SnQmSE1j4PgJXowLRHKr4LNagEFADs=
}

image create photo mini-cross -data {
    R0lGODdhEAAQAPEAALLA3P8AAICAgAAAACwAAAAAEAAQAAACKISPqcsbHgQKFEpAM8x0DMYF
    X8ONYNhgovpApqasU5TItWngiZ72TAEAOw==
}

image create photo mini-desktop -data {
    R0lGODdhEAAQAPIAAICAgACAgAAAAAD//8DAwP///4CAAP//ACwAAAAAEAAQAAADQgi6EMIQ
    BveidEBUG8asWqSNobJZzIku6tq62UIARSEQhkHsRDXXNtwhd/PRgoaD8vB49EjPkekIrAJj
    K0iTxCUpEgA7
}

image create photo mini-dfolder -data {
    R0lGODdhEAAQAPIAALLA3ICAgMDAwP//AAAA/wAAAP///wAAACwAAAAAEAAQAAADSQi63BsQ
    OhbEsCJMUK/PkcQZZGmSQTF+YTtiwWkWsRcTeB7TBmwQP52BZwvmCLuY74hLGopM5LAVo+4A
    hax2u93ESJkNlqsFJAAAOw==
}

image create photo mini-diff -data {
    R0lGODdhEAAQAPEAALLA3P8AAAAAAP///ywAAAAAEAAQAAACQYSPqcLtckSYQYyLIZDGVnxB
    HDBYw5dtAbldaKhGrhkyVTODTBnU07PjUSiaTsZBlIEyydbS93M+RVGgo1NUaA0FADs=
}

image create photo mini-diskette -data {
    R0lGODdhEAAQAPIAAAAAgAAAAICAgP//AODg4P///8DAwAAAACwAAAAAEAAQAAADQAgQ3B5K
    qEGrHQoCwrsnmVKMZFmE2/ehZouq6yK2JarcOK4pRu8bOhwQ8AvehsXbjsjzGXnNnk4STWYE
    goe2kQAAOw==
}

image create photo mini-display -data {
    R0lGODdhEAAQAPIAALLA3ICAgP///wAAAAAA/8DAwAAAAAAAACwAAAAAEAAQAAADPgi63Bsw
    SviEvdgOFcT4INhtwEic6DlyHiGkqscOMLqWbU3cps7ntd9gIpHhMkgSIMQEOTqXQkC5aDYd
    2EYCADs=
}

image create photo mini-doc -data {
    R0lGODdhEAAQAPIAALLA3ICAgMDAwAAAAP///wAAAAAAAAAAACwAAAAAEAAQAAADNAix3PAw
    kEmnCPDJSgXBEUcN5BCKnamh6ckKqsJa8fbWMwG76L7OPhkQN4wIjshksMRsqhIAOw==
}

image create photo mini-doc1 -data {
    R0lGODdhEAAQAPEAALLA3AAAAP///4CAgCwAAAAAEAAQAAACOYSPicEdeoKYk0EghxbyKUlx
    zSdomxYMCRhW6lKaW7q2FA3L8xvZbq0bcHgGVgsXcSiJhqDsAgUUAAA7
}

image create photo mini-dog -data {
    R0lGODdhEAAQAPEAAICAgAAAAP///8DAwCwAAAAAEAAQAAACPoSPqRbt6oKYgiEpxqA1XKkJ
    zeRdGTZg4pVybgk0sTvFMENydhJsI3WbTVIRnoiSWqhsMmOIEzRwntGFFVAAADs=
}

image create photo mini-edit -data {
    R0lGODdhEAAQAPIAALLA3AAAAICAgP///wAA/wAAAAAAAAAAACwAAAAAEAAQAAADPwi63CAw
    RveGvUMEJ7LMw7YQHWZpgUiQXoRta1CaVxBX0ndXtLXjOQ1BpJi9UkRgBBliGEMvZ6/GQFqv
    lGwjAQA7
}

image create photo mini-espada -data {
    R0lGODdhEAAQAPAAAICAgAAAACwAAAAAEAAQAAACIoSPqRbr7RSMJ1jK7I26v+4l4CiOYWVq
    0tWo1IQBMHfGSwEAOw==
}

image create photo mini-exclam -data {
    R0lGODdhEAAQAPIAALLA3ICAgACAAP///wAAAAAAAAAAAAAAACwAAAAAEAAQAAADLQi6GsKQ
    hSFEiJJWglf9XOeAV/dtnXKGKZh6AvvGLyOnU1UDZznHPhwhuEslAAA7
}

image create photo mini-exp -data {
    R0lGODdhEAAQAPEAALLA3AAAAICAgP//ACwAAAAAEAAQAAACMoSPqRbrzYQDYbQAD97VWtUN
    4shJzIiSSZhmDKuuaayJmN1lHGVT2GHSuAJB0OSInBQAADs=
}

image create photo mini-eye -data {
    R0lGODdhEAAQAPEAALLA3AAAAIKCgsPDwywAAAAAEAAQAAACK4SPqcvtb4KcYs1wKJIADzF0
    HTZGgBBU5JiaX0hWh6Bmp5yoHA71/g+EFAAAOw==
}

image create photo mini-eyes -data {
    R0lGODdhEAAQAPIAALLA3AAAAICAgMDAwP///wAAAAAAAAAAACwAAAAAEAAQAAADPwi63P4w
    tkDDqvYOQoYNW5eBHOeF5leWwcoFQuvKK9xSLIG/sSefO48AQBL1UoIhsZJcUpqLJBQgVUqu
    2KwiAQA7
}

image create photo mini-fax -data {
    R0lGODdhEAAQAPIAALLA3ICAgAAAAMDAwP///wAAAAAAAAAAACwAAAAAEAAQAAADSAi6HM5w
    BUIfdI5qIuQk39Yp0zBkokScpTlwJ1DOQuAKZkYHtXvWu17OAaSYhBii0DhMdnC5VZI3Agig
    LGXEitNuF9fqd7xIAAA7
}

image create photo mini-fdisk -data {
    R0lGODdhEAAQAPIAALLA3ICAgMDAwAAAAP8AAP///wAAAAAAACwAAAAAEAAQAAADMgi63P4w
    yhmqvVYFwbvnwRAUZGmSlfh9hJBu3eW9bjrcVq125hxiQMtAcSsajZOkcpkAADs=
}

image create photo mini-filemgr -data {
    R0lGODdhEAAQAPIAALLA3ICAgMDAwAAAAP///wAAAAAAAAAAACwAAAAAEAAQAAADPggK0f5L
    BUGraCO+jTX5IDF0S0BY1Bhk5TkMlcpKJyp7qHCXb9+TtNBnR8sRGS5YCog0riJN24zn60Gv
    2EUCADs=
}

image create photo mini-folder -data {
    R0lGODdhEAAQAPIAALLA3ICAgMDAwP//AAAAAP///wAAAAAAACwAAAAAEAAQAAADOwi63BsQ
    OhbEsCJMUK/PkcQVZGmSATF+rJWOWHu9QSHHdBHvs1rfnhxvlwO6fKFkSAUgOJ9Q6GZKdSQA
    ADs=
}

image create photo mini-font -data {
    R0lGODdhEAAQAPEAALLA3AAAAICAgAAAACwAAAAAEAAQAAACJ4SPqcvtF8IzMYhXrYuCN95p
    Cwh4Y2YmoBBequWWIpLKMcIm+cQ3BQA7
}

image create photo mini-fractal -data {
    R0lGODdhEAAQAPIAALLA3AAAAICAgP8AAP//AMDAwACAAAAA/ywAAAAAEAAQAAADSQi63BpB
    MAHjqvCNQXh4T7V15Fd8gZF24iZpxqBe3hXPALp9j4HzgcMAuBnmLofDK7AL5ZJE1iMJvZQu
    kFeOZHTQrt4HlxcuexMAOw==
}

image create photo mini-frame -data {
    R0lGODdhEAAQAPEAALLA3P8AAAAAAAAAACwAAAAAEAAQAAACM4SPqcGsGISU4YF43V3izrpx
    IdMlWFRhZqeeD+rFJniWEHu4ptGwNmSQyF4NlQUw+R2PBQA7
}

image create photo mini-ftp -data {
    R0lGODdhEAAQAPEAAICAgP///wAAAAAA/ywAAAAAEAAQAAACNoSPqcEdelwDDwh7w9hN+ItI
    EhhtphmQhuiolMa1l/eyaQKf3ZzZd3gatHA+l+93+CiVkCagAAA7
}

image create photo mini-gball -data {
    R0lGODdhEAAQAPEAALLA3ACAAP///4CAgCwAAAAAEAAQAAACG4SPqcvtD1mYMAhBncVh6Dl5
    Xyc6wxml6so+BQA7
}

image create photo mini-go -data {
    R0lGODdhEAAQAPEAAICAgAAA//8AAP///ywAAAAAEAAQAAACMoSPecEpj8IYzYgJjaTh3JEB
    zOg9oViVgsK27gtbJ9p52KpN6Rduu4mjpQCmBCmGdBUAADs=
}

image create photo mini-gopher -data {
    R0lGODdhEAAQAPIAAICAgICAAIAAAP///wAAAAAAAAAAAAAAACwAAAAAEAAQAAADSQgKESLN
    LRXAg+41SzO+zbM4Q0mawuQQxECy0ijAGZzKmheOHst+qcvFRwAKQT8joIhkhggK5oywoq4m
    LFSJNZloB92weExWJAAAOw==
}

image create photo mini-graph -data {
    R0lGODdhEAAQAPIAAICAgAAAAP8A/wAA/wD/AP8AAAAAAAAAACwAAAAAEAAQAAADOwi6G86Q
    CRGindUCV7EGw9BRXzhmlgl4DAeKK8kQRKWyC23Dnqu/J0ChUPndSMNiDRirJDnQKPRDrSoS
    ADs=
}

image create photo mini-gv -data {
    R0lGODdhEAAQAPEAALLA3AAAAP///wAAACwAAAAAEAAQAAACMYSPqcGhGYQU7oE4ZV1ZP0Zp
    FINgYYhtZjdtF9tyrHussdzRL0yV7e+pNS4kkuUIKAAAOw==
}

image create photo mini-hammer -data {
    R0lGODdhEAAQAPEAAL+/vwAAAP///4CAgCwAAAAAEAAQAAACK4SPiRHAr5wQYdqWqt00i6FN
    TLc0TzA4WAQZq9JG5SurtBzXtn7ktc8L6goAOw==
}

image create photo mini-happy -data {
    R0lGODdhEAAQAPEAALLA3AAAAP//AAAAACwAAAAAEAAQAAACM4SPqRDda5qY86VAc70VSxEg
    WAeO4GFK3xlpbti6GcxU2kjXpbOJFN8TmToQhiNXTCoPBQA7
}

image create photo mini-hdisk -data {
    R0lGODdhEAAQAPIAALLA3ICAgMDAwAAAAACAAP///wAAAAAAACwAAAAAEAAQAAADLgi63P4w
    yhmqvVYFwbvnwRAUZGmSlfh9hJBu6/e62EWr53nXfKgMwKAwOCkajwkAOw==
}

image create photo mini-heart -data {
    R0lGODdhEAAQAPAAAICAgAAAACwAAAAAEAAQAAACIoSPqbvh54KKj0pogb16b+RRSRhNIeMx
    RqauTwvBoBzTbQEAOw==
}

image create photo mini-hex -data {
    R0lGODdhEAAQAPEAAICAgP///wAAAAAA/ywAAAAAEAAQAAACO4SPecHdIBIbjQYQ4qLcQqFh
    3FRlS2ChZei0DauSJDtYY20a8qjC6Z/DuFq+0myjulFoydjyAIpKpYACADs=
}

image create photo mini-hextris -data {
    R0lGODdhEAAQAPIAALLA3ICAgP//AAAAAP8AAAAAAAAAAAAAACwAAAAAEAAQAAADNAi63P5Q
    hRlXEHjUSzrR0eANQQUMaLlhAvlM3EhZrNgNtSR4H7qPCttHJXQFUwyU0cRsMhMAOw==
}

image create photo mini-iconify -data {
    R0lGODdhEAAOAPEAALLA3P8AAAAAAAAAACwAAAAAEAAOAAACKoyPKSHt7xgDtFoqxd0g8+tV
    iIYtJHacIWqopgWJ7ydPdGnfUsKn0A8pAAA7
}

image create photo mini-icons -data {
    R0lGODdhEAAQAPIAAICAgP///wAAAAAA/wD/AP8AAP//AAAAACwAAAAAEAAQAAADPAi63BoQ
    ihfDBGFo+4jnmDaAgUeQImmS1VWBQiwr8uzceL68bvsUQJJhSAIWhESXEWlgRXpPWu0yvega
    CQA7
}

image create photo mini-keyboard -data {
    R0lGODdhEQAQAPEAAICAgP///wAAAMDAwCwAAAAAEQAQAAACPYSPecHtDgQIqsY5hwiab31R
    QzQKZRlqwsq2kuTFHQPC2nkPqO32LxZrdGoYnI50gUV8rYul8mL2ntRqogAAOw==
}

set images1 { 
    apm-alert apm-empty apm-full apm-half apm-loading apm-online 
    apm-unknown folder arch asmail audiovol ball bball 
}
set images2 {
    bomb book1 book2 books briefcase bug1 bug2 bx2 calc camera cat 
    cave cd cdlabel chinese clipboard clock colors connect crosbone 
}
set images3 {
    cross desktop dfolder diff diskette display doc doc1 dog edit 
    espada exclam exp eye eyes fax fdisk filemgr font fractal 
}
set images4 {
    frame ftp gball go gopher graph gv hammer happy hdisk heart hex 
    hextris iconify icons keyboard 
}

proc MakeContainer { count images } {
    set c .c$count
    set top .top$count
    set b .b$count

    blt::container $c -bd 0 -highlightthickness 0
    toplevel $top 
    wm withdraw $top

    wm protocol $top WM_DELETE_WINDOW "$b invoke"

    frame $top.f -relief raised -highlightthickness 0
    pack $top.f -expand yes -fill x 

    foreach img $images {
	button $top.f.$img -image mini-$img -bd 1 -command "puts $img" \
	    -highlightthickness 0
	pack $top.f.$img -side left -padx 0 -pady 0
    } 
    global $img
    checkbutton $b -variable $img -onvalue $top -offvalue "" -command \
	[subst -nocommands { $c configure -window \$$img }]
    $b select 
    blt::table . \
	$b $count,0 -anchor w \
	$c $count,1 -fill x 
    blt::table configure . c0 -resize none
    blt::table configure . r$count -resize none
    after 1 [subst {
	update 
	wm deiconify $top
	$c configure -window $top
    }]
    return $c
}

MakeContainer 1 $images1
MakeContainer 2 $images2
MakeContainer 3 $images3
MakeContainer 4 $images4

canvas .a 
blt::table . .a -cspan 40

