/* manager.c generated by valac 0.30.1, the Vala compiler
 * generated from manager.vala, do not modify */

/* Copyright (C) 2016 Canonical Ltd.
 * Author: Luke Yelavich <luke.yelavich@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Loads, sets, and resets profile settings, and provides access to information
 * stored in the profile manifest.
 */

#include <glib.h>
#include <glib-object.h>
#include <unistd.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>


#define A11Y_PROFILE_MANAGER_TYPE_PROFILE (a11y_profile_manager_profile_get_type ())
#define A11Y_PROFILE_MANAGER_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfile))
#define A11Y_PROFILE_MANAGER_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfileClass))
#define A11Y_PROFILE_MANAGER_IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), A11Y_PROFILE_MANAGER_TYPE_PROFILE))
#define A11Y_PROFILE_MANAGER_IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), A11Y_PROFILE_MANAGER_TYPE_PROFILE))
#define A11Y_PROFILE_MANAGER_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), A11Y_PROFILE_MANAGER_TYPE_PROFILE, A11yProfileManagerProfileClass))

typedef struct _A11yProfileManagerProfile A11yProfileManagerProfile;
typedef struct _A11yProfileManagerProfileClass A11yProfileManagerProfileClass;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GType a11y_profile_manager_profile_get_type (void) G_GNUC_CONST;
GSList* a11y_profile_manager_list_profiles (void);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
A11yProfileManagerProfile* a11y_profile_manager_profile_new (const gchar* profile_dir);
A11yProfileManagerProfile* a11y_profile_manager_profile_construct (GType object_type, const gchar* profile_dir);
void a11y_profile_manager_profile_validate (A11yProfileManagerProfile* self, GError** error);
gboolean a11y_profile_manager_profile_get_valid (A11yProfileManagerProfile* self);
A11yProfileManagerProfile* a11y_profile_manager_get_profile_by_dir_name (const gchar* dir_name);
const gchar* a11y_profile_manager_profile_get_dir_name (A11yProfileManagerProfile* self);
A11yProfileManagerProfile* a11y_profile_manager_get_profile_by_name (const gchar* name);
const gchar* a11y_profile_manager_profile_get_name (A11yProfileManagerProfile* self);
void a11y_profile_manager_set_active_profile (A11yProfileManagerProfile* profile_obj, GError** error);
void a11y_profile_manager_profile_reset_settings (A11yProfileManagerProfile* self, GError** error);
void a11y_profile_manager_profile_set_settings (A11yProfileManagerProfile* self, GError** error);


/**
 * Lists the available accessibility profiles. Only valid profiles are
 * added to the list.
 *
 * @return a #GSList of {@link Profile} objects.
 *
 * @since 0.1
 */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GSList* a11y_profile_manager_list_profiles (void) {
	GSList* result = NULL;
	GSList* profiles = NULL;
	GDir* profile_dir = NULL;
	gint _tmp0_ = 0;
	gchar* name = NULL;
	GError * _inner_error_ = NULL;
	profiles = NULL;
	profile_dir = NULL;
	_tmp0_ = access (PROFILEDIR, R_OK | X_OK);
	if (_tmp0_ < 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("You do not have permission to examine the contents of the profile dire" \
"ctory %s.");
		g_warning (_tmp1_, PROFILEDIR);
		result = NULL;
		_g_dir_close0 (profile_dir);
		__g_slist_free__g_object_unref0_0 (profiles);
		return result;
	}
	{
		GDir* _tmp2_ = NULL;
		GDir* _tmp3_ = NULL;
		GDir* _tmp4_ = NULL;
		_tmp3_ = g_dir_open (PROFILEDIR, (guint) 0, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch14_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_dir_close0 (profile_dir);
		profile_dir = _tmp4_;
		_g_dir_close0 (_tmp2_);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("manager.vala:51: %s", _tmp6_);
		result = NULL;
		_g_error_free0 (e);
		_g_dir_close0 (profile_dir);
		__g_slist_free__g_object_unref0_0 (profiles);
		return result;
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_dir_close0 (profile_dir);
		__g_slist_free__g_object_unref0_0 (profiles);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		GDir* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* profile_path = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp7_ = profile_dir;
		_tmp8_ = g_dir_read_name (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (name);
		name = _tmp9_;
		_tmp10_ = name;
		if (!(_tmp10_ != NULL)) {
			break;
		}
		_tmp11_ = name;
		_tmp12_ = g_strconcat (PROFILEDIR "/", _tmp11_, NULL);
		profile_path = _tmp12_;
		_tmp13_ = profile_path;
		_tmp14_ = access (_tmp13_, R_OK | X_OK);
		if (_tmp14_ < 0) {
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			_tmp15_ = _ ("You do not have permission to access %s.");
			_tmp16_ = profile_path;
			g_warning (_tmp15_, _tmp16_);
			_g_free0 (profile_path);
			continue;
		}
		_tmp17_ = profile_path;
		_tmp18_ = g_file_test (_tmp17_, G_FILE_TEST_IS_DIR);
		if (_tmp18_) {
			A11yProfileManagerProfile* profile = NULL;
			const gchar* _tmp19_ = NULL;
			A11yProfileManagerProfile* _tmp20_ = NULL;
			A11yProfileManagerProfile* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp19_ = name;
			_tmp20_ = a11y_profile_manager_profile_new (_tmp19_);
			profile = _tmp20_;
			{
				A11yProfileManagerProfile* _tmp21_ = NULL;
				_tmp21_ = profile;
				a11y_profile_manager_profile_validate (_tmp21_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch15_g_error;
				}
			}
			goto __finally15;
			__catch15_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("manager.vala:75: %s", _tmp23_);
				_g_error_free0 (e);
				_g_object_unref0 (profile);
				_g_free0 (profile_path);
				continue;
			}
			__finally15:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (profile);
				_g_free0 (profile_path);
				_g_free0 (name);
				_g_dir_close0 (profile_dir);
				__g_slist_free__g_object_unref0_0 (profiles);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp24_ = profile;
			_tmp25_ = a11y_profile_manager_profile_get_valid (_tmp24_);
			_tmp26_ = _tmp25_;
			if (_tmp26_) {
				A11yProfileManagerProfile* _tmp27_ = NULL;
				A11yProfileManagerProfile* _tmp28_ = NULL;
				_tmp27_ = profile;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				profiles = g_slist_append (profiles, _tmp28_);
			}
			_g_object_unref0 (profile);
		}
		_g_free0 (profile_path);
	}
	result = profiles;
	_g_free0 (name);
	_g_dir_close0 (profile_dir);
	return result;
}


/**
 * @param dir_name The directory name relative to the profiles directory
 *
 * @return A validated profile object, or %NULL if no profile found.
 *
 * @since 0.1
 */
A11yProfileManagerProfile* a11y_profile_manager_get_profile_by_dir_name (const gchar* dir_name) {
	A11yProfileManagerProfile* result = NULL;
	GSList* profile_list = NULL;
	GSList* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	g_return_val_if_fail (dir_name != NULL, NULL);
	_tmp0_ = a11y_profile_manager_list_profiles ();
	profile_list = _tmp0_;
	_tmp1_ = profile_list;
	{
		GSList* profile_collection = NULL;
		GSList* profile_it = NULL;
		profile_collection = _tmp1_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			A11yProfileManagerProfile* _tmp2_ = NULL;
			A11yProfileManagerProfile* profile = NULL;
			_tmp2_ = _g_object_ref0 ((A11yProfileManagerProfile*) profile_it->data);
			profile = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				A11yProfileManagerProfile* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				_tmp4_ = profile;
				_tmp5_ = a11y_profile_manager_profile_get_valid (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					A11yProfileManagerProfile* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					_tmp7_ = profile;
					_tmp8_ = a11y_profile_manager_profile_get_dir_name (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = dir_name;
					_tmp3_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					result = profile;
					__g_slist_free__g_object_unref0_0 (profile_list);
					return result;
				}
				_g_object_unref0 (profile);
			}
		}
	}
	result = NULL;
	__g_slist_free__g_object_unref0_0 (profile_list);
	return result;
}


/**
 * @param name The name of the profile as specified in its manifest file
 *
 * @return A validated profile object, or %NULL if no profile found.
 *
 * @since 0.1
 */
A11yProfileManagerProfile* a11y_profile_manager_get_profile_by_name (const gchar* name) {
	A11yProfileManagerProfile* result = NULL;
	GSList* profile_list = NULL;
	GSList* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = a11y_profile_manager_list_profiles ();
	profile_list = _tmp0_;
	_tmp1_ = profile_list;
	{
		GSList* profile_collection = NULL;
		GSList* profile_it = NULL;
		profile_collection = _tmp1_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			A11yProfileManagerProfile* _tmp2_ = NULL;
			A11yProfileManagerProfile* profile = NULL;
			_tmp2_ = _g_object_ref0 ((A11yProfileManagerProfile*) profile_it->data);
			profile = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				A11yProfileManagerProfile* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				_tmp4_ = profile;
				_tmp5_ = a11y_profile_manager_profile_get_valid (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					A11yProfileManagerProfile* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					_tmp7_ = profile;
					_tmp8_ = a11y_profile_manager_profile_get_name (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = name;
					_tmp3_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					result = profile;
					__g_slist_free__g_object_unref0_0 (profile_list);
					return result;
				}
				_g_object_unref0 (profile);
			}
		}
	}
	result = NULL;
	__g_slist_free__g_object_unref0_0 (profile_list);
	return result;
}


/**
 * Sets the active accessibility profile.
 *
 * @param profile_obj A validated #Profile object.
 *
 * @since 0.1
 */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void a11y_profile_manager_set_active_profile (A11yProfileManagerProfile* profile_obj, GError** error) {
	A11yProfileManagerProfile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GSettings* profile_settings = NULL;
	GSettings* _tmp3_ = NULL;
	gchar* active_profile_name = NULL;
	GSettings* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	A11yProfileManagerProfile* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	GSettings* _tmp24_ = NULL;
	GSettings* _tmp28_ = NULL;
	A11yProfileManagerProfile* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (profile_obj != NULL);
	_tmp0_ = profile_obj;
	_tmp1_ = a11y_profile_manager_profile_get_valid (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = g_settings_new ("com.canonical.a11y-profile-manager");
	profile_settings = _tmp3_;
	_tmp4_ = profile_settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "active-profile");
	active_profile_name = _tmp5_;
	_tmp6_ = profile_obj;
	_tmp7_ = a11y_profile_manager_profile_get_dir_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = active_profile_name;
	if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
		_g_free0 (active_profile_name);
		_g_object_unref0 (profile_settings);
		return;
	}
	_tmp11_ = active_profile_name;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = active_profile_name;
		_tmp10_ = g_strcmp0 (_tmp12_, "") != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		A11yProfileManagerProfile* active_profile = NULL;
		const gchar* _tmp13_ = NULL;
		A11yProfileManagerProfile* _tmp14_ = NULL;
		A11yProfileManagerProfile* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		_tmp13_ = active_profile_name;
		_tmp14_ = a11y_profile_manager_profile_new (_tmp13_);
		active_profile = _tmp14_;
		{
			A11yProfileManagerProfile* _tmp15_ = NULL;
			_tmp15_ = active_profile;
			a11y_profile_manager_profile_validate (_tmp15_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch16_g_error;
			}
		}
		goto __finally16;
		__catch16_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_warning ("manager.vala:166: %s", _tmp17_);
			_g_error_free0 (e);
		}
		__finally16:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (active_profile);
			_g_free0 (active_profile_name);
			_g_object_unref0 (profile_settings);
			return;
		}
		_tmp18_ = active_profile;
		_tmp19_ = a11y_profile_manager_profile_get_valid (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_) {
			{
				A11yProfileManagerProfile* _tmp21_ = NULL;
				_tmp21_ = active_profile;
				a11y_profile_manager_profile_reset_settings (_tmp21_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch17_g_error;
				}
			}
			goto __finally17;
			__catch17_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("manager.vala:177: %s", _tmp23_);
				_g_error_free0 (e);
			}
			__finally17:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (active_profile);
				_g_free0 (active_profile_name);
				_g_object_unref0 (profile_settings);
				return;
			}
		}
		_g_object_unref0 (active_profile);
	}
	_tmp24_ = profile_settings;
	g_settings_reset (_tmp24_, "active-profile");
	g_settings_sync ();
	{
		A11yProfileManagerProfile* _tmp25_ = NULL;
		_tmp25_ = profile_obj;
		a11y_profile_manager_profile_set_settings (_tmp25_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_ = NULL;
		GError* _tmp27_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _g_error_copy0 (_tmp26_);
		_inner_error_ = _tmp27_;
		_g_error_free0 (e);
		goto __finally18;
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (active_profile_name);
		_g_object_unref0 (profile_settings);
		return;
	}
	_tmp28_ = profile_settings;
	_tmp29_ = profile_obj;
	_tmp30_ = a11y_profile_manager_profile_get_dir_name (_tmp29_);
	_tmp31_ = _tmp30_;
	g_settings_set_string (_tmp28_, "active-profile", _tmp31_);
	g_settings_sync ();
	_g_free0 (active_profile_name);
	_g_object_unref0 (profile_settings);
	return;
}



