/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.util;

import java.util.AbstractList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollisionCheckStack<E>
extends AbstractList<E> {
    private Object[] data;
    private int[] next;
    private int size = 0;
    private boolean useIdentity = true;
    private final int[] initialHash = new int[17];

    public CollisionCheckStack() {
        this.data = new Object[16];
        this.next = new int[16];
    }

    public void setUseIdentity(boolean bl) {
        this.useIdentity = bl;
    }

    public boolean getUseIdentity() {
        return this.useIdentity;
    }

    public boolean push(E e) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = e;
        int n = this.hash(e);
        boolean bl = this.findDuplicate(e, n);
        this.next[this.size] = this.initialHash[n];
        this.initialHash[n] = this.size + 1;
        ++this.size;
        return bl;
    }

    public void pushNocheck(E e) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = e;
        this.next[this.size] = -1;
        ++this.size;
    }

    @Override
    public E get(int n) {
        return (E)this.data[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    private int hash(Object object) {
        return ((this.useIdentity ? System.identityHashCode(object) : object.hashCode()) & Integer.MAX_VALUE) % this.initialHash.length;
    }

    public E pop() {
        --this.size;
        Object object = this.data[this.size];
        this.data[this.size] = null;
        int n = this.next[this.size];
        if (n >= 0) {
            int n2 = this.hash(object);
            assert (this.initialHash[n2] == this.size + 1);
            this.initialHash[n2] = n;
        }
        return (E)object;
    }

    public E peek() {
        return (E)this.data[this.size - 1];
    }

    private boolean findDuplicate(E e, int n) {
        int n2 = this.initialHash[n];
        while (n2 != 0) {
            Object object = this.data[--n2];
            if (this.useIdentity ? object == e : e.equals(object)) {
                return true;
            }
            n2 = this.next[n2];
        }
        return false;
    }

    private void expandCapacity() {
        int n = this.data.length;
        int n2 = n * 2;
        Object[] objectArray = new Object[n2];
        int[] nArray = new int[n2];
        System.arraycopy(this.data, 0, objectArray, 0, n);
        System.arraycopy(this.next, 0, nArray, 0, n);
        this.data = objectArray;
        this.next = nArray;
    }

    public void reset() {
        if (this.size > 0) {
            this.size = 0;
            Arrays.fill(this.initialHash, 0);
        }
    }

    public String getCycleString() {
        E e;
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size() - 1;
        E e2 = this.get(n);
        stringBuilder.append(e2);
        do {
            stringBuilder.append(" -> ");
            e = this.get(--n);
            stringBuilder.append(e);
        } while (e2 != e);
        return stringBuilder.toString();
    }
}

