/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.BufferedPaints;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.pipe.hw.AccelSurface;

public abstract class BufferedContext {
    public static final int NO_CONTEXT_FLAGS = 0;
    public static final int SRC_IS_OPAQUE = 1;
    public static final int USE_MASK = 2;
    protected RenderQueue rq;
    protected RenderBuffer buf;
    protected static BufferedContext currentContext;
    private AccelSurface validatedSrcData;
    private AccelSurface validatedDstData;
    private Region validatedClip;
    private Composite validatedComp;
    private Paint validatedPaint;
    private boolean isValidatedPaintJustAColor;
    private int validatedRGB;
    private int validatedFlags;
    private boolean xformInUse;
    private int transX;
    private int transY;

    protected BufferedContext(RenderQueue renderQueue) {
        this.rq = renderQueue;
        this.buf = renderQueue.getBuffer();
    }

    public static void validateContext(AccelSurface accelSurface, AccelSurface accelSurface2, Region region, Composite composite, AffineTransform affineTransform, Paint paint, SunGraphics2D sunGraphics2D, int n) {
        BufferedContext bufferedContext = accelSurface2.getContext();
        bufferedContext.validate(accelSurface, accelSurface2, region, composite, affineTransform, paint, sunGraphics2D, n);
    }

    public static void validateContext(AccelSurface accelSurface) {
        BufferedContext.validateContext(accelSurface, accelSurface, null, null, null, null, null, 0);
    }

    public void validate(AccelSurface accelSurface, AccelSurface accelSurface2, Region region, Composite composite, AffineTransform affineTransform, Paint paint, SunGraphics2D sunGraphics2D, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        if (!accelSurface2.isValid() || accelSurface2.isSurfaceLost() || accelSurface.isSurfaceLost()) {
            this.invalidateContext();
            throw new InvalidPipeException("bounds changed or surface lost");
        }
        if (paint instanceof Color) {
            n2 = ((Color)paint).getRGB();
            if (this.isValidatedPaintJustAColor) {
                if (n2 != this.validatedRGB) {
                    this.validatedRGB = n2;
                    bl2 = true;
                }
            } else {
                this.validatedRGB = n2;
                bl2 = true;
                this.isValidatedPaintJustAColor = true;
            }
        } else if (this.validatedPaint != paint) {
            bl2 = true;
            this.isValidatedPaintJustAColor = false;
        }
        if (currentContext != this || accelSurface != this.validatedSrcData || accelSurface2 != this.validatedDstData) {
            if (accelSurface2 != this.validatedDstData) {
                bl = true;
            }
            if (paint == null) {
                bl2 = true;
            }
            this.setSurfaces(accelSurface, accelSurface2);
            currentContext = this;
            this.validatedSrcData = accelSurface;
            this.validatedDstData = accelSurface2;
        }
        if (region != this.validatedClip || bl) {
            if (region != null) {
                if (bl || this.validatedClip == null || !this.validatedClip.isRectangular() || !region.isRectangular() || region.getLoX() != this.validatedClip.getLoX() || region.getLoY() != this.validatedClip.getLoY() || region.getHiX() != this.validatedClip.getHiX() || region.getHiY() != this.validatedClip.getHiY()) {
                    this.setClip(region);
                }
            } else {
                this.resetClip();
            }
            this.validatedClip = region;
        }
        if (composite != this.validatedComp || n != this.validatedFlags) {
            if (composite != null) {
                this.setComposite(composite, n);
            } else {
                this.resetComposite();
            }
            bl2 = true;
            this.validatedComp = composite;
            this.validatedFlags = n;
        }
        n2 = 0;
        if (affineTransform == null) {
            if (this.xformInUse) {
                this.resetTransform();
                this.xformInUse = false;
                n2 = 1;
            } else if (sunGraphics2D != null && (this.transX != sunGraphics2D.transX || this.transY != sunGraphics2D.transY)) {
                n2 = 1;
            }
            if (sunGraphics2D != null) {
                this.transX = sunGraphics2D.transX;
                this.transY = sunGraphics2D.transY;
            }
        } else {
            this.setTransform(affineTransform);
            this.xformInUse = true;
            n2 = 1;
        }
        if (!this.isValidatedPaintJustAColor && n2 != 0) {
            bl2 = true;
        }
        if (bl2) {
            if (paint != null) {
                BufferedPaints.setPaint(this.rq, sunGraphics2D, paint, n);
            } else {
                BufferedPaints.resetPaint(this.rq);
            }
            this.validatedPaint = paint;
        }
        accelSurface2.markDirty();
    }

    public void invalidateSurfaces() {
        this.validatedSrcData = null;
        this.validatedDstData = null;
    }

    private void setSurfaces(AccelSurface accelSurface, AccelSurface accelSurface2) {
        this.rq.ensureCapacityAndAlignment(20, 4);
        this.buf.putInt(70);
        this.buf.putLong(accelSurface.getNativeOps());
        this.buf.putLong(accelSurface2.getNativeOps());
    }

    private void resetClip() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(55);
    }

    private void setClip(Region region) {
        if (region.isRectangular()) {
            this.rq.ensureCapacity(20);
            this.buf.putInt(51);
            this.buf.putInt(region.getLoX()).putInt(region.getLoY());
            this.buf.putInt(region.getHiX()).putInt(region.getHiY());
        } else {
            this.rq.ensureCapacity(28);
            this.buf.putInt(52);
            this.buf.putInt(53);
            int n = this.buf.position();
            this.buf.putInt(0);
            int n2 = 0;
            int n3 = this.buf.remaining() / 16;
            int[] nArray = new int[4];
            SpanIterator spanIterator = region.getSpanIterator();
            while (spanIterator.nextSpan(nArray)) {
                if (n3 == 0) {
                    this.buf.putInt(n, n2);
                    this.rq.flushNow();
                    this.buf.putInt(53);
                    n = this.buf.position();
                    this.buf.putInt(0);
                    n2 = 0;
                    n3 = this.buf.remaining() / 16;
                }
                this.buf.putInt(nArray[0]);
                this.buf.putInt(nArray[1]);
                this.buf.putInt(nArray[2]);
                this.buf.putInt(nArray[3]);
                ++n2;
                --n3;
            }
            this.buf.putInt(n, n2);
            this.rq.ensureCapacity(4);
            this.buf.putInt(54);
        }
    }

    private void resetComposite() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(58);
    }

    private void setComposite(Composite composite, int n) {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            this.rq.ensureCapacity(16);
            this.buf.putInt(56);
            this.buf.putInt(alphaComposite.getRule());
            this.buf.putFloat(alphaComposite.getAlpha());
            this.buf.putInt(n);
        } else if (composite instanceof XORComposite) {
            int n2 = ((XORComposite)composite).getXorPixel();
            this.rq.ensureCapacity(8);
            this.buf.putInt(57);
            this.buf.putInt(n2);
        } else {
            throw new InternalError("not yet implemented");
        }
    }

    private void resetTransform() {
        this.rq.ensureCapacity(4);
        this.buf.putInt(60);
    }

    private void setTransform(AffineTransform affineTransform) {
        this.rq.ensureCapacityAndAlignment(52, 4);
        this.buf.putInt(59);
        this.buf.putDouble(affineTransform.getScaleX());
        this.buf.putDouble(affineTransform.getShearY());
        this.buf.putDouble(affineTransform.getShearX());
        this.buf.putDouble(affineTransform.getScaleY());
        this.buf.putDouble(affineTransform.getTranslateX());
        this.buf.putDouble(affineTransform.getTranslateY());
    }

    public void invalidateContext() {
        this.resetTransform();
        this.resetComposite();
        this.resetClip();
        BufferedPaints.resetPaint(this.rq);
        this.invalidateSurfaces();
        this.validatedComp = null;
        this.validatedClip = null;
        this.validatedPaint = null;
        this.isValidatedPaintJustAColor = false;
        this.xformInUse = false;
    }

    public abstract RenderQueue getRenderQueue();

    public abstract void saveState();

    public abstract void restoreState();
}

