/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior;

import com.sun.corba.se.impl.ior.EncapsulationUtility;
import com.sun.corba.se.spi.ior.Identifiable;
import java.util.Arrays;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class GenericIdentifiable
implements Identifiable {
    private int id;
    private byte[] data;

    public GenericIdentifiable(int n, InputStream inputStream) {
        this.id = n;
        this.data = EncapsulationUtility.readOctets(inputStream);
    }

    public int getId() {
        return this.id;
    }

    public void write(OutputStream outputStream) {
        outputStream.write_ulong(this.data.length);
        outputStream.write_octet_array(this.data, 0, this.data.length);
    }

    public String toString() {
        return "GenericIdentifiable[id=" + this.getId() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenericIdentifiable)) {
            return false;
        }
        GenericIdentifiable genericIdentifiable = (GenericIdentifiable)object;
        return this.getId() == genericIdentifiable.getId() && Arrays.equals(this.getData(), genericIdentifiable.getData());
    }

    public int hashCode() {
        int n = 17;
        for (int i = 0; i < this.data.length; ++i) {
            n = 37 * n + this.data[i];
        }
        return n;
    }

    public GenericIdentifiable(int n, byte[] byArray) {
        this.id = n;
        this.data = (byte[])byArray.clone();
    }

    public byte[] getData() {
        return this.data;
    }
}

