/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.util.ArrayList;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public class MidiUtils {
    public static final int DEFAULT_TEMPO_MPQ = 500000;
    public static final int META_END_OF_TRACK_TYPE = 47;
    public static final int META_TEMPO_TYPE = 81;

    public static boolean isMetaEndOfTrack(MidiMessage midiMessage) {
        if (midiMessage.getLength() != 3 || midiMessage.getStatus() != 255) {
            return false;
        }
        byte[] byArray = midiMessage.getMessage();
        return (byArray[1] & 0xFF) == 47 && byArray[2] == 0;
    }

    public static boolean isMetaTempo(MidiMessage midiMessage) {
        if (midiMessage.getLength() != 6 || midiMessage.getStatus() != 255) {
            return false;
        }
        byte[] byArray = midiMessage.getMessage();
        return (byArray[1] & 0xFF) == 81 && byArray[2] == 3;
    }

    public static int getTempoMPQ(MidiMessage midiMessage) {
        if (midiMessage.getLength() != 6 || midiMessage.getStatus() != 255) {
            return -1;
        }
        byte[] byArray = midiMessage.getMessage();
        if ((byArray[1] & 0xFF) != 81 || byArray[2] != 3) {
            return -1;
        }
        int n = byArray[5] & 0xFF | (byArray[4] & 0xFF) << 8 | (byArray[3] & 0xFF) << 16;
        return n;
    }

    public static double convertTempo(double d) {
        if (d <= 0.0) {
            d = 1.0;
        }
        return 6.0E7 / d;
    }

    public static long ticks2microsec(long l, double d, int n) {
        return (long)((double)l * d / (double)n);
    }

    public static long microsec2ticks(long l, double d, int n) {
        return (long)((double)l * (double)n / d);
    }

    public static long tick2microsecond(Sequence sequence, long l, TempoCache tempoCache) {
        if (sequence.getDivisionType() != 0.0f) {
            double d = (double)l / (double)(sequence.getDivisionType() * (float)sequence.getResolution());
            return (long)(1000000.0 * d);
        }
        if (tempoCache == null) {
            tempoCache = new TempoCache(sequence);
        }
        int n = sequence.getResolution();
        long[] lArray = tempoCache.ticks;
        int[] nArray = tempoCache.tempos;
        int n2 = nArray.length;
        int n3 = tempoCache.snapshotIndex;
        int n4 = tempoCache.snapshotMicro;
        long l2 = 0L;
        if (n3 <= 0 || n3 >= n2 || lArray[n3] > l) {
            n4 = 0;
            n3 = 0;
        }
        if (n2 > 0) {
            int n5 = n3 + 1;
            while (n5 < n2 && lArray[n5] <= l) {
                n4 = (int)((long)n4 + MidiUtils.ticks2microsec(lArray[n5] - lArray[n5 - 1], nArray[n5 - 1], n));
                n3 = n5++;
            }
            l2 = (long)n4 + MidiUtils.ticks2microsec(l - lArray[n3], nArray[n3], n);
        }
        tempoCache.snapshotIndex = n3;
        tempoCache.snapshotMicro = n4;
        return l2;
    }

    public static long microsecond2tick(Sequence sequence, long l, TempoCache tempoCache) {
        int n;
        if (sequence.getDivisionType() != 0.0f) {
            double d = (double)l * (double)sequence.getDivisionType() * (double)sequence.getResolution() / 1000000.0;
            long l2 = (long)d;
            if (tempoCache != null) {
                tempoCache.currTempo = (int)tempoCache.getTempoMPQAt(l2);
            }
            return l2;
        }
        if (tempoCache == null) {
            tempoCache = new TempoCache(sequence);
        }
        long[] lArray = tempoCache.ticks;
        int[] nArray = tempoCache.tempos;
        int n2 = nArray.length;
        int n3 = sequence.getResolution();
        long l3 = 0L;
        long l4 = 0L;
        boolean bl = false;
        if (l > 0L && n2 > 0) {
            long l5;
            for (n = 1; n < n2 && (l5 = l3 + MidiUtils.ticks2microsec(lArray[n] - lArray[n - 1], nArray[n - 1], n3)) <= l; ++n) {
                l3 = l5;
            }
            l4 = lArray[n - 1] + MidiUtils.microsec2ticks(l - l3, nArray[n - 1], n3);
        }
        tempoCache.currTempo = nArray[n - 1];
        return l4;
    }

    public static int tick2index(Track track, long l) {
        int n = 0;
        if (l > 0L) {
            long l2;
            int n2 = 0;
            int n3 = track.size() - 1;
            while (n2 < n3 && (l2 = track.get(n = n2 + n3 >> 1).getTick()) != l) {
                if (l2 < l) {
                    if (n2 == n3 - 1) {
                        ++n;
                        break;
                    }
                    n2 = n;
                    continue;
                }
                n3 = n;
            }
        }
        return n;
    }

    public static class TempoCache {
        long[] ticks = new long[1];
        int[] tempos = new int[1];
        int snapshotIndex = 0;
        int snapshotMicro = 0;
        int currTempo;
        private boolean firstTempoIsFake = false;

        public TempoCache() {
            this.tempos[0] = 500000;
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public TempoCache(Sequence sequence) {
            this();
            this.refresh(sequence);
        }

        public synchronized void refresh(Sequence sequence) {
            MidiEvent midiEvent;
            int n;
            int n2;
            ArrayList<MidiEvent> arrayList = new ArrayList<MidiEvent>();
            Track[] trackArray = sequence.getTracks();
            if (trackArray.length > 0) {
                Track track = trackArray[0];
                n2 = track.size();
                for (n = 0; n < n2; ++n) {
                    midiEvent = track.get(n);
                    MidiMessage midiMessage = midiEvent.getMessage();
                    if (!MidiUtils.isMetaTempo(midiMessage)) continue;
                    arrayList.add(midiEvent);
                }
            }
            int n3 = arrayList.size() + 1;
            this.firstTempoIsFake = true;
            if (n3 > 1 && ((MidiEvent)arrayList.get(0)).getTick() == 0L) {
                --n3;
                this.firstTempoIsFake = false;
            }
            this.ticks = new long[n3];
            this.tempos = new int[n3];
            n2 = 0;
            if (this.firstTempoIsFake) {
                this.ticks[0] = 0L;
                this.tempos[0] = 500000;
                ++n2;
            }
            n = 0;
            while (n < arrayList.size()) {
                midiEvent = (MidiEvent)arrayList.get(n);
                this.ticks[n2] = midiEvent.getTick();
                this.tempos[n2] = MidiUtils.getTempoMPQ(midiEvent.getMessage());
                ++n;
                ++n2;
            }
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public int getCurrTempoMPQ() {
            return this.currTempo;
        }

        float getTempoMPQAt(long l) {
            return this.getTempoMPQAt(l, -1.0f);
        }

        synchronized float getTempoMPQAt(long l, float f) {
            for (int i = 0; i < this.ticks.length; ++i) {
                if (this.ticks[i] <= l) continue;
                if (i > 0) {
                    --i;
                }
                if (f > 0.0f && i == 0 && this.firstTempoIsFake) {
                    return f;
                }
                return this.tempos[i];
            }
            return this.tempos[this.tempos.length - 1];
        }
    }
}

