/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import java.util.Vector;

class WaitQ
extends Vector {
    boolean isBeingDestroyed = false;

    WaitQ(int n, int n2) {
        super(n, n2);
    }

    public synchronized void addWaiting(SnmpInformRequest snmpInformRequest) {
        int n;
        long l = snmpInformRequest.getAbsMaxTimeToWait();
        for (n = this.size(); n > 0 && l >= this.getRequestAt(n - 1).getAbsMaxTimeToWait(); --n) {
        }
        if (n == this.size()) {
            this.addElement(snmpInformRequest);
            this.notifyClients();
        } else {
            this.insertElementAt(snmpInformRequest, n);
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.lastElement();
                l = snmpInformRequest.getAbsMaxTimeToWait() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
        return false;
    }

    public synchronized SnmpInformRequest getTimeoutRequests() {
        if (this.waitUntilReady()) {
            SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.lastElement();
            --this.elementCount;
            return snmpInformRequest;
        }
        return null;
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty() && SnmpQManager.isDebugOn()) {
            SnmpQManager.debug("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on waitq permenantly. But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpInformRequest getRequestAt(int n) {
        return (SnmpInformRequest)this.elementAt(n);
    }

    public synchronized SnmpInformRequest removeRequest(long l) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SnmpInformRequest snmpInformRequest = this.getRequestAt(i);
            if (l != (long)snmpInformRequest.getRequestId()) continue;
            this.removeElementAt(i);
            return snmpInformRequest;
        }
        return null;
    }
}

