/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

public class ResourceResolver {
    static Logger log = Logger.getLogger(ResourceResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    List _individualResolverVector = null;
    protected ResourceResolverSpi _resolverSpi = null;

    private ResourceResolver(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (ResourceResolverSpi)Class.forName(string).newInstance();
    }

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this._resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string) throws ResourceResolverException {
        int n = _resolverVector.size();
        for (int i = 0; i < n; ++i) {
            ResourceResolver resourceResolver = (ResourceResolver)_resolverVector.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + resourceResolver.getClass().getName());
            }
            if (resourceResolver == null || !resourceResolver.canResolve(attr, string)) continue;
            return resourceResolver;
        }
        Object[] objectArray = new Object[]{attr != null ? attr.getNodeValue() : "null", string};
        throw new ResourceResolverException("utils.resolver.noClass", objectArray, attr, string);
    }

    public static final ResourceResolver getInstance(Attr attr, String string, List list) throws ResourceResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I was asked to create a ResourceResolver and got " + list.size());
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " extra resolvers to my existing " + _resolverVector.size() + " system-wide resolvers");
        }
        int n = 0;
        if (list != null && (n = list.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                ResourceResolver resourceResolver = (ResourceResolver)list.get(i);
                if (resourceResolver == null) continue;
                String string2 = resourceResolver._resolverSpi.getClass().getName();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "check resolvability by class " + string2);
                }
                if (!resourceResolver.canResolve(attr, string)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.getInstance(attr, string);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = new ResourceResolver(string);
            _resolverVector.add(resourceResolver);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error loading resolver " + string + " disabling it");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            log.log(Level.WARNING, "Error loading resolver " + string + " disabling it");
        }
    }

    public static void registerAtStart(String string) {
        _resolverVector.add(0, string);
    }

    public static XMLSignatureInput resolveStatic(Attr attr, String string) throws ResourceResolverException {
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
        return resourceResolver.resolve(attr, string);
    }

    public XMLSignatureInput resolve(Attr attr, String string) throws ResourceResolverException {
        return this._resolverSpi.engineResolve(attr, string);
    }

    public void setProperty(String string, String string2) {
        this._resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this._resolverSpi.engineGetProperty(string);
    }

    public void addProperties(Map map) {
        this._resolverSpi.engineAddProperies(map);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this._resolverSpi.understandsProperty(string);
    }

    private boolean canResolve(Attr attr, String string) {
        return this._resolverSpi.engineCanResolve(attr, string);
    }
}

