/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.xml.internal.ws.api.pipe.Fiber;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Engine {
    private volatile Executor threadPool;
    public final String id;

    public Engine(String string, Executor executor) {
        this(string);
        this.threadPool = executor;
    }

    public Engine(String string) {
        this.id = string;
    }

    public void setExecutor(Executor executor) {
        this.threadPool = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRunnable(Fiber fiber) {
        if (this.threadPool == null) {
            Engine engine = this;
            synchronized (engine) {
                this.threadPool = Executors.newCachedThreadPool(new DaemonThreadFactory());
            }
        }
        this.threadPool.execute(fiber);
    }

    public Fiber createFiber() {
        return new Fiber(this);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DaemonThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "jaxws-engine-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

