/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CompoundTextSupport {
    static int MAX_CONTROL_SEQUENCE_LEN;
    private static final Map sequenceToEncodingMap;
    private static final Map highBitsMap;
    private static final Map encodingToSequenceMap;
    private static final List encodings;

    private static boolean isEncodingSupported(String string) {
        try {
            if (Charset.isSupported(string)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return CompoundTextSupport.getDecoder(string) != null && CompoundTextSupport.getEncoder(string) != null;
    }

    static CharsetDecoder getStandardDecoder(byte[] byArray) {
        return CompoundTextSupport.getNonStandardDecoder(byArray, null);
    }

    static boolean getHighBit(byte[] byArray) {
        Boolean bl = (Boolean)highBitsMap.get(new ControlSequence(byArray));
        return bl == Boolean.TRUE;
    }

    static CharsetDecoder getNonStandardDecoder(byte[] byArray, byte[] byArray2) {
        return CompoundTextSupport.getDecoder((String)sequenceToEncodingMap.get(new ControlSequence(byArray, byArray2)));
    }

    static CharsetDecoder getDecoder(String string) {
        if (string == null) {
            return null;
        }
        Charset charset = null;
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Class<?> clazz;
            try {
                clazz = Class.forName("sun.awt.motif." + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            try {
                charset = (Charset)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        try {
            return charset.newDecoder();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    static byte[] getEscapeSequence(String string) {
        ControlSequence controlSequence = (ControlSequence)encodingToSequenceMap.get(string);
        if (controlSequence != null) {
            return controlSequence.escSequence;
        }
        return null;
    }

    static byte[] getEncoding(String string) {
        ControlSequence controlSequence = (ControlSequence)encodingToSequenceMap.get(string);
        if (controlSequence != null) {
            return controlSequence.encoding;
        }
        return null;
    }

    static List getEncodings() {
        return encodings;
    }

    static CharsetEncoder getEncoder(String string) {
        if (string == null) {
            return null;
        }
        Charset charset = null;
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Class<?> clazz;
            try {
                clazz = Class.forName("sun.awt.motif." + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            try {
                charset = (Charset)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        try {
            return charset.newEncoder();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private CompoundTextSupport() {
    }

    static {
        HashMap<ControlSequence, String> hashMap = new HashMap<ControlSequence, String>(33, 1.0f);
        HashMap<ControlSequence, Boolean> hashMap2 = new HashMap<ControlSequence, Boolean>(31, 1.0f);
        HashMap<String, ControlSequence> hashMap3 = new HashMap<String, ControlSequence>(21, 1.0f);
        ArrayList<String> arrayList = new ArrayList<String>(21);
        if (!CompoundTextSupport.isEncodingSupported("US-ASCII") || !CompoundTextSupport.isEncodingSupported("ISO-8859-1")) {
            throw new ExceptionInInitializerError("US-ASCII and ISO-8859-1 unsupported");
        }
        ControlSequence controlSequence = new ControlSequence(new byte[]{27, 40, 66});
        hashMap.put(controlSequence, "US-ASCII");
        hashMap2.put(controlSequence, Boolean.FALSE);
        ControlSequence controlSequence2 = new ControlSequence(new byte[]{27, 41, 66});
        hashMap.put(controlSequence2, "US-ASCII");
        hashMap2.put(controlSequence2, Boolean.FALSE);
        controlSequence2 = new ControlSequence(new byte[]{27, 45, 65});
        hashMap.put(controlSequence2, "ISO-8859-1");
        hashMap2.put(controlSequence2, Boolean.TRUE);
        ControlSequence controlSequence3 = controlSequence.concatenate(controlSequence2);
        hashMap3.put("ISO-8859-1", controlSequence3);
        arrayList.add("ISO-8859-1");
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-2")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 66});
            hashMap.put(controlSequence2, "ISO-8859-2");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-2", controlSequence3);
            arrayList.add("ISO-8859-2");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-3")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 67});
            hashMap.put(controlSequence2, "ISO-8859-3");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-3", controlSequence3);
            arrayList.add("ISO-8859-3");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-4")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 68});
            hashMap.put(controlSequence2, "ISO-8859-4");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-4", controlSequence3);
            arrayList.add("ISO-8859-4");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-5")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 76});
            hashMap.put(controlSequence2, "ISO-8859-5");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-5", controlSequence3);
            arrayList.add("ISO-8859-5");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-6")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 71});
            hashMap.put(controlSequence2, "ISO-8859-6");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-6", controlSequence3);
            arrayList.add("ISO-8859-6");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-7")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 70});
            hashMap.put(controlSequence2, "ISO-8859-7");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-7", controlSequence3);
            arrayList.add("ISO-8859-7");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-8")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 72});
            hashMap.put(controlSequence2, "ISO-8859-8");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-8", controlSequence3);
            arrayList.add("ISO-8859-8");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-9")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 77});
            hashMap.put(controlSequence2, "ISO-8859-9");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-9", controlSequence3);
            arrayList.add("ISO-8859-9");
        }
        if (CompoundTextSupport.isEncodingSupported("JIS_X0201")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 40, 74});
            controlSequence3 = new ControlSequence(new byte[]{27, 40, 73});
            ControlSequence controlSequence4 = new ControlSequence(new byte[]{27, 41, 74});
            ControlSequence controlSequence5 = new ControlSequence(new byte[]{27, 41, 73});
            hashMap.put(controlSequence2, "JIS_X0201");
            hashMap.put(controlSequence3, "JIS_X0201");
            hashMap.put(controlSequence4, "JIS_X0201");
            hashMap.put(controlSequence5, "JIS_X0201");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.TRUE);
            hashMap2.put(controlSequence4, Boolean.FALSE);
            hashMap2.put(controlSequence5, Boolean.TRUE);
            ControlSequence controlSequence6 = controlSequence2.concatenate(controlSequence5);
            hashMap3.put("JIS_X0201", controlSequence6);
            arrayList.add("JIS_X0201");
        }
        if (CompoundTextSupport.isEncodingSupported("X11GB2312")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 65});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 65});
            hashMap.put(controlSequence2, "X11GB2312");
            hashMap.put(controlSequence3, "X11GB2312");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11GB2312", controlSequence2);
            arrayList.add("X11GB2312");
        }
        if (CompoundTextSupport.isEncodingSupported("x-JIS0208")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 66});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 66});
            hashMap.put(controlSequence2, "x-JIS0208");
            hashMap.put(controlSequence3, "x-JIS0208");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("x-JIS0208", controlSequence2);
            arrayList.add("x-JIS0208");
        }
        if (CompoundTextSupport.isEncodingSupported("X11KSC5601")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 67});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 67});
            hashMap.put(controlSequence2, "X11KSC5601");
            hashMap.put(controlSequence3, "X11KSC5601");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11KSC5601", controlSequence2);
            arrayList.add("X11KSC5601");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO-8859-15")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 98});
            hashMap.put(controlSequence2, "ISO-8859-15");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO-8859-15", controlSequence3);
            arrayList.add("ISO-8859-15");
        }
        if (CompoundTextSupport.isEncodingSupported("TIS-620")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 84});
            hashMap.put(controlSequence2, "TIS-620");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("TIS-620", controlSequence3);
            arrayList.add("TIS-620");
        }
        if (CompoundTextSupport.isEncodingSupported("JIS_X0212-1990")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 68});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 68});
            hashMap.put(controlSequence2, "JIS_X0212-1990");
            hashMap.put(controlSequence3, "JIS_X0212-1990");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("JIS_X0212-1990", controlSequence2);
            arrayList.add("JIS_X0212-1990");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P1")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 71});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 71});
            hashMap.put(controlSequence2, "X11CNS11643P1");
            hashMap.put(controlSequence3, "X11CNS11643P1");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11CNS11643P1", controlSequence2);
            arrayList.add("X11CNS11643P1");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P2")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 72});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 72});
            hashMap.put(controlSequence2, "X11CNS11643P2");
            hashMap.put(controlSequence3, "X11CNS11643P2");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11CNS11643P2", controlSequence2);
            arrayList.add("X11CNS11643P2");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P3")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 73});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 73});
            hashMap.put(controlSequence2, "X11CNS11643P3");
            hashMap.put(controlSequence3, "X11CNS11643P3");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11CNS11643P3", controlSequence2);
            arrayList.add("X11CNS11643P3");
        }
        if (CompoundTextSupport.isEncodingSupported("x-Johab")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 37, 47, 50}, new byte[]{83, 85, 78, 45, 75, 83, 67, 53, 54, 48, 49, 46, 49, 57, 57, 50, 45, 51});
            hashMap.put(controlSequence2, "x-Johab");
            hashMap3.put("x-Johab", controlSequence2);
            arrayList.add("x-Johab");
        }
        if (CompoundTextSupport.isEncodingSupported("Big5")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 37, 47, 50}, new byte[]{83, 85, 78, 45, 66, 73, 71, 53, 45, 49});
            hashMap.put(controlSequence2, "Big5");
            hashMap3.put("Big5", controlSequence2);
            arrayList.add("Big5");
        }
        sequenceToEncodingMap = Collections.unmodifiableMap(hashMap);
        highBitsMap = Collections.unmodifiableMap(hashMap2);
        encodingToSequenceMap = Collections.unmodifiableMap(hashMap3);
        encodings = Collections.unmodifiableList(arrayList);
    }

    private static final class ControlSequence {
        final int hash;
        final byte[] escSequence;
        final byte[] encoding;

        ControlSequence(byte[] byArray) {
            this(byArray, null);
        }

        ControlSequence(byte[] byArray, byte[] byArray2) {
            int n;
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.escSequence = byArray;
            this.encoding = byArray2;
            int n2 = 0;
            int n3 = byArray.length;
            for (n = 0; n < byArray.length; ++n) {
                n2 += (byArray[n] & 0xFF) << n % 4;
            }
            if (byArray2 != null) {
                for (n = 0; n < byArray2.length; ++n) {
                    n2 += (byArray2[n] & 0xFF) << n % 4;
                }
                n3 += 2 + byArray2.length + 1;
            }
            this.hash = n2;
            if (MAX_CONTROL_SEQUENCE_LEN < n3) {
                MAX_CONTROL_SEQUENCE_LEN = n3;
            }
        }

        public boolean equals(Object object) {
            int n;
            if (this == object) {
                return true;
            }
            if (!(object instanceof ControlSequence)) {
                return false;
            }
            ControlSequence controlSequence = (ControlSequence)object;
            if (this.escSequence != controlSequence.escSequence) {
                if (this.escSequence.length != controlSequence.escSequence.length) {
                    return false;
                }
                for (n = 0; n < this.escSequence.length; ++n) {
                    if (this.escSequence[n] == controlSequence.escSequence[n]) continue;
                    return false;
                }
            }
            if (this.encoding != controlSequence.encoding) {
                if (this.encoding == null || controlSequence.encoding == null || this.encoding.length != controlSequence.encoding.length) {
                    return false;
                }
                for (n = 0; n < this.encoding.length; ++n) {
                    if (this.encoding[n] == controlSequence.encoding[n]) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return this.hash;
        }

        ControlSequence concatenate(ControlSequence controlSequence) {
            if (this.encoding != null) {
                throw new IllegalArgumentException("cannot concatenate to a non-standard charset escape sequence");
            }
            int n = this.escSequence.length + controlSequence.escSequence.length;
            byte[] byArray = new byte[n];
            System.arraycopy(this.escSequence, 0, byArray, 0, this.escSequence.length);
            System.arraycopy(controlSequence.escSequence, 0, byArray, this.escSequence.length, controlSequence.escSequence.length);
            return new ControlSequence(byArray, controlSequence.encoding);
        }
    }
}

