/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibWrapper;

class XFramePeer
extends XDecoratedPeer
implements FramePeer,
XConstants {
    private static Logger log = Logger.getLogger("sun.awt.X11.XFramePeer");
    private static Logger stateLog = Logger.getLogger("sun.awt.X11.states");
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XFramePeer");
    XMenuBarPeer menubarPeer;
    MenuBar menubar;
    int state;
    private Boolean undecorated;
    static final int CROSSHAIR_INSET = 5;
    static final int BUTTON_Y = 6;
    static final int BUTTON_W = 17;
    static final int BUTTON_H = 17;
    static final int SYS_MENU_X = 6;
    static final int SYS_MENU_CONTAINED_X = 11;
    static final int SYS_MENU_CONTAINED_Y = 13;
    static final int SYS_MENU_CONTAINED_W = 8;
    static final int SYS_MENU_CONTAINED_H = 3;
    static final int MAXIMIZE_X_DIFF = 22;
    static final int MAXIMIZE_CONTAINED_X_DIFF = 17;
    static final int MAXIMIZE_CONTAINED_Y = 11;
    static final int MAXIMIZE_CONTAINED_W = 8;
    static final int MAXIMIZE_CONTAINED_H = 8;
    static final int MINIMIZE_X_DIFF = 39;
    static final int MINIMIZE_CONTAINED_X_DIFF = 32;
    static final int MINIMIZE_CONTAINED_Y = 13;
    static final int MINIMIZE_CONTAINED_W = 3;
    static final int MINIMIZE_CONTAINED_H = 3;
    static final int TITLE_X = 23;
    static final int TITLE_W_DIFF = 60;
    static final int TITLE_MID_Y = 14;
    static final int MENUBAR_X = 6;
    static final int MENUBAR_Y = 23;
    static final int HORIZ_RESIZE_INSET = 22;
    static final int VERT_RESIZE_INSET = 22;

    XFramePeer(Frame frame) {
        super(frame);
    }

    XFramePeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        Frame frame = (Frame)this.target;
        this.winAttr.initialState = frame.getState();
        this.state = 0;
        this.undecorated = frame.isUndecorated();
        boolean bl = this.winAttr.nativeDecor = !frame.isUndecorated();
        this.winAttr.decorations = this.winAttr.nativeDecor ? XWindowAttributesData.AWT_DECOR_ALL : XWindowAttributesData.AWT_DECOR_NONE;
        this.winAttr.functions = 1;
        this.winAttr.isResizable = true;
        this.winAttr.title = frame.getTitle();
        this.winAttr.initialResizability = frame.isResizable();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Frame''s initial attributes: decor {0}, resizable {1}, undecorated {2}, initial state {3}", new Object[]{this.winAttr.decorations, this.winAttr.initialResizability, !this.winAttr.nativeDecor, this.winAttr.initialState});
        }
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.setupState(true);
    }

    protected Insets guessInsets() {
        if (this.isTargetUndecorated()) {
            return new Insets(0, 0, 0, 0);
        }
        return super.guessInsets();
    }

    boolean isTargetUndecorated() {
        if (this.undecorated != null) {
            return this.undecorated;
        }
        return ((Frame)this.target).isUndecorated();
    }

    void setupState(boolean bl) {
        if (bl) {
            this.state = this.winAttr.initialState;
        }
        if ((this.state & 1) != 0) {
            this.setInitialState(3);
        } else {
            this.setInitialState(1);
        }
        this.setExtendedState(this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMenuBar(MenuBar menuBar) {
        block13: {
            block12: {
                block11: {
                    XToolkit.awtLock();
                    try {
                        Object object = this.getStateLock();
                        synchronized (object) {
                            if (menuBar == this.menubar) {
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 10] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                                Object var6_3 = null;
                                break block11;
                            }
                            if (menuBar == null) {
                                if (this.menubar != null) {
                                    this.menubarPeer.xSetVisible(false);
                                    this.menubar = null;
                                    this.menubarPeer.dispose();
                                    this.menubarPeer = null;
                                }
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                                break block12;
                            }
                            this.menubar = menuBar;
                            this.menubarPeer = (XMenuBarPeer)menuBar.getPeer();
                            if (this.menubarPeer != null) {
                                this.menubarPeer.init((Frame)this.target);
                            }
                            Rectangle rectangle = this.target.getBounds();
                            this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            this.updateChildrenSizes();
                        }
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                }
                XToolkit.awtUnlock();
                return;
            }
            Object var6_4 = null;
            XToolkit.awtUnlock();
            return;
        }
        Object var6_5 = null;
        XToolkit.awtUnlock();
        if (this.target.isVisible()) {
            this.target.validate();
        }
    }

    XMenuBarPeer getMenubarPeer() {
        return this.menubarPeer;
    }

    int getMenuBarHeight() {
        if (this.menubarPeer != null) {
            return this.menubarPeer.getDesiredHeight();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildrenSizes() {
        super.updateChildrenSizes();
        XToolkit.awtLock();
        try {
            Object object = this.getStateLock();
            synchronized (object) {
                int n = this.dimensions.getClientSize().width;
                if (this.menubarPeer != null) {
                    this.menubarPeer.reshape(0, 0, n, this.getMenuBarHeight());
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximizedBounds(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting maximized bounds to " + rectangle);
        }
        if (rectangle == null) {
            return;
        }
        this.maxBounds = new Rectangle(rectangle);
        XToolkit.awtLock();
        try {
            XSizeHints xSizeHints = this.getHints();
            xSizeHints.set_flags(xSizeHints.get_flags() | 0x20L);
            if (rectangle.width != Integer.MAX_VALUE) {
                xSizeHints.set_max_width(rectangle.width);
            } else {
                xSizeHints.set_max_width((int)XlibWrapper.DisplayWidth(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay())));
            }
            if (rectangle.height != Integer.MAX_VALUE) {
                xSizeHints.set_max_height(rectangle.height);
            } else {
                xSizeHints.set_max_height((int)XlibWrapper.DisplayHeight(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay())));
            }
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(xSizeHints.get_flags()));
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), this.window, xSizeHints.pData);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        if (!this.isShowing()) {
            stateLog.finer("Frame is not showing");
            this.state = n;
            return;
        }
        this.changeState(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int n) {
        int n2 = this.state ^ n;
        int n3 = n2 & 1;
        boolean bl = (n & 1) != 0;
        stateLog.log(Level.FINER, "Changing state, old state {0}, new state {1}(iconic {2})", new Object[]{this.state, n, bl});
        if (n3 != 0 && bl) {
            if (stateLog.isLoggable(Level.FINER)) {
                stateLog.finer("Iconifying shell " + this.getShell() + ", this " + this + ", screen " + this.getScreenNumber());
            }
            XToolkit.awtLock();
            try {
                int n4 = XlibWrapper.XIconifyWindow(XToolkit.getDisplay(), this.getShell(), this.getScreenNumber());
                if (stateLog.isLoggable(Level.FINER)) {
                    stateLog.finer("XIconifyWindow returned " + n4);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        if ((n2 & 0xFFFFFFFE) != 0) {
            this.setExtendedState(n);
        }
        if (n3 != 0 && !bl) {
            if (stateLog.isLoggable(Level.FINER)) {
                stateLog.finer("DeIconifying " + this);
            }
            this.xSetVisible(true);
        }
    }

    void setExtendedState(int n) {
        XWM.getWM().setExtendedState(this, n);
    }

    public void handlePropertyNotify(XEvent xEvent) {
        Integer n;
        super.handlePropertyNotify(xEvent);
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Property change {0}", new Object[]{String.valueOf(xPropertyEvent)});
        }
        if ((n = XWM.getWM().isStateChange(this, xPropertyEvent)) == null) {
            return;
        }
        int n2 = this.state ^ n;
        if (n2 == 0) {
            stateLog.finer("State is the same: " + this.state);
            return;
        }
        int n3 = this.state;
        this.state = n;
        if ((n2 & 1) != 0) {
            if ((this.state & 1) != 0) {
                stateLog.finer("Iconified");
                this.handleIconify();
            } else {
                stateLog.finer("DeIconified");
                this.content.purgeIconifiedExposeEvents();
                this.handleDeiconify();
            }
        }
        this.handleStateChange(n3, this.state);
    }

    public void handleStateChange(int n, int n2) {
        super.handleStateChange(n, n2);
        for (ToplevelStateListener toplevelStateListener : this.toplevelStateListeners) {
            toplevelStateListener.stateChangedJava(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean bl) {
        if (bl) {
            this.setupState(false);
        } else if ((this.state & 6) != 0) {
            XWM.getWM().setExtendedState(this, this.state & 0xFFFFFFF9);
        }
        super.setVisible(bl);
        if (!bl && (this.state & 1) != 0) {
            XToolkit.awtLock();
            try {
                XUnmapEvent xUnmapEvent = new XUnmapEvent();
                xUnmapEvent.set_window(this.getShell());
                xUnmapEvent.set_event(XToolkit.getDefaultRootWindow());
                xUnmapEvent.set_type(18);
                xUnmapEvent.set_from_configure(false);
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, xUnmapEvent.pData);
                xUnmapEvent.dispose();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        if (bl && this.maxBounds != null) {
            this.setMaximizedBounds(this.maxBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInitialState(int n) {
        XToolkit.awtLock();
        try {
            XWMHints xWMHints = this.getWMHints();
            xWMHints.set_flags(2L | xWMHints.get_flags());
            xWMHints.set_initial_state(n);
            if (stateLog.isLoggable(Level.FINE)) {
                stateLog.fine("Setting initial WM state on " + this + " to " + n);
            }
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    public void dispose() {
        if (this.menubarPeer != null) {
            this.menubarPeer.dispose();
        }
        super.dispose();
    }

    boolean isMaximized() {
        return (this.state & 6) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Object object;
        Serializable serializable;
        Object object2;
        super.print(graphics);
        Frame frame = (Frame)this.target;
        Insets insets = frame.getInsets();
        Dimension dimension = frame.getSize();
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        if (color == null) {
            color = XToolkit.getUIDefaults().getColor("window");
        }
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
            if (color3.equals(Color.white)) {
                graphics.setColor(new Color(230, 230, 230));
            } else {
                graphics.setColor(color3);
            }
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.drawLine(0, 1, dimension.width - 1, 1);
            graphics.drawLine(0, 0, 0, dimension.height);
            graphics.drawLine(1, 0, 1, dimension.height - 1);
            graphics.setColor(color3);
            graphics.drawLine(6, dimension.height - 5, dimension.width - 5, dimension.height - 5);
            graphics.drawLine(dimension.width - 5, 6, dimension.width - 5, dimension.height - 5);
            graphics.setColor(color4);
            graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
            graphics.drawLine(2, dimension.height - 1, dimension.width, dimension.height - 1);
            graphics.drawLine(dimension.width, 1, dimension.width, dimension.height);
            graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height);
            graphics.drawLine(5, 5, dimension.width - 5, 5);
            graphics.drawLine(5, 5, 5, dimension.height - 5);
        }
        if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_TITLE)) {
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MENU)) {
                graphics.setColor(color);
                graphics.fill3DRect(6, 6, 17, 17, true);
                graphics.fill3DRect(11, 13, 8, 3, true);
            }
            graphics.fill3DRect(23, 6, dimension.width - 60, 17, true);
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MINIMIZE)) {
                graphics.fill3DRect(dimension.width - 39, 6, 17, 17, true);
                graphics.fill3DRect(dimension.width - 32, 13, 3, 3, true);
            }
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_MAXIMIZE)) {
                graphics.fill3DRect(dimension.width - 22, 6, 17, 17, true);
                graphics.fill3DRect(dimension.width - 17, 11, 8, 8, true);
            }
            graphics.setColor(color2);
            object2 = new Font("SansSerif", 0, 10);
            graphics.setFont((Font)object2);
            serializable = graphics.getFontMetrics();
            object = frame.getTitle();
            graphics.drawString((String)object, (46 + dimension.width - 60) / 2 - ((FontMetrics)serializable).stringWidth((String)object) / 2, 14 + ((FontMetrics)serializable).getMaxDescent());
        }
        if (frame.isResizable() && this.hasDecorations(XWindowAttributesData.AWT_DECOR_RESIZEH)) {
            graphics.setColor(color4);
            graphics.drawLine(1, 22, 5, 22);
            graphics.drawLine(22, 1, 22, 5);
            graphics.drawLine(dimension.width - 5 + 1, 22, dimension.width, 22);
            graphics.drawLine(dimension.width - 22 - 1, 2, dimension.width - 22 - 1, 6);
            graphics.drawLine(1, dimension.height - 22 - 1, 5, dimension.height - 22 - 1);
            graphics.drawLine(22, dimension.height - 5 + 1, 22, dimension.height);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22 - 1, dimension.width, dimension.height - 22 - 1);
            graphics.drawLine(dimension.width - 22 - 1, dimension.height - 5 + 1, dimension.width - 22 - 1, dimension.height);
            graphics.setColor(color3);
            graphics.drawLine(2, 23, 5, 23);
            graphics.drawLine(23, 2, 23, 5);
            graphics.drawLine(dimension.width - 5 + 1, 23, dimension.width - 1, 23);
            graphics.drawLine(dimension.width - 22, 2, dimension.width - 22, 5);
            graphics.drawLine(2, dimension.height - 22, 5, dimension.height - 22);
            graphics.drawLine(23, dimension.height - 5 + 1, 23, dimension.height - 1);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22, dimension.width - 1, dimension.height - 22);
            graphics.drawLine(dimension.width - 22, dimension.height - 5 + 1, dimension.width - 22, dimension.height - 1);
        }
        if ((object2 = this.menubarPeer) != null) {
            serializable = this.getInsets();
            object = graphics.create();
            int n = 0;
            int n2 = 0;
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
                n += 6;
                n2 += 6;
            }
            if (this.hasDecorations(XWindowAttributesData.AWT_DECOR_TITLE)) {
                n2 += 17;
            }
            try {
                ((Graphics)object).translate(n, n2);
                ((XMenuBarPeer)object2).print((Graphics)object);
                Object var15_14 = null;
                ((Graphics)object).dispose();
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                ((Graphics)object).dispose();
                throw throwable;
            }
        }
    }

    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 3);
    }

    public Rectangle getBoundsPrivate() {
        return this.getBounds();
    }
}

