/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.PrintWriter;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnection;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.ee.ConnectionHandler;
import sun.security.action.GetPropertyAction;

public class JdbcOdbcDriver
extends JdbcOdbcObject
implements JdbcOdbcDriverInterface {
    protected static JdbcOdbc OdbcApi;
    protected static long hEnv;
    protected static long hDbc;
    protected static Hashtable connectionList;
    protected int iTimeOut;
    protected static String nativePrefix;
    protected PrintWriter outWriter;
    protected JdbcOdbcTracer tracer = new JdbcOdbcTracer();

    public JdbcOdbcDriver() {
        if (connectionList == null) {
            connectionList = new Hashtable();
        }
        nativePrefix = "";
    }

    protected synchronized void finalize() {
        if (OdbcApi.getTracer().isTracing()) {
            OdbcApi.getTracer().trace("Driver.finalize");
        }
        try {
            if (hDbc != 0L) {
                this.disconnect(hDbc);
                this.closeConnection(hDbc);
                hDbc = 0L;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection(OdbcApi, hEnv, this);
        int n = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        jdbcOdbcConnection.initialize(JdbcOdbcDriver.getSubName(string), properties, n);
        jdbcOdbcConnection.setURL(string);
        return jdbcOdbcConnection;
    }

    public synchronized Connection EEConnect(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        ConnectionHandler connectionHandler = new ConnectionHandler(OdbcApi, hEnv, this);
        int n = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        connectionHandler.initialize(JdbcOdbcDriver.getSubName(string), properties, n);
        connectionHandler.setURL(string);
        return connectionHandler;
    }

    public int getTimeOut() {
        return this.iTimeOut;
    }

    public void setTimeOut(int n) {
        this.iTimeOut = n;
    }

    public PrintWriter getWriter() {
        return this.outWriter;
    }

    public void setWriter(PrintWriter printWriter) {
        this.outWriter = printWriter;
        this.tracer.setWriter(this.outWriter);
    }

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = false;
        if (this.knownURL(string) && this.trusted()) {
            bl = true;
        }
        return bl;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.getPropertyInfo (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        String string2 = JdbcOdbcDriver.makeConnectionString(properties);
        String string3 = "";
        string3 = this.getConnectionAttributes(JdbcOdbcDriver.getSubName(string), string2);
        Hashtable hashtable = this.getAttributeProperties(string3);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[hashtable.size()];
        for (int i = 0; i < hashtable.size(); ++i) {
            driverPropertyInfoArray[i] = (DriverPropertyInfo)hashtable.get(new Integer(i));
        }
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private boolean initialize() throws SQLException {
        boolean bl = true;
        if (OdbcApi == null) {
            try {
                OdbcApi = new JdbcOdbc(this.tracer, nativePrefix);
                this.tracer = OdbcApi.getTracer();
                JdbcOdbcDriver.OdbcApi.charSet = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
            }
            catch (Exception exception) {
                if (OdbcApi.getTracer().isTracing()) {
                    OdbcApi.getTracer().trace("Unable to load JdbcOdbc library");
                }
                bl = false;
            }
        }
        if (this.getWriter() != null) {
            OdbcApi.getTracer().setWriter(this.getWriter());
        }
        if (hEnv == 0L) {
            try {
                hEnv = OdbcApi.SQLAllocEnv();
            }
            catch (Exception exception) {
                if (OdbcApi.getTracer().isTracing()) {
                    OdbcApi.getTracer().trace("Unable to allocate environment");
                }
                bl = false;
            }
        }
        return bl;
    }

    private boolean knownURL(String string) {
        String string2 = JdbcOdbcDriver.getProtocol(string);
        if (!string2.equalsIgnoreCase("jdbc")) {
            return false;
        }
        string2 = JdbcOdbcDriver.getSubProtocol(string);
        return string2.equalsIgnoreCase("odbc");
    }

    public static String getProtocol(String string) {
        String string2 = "";
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getSubProtocol(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n2 + 1, n);
        }
        return string2;
    }

    public static String getSubName(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private boolean trusted() {
        SecurityManager securityManager;
        boolean bl = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("JDBC to ODBC Bridge: Checking security");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            try {
                String string = AccessController.doPrivileged(new GetPropertyAction("browser"));
                if (string != null && string.equalsIgnoreCase("Netscape Navigator")) {
                    nativePrefix = "Netscape_";
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                securityManager.checkWrite("JdbcOdbcSecurityCheck");
                bl = true;
            }
            catch (SecurityException securityException) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("Security check failed: " + securityException.getMessage());
                }
                bl = false;
            }
        } else {
            if (this.tracer.isTracing()) {
                this.tracer.trace("No SecurityManager present, assuming trusted application/applet");
            }
            bl = true;
        }
        bl = true;
        return bl;
    }

    public String getConnectionAttributes(String string, String string2) throws SQLException {
        String string3;
        String string4 = "DSN=" + string + string2;
        if (hDbc == 0L) {
            hDbc = this.allocConnection(hEnv);
        }
        if ((string3 = OdbcApi.SQLBrowseConnect(hDbc, string4)) == null) {
            string3 = "";
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        return string3;
    }

    public Hashtable getAttributeProperties(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Hashtable<Integer, DriverPropertyInfo> hashtable = new Hashtable<Integer, DriverPropertyInfo>();
        int n4 = string.length();
        while (n < n4) {
            boolean bl = true;
            String string2 = null;
            String string3 = null;
            String[] stringArray = null;
            String string4 = null;
            n2 = string.indexOf(";", n);
            if (n2 < 0) {
                n2 = n4;
            }
            String string5 = string.substring(n, n2);
            int n5 = 0;
            int n6 = string5.indexOf(":", 0);
            int n7 = string5.indexOf("=", 0);
            if (string5.startsWith("*")) {
                bl = false;
                ++n5;
            }
            if (n6 > 0) {
                string2 = string5.substring(n5, n6);
            }
            if (n6 > 0 && n7 > 0) {
                string3 = string5.substring(n6 + 1, n7);
            }
            if (n7 > 0 && (string4 = string5.substring(n7 + 1)).equals("?")) {
                string4 = null;
            }
            if (string4 != null && string4.startsWith("{")) {
                stringArray = JdbcOdbcDriver.listToArray(string4);
                string4 = null;
            }
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, string4);
            driverPropertyInfo.description = string3;
            driverPropertyInfo.required = bl;
            driverPropertyInfo.choices = stringArray;
            hashtable.put(new Integer(n3), driverPropertyInfo);
            ++n3;
            n = n2 + 1;
        }
        return hashtable;
    }

    protected static String makeConnectionString(Properties properties) {
        String string = "";
        Enumeration<?> enumeration = properties.propertyNames();
        JdbcOdbcDriver.OdbcApi.charSet = properties.getProperty("charSet", AccessController.doPrivileged(new GetPropertyAction("file.encoding")));
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.equalsIgnoreCase("user")) {
                string2 = "UID";
            }
            if (string2.equalsIgnoreCase("password")) {
                string2 = "PWD";
            }
            if (string3 == null) continue;
            string = string + ";" + string2 + "=" + string3;
        }
        return string;
    }

    protected static String[] listToArray(String string) {
        String string2;
        String[] stringArray = null;
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        int n4 = string.length();
        if (!string.startsWith("{")) {
            return null;
        }
        if (!string.endsWith("}")) {
            return null;
        }
        while (n2 < n4) {
            n3 = string.indexOf(",", n2);
            if (n3 < 0) {
                n3 = n4 - 1;
            }
            string2 = string.substring(n2, n3);
            hashtable.put(new Integer(n), string2);
            ++n;
            n2 = n3 + 1;
        }
        stringArray = new String[n];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2] = string2 = (String)hashtable.get(new Integer(n2));
        }
        return stringArray;
    }

    public long allocConnection(long l) throws SQLException {
        long l2 = 0L;
        l2 = OdbcApi.SQLAllocConnect(l);
        connectionList.put(new Long(l2), new Long(l));
        return l2;
    }

    public void closeConnection(long l) throws SQLException {
        OdbcApi.SQLFreeConnect(l);
        Long l2 = (Long)connectionList.remove(new Long(l));
        if (connectionList.size() == 0 && hEnv != 0L) {
            OdbcApi.SQLFreeEnv(hEnv);
            hEnv = 0L;
        }
    }

    public void disconnect(long l) throws SQLException {
        OdbcApi.SQLDisconnect(l);
    }

    static {
        block3: {
            JdbcOdbcTracer jdbcOdbcTracer = new JdbcOdbcTracer();
            if (jdbcOdbcTracer.isTracing()) {
                jdbcOdbcTracer.trace("JdbcOdbcDriver class loaded");
            }
            JdbcOdbcDriver jdbcOdbcDriver = new JdbcOdbcDriver();
            try {
                DriverManager.registerDriver(jdbcOdbcDriver);
            }
            catch (SQLException sQLException) {
                if (!jdbcOdbcTracer.isTracing()) break block3;
                jdbcOdbcTracer.trace("Unable to register driver");
            }
        }
    }
}

