/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.stax;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.Encoder;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.stax.StAXManager;
import com.sun.xml.internal.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.internal.fastinfoset.util.NamespaceContextImplementation;
import com.sun.xml.internal.org.jvnet.fastinfoset.stax.LowLevelFastInfosetStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EmptyStackException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StAXDocumentSerializer
extends Encoder
implements XMLStreamWriter,
LowLevelFastInfosetStreamWriter {
    protected StAXManager _manager;
    protected String _encoding;
    protected String _currentLocalName;
    protected String _currentUri;
    protected String _currentPrefix;
    protected boolean _inStartElement = false;
    protected boolean _isEmptyElement = false;
    protected String[] _attributesArray = new String[64];
    protected int _attributesArrayIndex = 0;
    protected boolean[] _nsSupportContextStack = new boolean[32];
    protected int _stackCount = -1;
    protected NamespaceContextImplementation _nsContext = new NamespaceContextImplementation();
    protected String[] _namespacesArray = new String[16];
    protected int _namespacesArrayIndex = 0;

    public StAXDocumentSerializer() {
        super(true);
        this._manager = new StAXManager(2);
    }

    public StAXDocumentSerializer(OutputStream outputStream) {
        super(true);
        this.setOutputStream(outputStream);
        this._manager = new StAXManager(2);
    }

    public StAXDocumentSerializer(OutputStream outputStream, StAXManager stAXManager) {
        super(true);
        this.setOutputStream(outputStream);
        this._manager = stAXManager;
    }

    public void reset() {
        super.reset();
        this._attributesArrayIndex = 0;
        this._namespacesArrayIndex = 0;
        this._nsContext.reset();
        this._stackCount = -1;
        this._currentPrefix = null;
        this._currentUri = null;
        this._currentLocalName = null;
        this._isEmptyElement = false;
        this._inStartElement = false;
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("finf", "1.0");
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.writeStartDocument("finf", string);
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.reset();
        try {
            this.encodeHeader(false);
            this.encodeInitialVocabulary();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        try {
            while (this._stackCount >= 0) {
                this.writeEndElement();
                --this._stackCount;
            }
            this.encodeDocumentTermination();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void close() throws XMLStreamException {
        this.reset();
    }

    public void flush() throws XMLStreamException {
        try {
            this._s.flush();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.writeStartElement("", string, "");
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.writeStartElement("", string2, string);
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.encodeTerminationAndCurrentElement(false);
        this._inStartElement = true;
        this._isEmptyElement = false;
        this._currentLocalName = string2;
        this._currentPrefix = string;
        this._currentUri = string3;
        ++this._stackCount;
        if (this._stackCount == this._nsSupportContextStack.length) {
            boolean[] blArray = new boolean[this._stackCount * 2];
            System.arraycopy(this._nsSupportContextStack, 0, blArray, 0, this._nsSupportContextStack.length);
            this._nsSupportContextStack = blArray;
        }
        this._nsSupportContextStack[this._stackCount] = false;
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.writeEmptyElement("", string, "");
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.writeEmptyElement("", string2, string);
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.encodeTerminationAndCurrentElement(false);
        this._inStartElement = true;
        this._isEmptyElement = true;
        this._currentLocalName = string2;
        this._currentPrefix = string;
        this._currentUri = string3;
        ++this._stackCount;
        if (this._stackCount == this._nsSupportContextStack.length) {
            boolean[] blArray = new boolean[this._stackCount * 2];
            System.arraycopy(this._nsSupportContextStack, 0, blArray, 0, this._nsSupportContextStack.length);
            this._nsSupportContextStack = blArray;
        }
        this._nsSupportContextStack[this._stackCount] = false;
    }

    public void writeEndElement() throws XMLStreamException {
        if (this._inStartElement) {
            this.encodeTerminationAndCurrentElement(false);
        }
        try {
            this.encodeElementTermination();
            if (this._nsSupportContextStack[this._stackCount--]) {
                this._nsContext.popContext();
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (EmptyStackException emptyStackException) {
            throw new XMLStreamException(emptyStackException);
        }
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.writeAttribute("", "", string, string2);
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        String string4 = "";
        if (string.length() > 0 && ((string4 = this._nsContext.getNonDefaultPrefix(string)) == null || string4.length() == 0)) {
            if (string == "http://www.w3.org/2000/xmlns/" || string.equals("http://www.w3.org/2000/xmlns/")) {
                return;
            }
            throw new XMLStreamException(CommonResourceBundle.getInstance().getString("message.URIUnbound", new Object[]{string}));
        }
        this.writeAttribute(string4, string, string2, string3);
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        if (!this._inStartElement) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.attributeWritingNotAllowed"));
        }
        if (string2 == "http://www.w3.org/2000/xmlns/" || string2.equals("http://www.w3.org/2000/xmlns/")) {
            return;
        }
        if (this._attributesArrayIndex == this._attributesArray.length) {
            String[] stringArray = new String[this._attributesArrayIndex * 2];
            System.arraycopy(this._attributesArray, 0, stringArray, 0, this._attributesArrayIndex);
            this._attributesArray = stringArray;
        }
        this._attributesArray[this._attributesArrayIndex++] = string2;
        this._attributesArray[this._attributesArrayIndex++] = string;
        this._attributesArray[this._attributesArrayIndex++] = string3;
        this._attributesArray[this._attributesArrayIndex++] = string4;
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (string == null || string.length() == 0 || string.equals("xmlns")) {
            this.writeDefaultNamespace(string2);
        } else {
            if (!this._inStartElement) {
                throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.attributeWritingNotAllowed"));
            }
            if (this._namespacesArrayIndex == this._namespacesArray.length) {
                String[] stringArray = new String[this._namespacesArrayIndex * 2];
                System.arraycopy(this._namespacesArray, 0, stringArray, 0, this._namespacesArrayIndex);
                this._namespacesArray = stringArray;
            }
            this._namespacesArray[this._namespacesArrayIndex++] = string;
            this._namespacesArray[this._namespacesArrayIndex++] = string2;
            this.setPrefix(string, string2);
        }
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        if (!this._inStartElement) {
            throw new IllegalStateException(CommonResourceBundle.getInstance().getString("message.attributeWritingNotAllowed"));
        }
        if (this._namespacesArrayIndex == this._namespacesArray.length) {
            String[] stringArray = new String[this._namespacesArrayIndex * 2];
            System.arraycopy(this._namespacesArray, 0, stringArray, 0, this._namespacesArrayIndex);
            this._namespacesArray = stringArray;
        }
        this._namespacesArray[this._namespacesArrayIndex++] = "";
        this._namespacesArray[this._namespacesArrayIndex++] = string;
        this.setPrefix("", string);
    }

    public void writeComment(String string) throws XMLStreamException {
        try {
            if (this.getIgnoreComments()) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeComment(string.toCharArray(), 0, string.length());
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.writeProcessingInstruction(string, "");
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        try {
            if (this.getIgnoreProcesingInstructions()) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeProcessingInstruction(string, string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeCData(String string) throws XMLStreamException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    public void writeDTD(String string) throws XMLStreamException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        throw new UnsupportedOperationException(CommonResourceBundle.getInstance().getString("message.notImplemented"));
    }

    public void writeCharacters(String string) throws XMLStreamException {
        try {
            int n = string.length();
            if (n == 0) {
                return;
            }
            if (n < this._charBuffer.length) {
                if (this.getIgnoreWhiteSpaceTextContent() && StAXDocumentSerializer.isWhiteSpace(string)) {
                    return;
                }
                this.encodeTerminationAndCurrentElement(true);
                string.getChars(0, n, this._charBuffer, 0);
                this.encodeCharacters(this._charBuffer, 0, n);
            } else {
                char[] cArray = string.toCharArray();
                if (this.getIgnoreWhiteSpaceTextContent() && StAXDocumentSerializer.isWhiteSpace(cArray, 0, n)) {
                    return;
                }
                this.encodeTerminationAndCurrentElement(true);
                this.encodeCharactersNoClone(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        try {
            if (n2 <= 0) {
                return;
            }
            if (this.getIgnoreWhiteSpaceTextContent() && StAXDocumentSerializer.isWhiteSpace(cArray, n, n2)) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeCharacters(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this._nsContext.getPrefix(string);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (this._stackCount > -1 && !this._nsSupportContextStack[this._stackCount]) {
            this._nsSupportContextStack[this._stackCount] = true;
            this._nsContext.pushContext();
        }
        this._nsContext.declarePrefix(string, string2);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.setPrefix("", string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        throw new UnsupportedOperationException("setNamespaceContext");
    }

    public NamespaceContext getNamespaceContext() {
        return this._nsContext;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (this._manager != null) {
            return this._manager.getProperty(string);
        }
        return null;
    }

    public void setManager(StAXManager stAXManager) {
        this._manager = stAXManager;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public void writeOctets(byte[] byArray, int n, int n2) throws XMLStreamException {
        try {
            if (n2 == 0) {
                return;
            }
            this.encodeTerminationAndCurrentElement(true);
            this.encodeCIIOctetAlgorithmData(1, byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    protected void encodeTerminationAndCurrentElement(boolean bl) throws XMLStreamException {
        try {
            this.encodeTermination();
            if (this._inStartElement) {
                int n;
                this._b = 0;
                if (this._attributesArrayIndex > 0) {
                    this._b |= 0x40;
                }
                if (this._namespacesArrayIndex > 0) {
                    this.write(this._b | 0x38);
                    n = 0;
                    while (n < this._namespacesArrayIndex) {
                        this.encodeNamespaceAttribute(this._namespacesArray[n++], this._namespacesArray[n++]);
                    }
                    this._namespacesArrayIndex = 0;
                    this.write(240);
                    this._b = 0;
                }
                if (this._currentPrefix.length() == 0) {
                    if (this._currentUri.length() == 0) {
                        this._currentUri = this._nsContext.getNamespaceURI("");
                    } else {
                        String string = this.getPrefix(this._currentUri);
                        if (string != null) {
                            this._currentPrefix = string;
                        }
                    }
                }
                this.encodeElementQualifiedNameOnThirdBit(this._currentUri, this._currentPrefix, this._currentLocalName);
                n = 0;
                while (n < this._attributesArrayIndex) {
                    this.encodeAttributeQualifiedNameOnSecondBit(this._attributesArray[n++], this._attributesArray[n++], this._attributesArray[n++]);
                    String string = this._attributesArray[n];
                    this._attributesArray[n++] = null;
                    boolean bl2 = this.isAttributeValueLengthMatchesLimit(string.length());
                    this.encodeNonIdentifyingStringOnFirstBit(string, this._v.attributeValue, bl2, false);
                    this._b = 240;
                    this._terminate = true;
                }
                this._attributesArrayIndex = 0;
                this._inStartElement = false;
                if (this._isEmptyElement) {
                    this.encodeElementTermination();
                    if (this._nsSupportContextStack[this._stackCount--]) {
                        this._nsContext.popContext();
                    }
                    this._isEmptyElement = false;
                }
                if (bl) {
                    this.encodeTermination();
                }
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public final void initiateLowLevelWriting() throws XMLStreamException {
        this.encodeTerminationAndCurrentElement(false);
    }

    public final int getNextElementIndex() {
        return this._v.elementName.getNextIndex();
    }

    public final int getNextAttributeIndex() {
        return this._v.attributeName.getNextIndex();
    }

    public final int getLocalNameIndex() {
        return this._v.localName.getIndex();
    }

    public final int getNextLocalNameIndex() {
        return this._v.localName.getNextIndex();
    }

    public final void writeLowLevelTerminationAndMark() throws IOException {
        this.encodeTermination();
        this.mark();
    }

    public final void writeLowLevelStartElementIndexed(int n, int n2) throws IOException {
        this._b = n;
        this.encodeNonZeroIntegerOnThirdBit(n2);
    }

    public final boolean writeLowLevelStartElement(int n, String string, String string2, String string3) throws IOException {
        boolean bl = this.encodeElement(n, string3, string, string2);
        if (!bl) {
            this.encodeLiteral(n | 0x3C, string3, string, string2);
        }
        return bl;
    }

    public final void writeLowLevelStartNamespaces() throws IOException {
        this.write(56);
    }

    public final void writeLowLevelNamespace(String string, String string2) throws IOException {
        this.encodeNamespaceAttribute(string, string2);
    }

    public final void writeLowLevelEndNamespaces() throws IOException {
        this.write(240);
    }

    public final void writeLowLevelStartAttributes() throws IOException {
        if (this.hasMark()) {
            int n = this._markIndex;
            this._octetBuffer[n] = (byte)(this._octetBuffer[n] | 0x40);
            this.resetMark();
        }
    }

    public final void writeLowLevelAttributeIndexed(int n) throws IOException {
        this.encodeNonZeroIntegerOnSecondBitFirstBitZero(n);
    }

    public final boolean writeLowLevelAttribute(String string, String string2, String string3) throws IOException {
        boolean bl = this.encodeAttribute(string2, string, string3);
        if (!bl) {
            this.encodeLiteral(120, string2, string, string3);
        }
        return bl;
    }

    public final void writeLowLevelAttributeValue(String string) throws IOException {
        boolean bl = this.isAttributeValueLengthMatchesLimit(string.length());
        this.encodeNonIdentifyingStringOnFirstBit(string, this._v.attributeValue, bl, false);
    }

    public final void writeLowLevelStartNameLiteral(int n, String string, byte[] byArray, String string2) throws IOException {
        this.encodeLiteralHeader(n, string2, string);
        this.encodeNonZeroOctetStringLengthOnSecondBit(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public final void writeLowLevelStartNameLiteral(int n, String string, int n2, String string2) throws IOException {
        this.encodeLiteralHeader(n, string2, string);
        this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n2);
    }

    public final void writeLowLevelEndStartElement() throws IOException {
        if (this.hasMark()) {
            this.resetMark();
        } else {
            this._b = 240;
            this._terminate = true;
        }
    }

    public final void writeLowLevelEndElement() throws IOException {
        this.encodeElementTermination();
    }

    public final void writeLowLevelText(char[] cArray, int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.encodeTermination();
        this.encodeCharacters(cArray, 0, n);
    }

    public final void writeLowLevelText(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            return;
        }
        this.encodeTermination();
        if (n < this._charBuffer.length) {
            string.getChars(0, n, this._charBuffer, 0);
            this.encodeCharacters(this._charBuffer, 0, n);
        } else {
            char[] cArray = string.toCharArray();
            this.encodeCharactersNoClone(cArray, 0, n);
        }
    }

    public final void writeLowLevelOctets(byte[] byArray, int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.encodeTermination();
        this.encodeCIIOctetAlgorithmData(1, byArray, 0, n);
    }

    private boolean encodeElement(int n, String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(string3);
        for (int i = 0; i < entry._valueIndex; ++i) {
            QualifiedName qualifiedName = entry._value[i];
            if (string2 != qualifiedName.prefix && !string2.equals(qualifiedName.prefix) || string != qualifiedName.namespaceName && !string.equals(qualifiedName.namespaceName)) continue;
            this._b = n;
            this.encodeNonZeroIntegerOnThirdBit(qualifiedName.index);
            return true;
        }
        entry.addQualifiedName(new QualifiedName(string2, string, string3, "", this._v.elementName.getNextIndex()));
        return false;
    }

    private boolean encodeAttribute(String string, String string2, String string3) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(string3);
        for (int i = 0; i < entry._valueIndex; ++i) {
            QualifiedName qualifiedName = entry._value[i];
            if (string2 != qualifiedName.prefix && !string2.equals(qualifiedName.prefix) || string != qualifiedName.namespaceName && !string.equals(qualifiedName.namespaceName)) continue;
            this.encodeNonZeroIntegerOnSecondBitFirstBitZero(qualifiedName.index);
            return true;
        }
        entry.addQualifiedName(new QualifiedName(string2, string, string3, "", this._v.attributeName.getNextIndex()));
        return false;
    }

    private void encodeLiteralHeader(int n, String string, String string2) throws IOException {
        if (string != "") {
            n |= 1;
            if (string2 != "") {
                n |= 2;
            }
            this.write(n);
            if (string2 != "") {
                this.encodeNonZeroIntegerOnSecondBitFirstBitOne(this._v.prefix.get(string2));
            }
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(this._v.namespaceName.get(string));
        } else {
            this.write(n);
        }
    }

    private void encodeLiteral(int n, String string, String string2, String string3) throws IOException {
        this.encodeLiteralHeader(n, string, string2);
        int n2 = this._v.localName.obtainIndex(string3);
        if (n2 == -1) {
            this.encodeNonEmptyOctetStringOnSecondBit(string3);
        } else {
            this.encodeNonZeroIntegerOnSecondBitFirstBitOne(n2);
        }
    }
}

