/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.SetupData;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.SetupData.XMLPackageDescription;
import org.openoffice.setup.Util.Parser;

public class ProductDescription {
    private Vector macro = new Vector();
    private HashMap map = new HashMap();
    private String backslashText = "THIS_IS_A_BACKSLASH";

    protected ProductDescription(XMLPackageDescription descriptionData) {
        this.parse(descriptionData);
    }

    public void setNewMacro(String key, String value) {
        if (key != null && value != null) {
            String match = "\\$\\{" + key + "\\}";
            Pattern pattern = Pattern.compile(match, 2);
            this.map.put(key, value);
            Iterator m = this.map.entrySet().iterator();
            for (int i = 0; i < this.macro.size(); ++i) {
                Pair pair = (Pair)this.macro.get(i);
                if (!pair.search.pattern().equals(match)) continue;
                this.macro.remove(i);
            }
            this.macro.add(new Pair(pattern, value));
        }
    }

    public void dumpMacros() {
        for (int i = 0; i < this.macro.size(); ++i) {
            Pair pair = (Pair)this.macro.get(i);
            System.out.println("Key: " + pair.search.pattern() + " Value: " + pair.replacement);
        }
    }

    public String get(String key) {
        return (String)this.map.get(key);
    }

    private boolean doMaskBackslash(String[] arr) {
        boolean changed = false;
        int index = arr[0].indexOf(92);
        if (index >= 0) {
            arr[0] = arr[0].replaceAll("\\", this.backslashText);
            changed = true;
        }
        return changed;
    }

    private String doUnmaskBackslash(String s) {
        s = s.replaceAll(this.backslashText, "\\");
        return s;
    }

    public String replaceMacros(String s) {
        String result = s;
        for (int i = 0; i < this.macro.size(); ++i) {
            Pair pair = (Pair)this.macro.get(i);
            Pattern pattern = pair.search;
            Matcher matcher = pattern.matcher(result);
            String replace = pair.replacement;
            result = matcher.replaceAll(replace);
        }
        return result;
    }

    private void parse(XMLPackageDescription data) {
        if (!data.getKey().equals("product")) {
            XMLPackageDescription section = data.getElement("product");
            if (section != null) {
                this.parse(section);
            }
        } else {
            String value;
            InstallData installData = InstallData.getInstance();
            XMLPackageDescription section = data.getElement("defaultdir");
            if (section != null && (value = section.getValue()) != null) {
                installData.setDefaultDir(value);
            }
            if ((section = data.getElement("productdir")) != null && (value = section.getValue()) != null) {
                installData.setProductDir(value);
            }
            if ((section = data.getElement("packageformat")) != null && (value = section.getValue()) != null) {
                installData.setPackageFormat(value);
            }
            if ((section = data.getElement("packagedirectory")) != null && (value = section.getValue()) != null && !value.equals("")) {
                installData.setPackageSubdir(value);
            }
            if ((section = data.getElement("architecture")) != null && (value = section.getValue()) != null && !value.equals("")) {
                installData.setArchitecture(value);
            }
            if ((section = data.getElement("multilingual")) != null && (value = section.getValue()) != null && !value.equals("")) {
                boolean multilingualValue = Parser.parseBoolean(value);
                installData.setIsMultiLingual(multilingualValue);
            }
            if ((section = data.getElement("dontupdate")) != null) {
                value = section.getValue();
                boolean dontupdate = false;
                if (value != null && !value.equals("")) {
                    dontupdate = Parser.parseBoolean(value);
                }
                installData.setDontUpdate(dontupdate);
            }
            if ((section = data.getElement("productminor")) != null && (value = section.getValue()) != null) {
                int intValue = Integer.parseInt(value);
                installData.setProductMinor(intValue);
            }
            if ((section = data.getElement("hideeula")) != null && (value = section.getValue()) != null && !value.equals("")) {
                boolean hideeulaValue = Parser.parseBoolean(value);
                installData.setHideEula(hideeulaValue);
            }
            Enumeration e = data.elements();
            while (e.hasMoreElements()) {
                XMLPackageDescription p = (XMLPackageDescription)e.nextElement();
                if (!p.getKey().equals("macro")) continue;
                String key = p.getAttribute("key");
                String value2 = p.getValue();
                if (key == null || value2 == null) continue;
                String match = "\\$\\{" + key + "\\}";
                Pattern pattern = Pattern.compile(match, 2);
                this.map.put(key, value2);
                this.macro.add(new Pair(pattern, value2));
            }
        }
    }

    private class Pair {
        public Pattern search;
        public String replacement;

        public Pair(Pattern key, String value) {
            this.search = key;
            this.replacement = value;
        }
    }
}

