/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import sun.misc.OSEnvironment;
import sun.misc.VMNotification;

public class VM {
    private static boolean suspended = false;
    @Deprecated
    public static final int STATE_GREEN = 1;
    @Deprecated
    public static final int STATE_YELLOW = 2;
    @Deprecated
    public static final int STATE_RED = 3;
    private static volatile boolean booted = false;
    private static long directMemory = 0x4000000L;
    private static boolean defaultAllowArraySyntax;
    private static boolean allowArraySyntax;
    private static volatile int finalRefCount;
    private static volatile int peakFinalRefCount;
    private static Map<Integer, Thread.State> threadStateMap;
    private static Map<Integer, String> threadStateNames;

    @Deprecated
    public static boolean threadsSuspended() {
        return suspended;
    }

    public static boolean allowThreadSuspension(ThreadGroup threadGroup, boolean bl) {
        return threadGroup.allowThreadSuspension(bl);
    }

    @Deprecated
    public static boolean suspendThreads() {
        suspended = true;
        return true;
    }

    @Deprecated
    public static void unsuspendThreads() {
        suspended = false;
    }

    @Deprecated
    public static void unsuspendSomeThreads() {
    }

    @Deprecated
    public static final int getState() {
        return 1;
    }

    @Deprecated
    public static void registerVMNotification(VMNotification vMNotification) {
    }

    @Deprecated
    public static void asChange(int n, int n2) {
    }

    @Deprecated
    public static void asChange_otherthread(int n, int n2) {
    }

    public static void booted() {
        booted = true;
    }

    public static boolean isBooted() {
        return booted;
    }

    public static long maxDirectMemory() {
        if (booted) {
            return directMemory;
        }
        Properties properties = System.getProperties();
        String string = (String)properties.remove("sun.nio.MaxDirectMemorySize");
        System.setProperties(properties);
        if (string != null) {
            if (string.equals("-1")) {
                directMemory = Runtime.getRuntime().maxMemory();
            } else {
                long l = Long.parseLong(string);
                if (l > -1L) {
                    directMemory = l;
                }
            }
        }
        return directMemory;
    }

    public static boolean allowArraySyntax() {
        if (!booted) {
            String string = System.getProperty("sun.lang.ClassLoader.allowArraySyntax");
            allowArraySyntax = string == null ? defaultAllowArraySyntax : Boolean.parseBoolean(string);
        }
        return allowArraySyntax;
    }

    public static void initializeOSEnvironment() {
        if (!booted) {
            OSEnvironment.initialize();
        }
    }

    public static int getFinalRefCount() {
        return finalRefCount;
    }

    public static int getPeakFinalRefCount() {
        return peakFinalRefCount;
    }

    public static void addFinalRefCount(int n) {
        if ((finalRefCount += n) > peakFinalRefCount) {
            peakFinalRefCount = finalRefCount;
        }
    }

    public static Thread.State toThreadState(int n) {
        VM.initThreadStateMap();
        Thread.State state = threadStateMap.get(n);
        if (state == null) {
            state = Thread.State.RUNNABLE;
        }
        return state;
    }

    private static synchronized void initThreadStateMap() {
        if (threadStateMap != null) {
            return;
        }
        Thread.State[] stateArray = Thread.State.values();
        int[][] nArrayArray = new int[stateArray.length][];
        String[][] stringArray = new String[stateArray.length][];
        VM.getThreadStateValues(nArrayArray, stringArray);
        threadStateMap = new HashMap<Integer, Thread.State>();
        threadStateNames = new HashMap<Integer, String>();
        for (int i = 0; i < stateArray.length; ++i) {
            int n;
            String string = stateArray[i].name();
            int[] nArray = null;
            String[] stringArray2 = null;
            for (n = 0; n < stateArray.length; ++n) {
                if (!stringArray[n][0].startsWith(string)) continue;
                nArray = nArrayArray[n];
                stringArray2 = stringArray[n];
            }
            if (nArray == null) {
                throw new InternalError("No VM thread state mapped to " + string);
            }
            if (nArray.length != stringArray2.length) {
                throw new InternalError("VM thread state values and names  mapped to " + string + ": length not matched");
            }
            for (n = 0; n < nArray.length; ++n) {
                threadStateMap.put(nArray[n], stateArray[i]);
                threadStateNames.put(nArray[n], stringArray2[n]);
            }
        }
    }

    private static native void getThreadStateValues(int[][] var0, String[][] var1);

    private static native void initialize();

    static {
        allowArraySyntax = defaultAllowArraySyntax = false;
        finalRefCount = 0;
        peakFinalRefCount = 0;
        threadStateMap = null;
        threadStateNames = null;
        VM.initialize();
    }
}

