/*
 * Decompiled with CFR 0.152.
 */
package sun.jkernel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import sun.jkernel.ByteArrayToFromHexDigits;
import sun.jkernel.DownloadManager;
import sun.jkernel.StandaloneMessageDigest;

public class BundleCheck {
    private static final int DIGEST_STREAM_BUFFER_SIZE = 2048;
    private static final String BUNDLE_SUFFIX = ".zip";
    private static volatile Properties properties;
    private byte[] checkBytes;

    private BundleCheck() {
    }

    public static void storeProperties(String string) {
        try {
            File file = new File(string);
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, null);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            throw new RuntimeException("BundleCheck: storing properties threw: " + exception);
        }
    }

    private static void loadProperties() {
        properties = new Properties();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(DownloadManager.class.getResourceAsStream(DownloadManager.CHECK_VALUES_FILE));
            if (bufferedInputStream == null) {
                throw new RuntimeException("BundleCheck: unable to locate " + DownloadManager.CHECK_VALUES_FILE + " as resource");
            }
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            throw new RuntimeException("BundleCheck: loadProperties threw " + exception);
        }
    }

    private static synchronized Properties getProperties() {
        if (properties == null) {
            BundleCheck.loadProperties();
        }
        return properties;
    }

    public static void resetProperties() {
        properties = null;
    }

    public String toString() {
        return ByteArrayToFromHexDigits.bytesToHexString(this.checkBytes);
    }

    private void addProperty(String string) {
        if (properties == null) {
            properties = new Properties();
        }
        BundleCheck.getProperties().put(string, this.toString());
    }

    private BundleCheck(byte[] byArray) {
        this.checkBytes = byArray;
    }

    private BundleCheck(String string) {
        String string2 = BundleCheck.getProperties().getProperty(string);
        if (string2 == null) {
            throw new RuntimeException("BundleCheck: no check property for bundle: " + string);
        }
        this.checkBytes = ByteArrayToFromHexDigits.hexStringToBytes(string2);
    }

    private static BundleCheck getInstance(String string, File file, boolean bl) {
        Object object;
        if (file == null) {
            return new BundleCheck(string);
        }
        StandaloneMessageDigest standaloneMessageDigest = null;
        try {
            int n;
            object = new FileInputStream(file);
            standaloneMessageDigest = StandaloneMessageDigest.getInstance("SHA-1");
            byte[] byArray = new byte[2048];
            do {
                if ((n = ((FileInputStream)object).read(byArray)) <= 0) continue;
                standaloneMessageDigest.update(byArray, 0, n);
            } while (n != -1);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            throw new RuntimeException("BundleCheck.addProperty() caught: " + exception);
        }
        object = new BundleCheck(standaloneMessageDigest.digest());
        if (bl) {
            super.addProperty(string);
        }
        return object;
    }

    public static BundleCheck getInstance(File file) {
        return BundleCheck.getInstance(null, file, false);
    }

    static BundleCheck getInstance(String string) {
        return BundleCheck.getInstance(string, null, false);
    }

    public static void addProperty(String string, File file) {
        BundleCheck.getInstance(string, file, true);
    }

    static void add(String string, File file) {
        BundleCheck.getInstance(string, file, true).addProperty(string);
    }

    boolean equals(BundleCheck bundleCheck) {
        if (this.checkBytes == null || bundleCheck.checkBytes == null) {
            return false;
        }
        if (this.checkBytes.length != bundleCheck.checkBytes.length) {
            return false;
        }
        for (int i = 0; i < this.checkBytes.length; ++i) {
            if (this.checkBytes[i] == bundleCheck.checkBytes[i]) continue;
            if (DownloadManager.debug) {
                System.out.println("BundleCheck.equals mismatch between this: " + this.toString() + " and param: " + bundleCheck.toString());
            }
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            System.err.println("Usage: java BundleCheck <jre path> <bundle 1 name> ... <bundle N name>");
            return;
        }
        for (n = 1; n < stringArray.length; ++n) {
            BundleCheck.addProperty(stringArray[n], new File(stringArray[n] + BUNDLE_SUFFIX));
        }
        BundleCheck.storeProperties(DownloadManager.CHECK_VALUES_DIR);
        try {
            n = Runtime.getRuntime().exec("jar uf " + stringArray[0] + "\\lib\\rt.jar " + DownloadManager.CHECK_VALUES_DIR).waitFor();
            if (n != 0) {
                System.err.println("BundleCheck: exec of jar uf gave nonzero status");
                return;
            }
        }
        catch (Exception exception) {
            System.err.println("BundleCheck: exec of jar uf threw: " + exception);
            return;
        }
    }
}

