/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.handler.MessageHandler;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.handler.HandlerException;
import com.sun.xml.internal.ws.resources.ClientMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SOAPBindingImpl
extends BindingImpl
implements SOAPBinding {
    public static final String X_SOAP12HTTP_BINDING = "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/";
    private static final String ROLE_NONE = "http://www.w3.org/2003/05/soap-envelope/role/none";
    private Set<String> roles;
    protected final SOAPVersion soapVersion;
    private Set<QName> portKnownHeaders = Collections.emptySet();
    private static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];

    SOAPBindingImpl(BindingID bindingID) {
        this(bindingID, EMPTY_FEATURES);
    }

    SOAPBindingImpl(BindingID bindingID, WebServiceFeature ... webServiceFeatureArray) {
        super(bindingID);
        this.soapVersion = bindingID.getSOAPVersion();
        this.roles = new HashSet<String>();
        this.addRequiredRoles();
        this.setFeatures(webServiceFeatureArray);
        this.features.addAll(bindingID.createBuiltinFeatureList());
    }

    public void setPortKnownHeaders(@NotNull Set<QName> set) {
        this.portKnownHeaders = set;
        this.setHandlerConfig(this.createHandlerConfig(this.getHandlerChain()));
    }

    @Override
    protected HandlerConfiguration createHandlerConfig(List<Handler> list) {
        ArrayList<LogicalHandler> arrayList = new ArrayList<LogicalHandler>();
        ArrayList<SOAPHandler> arrayList2 = new ArrayList<SOAPHandler>();
        ArrayList<MessageHandler> arrayList3 = new ArrayList<MessageHandler>();
        HashSet<QName> hashSet = new HashSet<QName>();
        for (Handler handler : list) {
            Set<QName> set;
            if (handler instanceof LogicalHandler) {
                arrayList.add((LogicalHandler)handler);
                continue;
            }
            if (handler instanceof SOAPHandler) {
                arrayList2.add((SOAPHandler)handler);
                set = ((SOAPHandler)handler).getHeaders();
                if (set == null) continue;
                hashSet.addAll(set);
                continue;
            }
            if (handler instanceof MessageHandler) {
                arrayList3.add((MessageHandler)handler);
                set = ((MessageHandler)handler).getHeaders();
                if (set == null) continue;
                hashSet.addAll(set);
                continue;
            }
            throw new HandlerException("handler.not.valid.type", handler.getClass());
        }
        return new HandlerConfiguration(this.roles, this.portKnownHeaders, list, arrayList, arrayList2, arrayList3, hashSet);
    }

    protected void addRequiredRoles() {
        this.roles.addAll(this.soapVersion.requiredRoles);
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(Set<String> set) {
        if (set == null) {
            set = new HashSet<String>();
        }
        if (set.contains(ROLE_NONE)) {
            throw new WebServiceException(ClientMessages.INVALID_SOAP_ROLE_NONE());
        }
        this.roles = set;
        this.addRequiredRoles();
        HandlerConfiguration handlerConfiguration = this.getHandlerConfig();
        this.setHandlerConfig(new HandlerConfiguration(this.roles, this.portKnownHeaders, handlerConfiguration.getHandlerChain(), handlerConfiguration.getLogicalHandlers(), handlerConfiguration.getSoapHandlers(), handlerConfiguration.getMessageHandlers(), handlerConfiguration.getHandlerKnownHeaders()));
    }

    @Override
    public boolean isMTOMEnabled() {
        return this.isFeatureEnabled(MTOMFeature.class);
    }

    @Override
    public void setMTOMEnabled(boolean bl) {
        this.setFeatures(new MTOMFeature(bl));
    }

    @Override
    public SOAPFactory getSOAPFactory() {
        return this.soapVersion.saajSoapFactory;
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.soapVersion.saajMessageFactory;
    }
}

