/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKDefaultEngine;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Metacity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import sun.awt.UNIXToolkit;
import sun.swing.plaf.synth.SynthUI;

class GTKPainter
extends SynthPainter {
    private static final GTKConstants.PositionType[] POSITIONS = new GTKConstants.PositionType[]{GTKConstants.PositionType.BOTTOM, GTKConstants.PositionType.RIGHT, GTKConstants.PositionType.TOP, GTKConstants.PositionType.LEFT};
    private static final GTKConstants.ShadowType[] SHADOWS = new GTKConstants.ShadowType[]{GTKConstants.ShadowType.NONE, GTKConstants.ShadowType.IN, GTKConstants.ShadowType.OUT, GTKConstants.ShadowType.ETCHED_IN, GTKConstants.ShadowType.OUT};
    private static final GTKEngine ENGINE = GTKEngine.INSTANCE;
    static final GTKPainter INSTANCE = new GTKPainter();

    private GTKPainter() {
    }

    private String getName(SynthContext synthContext) {
        return synthContext.getRegion().isSubregion() ? null : synthContext.getComponent().getName();
    }

    public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintRadioButtonBackground(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintRadioButtonMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintFormattedTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintTextBackground(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintToolBarBackground(synthContext, graphics, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(region, n5);
        int n7 = ((JToolBar)synthContext.getComponent()).getOrientation();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5, n7)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5, n7);
                ENGINE.paintBox(graphics, synthContext, region, n6, GTKConstants.ShadowType.OUT, "handlebox_bin", n, n2, n3, n4);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = ((JToolBar)synthContext.getComponent()).getOrientation();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5);
                ENGINE.paintBox(graphics, synthContext, region, 1, GTKConstants.ShadowType.OUT, "toolbar", n, n2, n3, n4);
                ENGINE.finishPainting();
            }
        }
    }

    public void paintPasswordFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintTextBackground(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintTextFieldBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.getName(synthContext) == "Tree.cellEditor") {
            this.paintTreeCellEditorBackground(synthContext, graphics, n, n2, n3, n4);
        } else {
            this.paintTextBackground(synthContext, graphics, n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        if (n5 == 2) {
            Object object = UNIXToolkit.GTK_LOCK;
            synchronized (object) {
                if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region)) {
                    ENGINE.startPainting(graphics, n, n2, n3, n4, region);
                    ENGINE.paintFlatBox(graphics, synthContext, region, 2, GTKConstants.ShadowType.ETCHED_OUT, "checkbutton", n, n2, n3, n4, ColorType.BACKGROUND);
                    ENGINE.finishPainting();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        if (n5 == 2) {
            Object object = UNIXToolkit.GTK_LOCK;
            synchronized (object) {
                if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region)) {
                    GTKConstants.ShadowType shadowType = GTKLookAndFeel.is2_2() ? GTKConstants.ShadowType.NONE : GTKConstants.ShadowType.OUT;
                    ENGINE.startPainting(graphics, n, n2, n3, n4, region);
                    ENGINE.paintBox(graphics, synthContext, region, n5, shadowType, "menuitem", n, n2, n3, n4);
                    ENGINE.finishPainting();
                }
            }
        }
    }

    public void paintLabelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = this.getName(synthContext);
        if (string == "TableHeader.renderer" || string == "GTKFileChooser.directoryListLabel" || string == "GTKFileChooser.fileListLabel") {
            this.paintButtonBackgroundImpl(synthContext, graphics, Region.BUTTON, "button", n, n2, n3, n4, true, false, false, false);
        } else if (string == "ComboBox.renderer") {
            this.paintTextBackground(synthContext, graphics, n, n2, n3, n4);
        }
    }

    public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Metacity.INSTANCE.paintFrameBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillArea(synthContext, graphics, n, n2, n3, n4, ColorType.BACKGROUND);
    }

    public void paintDesktopIconBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Metacity.INSTANCE.paintFrameBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string = this.getName(synthContext);
        if (string != null && string.startsWith("InternalFrameTitlePane.")) {
            Metacity.INSTANCE.paintButtonBackground(synthContext, graphics, n, n2, n3, n4);
        } else {
            AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
            boolean bl = abstractButton.isContentAreaFilled() && abstractButton.isBorderPainted();
            boolean bl2 = abstractButton.isFocusPainted();
            boolean bl3 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultCapable();
            boolean bl4 = abstractButton.getParent() instanceof JToolBar;
            this.paintButtonBackgroundImpl(synthContext, graphics, Region.BUTTON, "button", n, n2, n3, n4, bl, bl2, bl3, bl4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintButtonBackgroundImpl(SynthContext synthContext, Graphics graphics, Region region, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n5 = synthContext.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            boolean bl5;
            if (ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5, string, bl, bl2, bl3, bl4)) {
                return;
            }
            ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5, string, bl, bl2, bl3, bl4);
            GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
            if (bl3 && !bl4) {
                Insets insets = gTKStyle.getClassSpecificInsetsValue(synthContext, "default-border", GTKStyle.BUTTON_DEFAULT_BORDER_INSETS);
                if (bl && (n5 & 0x400) != 0) {
                    ENGINE.paintBox(graphics, synthContext, region, 1, GTKConstants.ShadowType.IN, "buttondefault", n, n2, n3, n4);
                }
                n += insets.left;
                n2 += insets.top;
                n3 -= insets.left + insets.right;
                n4 -= insets.top + insets.bottom;
            }
            boolean bl6 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
            int n6 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            int n7 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
            int n8 = n6 + n7;
            int n9 = gTKStyle.getXThickness();
            int n10 = gTKStyle.getYThickness();
            if (!bl6 && (n5 & 0x100) == 256) {
                n += n8;
                n2 += n8;
                n3 -= 2 * n8;
                n4 -= 2 * n8;
            }
            int n11 = GTKLookAndFeel.synthStateToGTKState(region, n5);
            if (bl4) {
                bl5 = n11 != 1 && n11 != 8;
            } else {
                boolean bl7 = bl5 = bl || n11 != 1;
            }
            if (bl5) {
                GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
                if ((n5 & 0x204) != 0) {
                    shadowType = GTKConstants.ShadowType.IN;
                }
                ENGINE.paintBox(graphics, synthContext, region, n11, shadowType, string, n, n2, n3, n4);
            }
            if (bl2 && (n5 & 0x100) != 0) {
                if (bl6) {
                    n += n9 + n7;
                    n2 += n10 + n7;
                    n3 -= 2 * (n9 + n7);
                    n4 -= 2 * (n10 + n7);
                } else {
                    n -= n8;
                    n2 -= n8;
                    n3 += 2 * n8;
                    n4 += 2 * n8;
                }
                ENGINE.paintFocus(graphics, synthContext, region, n11, string, n, n2, n3, n4);
            }
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Region region = synthContext.getRegion();
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        GTKConstants.ArrowType arrowType = null;
        switch (n5) {
            case 1: {
                arrowType = GTKConstants.ArrowType.UP;
                break;
            }
            case 5: {
                arrowType = GTKConstants.ArrowType.DOWN;
                break;
            }
            case 3: {
                arrowType = GTKConstants.ArrowType.RIGHT;
                break;
            }
            case 7: {
                arrowType = GTKConstants.ArrowType.LEFT;
            }
        }
        String string2 = "arrow";
        if (string == "ScrollBar.button") {
            string2 = arrowType == GTKConstants.ArrowType.UP || arrowType == GTKConstants.ArrowType.DOWN ? "vscrollbar" : "hscrollbar";
        } else if (string == "Spinner.nextButton" || string == "Spinner.previousButton") {
            string2 = "spinbutton";
        } else if (string != "ComboBox.arrowButton") assert (false);
        int n6 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        GTKConstants.ShadowType shadowType = n6 == 4 ? GTKConstants.ShadowType.IN : GTKConstants.ShadowType.OUT;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(graphics, n, n2, n3, n4, n6, string, n5)) {
                return;
            }
            ENGINE.startPainting(graphics, n, n2, n3, n4, n6, string, n5);
            ENGINE.paintArrow(graphics, synthContext, region, n6, shadowType, arrowType, string2, n, n2, n3, n4);
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        AbstractButton abstractButton = (AbstractButton)synthContext.getComponent();
        String string = abstractButton.getName();
        String string2 = "button";
        int n5 = 0;
        if (string == "ScrollBar.button") {
            Integer n6 = (Integer)abstractButton.getClientProperty("__arrow_direction__");
            n5 = n6 != null ? n6 : 7;
            switch (n5) {
                default: {
                    string2 = "hscrollbar";
                    break;
                }
                case 1: 
                case 5: {
                    string2 = "vscrollbar";
                    break;
                }
            }
        } else if (string == "Spinner.previousButton") {
            string2 = "spinbutton_down";
        } else if (string == "Spinner.nextButton") {
            string2 = "spinbutton_up";
        } else if (string != "ComboBox.arrowButton") assert (false);
        int n7 = synthContext.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            int n8;
            if (ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n7, string2, n5)) {
                return;
            }
            ENGINE.startPainting(graphics, n, n2, n3, n4, region, n7, string2, n5);
            if (string2.startsWith("spin")) {
                n8 = abstractButton.getParent().isEnabled() ? 1 : 8;
                int n9 = string2 == "spinbutton_up" ? n2 : n2 - n4;
                int n10 = n4 * 2;
                ENGINE.paintBox(graphics, synthContext, region, n8, GTKConstants.ShadowType.IN, "spinbutton", n, n9, n3, n10);
            }
            n8 = GTKLookAndFeel.synthStateToGTKState(region, n7);
            GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
            if ((n8 & 0x204) != 0) {
                shadowType = GTKConstants.ShadowType.IN;
            }
            ENGINE.paintBox(graphics, synthContext, region, n8, shadowType, string2, n, n2, n3, n4);
            ENGINE.finishPainting();
        }
    }

    public void paintListBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillArea(synthContext, graphics, n, n2, n3, n4, GTKColorType.TEXT_BACKGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region)) {
                return;
            }
            GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
            int n5 = gTKStyle.getClassSpecificIntValue(synthContext, "shadow-type", 2);
            GTKConstants.ShadowType shadowType = SHADOWS[n5];
            int n6 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
            ENGINE.startPainting(graphics, n, n2, n3, n4, region);
            ENGINE.paintBox(graphics, synthContext, region, n6, shadowType, "menubar", n, n2, n3, n4);
            ENGINE.finishPainting();
        }
    }

    public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintMenuItemBackground(synthContext, graphics, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if (n5 == 2) {
            Region region = Region.MENU_ITEM;
            Object object = UNIXToolkit.GTK_LOCK;
            synchronized (object) {
                if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region)) {
                    GTKConstants.ShadowType shadowType = GTKLookAndFeel.is2_2() ? GTKConstants.ShadowType.NONE : GTKConstants.ShadowType.OUT;
                    ENGINE.startPainting(graphics, n, n2, n3, n4, region);
                    ENGINE.paintBox(graphics, synthContext, region, n5, shadowType, "menuitem", n, n2, n3, n4);
                    ENGINE.finishPainting();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintPopupMenuBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5)) {
                return;
            }
            ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5);
            ENGINE.paintBox(graphics, synthContext, region, n5, GTKConstants.ShadowType.OUT, "menu", n, n2, n3, n4);
            GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
            int n6 = gTKStyle.getXThickness();
            int n7 = gTKStyle.getYThickness();
            ENGINE.paintBackground(graphics, synthContext, region, n5, gTKStyle.getGTKColor(synthContext, n5, GTKColorType.BACKGROUND), n + n6, n2 + n7, n3 - n6 - n6, n4 - n7 - n7);
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region);
                ENGINE.paintBox(graphics, synthContext, region, 1, GTKConstants.ShadowType.IN, "trough", n, n2, n3, n4);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Region region = synthContext.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, "fg")) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, "fg");
                ENGINE.paintBox(graphics, synthContext, region, 2, GTKConstants.ShadowType.OUT, "bar", n, n2, n3, n4);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintViewportBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region);
                ENGINE.paintShadow(graphics, synthContext, region, 1, GTKConstants.ShadowType.IN, "scrolled_window", n, n2, n3, n4);
                ENGINE.finishPainting();
            }
        }
    }

    public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintViewportBorder(synthContext, graphics, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        String string;
        Region region = synthContext.getRegion();
        int n6 = synthContext.getComponentState();
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JToolBar.Separator) {
            string = "toolbar";
            float f = 0.2f;
            JToolBar.Separator separator = (JToolBar.Separator)jComponent;
            Dimension dimension = separator.getSeparatorSize();
            GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
            if (n5 == 0) {
                n += (int)((float)n3 * f);
                n3 -= (int)((float)n3 * f * 2.0f);
                n2 += (dimension.height - gTKStyle.getYThickness()) / 2;
            } else {
                n2 += (int)((float)n4 * f);
                n4 -= (int)((float)n4 * f * 2.0f);
                n += (dimension.width - gTKStyle.getXThickness()) / 2;
            }
        } else {
            string = "separator";
            Insets insets = jComponent.getInsets();
            n += insets.left;
            n2 += insets.top;
            if (n5 == 0) {
                n3 -= insets.left + insets.right;
            } else {
                n4 -= insets.top + insets.bottom;
            }
        }
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n6, string, n5)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n6, string, n5);
                if (n5 == 0) {
                    ENGINE.paintHline(graphics, synthContext, region, n6, string, n, n2, n3, n4);
                } else {
                    ENGINE.paintVline(graphics, synthContext, region, n6, string, n, n2, n3, n4);
                }
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        Region region = synthContext.getRegion();
        int n5 = synthContext.getComponentState();
        boolean bl = (n5 & 0x100) != 0;
        int n6 = 0;
        if (bl) {
            object = (GTKStyle)synthContext.getStyle();
            n6 = ((GTKStyle)object).getClassSpecificIntValue(synthContext, "focus-line-width", 1) + ((GTKStyle)object).getClassSpecificIntValue(synthContext, "focus-padding", 1);
            n -= n6;
            n2 -= n6;
            n3 += n6 * 2;
            n4 += n6 * 2;
        }
        object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5);
                int n7 = GTKLookAndFeel.synthStateToGTKState(region, n5);
                ENGINE.paintBox(graphics, synthContext, region, n7, GTKConstants.ShadowType.IN, "trough", n + n6, n2 + n6, n3 - 2 * n6, n4 - 2 * n6);
                if (bl) {
                    ENGINE.paintFocus(graphics, synthContext, region, 1, "trough", n, n2, n3, n4);
                }
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Region region = synthContext.getRegion();
        int n6 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n6, n5)) {
                GTKConstants.Orientation orientation = n5 == 0 ? GTKConstants.Orientation.HORIZONTAL : GTKConstants.Orientation.VERTICAL;
                String string = n5 == 0 ? "hscale" : "vscale";
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n6, n5);
                ENGINE.paintSlider(graphics, synthContext, region, n6, GTKConstants.ShadowType.OUT, string, n, n2, n3, n4, orientation);
                ENGINE.finishPainting();
            }
        }
    }

    public void paintSpinnerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        JSplitPane jSplitPane = (JSplitPane)synthContext.getComponent();
        GTKConstants.Orientation orientation = jSplitPane.getOrientation() == 1 ? GTKConstants.Orientation.VERTICAL : GTKConstants.Orientation.HORIZONTAL;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, new Object[]{region, n5, orientation})) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, new Object[]{region, n5, orientation});
                ENGINE.paintHandle(graphics, synthContext, region, n5, GTKConstants.ShadowType.OUT, "paned", n, n2, n3, n4, orientation);
                ENGINE.finishPainting();
            }
        }
    }

    public void paintSplitPaneDragDivider(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.paintSplitPaneDividerForeground(synthContext, graphics, n, n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintTabbedPaneContentBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        int n5 = jTabbedPane.getSelectedIndex();
        GTKConstants.PositionType positionType = GTKLookAndFeel.SwingOrientationConstantToGTK(jTabbedPane.getTabPlacement());
        int n6 = 0;
        int n7 = 0;
        if (n5 != -1) {
            object = jTabbedPane.getBoundsAt(n5);
            if (positionType == GTKConstants.PositionType.TOP || positionType == GTKConstants.PositionType.BOTTOM) {
                n6 = ((Rectangle)object).x - 1;
                n7 = ((Rectangle)object).width;
            } else {
                n6 = ((Rectangle)object).y - 1;
                n7 = ((Rectangle)object).height;
            }
        }
        object = synthContext.getRegion();
        int n8 = GTKLookAndFeel.synthStateToGTKState((Region)object, synthContext.getComponentState());
        Object object2 = UNIXToolkit.GTK_LOCK;
        synchronized (object2) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, new Object[]{object, n8, positionType, n6, n7})) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, new Object[]{object, n8, positionType, n6, n7});
                ENGINE.paintBoxGap(graphics, synthContext, (Region)object, n8, GTKConstants.ShadowType.OUT, "notebook", n, n2, n3, n4, positionType, n6, n7);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Region region = synthContext.getRegion();
        int n6 = synthContext.getComponentState();
        int n7 = (n6 & 0x200) != 0 ? 1 : 4;
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        int n8 = jTabbedPane.getTabPlacement();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n7, n8, n5)) {
                GTKConstants.PositionType positionType = POSITIONS[n8 - 1];
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n7, n8, n5);
                ENGINE.paintExtension(graphics, synthContext, region, n7, GTKConstants.ShadowType.OUT, "tab", n, n2, n3, n4, positionType, n5);
                ENGINE.finishPainting();
            }
        }
    }

    public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillArea(synthContext, graphics, n, n2, n3, n4, GTKColorType.TEXT_BACKGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTextBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        int n5 = synthContext.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5)) {
                return;
            }
            int n6 = GTKLookAndFeel.synthStateToGTKState(region, n5);
            int n7 = 0;
            boolean bl = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
            if (!bl && (n5 & 0x100) != 0) {
                n7 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
                n += n7;
                n2 += n7;
                n3 -= 2 * n7;
                n4 -= 2 * n7;
            }
            int n8 = gTKStyle.getXThickness();
            int n9 = gTKStyle.getYThickness();
            ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5);
            ENGINE.paintShadow(graphics, synthContext, region, n6, GTKConstants.ShadowType.IN, "entry", n, n2, n3, n4);
            ENGINE.paintFlatBox(graphics, synthContext, region, n6, GTKConstants.ShadowType.NONE, "entry_bg", n + n8, n2 + n9, n3 - 2 * n8, n4 - 2 * n9, ColorType.TEXT_BACKGROUND);
            if (n7 > 0) {
                ENGINE.paintFocus(graphics, synthContext, region, n6, "entry", n -= n7, n2 -= n7, n3 += 2 * n7, n4 += 2 * n7);
            }
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTreeCellEditorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5);
                ENGINE.paintFlatBox(graphics, synthContext, region, n5, GTKConstants.ShadowType.NONE, "entry_bg", n, n2, n3, n4, ColorType.TEXT_BACKGROUND);
                ENGINE.finishPainting();
            }
        }
    }

    public void paintRootPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillArea(synthContext, graphics, n, n2, n3, n4, GTKColorType.BACKGROUND);
    }

    public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        boolean bl = jToggleButton.isContentAreaFilled() && jToggleButton.isBorderPainted();
        boolean bl2 = jToggleButton.isFocusPainted();
        boolean bl3 = jToggleButton.getParent() instanceof JToolBar;
        this.paintButtonBackgroundImpl(synthContext, graphics, region, "button", n, n2, n3, n4, bl, bl2, false, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        boolean bl = (synthContext.getComponentState() & 0x100) != 0;
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, bl)) {
                return;
            }
            ENGINE.startPainting(graphics, n, n2, n3, n4, region, bl);
            Insets insets = synthContext.getComponent().getInsets();
            GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
            int n5 = gTKStyle.getClassSpecificIntValue(synthContext, "trough-border", 1);
            insets.left -= n5;
            insets.right -= n5;
            insets.top -= n5;
            insets.bottom -= n5;
            ENGINE.paintBox(graphics, synthContext, region, 4, GTKConstants.ShadowType.IN, "trough", n + insets.left, n2 + insets.top, n3 - insets.left - insets.right, n4 - insets.top - insets.bottom);
            if (bl) {
                ENGINE.paintFocus(graphics, synthContext, region, 1, "trough", n, n2, n3, n4);
            }
            ENGINE.finishPainting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Region region = synthContext.getRegion();
        int n6 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n6, n5)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n6, n5);
                GTKConstants.Orientation orientation = n5 == 0 ? GTKConstants.Orientation.HORIZONTAL : GTKConstants.Orientation.VERTICAL;
                ENGINE.paintSlider(graphics, synthContext, region, n6, GTKConstants.ShadowType.OUT, "slider", n, n2, n3, n4, orientation);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintToolTipBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region);
                ENGINE.paintFlatBox(graphics, synthContext, region, 1, GTKConstants.ShadowType.OUT, "tooltip", n, n2, n3, n4, ColorType.BACKGROUND);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintTreeCellBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = synthContext.getRegion();
        int n5 = synthContext.getComponentState();
        int n6 = GTKLookAndFeel.synthStateToGTKState(region, n5);
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, region, n5)) {
                ENGINE.startPainting(graphics, n, n2, n3, n4, region, n5);
                ENGINE.paintFlatBox(graphics, synthContext, region, n6, GTKConstants.ShadowType.NONE, "cell_odd", n, n2, n3, n4, ColorType.TEXT_BACKGROUND);
                ENGINE.finishPainting();
            }
        }
    }

    public void paintTreeCellFocus(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Region region = Region.TREE_CELL;
        int n5 = synthContext.getComponentState();
        this.paintFocus(synthContext, graphics, region, n5, "treeview", n, n2, n3, n4);
    }

    public void paintTreeBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillArea(synthContext, graphics, n, n2, n3, n4, GTKColorType.TEXT_BACKGROUND);
    }

    public void paintViewportBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillArea(synthContext, graphics, n, n2, n3, n4, GTKColorType.TEXT_BACKGROUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintFocus(SynthContext synthContext, Graphics graphics, Region region, int n, String string, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(region, n);
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n2, n3, n4, n5, region, n6, "focus")) {
                ENGINE.startPainting(graphics, n2, n3, n4, n5, region, n6, "focus");
                ENGINE.paintFocus(graphics, synthContext, region, n6, string, n2, n3, n4, n5);
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintMetacityElement(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5, GTKConstants.ShadowType shadowType, GTKConstants.ArrowType arrowType) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n2, n3, n4, n5, new Object[]{n, string, shadowType, arrowType})) {
                ENGINE.startPainting(graphics, n2, n3, n4, n5, new Object[]{n, string, shadowType, arrowType});
                if (string == "metacity-arrow") {
                    ENGINE.paintArrow(graphics, synthContext, Region.INTERNAL_FRAME_TITLE_PANE, n, shadowType, arrowType, "", n2, n3, n4, n5);
                } else if (string == "metacity-box") {
                    ENGINE.paintBox(graphics, synthContext, Region.INTERNAL_FRAME_TITLE_PANE, n, shadowType, "", n2, n3, n4, n5);
                } else if (string == "metacity-vline") {
                    ENGINE.paintVline(graphics, synthContext, Region.INTERNAL_FRAME_TITLE_PANE, n, "", n2, n3, n4, n5);
                }
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintIcon(SynthContext synthContext, Graphics graphics, Method method, int n, int n2, int n3, int n4) {
        int n5 = synthContext.getComponentState();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, n5, method)) {
                block8: {
                    ENGINE.startPainting(graphics, n, n2, n3, n4, n5, method);
                    try {
                        method.invoke(this, synthContext, graphics, n5, n, n2, n3, n4);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        assert (false);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                ENGINE.finishPainting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintIcon(SynthContext synthContext, Graphics graphics, Method method, int n, int n2, int n3, int n4, Object object) {
        int n5 = synthContext.getComponentState();
        Object object2 = UNIXToolkit.GTK_LOCK;
        synchronized (object2) {
            if (!ENGINE.paintCachedImage(graphics, n, n2, n3, n4, n5, method, object)) {
                block8: {
                    ENGINE.startPainting(graphics, n, n2, n3, n4, n5, method, object);
                    try {
                        method.invoke(this, synthContext, graphics, n5, n, n2, n3, n4, object);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        assert (false);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                ENGINE.finishPainting();
            }
        }
    }

    public void paintTreeExpandedIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ENGINE.paintExpander(graphics, synthContext, Region.TREE, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n), GTKConstants.ExpanderStyle.EXPANDED, "treeview", n2, n3, n4, n5);
    }

    public void paintTreeCollapsedIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ENGINE.paintExpander(graphics, synthContext, Region.TREE, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n), GTKConstants.ExpanderStyle.COLLAPSED, "treeview", n2, n3, n4, n5);
    }

    public void paintCheckBoxIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
        if (((JCheckBox)synthContext.getComponent()).isSelected()) {
            shadowType = GTKConstants.ShadowType.IN;
        }
        ENGINE.paintCheck(graphics, synthContext, Region.CHECK_BOX, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n), shadowType, "checkbutton", n2, n3, n4, n5);
    }

    public void paintRadioButtonIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n);
        GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
        if ((n & 0x200) != 0) {
            n6 = 512;
        }
        if (n6 == 512) {
            shadowType = GTKConstants.ShadowType.IN;
        }
        ENGINE.paintOption(graphics, synthContext, Region.RADIO_BUTTON, n6, shadowType, "radiobutton", n2, n3, n4, n5);
    }

    public void paintMenuArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, GTKConstants.ArrowType arrowType) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n);
        GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
        if (n6 == 2) {
            shadowType = GTKConstants.ShadowType.IN;
        }
        ENGINE.paintArrow(graphics, synthContext, Region.MENU_ITEM, n6, shadowType, arrowType, "menuitem", n2 + 3, n3 + 3, 7, 7);
    }

    public void paintMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    public void paintCheckBoxMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    public void paintRadioButtonMenuItemArrowIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    public void paintCheckBoxMenuItemCheckIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n);
        if ((n & 2) != 0) {
            n6 = 2;
        }
        if ((n & 0x200) != 0) {
            shadowType = GTKConstants.ShadowType.IN;
        }
        ENGINE.paintCheck(graphics, synthContext, Region.CHECK_BOX_MENU_ITEM, n6, shadowType, "check", n2, n3, n4, n5);
    }

    public void paintRadioButtonMenuItemCheckIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n);
        if ((n & 2) != 0) {
            n6 = 2;
        }
        GTKConstants.ShadowType shadowType = GTKConstants.ShadowType.OUT;
        if ((n & 0x200) != 0) {
            shadowType = GTKConstants.ShadowType.IN;
        }
        ENGINE.paintOption(graphics, synthContext, Region.RADIO_BUTTON_MENU_ITEM, n6, shadowType, "option", n2, n3, n4, n5);
    }

    public void paintToolBarHandleIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5, GTKConstants.Orientation orientation) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n);
        orientation = orientation == GTKConstants.Orientation.HORIZONTAL ? GTKConstants.Orientation.VERTICAL : GTKConstants.Orientation.HORIZONTAL;
        ENGINE.paintHandle(graphics, synthContext, Region.TOOL_BAR, n6, GTKConstants.ShadowType.OUT, "handlebox", n2, n3, n4, n5, orientation);
    }

    public void paintAscendingSortIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ENGINE.paintArrow(graphics, synthContext, Region.TABLE, 1, GTKConstants.ShadowType.IN, GTKConstants.ArrowType.UP, "arrow", n2, n3, n4, n5);
    }

    public void paintDescendingSortIcon(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ENGINE.paintArrow(graphics, synthContext, Region.TABLE, 1, GTKConstants.ShadowType.IN, GTKConstants.ArrowType.DOWN, "arrow", n2, n3, n4, n5);
    }

    private void fillArea(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, ColorType colorType) {
        if (synthContext.getComponent().isOpaque()) {
            Region region = synthContext.getRegion();
            int n5 = GTKLookAndFeel.synthStateToGTKState(region, synthContext.getComponentState());
            GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
            graphics.setColor(gTKStyle.getGTKColor(synthContext, n5, colorType));
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    static class ListTableFocusBorder
    extends AbstractBorder
    implements UIResource {
        private boolean selectedCell;

        public static ListTableFocusBorder getSelectedCellBorder() {
            return new ListTableFocusBorder(true);
        }

        public static ListTableFocusBorder getUnselectedCellBorder() {
            return new ListTableFocusBorder(false);
        }

        public ListTableFocusBorder(boolean bl) {
            this.selectedCell = bl;
        }

        private SynthContext getContext(Component component) {
            Component component2;
            SynthContext synthContext = null;
            for (component2 = component; component2 != null && !(component2 instanceof JTable) && !(component2 instanceof JList); component2 = component2.getParent()) {
            }
            ComponentUI componentUI = null;
            if (component2 instanceof JTable) {
                componentUI = ((JTable)component2).getUI();
            } else if (component2 instanceof JList) {
                componentUI = ((JList)component2).getUI();
            }
            if (componentUI instanceof SynthUI) {
                synthContext = ((SynthUI)((Object)componentUI)).getContext((JComponent)component2);
            }
            return synthContext;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            SynthContext synthContext = this.getContext(component);
            int n6 = n5 = this.selectedCell ? 512 : 257;
            if (synthContext != null) {
                INSTANCE.paintFocus(synthContext, graphics, Region.TABLE, n5, "", n, n2, n3, n4);
            } else if (ENGINE instanceof GTKDefaultEngine) {
                graphics.setColor(Color.BLACK);
                ((GTKDefaultEngine)ENGINE)._paintFocus(graphics, n, n2, n3, n4, GTKDefaultEngine.DEFAULT_FOCUS_PATTERN, 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            int n = 1;
            SynthContext synthContext = this.getContext(component);
            if (synthContext != null) {
                n = ((GTKStyle)synthContext.getStyle()).getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            }
            return new Insets(n, n, n, n);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.getBorderInsets(component);
            if (insets == null) {
                return insets2;
            }
            insets.left = insets2.left;
            insets.right = insets2.right;
            insets.top = insets2.top;
            insets.bottom = insets2.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

