/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.nio.ch.Interruptible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelector
extends Selector {
    private AtomicBoolean selectorOpen = new AtomicBoolean(true);
    private final SelectorProvider provider;
    private final Set cancelledKeys = new HashSet();
    private Interruptible interruptor = null;

    protected AbstractSelector(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(SelectionKey selectionKey) {
        Set set = this.cancelledKeys;
        synchronized (set) {
            this.cancelledKeys.add(selectionKey);
        }
    }

    @Override
    public final void close() throws IOException {
        boolean bl = this.selectorOpen.getAndSet(false);
        if (!bl) {
            return;
        }
        this.implCloseSelector();
    }

    protected abstract void implCloseSelector() throws IOException;

    @Override
    public final boolean isOpen() {
        return this.selectorOpen.get();
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    protected final Set<SelectionKey> cancelledKeys() {
        return this.cancelledKeys;
    }

    protected abstract SelectionKey register(AbstractSelectableChannel var1, int var2, Object var3);

    protected final void deregister(AbstractSelectionKey abstractSelectionKey) {
        ((AbstractSelectableChannel)abstractSelectionKey.channel()).removeKey(abstractSelectionKey);
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                public void interrupt() {
                    AbstractSelector.this.wakeup();
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        if (Thread.currentThread().isInterrupted()) {
            this.interruptor.interrupt();
        }
    }

    protected final void end() {
        AbstractInterruptibleChannel.blockedOn(null);
    }
}

