/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Hashtable;
import sun.awt.PlatformFont;

public class X11FontMetrics
extends FontMetrics {
    int[] widths;
    int ascent;
    int descent;
    int leading;
    int height;
    int maxAscent;
    int maxDescent;
    int maxHeight;
    int maxAdvance;
    static Hashtable table;

    private static native void initIDs();

    public X11FontMetrics(Font font) {
        super(font);
        this.init();
    }

    public int getLeading() {
        return this.leading;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public int stringWidth(String string) {
        return this.charsWidth(string.toCharArray(), 0, string.length());
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        Font font = this.getFont();
        PlatformFont platformFont = (PlatformFont)font.getPeer();
        if (platformFont.mightHaveMultiFontMetrics()) {
            return this.getMFCharsWidth(cArray, n, n2, font);
        }
        if (this.widths != null) {
            int n3 = 0;
            for (int i = n; i < n + n2; ++i) {
                char c = cArray[i];
                if (c < '\u0000' || c >= this.widths.length) {
                    n3 += this.maxAdvance;
                    continue;
                }
                n3 += this.widths[c];
            }
            return n3;
        }
        return this.maxAdvance * n2;
    }

    private native int getMFCharsWidth(char[] var1, int var2, int var3, Font var4);

    public native int bytesWidth(byte[] var1, int var2, int var3);

    public int[] getWidths() {
        return this.widths;
    }

    native void init();

    static synchronized FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = (FontMetrics)table.get(font);
        if (fontMetrics == null) {
            fontMetrics = new X11FontMetrics(font);
            table.put(font, fontMetrics);
        }
        return fontMetrics;
    }

    static {
        X11FontMetrics.initIDs();
        table = new Hashtable();
    }
}

