/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.Util.Informer;

public class Calculator {
    private Calculator() {
    }

    private static int calculateInstallSize(Vector allPackages) {
        int value = 0;
        for (int i = 0; i < allPackages.size(); ++i) {
            PackageDescription packageData = (PackageDescription)allPackages.get(i);
            int size = packageData.getSize();
            value += size;
        }
        return value;
    }

    private static boolean missingDiscSpace(int required, int available) {
        boolean missingDiscSpace = true;
        if (required < available) {
            missingDiscSpace = false;
        }
        return missingDiscSpace;
    }

    public static boolean notEnoughDiscSpace(InstallData data) {
        int availableDiscSpace;
        Vector installPackages = data.getInstallPackages();
        int installationSize = Calculator.calculateInstallSize(installPackages);
        boolean insufficientDiscSpace = Calculator.missingDiscSpace(installationSize, availableDiscSpace = data.getAvailableDiscSpace());
        if (insufficientDiscSpace) {
            String message = ResourceManager.getString("String_Discspace_Insufficient") + "\n" + ResourceManager.getString("String_Discspace_Required") + ": " + installationSize + " kB." + "\n" + ResourceManager.getString("String_Discspace_Available") + ": " + availableDiscSpace + " kB." + "\n" + ResourceManager.getString("String_Discspace_Tip");
            String title = ResourceManager.getString("String_Error");
            Informer.showErrorMessage(message, title);
        }
        return insufficientDiscSpace;
    }
}

